;---------------------------------------------
;
;     RECOVER   ver 1.0      05/28/1982
;	
;    	by Darrell Flenniken
; 
; RECOVER is a utility to resurrect programs under Microsoft
; Basic that have been erased from the program buffer by
; NEW or lost by any other means as long as  the program
; buffer remains intact.  Recover is self relocating and may
; placed anywhere in high memory where there is no conflict.
; The desired memory location is specified as parameter when
; recover is loaded.  The size of the relocated module is 
; 80 bytes.  If Recover is loaded on top of BASIC, be sure
; to protect memory when loading MBASIC.
; Recover patches into the CP/M bios jump vector table and
; becomes  part of the conin routine and remains active 
; until a  cold boot is performed.
;
; To use Recover;
;		 Exit BASIC via SYSTEM or cold boot. 
;		 Load Recover specifying the load address
;		      ie, Recover B000
;		 Re-load MBASIC and open the same number
;		      of files that existed before program
;                     loss.
;		 When BASIC comes up type CTL-F
;
; If the program buffer was not destroyed the program will have
; recovered.  LIST the program to assess any possible damage that
; may have occured when the program was lost. 
; Because of the way BASIC initializes the program buffer, the
; first few characters of the first line will be lost, and Recover
; will number the first line as '1'.
;
; Recover is MBASIC version specific and as of now assembly time
; options are available for MBASIC versions 5.10, 5.20, and 5.21.
;
; Although not intended for this purpose, Recover will also unprotect
; programs saved with the 'P' option.  Load Recover as usual, load the
; protected program, type NEW, and then type CTL-F and the protected
; program will be unprotected.   
;
title	'RECOVER ver 1.0  '
page	60
;
base	equ	0
bdos	equ	base+5
tpa	equ	base+100h
tbuff	equ	base+80h
wrbuff	equ	09h
cr	equ	0dh
lf	equ	0ah
space	equ	20h
false	equ	0
true	equ	not false
;
;	Assembly Time Options
;
bas510	equ	false	;MBASIC ver 5.10
bas520	equ	false	;  "     "  5.20 
bas521	equ	true	;  "     "  5.21
;
;
origin	org	tpa
;
;
;---------------------------------------------
;
	lxi	sp,stack
;
;
;	get relocation address from buffer
;
	lxi	h,tbuff		;point to command buffer
	mov	a,m
	cpi	0		; must > 0 relo address required
	jc	error1
	mov	a,m		; point to last byte of command
	add	l
	mov	l,a
	mov	a,h
	aci	0
	mov	h,a
	inx	h
	mvi	m,0		;put a trailing 0 to mark end
;
;	process buffer
;
	lxi	h,tbuff+1
	mvi	b,4
	lxi	d,0
skip	inx	h
hex1	mov	a,m		; get character from buffer 
	cpi	0		; if hex 0 then less than 4
	jz	error1		; digits so jmp to error
	cpi	space		
	jz	skip		; skip the spaces
	sui	'0'		; convert 0-9 to hex
	jc	error1		; must be > or = zero
	cpi	0ah
	jc	hex2		; jmp if 0 - 9
	ani	5fh		; strip bit 6 (lower -> upper)
	sui	7		; convert A-F to hex	 	
	cpi	10h		; must be less than 10 hex
	jnc	error1
;
hex2    inx	h		; this routine will move four
	mov	c,a		; hex digits into the DE reg
	mov	a,d		; get D contents
	rlc			; move lo nibble to hi
	rlc
	rlc
	rlc
	ani	0f0h		; clear lo nibble 
	mov	d,a		; save to D
	mov	a,e		; get E contents
	rlc			; swap hi/lo nibble
	rlc
	rlc
	rlc
	mov	e,a		; save to E
	ani	0fh		; clear hi nibble (lo=orig hi) 
	ora	d		; mov hi nibble from E 
	mov	d,a		; to lo nibble of D
	mov	a,e		; get swapped E
	ani	0f0h		; clear lo nibble (hi= orig lo)
	ora	c		; move new digit from command
	mov	e,a		; line to lo nibble of E
	dcr	b		; four digits yet ?
	jnz	hex1		; no, continue
	xchg
	shld	load
;
;this routine will move and relocate a code block 
;
	lxi	h,entry
	shld	source$beg
	lxi	h,endmov
	shld	source$end
	lhld	load
	shld	dest$beg
	lxi	d,endmov-entry
	dad	d
	shld	dest$end	
	lhld 	source$end	;last address to move
	mov 	d,h
	mov 	e,l
	lhld 	dest$beg	;destination
	mov 	b,h
	mov 	c,l
	lhld 	source$beg	;first address to move
	push 	b
	call 	complhl		;compliment hl
	dad	d
	mov 	b,h
	mov 	c,l
	pop 	h
	dad 	b
reloc1	ldax 	d		;move routine
	mov 	m,a
	mov 	a,b
	ora 	a
	jnz 	reloc2
	mov 	a,c
	ora 	a
	jz 	reloc3
reloc2	dcx 	h
	dcx 	d
	dcx 	b
	jmp 	reloc1
reloc3 	push 	h
	mov 	h,d
	mov 	l,e
	call 	complhl		;prepare for subtraction
	pop 	d
	dad 	d
	shld 	factor		;displacement
	lhld 	dest$beg	;first addr. to reloc
;
	dcx 	h
reloc4	inx 	h
	xchg
	lhld 	dest$end	;last addr. to relocate
	xchg
	mov 	a,e
	sub 	l
	mov 	a,d
	sbb 	h
	jc 	reldone
	mvi 	b,1ah		;26 entries to try in table 3
	lxi 	d,table1	; get table of op codes w/target 
				; addresses, ie jmp, call, etc.
check3	ldax 	d		;get op code from table
	cmp 	m		; cmp with  code  segment
	jz 	act		; if same then adjust address 
	dcr 	b
	inx 	d		; ... by offset
	jnz 	check3		; if not check next table entry
	mvi 	b,12h		;18 entries to try in table 2
	lxi 	d,table2	; no match then get table  
				; of opcodes that contain direct 
				; data ... ie mvi, ani, etc. 
check2	ldax 	d		; get table entry
	cmp 	m		; cmp with code byte from program
	jz 	skip2		; if match then skip  data
	dcr 	b		; no match  continue table search
	inx 	d
	jnz 	check2
	jmp 	reloc4
skip2	inx 	h		;skip data
	jmp 	reloc4
act	push 	h
	lhld 	source$end	;last addr to move
	mov 	d,h
	mov 	e,l
	lhld 	source$beg	;first addr to move
	mov  	b,h
	mov 	c,l
	pop 	h
	inx 	h
	mov 	a,e
	sub 	m
	inx 	h
	mov 	a,d
	sbb 	m
	jc 	reloc4
	dcx 	h
	mov 	a,m
	sub 	c
	inx 	h
	mov 	a,m
	sbb 	b
	jc 	reloc4
	dcx 	h
	xchg
	lhld	factor		;displacement
	xchg
	mov 	a,m
	add 	e
	mov 	m,a
	inx 	h
	mov 	a,m
	adc 	d
	mov 	m,a
	jmp 	reloc4
;
complhl	push	psw
	mov	a,h
	cma
	mov	h,a
	mov	a,l
	cma
	mov	l,a
	inx	h
	pop	psw
	ret
;
reldone	
;	get bios vectors
;	and patch in Recover
;
	lhld	factor
	push	h
	pop	b
	lhld	base+1		;warm boot vector
	lxi	d,1		;bios jump table
	dad	d
	lxi	d,3
	dad	d
	dad	d		;conin vector
	push	h
	mov	e,m
	inx	h
	mov	d,m
	lxi	h,conin+1	;where we want it
	dad	b		;adjust for relocation
	mov	m,e
	inx	h
	mov	m,d
;
	pop	d
	lhld	dest$beg	;conin entry point
	xchg
	mov	m,e		;put it in bios table
	inx	h
	mov	m,d
;

;
	lxi	d,signon
	mvi	c,wrbuff
	call	bdos
	jmp	0
;
error1	lxi	d,errmsg1
	mvi	c,wrbuff
	call	bdos
	jmp	0
;
;
;---------------------------------------------
;
;
;	relocatable block
;
;	main loop
;
entry				
	call	conin	; Get character from console 
	cpi	06	; Ctl-F ?
	rnz		; No, Continue
			; Yes, Recover Program			
;
	if	bas520
	lhld	07bdh	;get loc of prog buffer (ver 5.20)
	endif
;
	if	bas510 or bas521
	lhld	079ah	; ver 5.10 and 5.21
	endif
;
	push	h
	pop	d	;save it in de
	inx	h	;skip over ...
	inx	h	; ... ptr to next line
	mvi	a,1	; assign line no. '1' ...
	mov	m,a	; ... to first line
	inx	h
	mvi	a,0
	mov	m,a
	mvi	b,7	; the number of bytes to fill ...
	mvi	a,' '	; ... with spaces
loop1	 
	inx	h
	mov	m,a	
	dcr	b
	jnz	loop1
loop2	 
	inx	h	;start looking for EOL = 0h
	mov	a,m
	cpi	0
	jnz	loop2
	inx 	h	; found it -> inc one byte
	mov	a,l	; ... this = start of 2nd line
	stax	d	; save it in ptr location of 1st line
	inx	d	; now BASIC's line pointers are ...
	mov	a,h	; restored -- mem  = ptr to next line
	stax	d
loop3	 
	mov	e,m	;get next line pointer in de
	inx	h
	mov	d,m
	xchg		;put it in hl
	mov	a,h	; is it = to zero ?
	ora	l
	cpi	0
	jnz	loop3
	xchg		;hl = address of eop
	lxi	b,2
	dad	b
;
; Restore BASIC's pointers
;
	if	bas520
	shld	0ae5h
	lxi	b,8
	dad	b
	shld	0ae7h
	shld	0ae9h
	shld	0ab8h
	endif
;
	if	bas521
	shld	0ac2h
	lxi	b,8
	dad	b
	shld	0ac4h
	shld	0ac6h
	shld	0bb5h
	endif
;
	if	bas510
	shld	0abfh
	lxi	b,8
	dad	b
	shld	0ac1h
	shld	0ac3h
	shld	0bb2h
	endif
	ret
;
conin	jmp	$-$	;filled in by relocator
;
endmov	equ	$	; The end of the relocated module
;
factor		dw	0	; the relocation offset 
source$beg	dw	0
source$end	dw	0
dest$beg	dw	0
dest$end	dw	0	
load		dw	0
;
;	relocation tables
;
table1	db 1,11h,21h,22h,2ah,31h,32h,3ah,0c2h,0c3h,0c4h,0cah
	db 0cch,0cdh,0d2h,0d4h,0dah,0dch,0e2h,0e4h,0eah,0ech
	db 0f2h,0f4h,0fah,0fch
table2	db 6,0eh,16h,1eh,26h,2eh,36h,3eh,0c6h,0ceh,0d3h,0d6h
	db 0dbh,0deh,0e6h,0eeh,0f6h,0feh
;
	ds	100h
stack	equ	$
;
signon	db	cr,lf,'   Recover ver 1.0 Activated',cr,lf,'$'
;			
errmsg1	db	cr,lf,'   Recover ver 1.0',cr,lf,lf
	db	      '   Invalid Relocation Address',cr,lf
	db	      '   Must be four hex digits.  ',cr,lf
	db	      '   Example: Recover CFFF',cr,lf,'$'
	end	origin


 	