;
;	FLIP - flip originate/answer mode of PMMI or DC Hayes modem
;	Originally written by Bruce Ratoff.
;
;	Version 7.0
;
;  Modification history:
;06/26/82 Added HELP select to prompt, shortened verbose sign-on message,
;	  changed input routine to force HELP mode if
;	  illegal prompt input, instead of flipping.
;	  Added sign-on message with version number.
;	  Added comments to un-commented code.
;	  Also expanded command line mode to include ORI and HELP
;	  modes.  Command line options are now:
;	  FLIP ORI	To get to ORIGINATE mode immediately
;	  FLIP ANS	To get to ANSWER mode immediately
;	  FLIP xxx	To get HELP
;	  If no options are specified, then cont/abort/help
;	  question is asked.  Note that none of these goodies
;	  works for the DC Hayes.			  (Dave Hardy)
;
;06/05/82 Updated to handle faster CPUs by replacing FASTCLK
;	  equate with CPUMHZ equate.  Also provided means of
;	  flipping back to answer mode with pmmi modem by 
;	  specifying 'ANS' as argument on command line.  No
;	  argument defaults to normal flip. (Paul Homchick)
;
;08/08/80 Updated to add conditional assembly for either
;	  PMMI or D C Hayes modem cards (BR)
;
;06/06/80 Updated to work with PMMI modem and to re-ask for
;	  input if invalid answer. Keith Petersen, W8SDZ.
;
;06/02/80 Updated to uppercase message and require exactly
;	  control-c or return, ignoring all else. (BR)
;
;  Define miscellaneous values
FALSE	EQU	0	;Basic logic definitions
TRUE	EQU	NOT FALSE
BDOS	EQU	5	;CP/M BDOS jump address
PMESSG	EQU	9	;CP/M BDOS Print String function
CHRINP	EQU	1	;CP/M BDOS Console Input function
BUFFER	EQU	80H	;CCP Command Buffer
;
;  Set the following to your CPU's clock speed in MHz
CPUMHZ	EQU	4	;CPU speed value used to calculate time delays
;
;  Select which modem is to be used
PMMI	EQU	TRUE	;Set TRUE if PMMI modem
DCH	EQU	FALSE	;Set TRUE if DC HAYES modem
;
;  Set your modem's control port address
	IF	DCH
MODCTL	EQU	92H	;DC HAYES modem control port address
	ENDIF
;
	IF	PMMI
MODCTL	EQU	0C0H	;PMMI modem control port address
	ENDIF
;
;  Program origin - 100H in most systems
	ORG	100H
;
START	MVI	C,PMESSG	;First, print sign-on message
	CALL	PSIGN
	DB	'FLIP  Ver 7.0',13,10,'$'
PSIGN	POP	D
	CALL	BDOS
;
	IF	PMMI		;Then see if options specified on command line
	LDA	BUFFER+1	;  Look at start of command line
	ORA	A
	JZ	FLIP		;  If no argument, then do normal FLIP
;
;  Otherwise, see if command specified is 'ANS' or 'ORI'
	MVI	C,3		;Compare whatever is there with
	LXI	D,BUFFER+2	;  with 'ANS' string
	LXI	H,ANSSTR
M1	DCR	C
	JZ	ANSWER		;Jump if it says 'ANS' to set ANSWER mode
	LDAX	D
	SUB	M
	JNZ	NOTANS		;If not 'ANS' then see if it's 'ORI'
	INX	H
	INX	D
	JMP	M1
;
NOTANS	MVI	C,3		;See if request to FLIP to ORI mode
	LXI	D,BUFFER+2
	LXI	H,ORISTR
M2	DCR	C
	JZ	ORIG		;Jump if yes
	LDAX	D
	SUB	M
	JNZ	HELP		;Else jump to HELP routine
	INX	H
	INX	D
	JMP	M2
;
;  Switch immediately to ORIGINATE mode
ORIG	MVI	C,PMESSG	;Tell user that we're switching to ORIGINATE
	LXI	D,ORIMSG
	CALL	BDOS
	JMP	ORIG2		;and then switch...
;
;  Print HELP message for user, then abort
HELP	MVI	C,PMESSG
	LXI	D,HLPMSG
	CALL	BDOS
	JMP	0
	ENDIF
;
;  Give user option to FLIP, ABORT, or get HELP
FLIP	MVI	C,PMESSG	;Say that we're FLIPping to ORIGINATE mode
	LXI	D,MESSG
	CALL	BDOS
;
	MVI	C,PMESSG	;Ask user to FLIP, ABORT, or get HELP
	LXI	D,MESSG2
	CALL	BDOS
	MVI	C,CHRINP	;Get user's response (1 character)
	CALL	BDOS
	CPI	3	;Is it a CTL-C?
	JZ	0	;  If so, then EXIT to CP/M via a warm-boot
	CPI	13	;Is it a CR?
	JNZ	HELP	;  If not, then assume it's a request for HELP
			;  If so, then fall through and FLIP to ORIGINATE mode
;
;  Set modem to OFF-HOOK ORIGINATE mode
	IF	PMMI	
ORIG2	MVI	A,1DH
	ENDIF
	IF	DCH
	MVI	A,87H
	ENDIF
	OUT	MODCTL	;Tell modem to FLIP
	IF	PMMI
	JMP	TIMER	;Then wait for user to FLIP
;
;  Switch modem immediately to ANSWER mode
ANSWER	MVI	C,PMESSG	;Tell user that we're switching to ANSWER mode
	LXI	D,MESSG3
	CALL	BDOS
	MVI	A,1EH		;Tell modem to FLIP
	OUT	MODCTL		;Then fall through to TIMER to wait for user
	ENDIF			;  to FLIP
;
;  TIMER routine - waits about 10 seconds for remote user to respond
TIMER	MVI	C,5*CPUMHZ	;Set for 10 seconds
;
;  Delay loop - Number of seconds must be in 'C' register
CTLP	LXI	H,0	;One second delay loop
	LXI	D,1
SLO	DAD	D	;Wait one second
	JNC	SLO	;1 second up? Jump if not
	DCR	C	;Decrement seconds counter
	JNZ	CTLP	;Continue timing for 'C' seconds
;
	IF	PMMI
;  Set PMMI modem to hang up if loss of carrier for 15 seconds
	MVI	A,1CH	;Set PMMI for auto timeout
	OUT	MODCTL
	ENDIF
;
	JMP	0	;Then EXIT to CP/M via a warm-boot
;
;  Messages printed to console
MESSG	DB	'Switch to ORIGINATE mode here?$'
;
MESSG2	DB	13,10
	DB	'Type RETURN to SWITCH, CTL-C to ABORT, or H for HELP: $'
;
	IF	PMMI
MESSG3	DB	'Switching to ANSWER mode here...$'
;
ORIMSG	DB	'Switching to ORIGINATE mode here...$'
;
ANSSTR	DB	'ANS'		;ANSWER mode compare string
;
ORISTR	DB	'ORI'		;ORIGINATE mode compare string
;
HLPMSG	DB	13,10,13,10
	DB	'USAGE:',13,10
	DB	'FLIP       will allow you to change this'
	DB	' end to ORIGINATE mode',13,10
	ENDIF
	IF	DCH
	DB	'$'
	ENDIF
;
	IF PMMI
	DB	'FLIP ANS   will change you to the'	
	DB	' ANSWER mode immediately.',13,10
	DB	'FLIP ORI   will change you to the'
	DB	' ORIGINATE mode immediately.',13,10,'$'
	ENDIF
;
	END
