/********************************************************************
	vio.c - the virtual io code, callable by rx.c
*/

/* begincode */

#include "a:std.h"		/* bdscio.h + my stuff */
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */

/* virtual gets() */


/* line editor, buffer up a line of text, recognizing rubouts etc.
	similar to normal gets() EXCEPT returns NULL immediatly after
	^z is encountered. str (call value) will contain all chars
	buffered till that moment, NULL terminated.	*/

char *
vgets(str, strsize, channel)
char *str;
int strsize;
unsigned channel;
{
	int  c;
	char *sptr;
	char x, fill, count;

	setmem(str,strsize,0);	/* clear buffer in case we hangup */
	if ((channel == CON) || (channel == C_M)) Cterm._vcolm_b = Cterm._vcolm_p;
	if ((channel == MOD) || (channel == C_M)) Mterm._vcolm_b = Mterm._vcolm_p;
	sptr = str;
	count = strsize - 1;		/* save room for nullbyte */
  while (count--) {
	switch (c = vget(channel)) {
	case CNTL_Z:
		*sptr = '\0';
		vputchar('\n', channel);	/* send lf */
		return NULL;
	case '\r':
	case '\n':
		*sptr = '\0';
		vputchar('\n', channel);	/* send lf */
		return str;
	case CNTL_U:
		setmem(str,strsize,0);	/* clear buffer in case we hangup */
		sptr = str;			/* reset buf ptr */
		count = strsize - 1;		/* reset its size */
		vprintf(channel, "#\n");	/* mark abort */
		if ((channel == CON) || (channel == C_M)) {
			fill = Cterm._vcolm_b;
			while (fill--) vputchar(' ', CON);	/* console */
		}
		if ((channel == MOD) || (channel == C_M)) {
			fill = Mterm._vcolm_b;
			while (fill--) vputchar(' ', MOD);	/* modem */
		}
		break;
	case CNTL_H:
		if (sptr > str) {
		    --sptr;		/* back up 1 char */
		    ++count;		/* account for it */
		    if (isprint(*sptr))	/* something to erase */
				backspace(1, channel);
		    else if (*sptr == '\t') {
				*sptr = '\0';
				if ((channel == CON) || (channel == C_M)) {
					backspace(Cterm._vcolm_p - Cterm._vcolm_b, CON); /* con */
				}
				if ((channel == MOD) || (channel == C_M)) {
					backspace(Mterm._vcolm_p - Mterm._vcolm_b, MOD); /* modem */
				}
				vprintf(channel, "%s", str);
		    }
		}
		break;
/*	case DEL:	add something for hardcopy devices */
	case CNTL_X:
		if ((channel == CON) || (channel == C_M)) {
			backspace((Cterm._vcolm_p - Cterm._vcolm_b), CON);
								/* console */
		}
		if ((channel == MOD) || (channel == C_M)) {
			backspace((Mterm._vcolm_p - Mterm._vcolm_b), MOD);
								/* modem */
		}
		setmem(str,strsize,0);	/* clear buffer in case we hangup */
		sptr = str;			/* reset buf ptr */
		count = strsize - 1;		/* reset its size */
		break;
	case CNTL_R:
		*sptr = '\0';
		vprintf(channel,"\n");
		if ((channel == CON) || (channel == C_M)) {
			fill = Cterm._vcolm_b;
			while (fill--) vputchar(' ', CON);/* do console */
		}
		if ((channel == MOD) || (channel == C_M)) {
			fill = Mterm._vcolm_b;
			while (fill--) vputchar(' ', MOD);/* do modem */
		}
		vprintf(channel, "%s", str);
		break;
	default:
		*sptr++ = c;			/* put it in string */
		vputchar(c, channel);			/* echo it */
		if ((channel == CON) || (channel == C_M))
			if ((Cterm._vcolm_p + 5) == Cterm._vcolms) cput(BELL);
		if ((channel == MOD) || (channel == C_M))
			if ((Mterm._vcolm_p + 5) == Mterm._vcolms) mput(BELL);
	}
  }
  *sptr = '\0';
  return str;
}

/* getchar() for virtual terminals */

vgetchar(channel)
unsigned channel;
{
	switch (channel) {
	case CON:	return cgetchar();
	case MOD: return mgetchar();
	case C_M: return dgetchar();
	default: return ERROR;
	}
}

/* get() for virtual terminals */

vget(channel)
unsigned channel;
{
	switch (channel) {
	case CON:	return cget();
	case MOD: return mget();
	case C_M: return dget();
	default: return ERROR;
	}
}

/* getchar() for local terminal only */

cgetchar()
{
	int c;

	switch (c = cget()) {
	case CNTL_Z: cputchar(c);      return -1;  /* echo ^z, ret -1 */
	case '\r': cputchar(c = '\n'); return c;	/* echo crlf, ret lf */
	case CNTL_C: Abort = TRUE;
	default: cputchar(c);	      return c;
	}
}

/* get a char without echo from local term */

cget()
{
	int c;

	while (TRUE) {			/* get a char */
		if (c = bdos(DIR_IO, INPUT)) break;	/* console..*/
	}
	return c;
}

/* modem getchar() for virtual machine */

mgetchar()
{
	int c;

	switch (c = mget()) {
	case CNTL_Z: mputchar(c);      return -1;  /* echo ^z, ret -1 */
	case '\r': mputchar(c = '\n'); return c;	/* echo crlf, ret lf */
	case CNTL_C: Abort = TRUE;
	default: mputchar(c);	      return c;
	}
}

mget()
{
	int c;
	while (TRUE) {			/* get a char */
		if (!still_there()) hangup(CONN_BROKEN);
		if (inp(UART_STATUS) & DATA_READY) break;
	}
	c = (m_in() & 0x7f);	/* ready, get it, strip parity */
/** if illegal return 'NULL' */
	return c;			/* it's ok, return it */
}

dgetchar()
{
	int c;

	switch (c = dget()) {
	case CNTL_Z: dputchar(c);      return -1;  /* echo ^z, ret -1 */
	case '\r': dputchar(c = '\n'); return c;	/* echo crlf, ret lf */
	case CNTL_C: Abort = TRUE;
	default: dputchar(c);	      return c;
	}
}

/* get a char without echo */

dget(channel)
{
	int c;

	while (TRUE) {			/* get a char */
		if (!still_there()) hangup(CONN_BROKEN);
		if (c = bdos(DIR_IO, INPUT)) break;	/* console..*/
		if (inp(UART_STATUS) & DATA_READY) { /* ..then modem */
			c = (m_in() & 0x7f); /* ready, get it, strip parity */
			break;
		}
	}
	return c;
}

/* filter incoming characters for illegal entrys */

m_in()
{
	return (inp(DATA_IN));
}

vscanf(channel, format)
unsigned channel;
char *format;
{
	char line[MAXLINE];
	vgets(line, MAXLINE, channel);	/* get a line of input from user */
	return _scn(line, &format);	/* and scan it with "_scn"	 */
}

/* printf() that stops on 'Abort' == TRUE */

vprintf(channel, format)
unsigned channel;
char *format;
{
	char line[MAXLINE];
	_spr(line, &format);
	vputs(line, channel);
}

/* puts() that stops on 'Abort' == TRUE */

vputs(str, channel)
char *str;
unsigned channel;
{
	while (*str && !Abort) vputchar(*str++, channel);
}

/* putchar() for virtual machine */

vputchar(c, channel)
char c;
unsigned channel;
{
	switch (channel) {
	case CON: return cputchar(c);
	case MOD: return mputchar(c);
	case C_M: return dputchar(c);
	default: return ERROR;
	}
}

/* put() for virtual machine */

vput(c, channel)
char c;
unsigned channel;
{
	switch (channel) {
	case CON: return cput(c);
	case MOD: return mput(c);
	case C_M: return dput(c);
	default: return ERROR;
	}
}

/* putchar() to local term */

cputchar(c)
int c;
{
	int cc, abort;
	char x;

	if (cc = bdos(DIR_IO, INPUT)) {
		if (cc == CNTL_S) cget();		/* x/on, x/off */
		else if (cc == CNTL_C) Abort = YES;
	}
	if (c == '\n') {	/* expand lf... */
		cput('\r');
		for (x = Cterm._vnulls; x--;) cput('\0');	/* nulls */
		Cterm._vcolm_p = 0;	/* for tab handling */
	}
	else if (c == '\t') {
		x = Cterm._vtab_size - (Cterm._vcolm_p % Cterm._vtab_size);
		for (;x--;) cput(' ');
		return;			/* don't send the '\t' */
	}
	cput(c);
}

/* put for local term */

cput(c)
char c;
{
	c_out(c);
	if (isprint(c)) ++Cterm._vcolm_p;
	else if (c == '\n')
		if (Cterm._vmore && More) {
			if ((++Cterm._vrow_p + 1) == Cterm._vrows) {
				if (!more_check()) Abort = YES;
				Cterm._vrow_p = NULL;
			}
		}
	else if (c == '\b') --Cterm._vcolm_p;
}

c_out(c)
char c;
{
	switch (c) {
		case CNTL_Q:	/* don't send... */
		case CNTL_R:
		case CNTL_S:	/* ...to...*/
		case CNTL_T:
			return;	/* ...xitan video board */
		case BELL:	if (!(c = Cterm._vbell)) return; /* bells? */
		default:
			bdos(DIR_IO, c);
	}
}

/* virtual modem putchar() */

mputchar(c)
char c;
{
	int x;

	if (!still_there()) hangup(CONN_BROKEN);
	if (inp(UART_STATUS) & DATA_READY) {
		if ((x = m_in()) == CNTL_C) Abort = YES;
		else if (x == CNTL_S) mget();		/* x/on, x/off */
	}
	if (c == '\n') {			/* expand lf... */
		mput('\r');
		for (x = Mterm._vnulls; x--;) mput('\0');	/* nulls */
		Mterm._vcolm_p = 0;			/* for tab handling */
	}
	else if (c == '\t') {
		x = Mterm._vtab_size - (Mterm._vcolm_p % Mterm._vtab_size);
		for (;x--;) mput(' ');
		return;			/* don't send the '\t' */
	}
	mput(c);
}

mput(c)
char c;
{
	m_out(c);
	if (isprint(c)) ++Mterm._vcolm_p;
	else if (c == '\n')
		if (Mterm._vmore && More) {
			if ((++Mterm._vrow_p + 1) == Mterm._vrows) {
				if (!more_check()) Abort = YES;
				Mterm._vrow_p = NULL;
			}
		}
	else if (c == '\b') --Mterm._vcolm_p;
}

/* filter outgoing character tty values */

m_out(c)
int c;
{	/* make modifications according to tty values */
	if (c == BELL) if (!(c = Mterm._vbell)) return;	/* bells? */
	while (!(inp(UART_STATUS) & BUFFER_EMPTY))
		;    	/* wait */
	outp(DATA_OUT, c);
}

/* putchar() for dual terminals */

dputchar(c)
int c;
{
	cputchar(c);
	mputchar(c);

/**save till debug...
	...fix tab stuff, send nulls after '\r', if used...
	int x;

	if (!still_there()) hangup(CONN_BROKEN);
	if (inp(UART_STATUS) & DATA_READY) x = m_in();
	else x = bdos(DIR_IO, INPUT);
	if (x == CNTL_C) Abort = YES;
	else if (x == CNTL_S) dget();		/* x/on, x/off */
	if (c == '\n') {			/* expand lf... */
		dput('\r');
		Tab_count = 0;			/* for tab handling */
	}
	else if (c == '\t') {
		x = Tab_size - (Tab_count % Tab_size);
		for (;x--;) dput(' ');
		return;			/* don't send the '\t' */
	}
	dput(c);
**/
}

/* put() for dual terminals */

dput(c)
int c;
{
	cput(c);
	mput(c);
}

more_check()
{
	vprintf(C_M, "more ? (<anykey> or N) ");
	if (tolower(vget(C_M)) == 'n') {
		vprintf(C_M, "n\n\n");	/* fake echo of 'n' */
		return NO;
	}
	x_line(1, C_M);			/* erase question */
	return YES;
}

backspace(x, channel)
char x;
unsigned channel;
{
	char xx;
	for (xx = x; xx; --xx) vputchar('\b', channel);
	for (xx = x; xx; --xx) vputchar(' ', channel);
	for (xx = x; xx; --xx) vputchar('\b', channel);
}

/* erase line from arg to _vterm._vcolm_p */

x_line(start, channel)
char start;
unsigned channel;
{
	char x, tbc;

	if ((channel == CON) || (channel == C_M)) {
		tbc = Cterm._vcolm_p - start + 1;
		for (x = tbc;x;--x) 		vputchar('\b', CON);
		for (x = 1;x <= tbc;++x) 	vputchar(' ', CON);
		for (x = tbc;x;--x) 		vputchar('\b', CON);
	}
	if ((channel == MOD) || (channel == C_M)) {
		tbc = Mterm._vcolm_p - start + 1;
		for (x = tbc;x;--x) 		vputchar('\b', MOD);
		for (x = 1;x <= tbc;++x) 	vputchar(' ', MOD);
		for (x = tbc;x;--x) 		vputchar('\b', MOD);
	}
}

/* endcode */
