	TITLE	'UNLOAD ver 2.1 - Create HEX file from COM file'
;	(revised 05/20/81)
;
;--->Needs MAC and SEQIO.LIB to assemble<---
;
;Originally from CPMUG 29.23
;
;05/20/81 Modified for 32 bytes/record instead of 16, for less
;	  overhead in the .HEX output file, by Dav Holle.
;
;11/07/80 Modified to default to 100H, increase size of buffers,
;	  add signon message.  By Keith Petersen, W8SDZ
;
;To use, type: UNLOAD <FILENAME> <ADDR>
;
;Where: <FILENAME>.COM is the source file
;	<FILENAME>.HEX will be the output file
;	<ADDR> is the optional start address in hex (default=100)
;
	ORG	100H
;
	MACLIB	SEQIO	;DEFINE MACRO LIBRARY USED
;
	LHLD	6	;GET BASE OF BDOS
	DCX	H	;BACK OFF ONE BYTE
	SPHL		;SET STACK THERE
	CALL	SIGNON
	DB	CR,LF,'UNLOAD ver 2.1',CR,LF,'$'
	DB	'05/20/81' ;REVISION DATE (doesn't print)
;
SIGNON:	POP	D	;GET MSG ADR
	MVI	C,@MSG	;PRINT IT
	CALL	@BDOS
	LXI	H,100H	;DEFAULT UNLOAD ADRS
	LXI	D,FCB2+1
	LDAX	D	;GET OPTION ADRS
	CPI	' '	;ANY GIVEN?
	JZ	INITFL	;NO, DEFAULT TO 100H
	LXI	H,0
	MVI	B,0
;
ADRLUP:	LDAX	D
	INX	D
	SUI	'0'
	JC	INITFL
	CPI	10
	JC	ADDNIB
	SUI	7
	JC	INITFL
	CPI	16
	JNC	INITFL
;
ADDNIB:	DAD	H
	DAD	H
	DAD	H
	DAD	H
	MOV	C,A
	DAD	B
	JMP	ADRLUP
;
INITFL:	PUSH	H
	FILE	INFILE,SOURCE,,1,COM,2048
	FILE	OUTFILE,OUTPUT,,1,HEX,2048
	POP	H
;
ADRDON:	SHLD	LODADR
;
UNLOOP:	GET	SOURCE
	JZ	GEOF
	PUSH	PSW
	MVI	A,':'
	PUT	OUTPUT
	XRA	A
	STA	CHEKS
	MVI	A,32	;was 16
	CALL	PUTBYTE
	LDA	LODADR+1
	CALL	PUTBYTE
	LDA	LODADR
	CALL	PUTBYTE
	XRA	A
	CALL	PUTBYTE
	POP	PSW
	MVI	B,32	;was 16
;
LINLUP:	PUSH	B
	CALL	PUTBYTE
	POP	B
	DCR	B
	JZ	NEXTL
	GET	SOURCE
	JMP	LINLUP
;
PUTBYTE:MOV	C,A
	LDA	CHEKS
	SUB	C
	STA	CHEKS
	MOV	A,C
	RRC
	RRC
	RRC
	RRC
	CALL	PUTNIB
	MOV	A,C
;
PUTNIB:	ANI	0FH
	ADI	'0'
	CPI	'9'+1
	JC	PUTNB1
	ADI	7
;
PUTNB1:	PUSH	B
	PUT	OUTPUT
	POP	B
	RET
;
NEXTL:	LDA	CHEKS
	CALL	PUTBYTE
	MVI	A,CR
	PUT	OUTPUT
	MVI	A,LF
	PUT	OUTPUT
	LHLD	LODADR
	LXI	D,32	;was 16
	DAD	D
	JMP	ADRDON
;
GEOF:	MVI	A,':'
	PUT	OUTPUT
	MVI	B,5
;
GEOF1:	XRA	A
	PUSH	B
	CALL	PUTBYTE
	POP	B
	DCR	B
	JNZ	GEOF1
	MVI	A,CR
	PUT	OUTPUT
	MVI	A,LF
	PUT	OUTPUT
	FINIS	OUTPUT
	LXI	D,DMSG
	MVI	C,@MSG
	CALL	@BDOS
	JMP	0
;
DMSG:	DB	'DONE',CR,LF,'$'
;
LODADR:	DS	2
CHEKS:	DS	1
FCB2	EQU	6CH
;
BUFFERS	EQU	$	;INPUT/OUTPUT BUFFERS GO HERE
;
	END
