/*
 * The object code UnLoader.
 *
 *      By: Larry A. Marek   Aug. 10, 1980
 *
 * Copyright (C) Larry A. Marek  Not for commercial use.
 * This program may not be bought or sold.  For hobbiest
 * use only!
 *
 * This program is the compliment of the
 * "LOAD.COM" program supplied on the CP/M
 * system diskette.  Unload takes an
 * executable CP/M transient program
 * and produces a intel hex file.
 *
 * The command line:  unload  foo
 * will take the file "foo.com" and create
 * a file "foo.hex".  The file "foo.hex"
 * can then be tranferred like any other
 * ascii file, and later re-LOADed to
 * working object code.
 */

#include "a:bdscio.h"

main(argc, argv)
int     argc;
char    **argv;
{
        char    cksum;
        int i, c, fdi, fdo;
        unsigned addr;
        char    infile[BUFSIZ], outfile[BUFSIZ];
        char    file_name[20];

/*
 * a quick check on the command line
 */

        if (argc != 2) {
                printf("Usage: unload filename\n");
                exit();
        }

/*
 * take the filename given and open that ".COM"
 * file for reading
 */

        strcpy(file_name, *++argv);
        strcat(file_name, ".COM");

        fdi = fopen(file_name, infile);
        if (fdi == ERROR) {
                printf("can't access '%s'\n", file_name);
                exit();
        }

/*
 * now create a ".HEX" file of the same filename
 * to write to
 */

        strcpy(file_name, *argv);
        strcat(file_name, ".HEX");

        fdo = fcreat(file_name, outfile);
        if (fdo == ERROR) {
                printf("Can't create: '%s'\n", file_name);
                exit();
        }

/*
 * the main work loop
 *
 * Here the start of every line has the address and
 * other load information, then sixteen hexadecimal
 * ascii bytes.  Last on the line is the checksum and
 * a carriage return, linefeed.
 */

        addr = 0x100;           /* cp/m transients start here */

        while ((c = getc(infile)) != EOF) {
                if ((addr % 16) == 0) {
                        cksum = 0;
                        putc(':', outfile);     /* record mark */

                        putc('1', outfile);
                        putc('0', outfile);     /* 16 frames to come */
                        cksum -= 0x10;

                        /* the load address */
                        putc(tohex(addr >> 12), outfile);
                        putc(tohex(addr >> 8), outfile);
                        cksum -= (addr >> 8);
                        putc(tohex(addr >> 4), outfile);
                        putc(tohex(addr), outfile);
                        cksum -= (addr & 0xff);

                        putc('0', outfile);     /* record type */
                        putc('0', outfile);
                }

                putc(tohex(c >> 4), outfile);
                putc(tohex(c), outfile);
                cksum -= c;

                ++addr;
                if ((addr % 16) == 0) {
                        putc(tohex(cksum >> 4), outfile);
                        putc(tohex(cksum), outfile);
                        putc('\r', outfile);
                        putc('\n', outfile);
                }

        }

/*
 * The unlikely (in cp/m) case the End-o-file was
 * reached before writing a full line to the ".HEX"
 * file.
 */

        if ((addr % 16) != 0) {
                while ((addr % 16) != 0) {
                        putc('0', outfile);
                        ++addr;
                }
                putc(tohex(cksum >> 4));
                putc(tohex(cksum));
                putc('\r', outfile);
                putc('\n', outfile);
        }

/*
 * to show the end of the hex file -  a zero length
 * line
 */

        putc(':', outfile);
        for (i = 0; i <= 5; i++)
                putc('0', outfile);

        putc(CPMEOF, outfile);  /* cp/m end of file */
        fflush(outfile);                /* flush the buffer */
        if (close(fdi) == ERROR)
                printf("Can't close: '%s'.COM\n", *argv);
        if (close(fdo) == ERROR)
                printf("Can't close: 's'.HEX\n", *argv);
}

/*
 * "tohex" converts it's input to an ascii hex digit.
 *  Input range is made to fit.
 */

tohex(c)
char    c;
{
        c &= 0xf;               /* range 0 - F */

        if (c <= 9)
                c += '0';
        else
                c += ('A' - 10);
        return(c);
}
