/********************************************************************

	send.c -

	Ward Christensen Protocol handler for sending ascii and binary files.
functions taken from yam package by Chuck Forsberg, cug disk Utilities
III, some modifications made for compatibility with cnode code.

*/

/* begincode */

#include "a:std.h"
#include "b:cnode.h"
#include "b:cnode.g"


main(argc, argv)
int argc;
char **argv;
{
	int err_flag;

	Batch = err_flag = FALSE;

	++argv;			/* point to first file name */

	if(Batch) {
		vprintf(C_M, "\n\t Batch mode not supported yet,sorry\n");
		return OK;			/* for now...*/
/** no batch yet -
		vprintf(C_M, "Sending in Batch Mode\n");
		if(expand(wcs, argc, argv)==ERROR) {
				err_flag = TRUE;
				goto fubar;
		}
		if(wctxpn("")==ERROR) {
				err_flag = TRUE;
				goto fubar;
		}
*/
	}
	else {
		while (--argc >= 1) {
			if (dnvalid(Tname, *argv) == ERROR) {
				vprintf(C_M, "\ncan't, bad name: %s !", *argv++);
				err_flag = TRUE;
				continue;
			}
			if(opentx(Tname)==ERROR) {
				vprintf(C_M, "\ncan't open '%s'\n", *argv++);
				err_flag = TRUE;
				continue;
			}
			vprintf(C_M, "'%s' open for transmission\n", *argv++);
			if(wctx()==ERROR) {
				err_flag = TRUE;
				goto fubar;
			}
		}
	}
	return err_flag;
fubar:
	closetx();
	sendbyt(CAN);sendbyt(CAN);sendbyt(CAN);
	return err_flag;
}

/** no batch yet -

expand(fnx, argc, argv)
int (*fnx)()
int argc;
char **argv;
{
	vprintf(C_M, "\n\twildcards (Batch Mode) not supported yet, sorry\n");
}

wcs(name)
char *name;
{
	if(opentx(name)==ERROR)
		return ERROR;
	if(wctxpn(name)!= ERROR)
		return wctx();
	else {
		return ERROR;
	}
}
*/

wctx()
{
	int sectnum, attempts;
	char txbuf[SECSIZ];

	vprintf(CON, "Awaiting initial NAK - ");
	while((Firstch=readbyt(400))!=NAK && Firstch!=TIMEOUT && Firstch!=CAN) {
		vprintf(CON, "\n\tgot 0x%2x, not NAK", Firstch);
					/* let user see it if strange char */
	}
	if(Firstch==CAN)
		return ERROR;
	if (Firstch == TIMEOUT) {
		vprintf(C_M, "\ntimeout on initial NAK!");
		return ERROR;
	}
	sectnum=1;
	while(filbuf(txbuf, SECSIZ)) {
		if(wcputsec(txbuf, sectnum)==ERROR) {
			return ERROR;
		}
		else {
			sectnum++;
		}
	}
	closetx();
	attempts=0;
	do {
		sendbyt(EOT);
		purgeline();		/* why? */
		attempts++;
	}
		while((Firstch=(readbyt(100)) != ACK) && attempts < RETRYMAX)
			;		/* wait for ACK */
	if(attempts == RETRYMAX) {
		vprintf(C_M, "\nNo ACK on EOT; Aborting... ");
		return ERROR;
	}
	else
		return OK;
}

wcputsec(txbuf, sectnum)
char *txbuf;
int sectnum;
{
	char attempts, *cp, xbyt;
	
	Firstch=0;	/* part of logic to detect CAN CAN */

	for(attempts=0; attempts <= RETRYMAX; attempts++) {
		Lastrx= Firstch;
		sendbyt(SOH);
		sendbyt(sectnum);
		sendbyt(~sectnum);
		Checksum=0;
		for(Wcj=SECSIZ,cp=txbuf; --Wcj>=0; ) {
			sendbyt(*cp);
			if (isprint(*cp) || *cp == '\r' || *cp == '\n' || *cp == '\t')
				cputchar(*cp);
			else cputchar('.');
			Checksum += *cp++;
		}
		sendbyt(Checksum);
		purgeline();

		Firstch=readbyt(100);
		if(Firstch==CAN && Lastrx==CAN) {
cancan:
			vprintf(C_M, "\nReceiver CANcelled transmission ");
			return ERROR;
		}
		else if(Firstch==ACK)
			return OK;
		else if(Firstch==TIMEOUT)
			vprintf(CON, "Timeout on sector ack attempt %d", attempts);
		else {
			vprintf(CON, "Got %2x for sector ACK attempt %d", Firstch, attempts);
			for(;;) {
				Lastrx=Firstch;
				if((Firstch=readbyt(1))==TIMEOUT)
					break;
				if(Firstch==CAN && Lastrx==CAN)
					goto cancan;
			}
		}
	}
	vprintf(C_M, "No ACK on sector; Abort ");
	return ERROR;
}

/** no batch yet -

wctxpn(name)
char *name;
{
	char *p;

	vprintf(CON, "Awaiting initial pathname NAK");
	if(readbyt(400)==ERROR)			/* wait for inital nak */
		return ERROR;
	/* don't send drive specification */
	if(p=index(':', name))
		name= ++p;
	if(wcputsec(name, 0)==ERROR) {
		vprintf(C_M, "Can't send pathname %s\n", name);
		return ERROR;
	}
	return OK;
}
*/

opentx(name)
char *name;
{
	vprintf(CON, "'%s' ", name);
#ifdef LOGFILE
	logfile(name, 's');		/* record file xmsn */
#endif
	if(fopen(name, File_buf)==ERROR){
		return ERROR;
	}
	Tfile= TRUE;
	return OK;
}

/* fill buf with count chars padding with ^Z for CPM */

filbuf(buf, count)
char *buf;
int count;
{
	int c, m;
	m=count;
	while((c=getc(File_buf))!=EOF) {
		*buf++ =c;
		if(--m == 0)
			break;
	}
	if(m==count)
		return 0;
	else		/* won't pad properly under cp/m because of */
			/* two different EOF's (EOF & CPMEOF), and the */
			/* fact that cp/m doesn't know type of file */
			/* instinctively, fix later */
		while(--m>=0)
			*buf++ = CNTL_Z;
	return count;
}

dnvalid(pname, name)
char *pname;
char *name;
{
	purge_ws(name);
	if (strlen(name) > 12) {
		vprintf(C_M, "\n'%s' doesn't fit (name too long)", name);
		return ERROR;
	}
	strcpy(pname, "b:");
	strcat(pname, name);
#ifdef RESTRICTED
	if	(	cisubstr(pname, ".com")
		||	cisubstr(pname, ".cmd")
		||	cisubstr(pname, ".bad")
		||	cisubstr(pname, ".sys")
		||	cisubstr(pname, ".mbx")
		||	cisubstr(pname, "!")	/* ! tags unsendable files */
		)	{
		vprintf(C_M, "\n'%s' Not for Distribution\n", name);
		return ERROR;
	}
#endif
	return OK;
}

sendbyt(byt)
char byt;
{
	while (!(inp(UART_STATUS) & BUFFER_EMPTY))
	;		/* wait */
	outp(DATA_OUT, byt);
}

readbyt(decisecs)
int decisecs;
{
	if (inp(UART_STATUS) & DATA_READY)
		return inp(DATA_IN);
	while (--decisecs >= 0) {
		if (inp(UART_STATUS) & DATA_READY)
			return inp(DATA_IN);
		if (bdos(DIR_IO, INPUT))	/* local forced timeout */
			return TIMEOUT;
		if (inp(UART_STATUS) & DATA_READY)
			return inp(DATA_IN);
		for (Timeout = T1pause; --Timeout; )
			if (inp(UART_STATUS) & DATA_READY)
				return inp(DATA_IN);
	}
	return TIMEOUT;
}

/* endcode */
