/* changes from cug release */

/*
	7/25/81- put this file on seperate development disk, ALL 
	development to this package to be done here only. crl files
	may be spread around as needed.

	7/7/81-	made ropen() free allocated buffer space before
	returning on ERROR. Don't close files that return ERROR
	from ropen().

	7/7/81- made rclose do primitive close even if buffer not
	flushed correctly, insuring that fd is always freed.

*/

/*
	random file routines

	some notes on these functions-

	since the buffer is completely written to disk even though only
one byte may have been added, a program that uses the entire 8 megabyte
range could fill a disk with 240 byes (assuming a declared buffer size
of 1 k and even distribution of those bytes over the entire range). one
solution would be to keep the buffer size down to 1 sector. the best is
to be reasonable with the address range of your program. logically a file
of 8 megabytes could be spread over x disks if necessary.

	these functions need:	1.cp/m 2.x
				2.alloc() installed in the stdlib
				3:_allocp = NULL; in main
				4.the undocumented (but existing)
					functions rsrec()
						  rcfsiz()
						  rtell()
						  rseek()
						  rread()
						  rwrite()
				  the code for these is in deff2a.asm
				  and is the only existing doc for them

	the buffer size is declared on opening the file and is maintained
in a space provided by alloc(). it can be any length from 1 sector to
memory size available (keep in mind the above note on buffer size as affected
by random writes). if your needs change you can close and reopen with a diff-
erent size buffer. closes AUTOMATICALLY flush the buffer, no explicit call
of _rflush() needed.

	see pages 164-169 of 'the c programming language' for insight
into the madness of the package

	important:

	DO NOT  'rclose()' a file that is not open, rclose() will
attempt to 'free()' memory that hasn't been set aside by alloc(),
causing havoc to the running program!

*/

#include "a:std.h"		/* bdscio.h plus my own system defs */

/*
	routines to parallel the buffered input and output routines,
allowing completely random buffered read and writes to a file

	these are closely modeled on the routines by Leor for
buffered sequential files.

functions - 

	rcreat(filename, fp, mode, secs)
		creat an as yet non-existant file
	ropen(filename, fp, mode, secs)
		open an already existing file
	rclose(fp)
		close a random file (takes care of all 'flushing')
	_rflush(fp)
		'flush' a random file buffer to disk
	fseek(fp, offset, origin)
		set the 'byte-pointer' to a specific byte within the
			8 megabyte range of 2.2
	ftell(fp)
		report the current position of the 'byte-pointer' in
			an open file
	bseek(fp, block, origin)
		does a fseek() using logical block size defined
			by _blksiz in struct _file
	btell(fp)
		returns the last block sought by bseek()
	rgetc(fp)
		returns the byte pointed at by the 'byte-pointer'
			and bumps the pointer by 1
	rputc(c, fp)
		puts the byte 'c' in the file at the position defined
			by the 'byte-pointer', bumps the pointer by 1

	the next four are basically their sequential file cousins
with rgetc() replacing getc() and rputc() replacing putc() in the
code.

	rgetw(fp)
	rputw(w, fp)
	rprintf(fp, format, arg1, arg2,...)
	rscanf(fp, format, arg1, arg2,...)

	rgets() and rputs() handle null terminated strings from and
to files without any 'crlf' conversions. rgetl() and rputl() are the
extensions of fgets() and fputs() in the distribution package. again,
their code is mostly from their cousins, with changes made as
necessary. the change to 'l' is to denote the fact that they work
in the 'line' enviroment of cp/m.

	rgets(str, fp)
	rputs(str, fp)
	rgetl(line, fp)
	rputl(line, fp)

	the next four are essentially two pairs of twins. they get or
put x amount of bytes from/to files.

	rget(fp, destination, nbyt)
	rput(fp, source, nbyt)
	rgetstruct(fp, destination, structsiz)
	rputstruct(fp, source, structsiz)
*/

/*
	this is the structure that controls the show. such a structure
	must be declared for each file in main. also, very important,
	be sure to include an initialization of _allocp = NULL; in
	main() before doing anything else.
	it is also necessary to set _blksiz of '-file' in main if
	you will be using the bseek(), btell() functions. they allow
	easy random access when using records of equal size.
*/

/*
struct _file {
	int _rfd;		/* file descripter */
	int _secs;		/* # of sectors in buffer */
	unsigned _frstsec;	/* first sector in buffer */
	unsigned _cursec;	/* cp/m current random sec */
	byte _curbyt;		/* current random byte */
	byte *_nxtbyt;		/* next byte to be processed */
	byte *_bufbase;		/* location of base */
	byte *_pastbuf;		/* first byte beyond end of buffer */
	char _mode;		/* read, write, append, or direct */
	int _update;		/* buffer modified flag */
	unsigned _curblk;	/* currently addressed block */
	int _blksiz;		/* size of a logical block */
};
*/

/*
	purge any old copies, creat and open 'filename', buffer
size equal to secs * size of one sector, mode of write (from
beginning of file), append (write at end of file), or direct
(read or write, starting at beginning of file, random access
to any part of file). read not allowed as you can't read a
new file.
*/

struct *	/* returns pointer to struct, or ERROR on error */
rcreat(filename, fp, mode, secs)
char *filename;
struct _file *fp;
char mode;
int secs;
{
	int fd;
	struct *ropen();

	switch (mode) {
	case 'r':	return ERROR;	/* can't read empty file */
	case 'w':
	case 'a':
	case 'd':
		if ((fd = creat(filename)) == ERROR ) return ERROR;
		fabort(fd);			/* free up fd */
		return ropen(filename, fp, mode, secs);	/* open */
	default:
		return ERROR;
	}
}
/*
	open 'filename' buffer in space provided by alloc(), setup
fp, buffer of size SECSIZ * secs
*/

struct *	/* returns pointer to struct, or ERROR on error */
ropen(filename, fp, mode, secs)
char *filename;
struct _file *fp;
char mode;
int secs;
{
	byte *alloc();
	unsigned rcfsiz(), rsrec(), ftell();

	switch (mode) {
	case 'r':				/* read mode */
		fp -> _rfd = open(filename, 0);	/* open read */
		break;
	case 'w':				/* write mode */
	case 'a':				/* append mode */
	case 'd':			/* direct or random mode */
		fp -> _rfd = open(filename, 2);	/* open r/w */
		break;
	default:
		return ERROR;
	}
	if (fp -> _rfd == ERROR) return ERROR;	/* open error */

	if ((fp -> _bufbase = alloc(secs * SECSIZ)) == 0) return ERROR;
					/* no room for buffer */
	fp -> _secs = secs;			/* secs. in buffer */
	fp -> _nxtbyt = fp -> _bufbase;	  /* start at begin of buf */
	fp -> _pastbuf = fp -> _bufbase + (secs * SECSIZ); /* endbuf */
	fp -> _mode = mode;
	fp -> _frstsec = (mode == 'a') ?    /* if 'a' start at end */
		rcfsiz(fp->_rfd) : rsrec(fp->_rfd); /* else at 0 */
	ftell(fp);		/* set _cursec and _curbyt in fp */
	if (_fillbuf(fp) == ERROR ) {		 /* fill the buffer */
		free(fp -> _bufbase);
		return ERROR;
	}
	return fp;
}

/*
	flushes, then closes the random file at fp
*/

rclose(fp)			/* return -1 on error */
struct _file *fp;
{
	int err_flag;

	err_flag = _rflush(fp);			/* flush buffer */
	free(fp->_bufbase);			/* free buffer space */
	if (close(fp->_rfd) == ERROR) return ERROR;	/* close it */
	return err_flag;			/* did it flush ok? */
}
/*
	fills buffer pointed at by fp->_bufbase, with file fp->_rfd,
with fp->_secs sectors, starting with cp/m random record field
fseek calls this after updating cp/m's rrf and fp's pointers (if
necessary because seek is out of buffer area)
*/

_fillbuf(fp)			/* return -1 on error, 0 if OK */
struct _file *fp;
{
	int fd, secs, got;
	byte *base;
	unsigned rseek();

	fd = fp -> _rfd;
	secs = fp -> _secs;
	base = fp -> _bufbase;

/* call rread for sectors till buffer full or ERROR */
	/* try to read all of buffer */
	while  (secs -= (got = rread(fd, base, secs))) {
		if ((got > 1000) OR (got == -1)) return ERROR;
		/* unwritten random sector in buffer area */
		/* fill this sector with 0's */
		setmem((base += (got * SECSIZ)), SECSIZ, 0);
		base += SECSIZ;			/* inc. buffer ptr */
		rseek(fd, 1, 1);		/* inc. file ptr */
		--secs;			/* this one filled with 0 */
	}			/* try filling rest of buffer */
	fp -> _update = NO;			/* clear update flag */
	return OK;
}
/*
	flushes the buffer fp->_bufbase if open for writing AND
fp->_update shows the buffer has indeed been written to since
last _fillbuf call. ignores flushes of i/o devices
*/

_rflush(fp)			/* return -1 on error, 0 if OK */
struct _file *fp;
{
	unsigned rseek();

	if ((fp < 4) OR (fp->_mode == 'r') OR (fp->_update == NO))
		return OK;		/* don't bother */
	if (rseek(fp -> _rfd,fp -> _frstsec, 0) == ERROR) return ERROR;
			/* seek first bufferd sec and ... */
	if (rwrite(fp->_rfd, fp->_bufbase, fp->_secs) != fp->_secs)
		return ERROR;	/* ...write entire buffer to disk */
	fp -> _update = NO;			/* clear update flag */
	return OK;
}
/*
	sets '_nxtbyt' of 'fp' to 'sector's and 'byt's from
'origin' , returns cp/m current random sector.
CAUTION!!! use of origin 1 and 2 not usable yet. will install long int
package some day to impliment them. -
*/

unsigned    /* returns currently addressed sec in buf, -1 on error */
fseek(fp, sector, byt, origin)
struct _file *fp;
unsigned sector;
byte byt;
int origin;
{
	unsigned ftell(), rseek(), rcfsiz();

	switch (origin) {
	case 0:	break;			/* from beginning of file */
	case 1:	sector += ftell(fp);	/* from present loc */
		break;
	case 2:	sector += rcfsiz(fp->_rfd); /* from end, must be neg */
		break;
	default:
		return ERROR;
	}
	if ((sector >= fp->_frstsec) AND	/* if in buffer */
		(sector < (fp->_frstsec + fp->_secs))) {
		fp->_nxtbyt = (sector - fp->_frstsec)*SECSIZ
			+ byt + fp->_bufbase;	/* point to it */
		return ftell(fp);
	}
	if (_rflush(fp) == ERROR) return ERROR;	/* else flush buf */
	if (rseek(fp->_rfd, sector, 0) == ERROR) return ERROR;
	fp->_frstsec = sector;			/* seek sec in file, */
	fp->_nxtbyt = byt + fp->_bufbase;	/* and init ptrs */
	if (_fillbuf(fp) == ERROR) return ERROR;	/* fill buf */
	return ftell(fp);	/* and return cp/m curr random sec */
}
/*
	sets 'fp->_cursec and _curbyt', returns current random
sector ('fp->_cursec', NOT the random rec field of the fcb).
call before believing fp->_curbyt or fp->_cursec.
*/

unsigned    /* returns currently addressed sec in buf, -1 on error */
ftell(fp)
struct _file *fp;
{
	unsigned b;

	fp->_curbyt = (b = fp->_nxtbyt - fp->_bufbase) % SECSIZ;
	return (fp->_cursec = b / SECSIZ + fp->_frstsec);
}
/*
	seek a current byte that equals the block size * block #,
	return the current block number or ERROR
	max block # is 65534, large block sizes might cause
	arithmatic overflow before this value is reached
*/

unsigned		/* returns cur. addressed block, -1 on error */
bseek(fp, block, origin)
struct _file *fp;
unsigned block;
int origin;
{
	unsigned sector, fseek();
	int r1, r2, blocksiz;
	byte byt;

	switch (origin) {
	case 0:	break;				/* from begin */
	case 1:	block += fp->_curblk;		/* from curr pos */
		break;
	case 2:		/* not supported */
	default:
		return ERROR;
	}
	blocksiz = fp->_blksiz;
	sector = (blocksiz/128)*block + (r1=(blocksiz%128))*(block/128)
		    + (r1*(r2=(block%128)))/128; /* need LONG INT */
	byt = r1 * r2 % 128;		/* hope this is right */
	if (fseek(fp, sector, byt, 0) == ERROR) return ERROR;
	return (fp->_curblk = block);
}
/*
	returns the current randomly addressed block
	that is, the last random block sought by
	bseek(), may not reflect _cursec and _curbyt
	if reads or writes have been done since bseek()
*/
unsigned				/* returns current log block */
btell(fp)
struct _file *fp;
{
	return (fp->_curblk);
}

/*
	returns a char from random buffered file 'fp'
*/

int			/* returns -1 on error */
rgetc(fp)
struct _file *fp;
{
	if (fp == 0) return getchar();		/* from con */
	if (fp == 3) return bdos(3);		/* from reader */
	if (fp->_pastbuf - fp->_nxtbyt)  return *fp->_nxtbyt++;
						/* in buffer */
	if (fseek(fp,0,0,1) == ERROR) return ERROR;
	/* else seek one byte beyond buf, forcing flush and fill */
	return *fp->_nxtbyt++;		/* now get it from buffer */
}

/*
	random buffered 'unget' a char. Only one call between
	'rgetc()' calls
*/

int			/* returns OK, -1 on error */
rungetc(c, fp)
char c;
struct _file *fp;
{
	if (fp == 0) return ungetch(c);			/* con */
	if (fp->_nxtbyt <= fp->_bufbase) return ERROR;
					/* can't push past begin */
	*--fp->_nxtbyt = c;		/* do it */
	fp->_update = YES;
	return OK;
}

/*
	puts the char 'c' into random buffered file 'fp'
*/

int			/* returns -1 on error */
rputc(c, fp)
char c;
struct _file *fp;
{
	if (fp->_mode == 'r') return ERROR; /* cant put in read file */
	if (fp == 1) return putchar(c);		/* to con */
	if (fp == 2) return bdos(5,c);		/* to list */
	if (fp == 3) return bdos(4,c);		/* to punch */
	if (fp->_pastbuf - fp->_nxtbyt) {		/* in buffer */
		fp->_update = YES;		    /* set update */
		return *fp->_nxtbyt++ = c;		/* write it */
	}
	if (fseek(fp,0,0,1) == ERROR) return ERROR; /* flush & fill */
	fp->_update = YES;			    /* set update */
	return *fp->_nxtbyt++ = c;		/* write it */
}
/*
	returns a 16 bit word from file 'fp'
*/

int			/* returns -1 on error */
rgetw(fp)
struct _file *fp;
{
	int a,b;	
	if (((a=rgetc(fp)) >= 0) && ((b= rgetc(fp)) >=0))
			return 256*b+a;
	return ERROR;
}
/*
	writes the 16 bit word 'w' to file 'fp'
*/

int			/* returns -1 on error */
rputw(w, fp)
int w;
struct _file *fp;
{
	if ((rputc(w % 256,fp) >=0 ) && (rputc(w / 256,fp) >= 0))
				return w;
	return ERROR;
}

/*
	gets a TRUE c string (null term.) from file 'fp'
into 'str', returns ptr to 'str'

*/

char *					/* returns -1 on error */
rgets(str, fp)
char *str;
struct _file *fp;
{
	int count, c;
	char *cptr;
	count = MAXLINE;
	cptr = str;
	while ((count-- - 1) && (c=rgetc(fp)) != EOF && c ) {
		*cptr++ = c;				/* stuff it */
	}
	if (c == EOF) return ERROR;
	*cptr = '\0';					/* null */
	return str;
}

/*
	puts the null terminated c 'str' into 'fp', including null
*/

rputs(str, fp)			/* returns OK, -1 on error */
char *str;
struct _file *fp;
{
	do {
		if (rputc(*str, fp) == ERROR) return ERROR;
	} while (*str++);
	return OK;
}

/*
	gets the LF terminated text from 'fp' into 'line',
stripping off CRs from CR-LF combos

*/

char *			/* returns NULL on error */
rgetl(line, fp)
char *line;
struct _file *fp;
{
	int count, c;
	char *cptr;
	count = MAXLINE;
	cptr = line;
	if ((c = rgetc(fp)) == CPMEOF || c == EOF) return NULL;

	do {
		if ((*cptr++ = c) == '\n') {
		  if (cptr>line+1 && *(cptr-2) == '\r')
			*(--cptr - 1) = '\n';
		  break;
		}
	 } while (count-- && (c=rgetc(fp)) != EOF && c != CPMEOF);

	if (c == CPMEOF) rungetc(c, fp);	/* push back control-Z */
	*cptr = '\0';
	return line;
}

/*
	puts string at 'line' into 'fp', converting LFs to CR-LFs
if no LF exists no terminator (crlf) is written (ala fputs)

*/

rputl(line, fp)			/* returns OK, -1 on error */
char *line;
struct _file *fp;
{
	char c;
	while (c = *line++) {
		if (c == '\n') {
			if (rputc('\r', fp) == ERROR) return ERROR;
		}
		if (rputc(c, fp) == ERROR) return ERROR;
	}
	return OK;
}

/*
	gets 'nbyts' into memory starting at 'destination' from
file in 'fp'
*/

byte *				/* returns -1 on error */
rget(fp, destination, nbyt)
struct _file *fp;
byte *destination;
unsigned nbyt;
{
	byte b, *ptr;

	ptr = destination;
	while (nbyt--) {
		if ((b = rgetc(fp)) == ERROR) return ERROR;
		*ptr++ = b;
	}
	return destination;
}
/*
	puts 'nbyts' into file 'fp' from 'source'
*/

rput(fp, source, nbyt)			/* returns OK, -1 on error */
struct _file *fp;
byte *source;
unsigned nbyt;
{
	while (nbyt--) {
		if (rputc(*source++, fp) == ERROR) return ERROR;
	}
	return OK;
}

/*
    gets struct 'structsiz' long into memory starting at 'struct_add'
from file in 'fp'
*/

byte *					/* returns -1 on error */
rgetstruct(fp, struct_add, structsiz)
struct _file *fp;
byte *struct_add;
unsigned structsiz;
{
	byte b, *ptr;

	ptr = struct_add;
	while (structsiz--) {
		if ((b = rgetc(fp)) == ERROR) return ERROR;
		*ptr++ = b;
	}
	return struct_add;
}
/*
	puts struct 'structsiz' long into file 'fp' from 'struct_add'
*/

rputstruct(fp, struct_add, structsiz)	/* returns OK, -1 on error */
struct _file *fp;
byte *struct_add;
unsigned structsiz;
{
	while (structsiz--) {
		if (rputc(*struct_add++, fp) == ERROR) return ERROR;
	}
	return OK;
}
/*
	printf to random buffered file
*/

int			/* returns OK, -1 on error */
rprintf(fp, format)
struct _file *fp;
char *format;
{
	char text[MAXLINE];
	_spr(text,&format);
	return rputl(text,fp);
}

/*
	scanf to random buffered file
*/

int			/* returns # of successful matches, 0 on EOF */
rscanf(fp, format)
struct _file *fp;
char *format;
{
	char text[MAXLINE];
	if (!rgetl(text,fp)) return 0;
	return _scn(text,&format);
}

error */
rgetstruct(fp, struct_a