/********************************************************************

	rcv.c -

	Ward Christensen Protocol handler for receiving ascii and binary files.
functions taken from yam package by Chuck Forsberg, cug disk Utilities
III, some modifications made for compatibility with cnode code.

*/

/* begincode */

#include "a:std.h"
#include "b:cnode.h"
#include "b:cnode.g"

main(argc, argv)
int argc;
char **argv;
{
	char rpn[SECSIZ];		/* rx path name */
	Batch = FALSE;

	++argv;			/* point to first file name */
	if(Batch || argc==1) {
		vprintf(C_M, "Batch mode not implimented yet, sorry\n");
		return OK;
/**
		vprintf(C_M, "Receiving in Batch Mode\n");
		for(;;) {
			if(wcrxpn(rpn)== ERROR)
				goto fubar;
			if(*rpn==0)
				return OK;
			if(wcrx(rpn)==ERROR)
				goto fubar;
		}
*/
	}
	else
		while (--argc >= 1) {
			if (upvalid(Rname, *argv) == ERROR) {
				vprintf(C_M, "\ncan't, bad name!");
				return ERROR;
			}
			vprintf(C_M, "ready to receive '%s'\n", *argv++);
			if(wcrx(Rname)==ERROR)
				goto fubar;
		}
	return OK;
fubar:
	sendbyt(CAN);sendbyt(CAN);sendbyt(CAN);
	closerx(TRUE);
	return ERROR;
}
/*
 * Fetch a pathname from the other end as a C ctyle ASCIZ string.
 * Length is indeterminate as long as less than SECSIZ
 * a null string represents no more files
 */

/** no batch yet -
wcrxpn(rpn)
char *rpn;	/* receive a pathname */
{
	char rname[SECSIZ];


	sendbyt(NAK);
	if(wcgetsec(rname, 100)==ERROR) {
		vprintf(C_M, "Pathname fetch failed\n");
		return ERROR;
	}
	strcpy(rpn, rname);
	sendbyt(ACK);
	return OK;
}

*/

/*
 * Adapted from CMODEM13.C, written by
 * Jack M. Wierda and Roderick W. Hart
 */

wcrx(name)
char *name;
{
	int sectnum, sectcurr, sectcomp;
	char *cp, rxbuf[128], sendchar;

	if(openrx(name)==ERROR)
		return ERROR;
	sectnum=0;
	sendchar=NAK;
	xsleep(50);				/* wait 5 secs */

	for(;;) {
		sendbyt(sendchar);	/* send it now, we're ready! */
		sectcurr=wcgetsec(rxbuf, (sectnum & 0x7f) ? 50 : 130);
		if(sectcurr==(sectnum+1 & 0xff)) {	/* mask low byte */

			sectnum++;
			for(cp=rxbuf,Wcj=128; --Wcj>=0; )
				if(putc(*cp++, File_buf)==ERROR) {
					vprintf(C_M, "\nDisk Full\n");
					return ERROR;
				}
			sendchar=ACK;
		}
		else if(sectcurr==sectnum) {
			vprintf(CON, "Received dup Sector %d",sectcurr);
			sendchar=ACK;
		}
		else if(sectcurr==WCEOT) {
			sendbyt(ACK);
			/* don't pad the file any more than it already is */
			closerx(FALSE);
			return OK;
		}
		else {
			vprintf(C_M, " Sync Error\n");
			return ERROR;
		}
	}
}

/*
 * wcgetsec fetches a Ward Christensen type sector.
 * Returns sector number encountered or ERROR if valid sector not received,
 * or CAN CAN received
 * or WCEOT if eot sector
 * time is timeout for first char, set to 4 seconds thereafter
 ***************** NO ACK IS SENT IF SECTOR IS RECEIVED OK **************
 *    (Caller must do that when he is good and ready to get next sector)
 */

wcgetsec(rxbuf, time)
char *rxbuf;
int time;
{
	int sectcurr,errors;
	char *cp;

	for(Lastrx=errors=0; errors<RETRYMAX; errors++) {
		do {
			Firstch=readbyt(time);
		}
		while(Firstch != SOH && Firstch != TIMEOUT && Firstch != EOT
			  && Firstch != CAN);	/* wait for one of these */
		if(Firstch==SOH) {
			sectcurr=readbyt(1);
			if((sectcurr+readbyt(1))==255) {
				Checksum=0;
				for(cp=rxbuf,Wcj=128; --Wcj>=0; ) {
					if ( isprint(*cp = readbyt(1))					|| *cp == '\r' || *cp == '\n' || *cp == '\t'
					)	cputchar(*cp);
					else cputchar('.');
					Checksum += (*cp++);
				}
				if(((Checksum-readbyt(1))& 0xff)==0)
					return sectcurr;
				else
					vprintf(CON, "Checksum Error #%d", errors);
			}
			else
				vprintf(CON, "Sector number garbled #%d", errors);
		}
		else if(Firstch==EOT)
			return WCEOT;
		else if(Firstch==CAN) {
			if(Lastrx==CAN) {
				vprintf(C_M, "\nSender CANcelled");
				return ERROR;
			} else {
				Lastrx=CAN;
				continue;
			}
		}
		else if(Firstch==TIMEOUT)
			vprintf(CON, "\nSOH Timeout #%d", errors);

		Lastrx=0;
		while(readbyt(1)!=TIMEOUT)
			;
		sendbyt(NAK);
#ifdef DEBUG
vprintf(CON, "\njust sent NAK");
#endif
		time=40;
	}
	/* try to stop the bubble machine. */
	sendbyt(CAN);sendbyt(CAN);sendbyt(CAN);
	return ERROR;
}

openrx(name)
char *name;
{
#ifdef LOGFILE
	logfile(name, 'r');		/* record file xmsn */
#endif
	vprintf(CON, "\nsaving it as '%s'", name);/* show the name right away */
	if(fopen(name, File_buf) != ERROR) {
		fclose(File_buf);
		vprintf(C_M, "\nI already have one, try another name");
		return ERROR;
	}
	if(fcreat(name, File_buf)==ERROR){
		vprintf(C_M, "\nCan't create '%s'", name);
		return ERROR;
	}
	Rfile= TRUE;
	return OK;
}

upvalid(pname, name)
char *pname;
char *name;
{
	purge_ws(name);
	if (strlen(name) > 12) {
		vprintf(C_M, "\n'%s' doesn't fit (name too long)", name);
		return ERROR;
	}
	strcpy(pname, "b:");	/* all uploads to disk b */
	strcat(pname, name);

#ifdef RESTRICTED
	char *s;
	if (s=cisubstr(pname, ".com"))	/* upload .com files as .obj */
		strcpy(s, ".obj");
	else if (s=cisubstr(pname, ".cmd"))	/* upload .cmd files as .xxx */
		strcpy(s, ".xxx");
	else if (s=cisubstr(pname, ".sys"))	/* upload .sys files as .xxx */
		strcpy(s, ".xxx");
	else if (s=cisubstr(pname, ".mbx"))	/* upload .mbx files as .xxx */
		strcpy(s, ".xxx");
	if(cisubstr(pname, "$$$"))
		return ERROR;		/* don't allow upload of $$$.sub */
#endif
	return OK;
}

sendbyt(byt)
char byt;
{
	while (!(inp(UART_STATUS) & BUFFER_EMPTY))
	;		/* wait */
	outp(DATA_OUT, byt);
}

readbyt(decisecs)
int decisecs;
{
	if (inp(UART_STATUS) & DATA_READY)
		return inp(DATA_IN);
	while (--decisecs >= 0) {
		if (inp(UART_STATUS) & DATA_READY)
			return inp(DATA_IN);
		if (bdos(DIR_IO, INPUT))	/* local forced timeout */
			return TIMEOUT;
		if (inp(UART_STATUS) & DATA_READY)
			return inp(DATA_IN);
		for (Timeout = T1pause; --Timeout; )
			if (inp(UART_STATUS) & DATA_READY)
				return inp(DATA_IN);
	}
	return TIMEOUT;
}

/* endcode */
