;
; MBOOT.ASM ver 3.0 AS MODIFIED FOR THE OSBORNE-1
; (revised 21 MAR 82)
;
;MODEM BOOT PROGRAM by Keith Petersen, W8SDZ.
;Thanks to John Taylor for idea of incorporating
;simple terminal routine.  Based on MODEM.ASM V2.0,
;by Ward Christensen with enhancements from MODEM527.
;
;CP/M - CP/M file transfer program (receive-only)
;
;This program is intended for use as a way to
;initially transfer MODEM.COM or MODEM.ASM to
;a new user.  It may be used with almost any
;modem (see equates).  If PMMI or D.C. Hayes modem
;is used, then uses 'ORIGINATE' mode, 300 baud.
;
;A simple terminal routine at start of program allows
;user to communicate with a remote system prior to
;receiving a file to make it possible to down-load
;a file without intervention on the part of the host
;system's operator.
;
;COMMANDS:  MBOOT FILENAME.FILETYPE
; or  MBOOT A:FILENAME.FILETYPE
; or  MBOOT B:FILENAME.FILETYPE
;
;The program will operate as a dumb terminal until
;an 'ESC' key is typed (ctrl-[).  It then branches
;to the receive routine.  The user may also exit
;to CP/M without opening the receive file by typing
;ctrl-E from the terminal.  The values for the escape
;and exit keys may be changed in accordance with the
;needs of the user - some keyboards do not have the
;'ESC' key and/or provision for control characters.
;See equates.
;
;NOTE: Comments for the source code and tabs have been
;removed to make this file easier to transport from one
;system to another.  (KBP)
;
FALSE EQU 0
TRUE  EQU NOT FALSE
;
STDCPM EQU TRUE  ;TRUE, IS STANDARD CP/M
;
BASE EQU 0
;
EXITCHR EQU 05H ;CTL-E TO EXIT TERM MODE TO CP/M
ESC     EQU 1BH ;ESCAPE TO EXIT TERM MODE TO FILE RCVE
;
ERRLIM EQU 10
;
SOH EQU 1
EOT EQU 4
ACK EQU 6
NAK EQU 15H
CAN EQU 18H
LF  EQU 10
CR  EQU 13
; 
BDOS EQU BASE+5
FCB  EQU BASE+5CH
;
 ORG BASE+100H
 CALL MXINIT
 JMP START
;
; --- CUSTOM MODEM DRIVER FOR OSBORNE-1 ---
;
  JMP MXINIT ; INIT MODEM ROUTINES (NOT HARDWARE)
IN$MODDATP JMP MXIN ; GET DATA FROM MODEM
OUT$MODDATP JMP MXOUT ; OUTPUT DATA TO MODEM
IN$STAT  JMP MXISTAT ; TEST FOR INPUT DATA
OUT$STAT JMP MXOSTAT ; TEST IF OK TO OUTPUT DATA
SET$BAUD JMP MXSETBAUD ; SETUP BAUDRATE
JMP$INITMOD JMP MXINITH ; INIT MODEM HARDWARE
;
MODCTLP EQU 2A00H ;ALTERNATE PAGE DATA PORT
MODSNDB EQU 02H ;YOUR BIT TO TEST FOR SEND
MODSNDR EQU 02H ;YOUR VALUE WHEN READY
MODRCVB EQU 01H ;YOUR BIT TO TEST FOR RECEIVE
MODRCVR EQU 01H ;YOUR VALUE WHEN READY
MODDATP EQU 2A01H ;ALTERNATE PAGE DATA PORT
;
; --- ALL OF THE MODEM ROUTINES MAY ONLY CHANGE ---
; THE A-REGISTER AND THE FLAGS.  NO OTHER
; REGISTERS MAY BE CHANGED.
;
; --- INPUT DATA FROM MODEM ---
;
MXIN CALL 0 ; PATCHED TO CALL INPUT ROUTINE
 RET
;
; --- OUTPUT DATA TO MODEM ---
;
MXOUT CALL 0 ; PATCHED TO CALL OUTPUT ROUTINE
 RET
;
; --- TEST IF DATA IS AVAILABLE FROM MODEM ---
;
MXISTAT CALL 0 ; PATCHED TO CALL STATUS ROUTINE
 ANI MODRCVB
 CPI MODRCVR 
 RET  ; RETURN WITH Z SET IF DATA IS READY
;
; --- TEST MODEM IS READY TO BE SENT NEXT CHAR. ---
;
MXOSTAT CALL 0 ; PATCHED TO CALL STATUS ROUTINE
 ANI MODSNDB
 CPI MODSNDR
 RET  ; RETURN WITH Z SET IF MODEM IS READY
;
; --- INIT MODEM ROUTINES (NOT HARDWARE) ---
; THIS ROUTINE NEED NOT PRESERVE ANY
; OF THE REGISTERS.
;
MXINIT LXI D,MSG ; POINT TO MESSAGE
 MVI C,9
 CALL 05H ; USE BDOS CALL TO PRINT STRING
;
 LHLD 6 ; FIND TOP OF USER RAM
 LXI D,-100H ; STEP DOWN A LITTLE
 DAD D
 PUSH H ; SAVE IT
 LXI D,BDJ ; POINT TO SOURCE OF CODE
 LXI B,CDLEN+2 ; SET LENGTH OF CODE
 XCHG
 DB 0EDH,0B0H ; --- FAKE LDIR
;
 LHLD 6 ; GET BDOS ADDRESS BACK
 POP D
 PUSH D
 INX D ; POINT TO ADDRESS POSITION
 XCHG
 MOV M,E ; PATCH IN ADDRESS
 INX H
 MOV M,D
;
 POP H
 SHLD 6 ; TRANSFER BDOS JUMP
;
 LXI D,OSIN-BDJ
 DAD D ; COMPUTE ADDRESS OF OSIN ROUTINE
 SHLD MXIN+1 ; PATCH CALL
 LXI D,OSOUT-OSIN
 DAD D
 SHLD MXOUT+1 ; PATCH CALL
 LXI D,OSTAT-OSOUT
 DAD D
 SHLD MXISTAT+1
 SHLD MXOSTAT+1
 RET
;
MSG: DB CR,LF,CR,LF
 DB ' SETUP FOR RS232 PORT ON OSBORN O-1'
 DB CR,LF,CR,LF,'$'
;
; --- INIT MODEM HARDWARE IF NECESSARY ---
; THIS ROUTINE MAY BE CALLED SEVERAL TIMES, SO BE
; SURE THAT THIS WILL NOT HANG UP THE HARDWARE.
;
MXINITH RET
;
; --- SET HARDWARE BAUDRATE FROM STRING POINTED TO BY---
; (H,L).  IF THE STRING STARTS WITH AN ASCII SPACE,
; SET THE BAUDRATE TO THE DEFAULT VALUE.  IF THE
; REQUEST IS NOT VALID, RETURN WITH CARRY SET.
;
; --- THIS WILL EITHER SETUP FOR 300 OR 1200 BAUD, 300 IF ERROR
MXSETBAUD:
 PUSH B
 MVI C,56H ; FOR 300 BAUD
 PUSH H
 PUSH D
 CALL OSET
 POP D
 POP H
 POP B
 XRA A ; CLEAR CARRY
 RET
;
OSET: LHLD 1 ; GET BIOS+3 ADDRESS
 MVI L,3CH ; SPECIAL OSBORN ROUTINE
 PCHL  ; BRANCH TO IT
;
;
; --- ROUTINES THAT GET COPIED UP TO TOP OF MEMORY ---
;  JUST UNDER THE BDOS
;
BDJ JMP 0 ; THIS GETS PATCHED TO JUMP TO BDOS ENTRY
;
OSIN DI  ; DISABLE INTERRUPTS
 OUT 0 ; SWITCH TO ALTERNATE PAGE
 LDA MODDATP ; GET DATA BYTE
 OUT 1 ; SWITCH BACK PAGES
 EI  ; RE-ENABLE INTERRUPTS
 RET
;
OSOUT DI  ; DISABLE INTERRUPTS
 OUT 0 ; SWITCH TO ALTERNATE PAGE
 STA MODDATP ; SEND DATA BYTE
 OUT 1 ; SWITCH BACK PAGES
 EI  ; RE-ENABLE INTERRUPTS
 RET
;
OSTAT DI  ; DISABLE INTERRUPTS
 OUT 0 ; SWITCH TO ALTERNATE PAGE
 LDA MODCTLP ; GET STATUS BYTE
 OUT 1 ; SWITCH BACK PAGES
 EI  ; RE-ENABLE INTERRUPTS
 RET
CDLEN EQU $-BDJ ; LENGTH OF CODE TO COPY
;
;
 ORG 300H ; START OF PROGRAM
; ----------------------------------------------------
;
START
 LXI H,0
 DAD SP
 SHLD STACK
 LXI SP,STACK
 CALL INITADR
 CALL ILPRT
 DB 'MBOOT as of '
 DB '11/5/80',CR,LF,0
 LDA FCB+1
 CPI ' '
 JNZ TERMI
 CALL ILPRT
 DB '++NO FILE NAME SPECIFIED++',CR,LF,0
 JMP EXIT
;
TERMI 
 CALL IN$MODDATP
 CALL IN$MODDATP
 CALL ILPRT
 DB CR,LF,'TERMINAL MODE',CR,LF
 DB 'CTL-E exits to CP/M, ESC starts file transfer'
 DB CR,LF,0
;
TERM CALL STAT
 JZ TERML
 CALL KEYIN
 CPI EXITCHR
 JZ EXIT
 CPI ESC
 JZ RCVFIL
 CALL OUT$MODDATP
;
TERML
;
 CALL IN$STAT
 JNZ TERM
 CALL IN$MODDATP
 ANI 7FH
 CALL TYPE
 JMP TERM
;
RCVFIL CALL ERASFIL
 CALL MAKEFIL
 CALL ILPRT
 DB 'FILE OPEN, READY TO RECEIVE',CR,LF,0
;
RCVLP CALL RCVSECT
 JC RCVEOT
 CALL WRSECT
 CALL INCRSNO
 CALL SENDACK
 JMP RCVLP
;
RCVEOT CALL WRBLOCK
 CALL SENDACK
 CALL CLOSFIL
 CALL ERXIT
 DB CR,LF,'TRANSFER COMPLETE$' 
;
RCVSECT XRA A
 STA ERRCT
;
RCVRPT MVI B,10
 CALL RECV
 JC RCVSERR
 CPI SOH
 JZ RCVSOH
 ORA A
 JZ RCVRPT
 CPI EOT
 STC
 RZ
;
RCVSERR MVI B,1
 CALL RECV
 JNC RCVSERR
 MVI A,NAK
 CALL SEND
 LDA ERRCT
 INR A
 STA ERRCT
 CPI ERRLIM
 JC RCVRPT
;
RCVSABT CALL CLOSFIL
 CALL ERXIT
 DB '++UNABLE TO RECEIVE BLOCK'
 DB CR,LF,'++ABORTING++$'
;
RCVSOH MVI B,1
 CALL RECV
 JC RCVSERR
 MOV D,A
 MVI B,1
 CALL RECV
 JC RCVSERR
 CMA
 CMP D
 JZ RCVDATA
 JMP RCVSERR
;
RCVDATA MOV A,D
 STA RCVSNO
 MVI C,0
 LXI H,BASE+80H
;
RCVCHR MVI B,1
 CALL RECV
 JC RCVSERR
 MOV M,A
 INR L
 JNZ RCVCHR
 MOV D,C
 MVI B,1
 CALL RECV
 JC RCVSERR
 CMP D
 JNZ RCVSERR
 LDA RCVSNO
 MOV B,A
 LDA SECTNO
 CMP B
 JZ RECVACK
 INR A
 CMP B
 JNZ ABORT
 RET
;
RECVACK CALL SENDACK
 JMP RCVSECT
;
SENDACK MVI A,ACK
;
SEND PUSH PSW
 ADD C
 MOV C,A
;
SENDW
 CALL OUT$STAT
 JNZ SENDW
 POP PSW
 CALL OUT$MODDATP
 RET
;
ABORT LXI SP,STACK
;
ABORTL MVI B,1
 CALL RECV
 JNC ABORTL
 MVI A,CAN
 CALL SEND
;
ABORTW MVI B,1
 CALL RECV
 JNC ABORTW
 MVI A,' '
 CALL SEND
 CALL ERXIT
 DB 'MBOOT PROGRAM CANCELLED$'
;
INCRSNO LDA SECTNO
 INR A
 STA SECTNO
 RET
;
ERASFIL LXI D,FCB
 MVI C,17
 CALL BDOS
 INR A
 RZ
 CALL ILPRT
 DB '++FILE EXISTS, TYPE Y TO ERASE: ',0
 CALL KEYIN
 PUSH PSW
 CALL TYPE
 CALL CRLF
 POP PSW
 ANI 5FH
 CPI 'Y'
 JNZ MXIT
 LXI D,FCB
 MVI C,19
 JMP BDOS
;
MAKEFIL LXI D,FCB
 MVI C,22
 CALL BDOS
 INR A
 RNZ
 CALL ERXIT
 DB '++ERROR - CAN''T MAKE FILE',CR,LF
 DB '++DIRECTORY MUST BE FULL$'
;
CLOSFIL LXI D,FCB
 MVI C,16
 CALL BDOS
 INR A
 RNZ
 CALL ERXIT
 DB '++CAN''T CLOSE FILE$'
;
WRSECT LHLD SECPTR
 XCHG
 LXI H,BASE+80H
 CALL MOVE128
 XCHG
 SHLD SECPTR
 LDA SECINBF
 INR A
 STA SECINBF
 CPI 16
 RNZ
;
WRBLOCK LDA SECINBF
 ORA A
 RZ
 MOV C,A
 LXI D,DBUF
;
DKWRLP PUSH H
 PUSH D
 PUSH B
 MVI C,26
 CALL BDOS
 LXI D,FCB
 MVI C,21
 CALL BDOS
 POP B
 POP D
 POP H
 ORA A
 JNZ WRERR
 LXI H,80H
 DAD D
 XCHG
 DCR C
 JNZ DKWRLP
 XRA A
 STA SECINBF
 LXI H,DBUF
 SHLD SECPTR
;
RSDMA LXI D,BASE+80H
 MVI C,26
 JMP BDOS
;
WRERR CALL RSDMA
 CALL ILPRT
 DB '++ERROR WRITING FILE',CR,LF,0
 JMP ABORT
;
RECV PUSH D
;
;
MSEC LXI D,50000
;
MWTI
 CALL IN$STAT
 JZ MCHAR
 DCR E
 JNZ MWTI
 DCR D
 JNZ MWTI
 DCR B
 JNZ MSEC
 POP D
 STC
 RET
;
MCHAR CALL IN$MODDATP
 POP D
 PUSH PSW
 ADD C
 MOV C,A
 POP PSW
 ORA A
 RET
;
INITADR LHLD BASE+1
 LXI D,3
 DAD D
 SHLD VSTAT+1
 DAD D
 SHLD VKEYIN+1
 DAD D
 SHLD VTYPE+1
 RET
;
INITMOD EQU $
;
 RET  ;<--THIS RET MUST BE HERE
;
CRLF MVI A,CR
 CALL TYPE
 MVI A,LF
;
TYPE PUSH PSW
 PUSH B
 PUSH D
 PUSH H
 MOV C,A
VTYPE CALL $-$
 POP H
 POP D
 POP B
 POP PSW
 RET
;
STAT PUSH B
 PUSH D
 PUSH H
VSTAT CALL $-$
 POP H
 POP D
 POP B
 ORA A
 RET
;
KEYIN PUSH B
 PUSH D
 PUSH H
VKEYIN CALL $-$
 POP H
 POP D
 POP B
 ANI 7FH
 RET
;
ILPRT XTHL
;
ILPLP MOV A,M
 ORA A
 JZ ILPRET
 CALL TYPE
 INX H
 JMP ILPLP
;
ILPRET XTHL
 RET
;
ERXIT POP D
 MVI C,9
 CALL BDOS
;
MXIT CALL ILPRT
 DB CR,LF,'DON''T FORGET TO DISCONNECT MODEM'
 DB CR,LF,0
;
EXIT LHLD STACK
 SPHL
 RET
;
MOVE128 MVI B,128
;
MOVE MOV A,M
 STAX D
 INX H
 INX D
 DCR B
 JNZ MOVE
 RET
;
RCVSNO DB 0
SECTNO DB 0
ERRCT DB 0
EOFLG DB 0
SECPTR DW DBUF
SECINBF DB 0
 DS 60
STACK DS 2
DBUF EQU $
;
 END
