/* a program to create/alter logfiles for the cboard software */

/*	This program will allow the examination of the data
	associated with a 'password' number. After entering
	a number its place is looked up in logfile.dat. The
	structure beginning at that point contains the id#,
	first name, etc. of a particular caller. The format
	of this structure is:

id_#:first_name:total_calls:last_call:group_#:privilege_#
 uns  string[15] uns         uns       byte    byte

	Other data obtained at id assignment time is kept in a
	seperate file, contact.dat

*/

/* begincode */

/* includes */

#include "a:std.h"		/* bdscio + my stuff */
#include "b:cnode.h"		/* things for the cnode package */

/* defines */

/* structs */

/* globals */

struct _file log;
struct _log_data data;
string log_name[20];
unsigned next_id, id_num;

/* beginmain */

main()
{
	_allocp = NULL;
	log._blksiz = sizeof(data);		/* for bseek */

	int fake;
	char c;

	printf("\f\n\tLogfile maintainance program:\n\n");
	strcpy(log_name, "b:logfile.dat");	/* default file */
name:	printf("\nOk to work with %s? ", log_name);
	if (tolower(getchar()) == 'n') {
		printf("\n\t\tSpecify file name: ");
		scanf("%s", log_name);
	}
/* open data file for random access */
	if (ropen(log_name, &log, 'd', 2) == ERROR) {
		printf("\n\tCan't open %s", log_name);
		printf("\n\t\tShall I create %s? ", log_name);
		if (tolower(getchar()) == 'n') goto name;
		if (new_log() == ERROR) goto name;
	}
/* display range of valid id#'s */
	next_id = rgetw(&log);
id:
	printf("\n\tThe next available id number is %d", next_id);
/* ask for id */
	printf("\n\t\tWhich id# shall we work with? ");
	if (scanf("%d", &id_num) == 0) done();
/* block seek the relative id struct */
	if (bseek(&log, (id_num - 1000), 0) == ERROR) {
		printf("\n\tCan't seek id %u.", id_num);
		goto id;			/* start fresh */
	}
/* read structure */
	if (rgetstruct(&log, &data, sizeof(data)) == ERROR) {
		printf("\n\tCan't read struct for id# %u", id_num);
		goto id;			/* start fresh */
	}
/* change field: */
    printf("\n\n%-6s%-15s","1.id","2.first name"); /* fields */
    printf("%-7s%-7s%-6s","3.llen","4.plen","5.nls");
    printf("%-8s%-7s","6.group","7.priv");
    printf("%-8s%-7s","8.calls","9.last");
    printf("%-5s%-4s","a.s1","b.s2");

    while (TRUE) {		/* change loop */

    printf("\n%6u%15s",data._id_number,data._first_name); /* display */
    printf("%7d%7d%6d",data._llen,data._plen,data._nulls);
    printf("%8d%7d",data._group,data._privileges);	 /*  struct */
    printf("%8u%7u",data._total_calls,data._last_call);  /*   the   */
    printf("%5d%4d",data._spare_1,data._spare_2);
	printf("\n\nChange field # ");		/* ask for change */
	if ((c = getchar()) == '\n') break;	/* exit from loop */
	switch (c) {
	case '1':
		printf("  %u to ", data._id_number);
		scanf("%u", &data._id_number);
		break;
	case '2':
		printf("  %s to ", data._first_name);
		scanf("%s", data._first_name);
		break;
	case '3':
		printf(" %d chars per line to ", data._llen);
		scanf("%d", &fake);    /* scanf can't scan short int */
		data._llen = fake;	/* ..so lets fake it */
		break;
	case '4':
		printf(" %d lines per page to ", data._plen);
		scanf("%d", &fake);
		data._plen = fake;
		break;
	case '5':
		printf(" %d nulls to ", data._nulls);
		scanf("%d", &fake);
		data._nulls = fake;
		break;
	case '6':
		printf("  group %d to group ", data._group);
		scanf("%d", &fake);
		data._group = fake;
		break;

	case '7':
		printf("  privilege level %d to ", data._privileges);
		scanf("%d", &fake);
		data._privileges = fake;
		break;
	case '8':
		printf("  %u total calls to ", data._total_calls);
		scanf("%u", &data._total_calls);
		break;
	case '9':
		printf("  (future) last call on ");
printf("%u",data._last_call);	/* future julian to calendar funct */
		printf(" to ");
		scanf("%u", &data._last_call);
		break;
	case 'a':
		printf(" %d to ", data._spare_1);
		scanf("%d", &fake);
		data._spare_1 = fake;
		break;
	case 'b':
		printf(" %d to ", data._spare_2);
		scanf("%d", &fake);
		data._spare_2 = fake;
		break;
	default:
		printf("Can't do field # %c", c);
	}
    }
update:
	printf("\n\n\t(K)eep or (P)urge this person? ");
	switch (tolower(getchar())) {
	case 'k':
/* inc next_id if necessary */
		if (id_num >= next_id) {
			next_id = id_num + 1;
		}
		break;
	case 'p':
		data._id_number = 0;		/* nullify rec */
		break;
	default:
		printf("\n\n\tHuh?");
		goto update;
	}
/* write struct to disk */
	if (bseek(&log, 0, 1) == ERROR) { /* reseek struct be4 read */
		printf("\n\tCan't reseek %u", id_num);
	}
	if (rputstruct(&log, &data, sizeof(data)) == ERROR) {
		printf("\n\tCan't update id# %u", id_num);
	}
	goto id;
}
/* endmain */

/* close files and return to opsystem */

done()
{
	fseek(&log, 0, 0, 0);			/* go to beginning */
	rputw(next_id, &log);			/* store next id # */
	if (rclose(&log) == ERROR) {
		printf("\n\t\tCan't close %s!", log_name);
	}
	exit();					/* return to opsys */
}

/* create and initialize a new logfile, erasing any old copies */

new_log()
{
/* create the file */
	if (rcreat(log_name, &log, 'd', 2) == ERROR) {
		printf("\n\tCan't create %s", log_name);
		return ERROR;
	}
/* add the 'next_id' value at record 0 */
	rputw(1002, &log);		    /* one beyond 'guest' */
/* add struct 'guest' at record 1 */
	data._id_number = 1001;
	data._llen = 64;
	data._plen = 16;
	data._nulls = 1;
	data._group = 1;				/* public */
	data._privileges = 1;			/* lowest */
	strcpy(data._first_name, "guest");	/* default name */
	data._total_calls = 0;
	data._last_call = 0;			/* not used yet */
	data._spare_1 = 0;
	data._spare_2 = 0;
	if (bseek(&log, 1, 0) == ERROR) {	/* find struct 1 */
		printf("\n\tCan't seek logical block 1");
	}
	if (rputstruct(&log, &data, sizeof(data)) == ERROR) {
		printf("\n\tCan't write default struct to file");
	}
	fseek(&log, 0, 0, 0);			/* back to beginning */
	return TRUE;
}

/* endcode */
/*	printf("\n\treading struct of size %u", sizeof(data)); */
/*	printf("\n\twriting struct of size %u", sizeof(data)); */
