/********************************************************************
	cnlib.c - library of common functions
*/

/* begincode */

#include "a:std.h"		/* bdscio.h + my stuff */
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */


/* remove all whitespace from string */

purge_ws(str)
string *str;
{
	char *ptr;

	for (ptr = str; *str; str++)
		if (!isspace(*str))
			*ptr++ = *str;
	*ptr++ = '\0';	/* ++ needed? */
}

/* change all uppercase alpha to lowercase */

purge_uc(str)
string *str;
{
	while (*str) *str = tolower(*str++);
			/* works, I don't like place of '++' */
}

/* returns TRUE if c is a printing char */

isprint(c)
char c;
{
	return c >= ' ' AND c <= '~';
}

build_fn(str, disk, fn, ft)
char *str;
char *disk;
char *fn;
char *ft;
{
	if (isalpha(disk[0])) {
		str[0] = disk[0];
		str[1] = ':';
		str[2] = '\0';
	}
	else if (disk[0] == '\0')	str[0] = '\0';
	else return ERROR;
	if (strlen(fn) <= 8) {
		strcat(str, fn);
	}
	else return ERROR;
	if (strlen(ft) <= 3) {
		strcat(str, ".");
		strcat(str, ft);
		return str;
	}
	else return ERROR;
}

qswapin(name,addr)
char *name;		/* the file to swap in */
unsigned addr;
{
	int fd, x;
	if (( fd = open(name,0)) == ERROR) {
		return ERROR;
	}
	if ((x = read(fd,addr,512)) < 0) {
		close(fd);
		return ERROR;
	}
	close(fd);
	return OK;
}

/* check for whitespace or ',' */

isdlmtr(c)
char c;
{
	return (isspace(c) || (c == ','));
}

xsleep(tenths)
int tenths;
{
	int x;

	for (;tenths--;)
		for (x = 4348;x--;)	;
}

purgeline()
{
	while (inp(UART_STATUS) & DATA_READY)
		inp(DATA_IN);
}

/*
 * cisubstr(string, token) searches for lower case token in string s
 * returns pointer to token within string if found, NULL otherwise
 */
char *
cisubstr(s, t)
char *s,*t;
{
	char *ss,*tt;
	/* search for first char of token */
	for(ss=s; *s; s++)
		if(tolower(*s)==*t)
			/* compare token with substring */
			for(ss=s,tt=t; ;) {
				if(*tt==0)
					return s;
				if(tolower(*ss++) != *tt++)
					break;
			}
	return NULL;
}
/*
 * index returns a pointer to the first occurrence of c in s,
 * NULL otherwise.
 */
char *
index(c, s)
char c,*s;
{
	for(; *s; s++)
		if(c== *s)
			return s;
	return NULL;
}

printf(format)
char *format;
{
	vprintf(C_M, "\ncode ERROR: printf()\n");
}

puts(s)
char *s;
{
	vprintf(C_M, "\ncode ERROR: puts()\n");
}

putchar(c)
char c;
{
	vprintf(C_M, "\ncode ERROR: putchar()\n");
}

gets(s)
char *s;
{
	vprintf(C_M, "\ncode ERROR: gets()\n");
}

getchar()
{
	vprintf(C_M, "\ncode ERROR: getchar()\n");
}

/* endcode */
