/********************************************************************
	cncmds.c - the command processor for the cnode package
*/
/* begincode */

#include "a:std.h"		/* bdscio.h + my stuff */
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */

/* execute user commands */

commands()
{
	int p_argc;
	char *p_argv[P_ARGNUM];
	string swap_file[15];
	int (*segment)();
	FLAG still_running, err_flag;
 
	segment = SEG_LOAD;
	err_flag = FALSE;
	still_running = TRUE;

	while (still_running) {			/* command loop */
		vprintf(C_M, "\n\n%% ");	/* prompt */
		vgets(Reply, MAXLINE, C_M);	/* command */
		if ((p_argc = pull_args(Reply, p_argv)) == ERROR) {
			vprintf(C_M, "\n huh???");
			continue;
		}
		if (p_argc == 0) {
			continue;
		}
	/* check first word for legal command */
		if (strcmp(p_argv[0], "?") IS_SAME) {
			err_flag = send_text("a:command.hlp", YES);
		}
		else if (strcmp(p_argv[0], "help") IS_SAME) {
			err_flag = help(p_argc, p_argv);
		}
		else if (strcmp(p_argv[0], "cm") IS_SAME) {
			err_flag = cm(p_argc, p_argv);
		}
		else if (strcmp(p_argv[0], "ver") IS_SAME) {
			err_flag = ver_number(p_argc, p_argv);
		}
		else if (strcmp(p_argv[0], "more") IS_SAME) {
			more_tgl(p_argc, p_argv);
		}
		else if (strcmp(p_argv[0], "bell") IS_SAME) {
			bell_tgl(p_argc, p_argv);
		}
		else if (strcmp(p_argv[0], "logout") IS_SAME) {
			still_running = FALSE;
		}
		else if (strcmp(p_argv[0], "bye") IS_SAME) {
			still_running = FALSE;
		}
	/* qswapin() the segment if necessary */
		else for (;;) {
			if (strlen(p_argv[0]) > 8) {
				vprintf(C_M, "\n%s is an invalid command name.\n", p_argv[0]);
				break;
			}
			build_fn(swap_file, "a", p_argv[0], "cmd");
			if (qswapin(swap_file, SEG_LOAD) == ERROR) {
				vprintf(C_M, "\n can't load that command (%s)", p_argv[0]);
				break;
			}
			err_flag = (*segment)(p_argc, p_argv);
							/* via indirection */
				break;
		}
		if (err_flag) {
			vprintf(C_M, "\n caution, %s didn't ", p_argv[0]);
			vprintf(C_M, "execute properly!!!\n");
			err_flag = FALSE;
		}
		while (p_argc) free(p_argv[--p_argc]);
	}		/* end command loop */
}			/* end commands */

/*
	argstr is scanned for words (block of printing char separated by
whitespace), each being placed in core with alloc. The location of
each is recorded in argvec[]. The number of args pulled is returned.
*/

pull_args(argstr, p_argv)
char *argstr;
char **p_argv;
{
	string *word, *find_word();
	char *alloc();
	unsigned wdlen;
	int cnt;

	purge_uc(argstr);	/* make all lowercase */

/* 'pull' each word from the string, placing in core */

	cnt = 0;
	while (word = find_word(&argstr)) {	/* find a 'word' */
		p_argv[cnt] = alloc((wdlen = argstr - word) + 1);
						/* find storage */
		movmem(word,p_argv[cnt],wdlen);		/* move to core */
		*(p_argv[cnt] + wdlen) = '\0';
		if (++cnt > 9) {
			vprintf(C_M, "\ntoo many arguments!\n"); /* next arg */
			while (cnt) free(p_argv[--cnt]);
			return ERROR;
		}
	}
	return cnt;		/* return p_argc */
}

/*	point ptrptr to byte following next valid word, return ptr to
	beginning of said word, or NULL if no more words	*/

string *
find_word(ptrptr)
string **ptrptr;
{
	char c, *word;

	word = NULL;
	while (c = **ptrptr) {
		if (isdlmtr(c)) ++(*ptrptr);	/* find begin */
		else {
			word = *ptrptr;		/* found begin */
			while (c = **ptrptr) {
				if (!isdlmtr(c)) ++(*ptrptr);/* skip over it */
				else break;
			}
			return word;
		}
	}
	return word;			/* end of line */
}


/**	allow the changing of disk b while program runs */

cm(p_argc, p_argv)
int p_argc;
string **p_argv;
{
/** check for open files on b, close if so */
/* 'home' function when used with godbout board to save disk buffers */
	bios(HOME);				/* flush the buffer */
	vprintf(CON, "\nplace the requested disk in b, then <anykey>");
	cgetchar();				/* wait... */
	bdos(RESET_DRIVE, 0x2);		/* drive (b) reset function */
/** 'mount' new logical disk (when 'mount' is added) */

	vprintf(C_M, "\nnew disk has been mounted, you may proceed...\n");
	return OK;
}

/* report the version number of this system */

ver_number(p_argc, p_argv)
int p_argc;
char **p_argv;
{
	vprintf(C_M, "\n\tcnode version %d.%02d", Version/100, Version%100);
	return OK;
}

/* toggle the 'more' feature on and off */

more_tgl(p_argc, p_argv)
int p_argc;
string **p_argv;
{
	return Mterm._vmore = !Mterm._vmore;
}

/* toggle the 'bell' feature */

bell_tgl(p_argc, p_argv)
int p_argc;
string **p_argv;
{
	if (Mterm._vbell) Mterm._vbell = '\0';
	else Mterm._vbell = Log_data._bell;
}

/* endcode */
