/********************************************************************
	baud.c - set the baud rate
*/
/* begincode */

#include "a:std.h"		/* bdscio.h + my stuff */
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */

main(p_argc, p_argv)
int p_argc;
string **p_argv;
{
	int baudrate;

	if (p_argc != 2) {
		vprintf(C_M, "\nusage: 'baud <baudrate> <cr>'");
		return ERROR;
	}
	baudrate = atoi(p_argv[1]);
	if ((baudrate < 61) || (baudrate > 710)) {
		vprintf(C_M, "\nbaudrate out of range (61-710)");
		return ERROR;
	}
	if (baudrate > 300) outp(MODEM_CONTROL, 0x5f);	/* optimize 0-600 */
	else outp(MODEM_CONTROL, 0x7f);			/* optimize 0-300 */
	sleep(2);		/* let it work */
	outp(TIMER_RATE, 15625/baudrate);
	return OK;
}

/* endcode */
