/*********************************************************************
	Declarations for the routines in PORTIO.ASM

by 	Bob Fisher
	De Paul University
	243 S. Wabash
	Chicago, IL 60604
*********************************************************************/

/*Get byte (bit(8)) from port.  The parameter is the port.
  This can be altered to return fixed or fixed(7). It could
  be bit(16) too, but the actual value will be in the lower
  8 bits, not the upper.*/

	dcl input entry(fixed) returns(bit(8)); 

/*Get character from port*/

	dcl inchr entry(fixed) returns(char(1));

/* Send byte or character to port.  In each case, the first parameter
   is the port number, the second is the value to be sent.*/

	dcl output entry(fixed,fixed);		
	dcl outchr entry(fixed,char(1));

/* Get port status.
   The first parameter is the port number, the second is the mask of
   bits to test, the third is the ready mask of bits that should be 1
   Status returns true or false.*/

	 dcl status entry(fixed,bit(8),bit(8)) returns (bit(8));

	name	'PORTIO'
	title	'Direct port input/output for PL/I programs.'

; By Bob Fisher
;    DePaul University
;    Chicago, IL 60604
;
	public	input	;read port, return bit(8)
	public	inchr	;read port, return character
	public	output	;write byte to port
	public	outchr	;write character to port
	public	status	;test port status

;*******************************************************************
;* dcl input entry(fixed) returns (fixed);
;*   The fixed parameter is the port number.
;*
;* dcl inchr entry(fixed) returns(char(1);
;*
;* dcl output entry(fixed,fixed);
;*   The first parameter is the port number, the second parameter
;*   is the value to be sent.
;* 
;* dcl outchr entry(fixed,char(1));
;*   The first parameter is the port number, the second is the character
;*
;* dcl status entry(fixed,bit(8),bit(8)) returns bit(8);
;*   The first parameter is the port number, the second is the mask of
;*   bits to test, the third is the ready mask of bits that should be 1
;*   Status returns true or false.
;*
;* Note: output and outchr are, in fact, the same routine.  Separate 
;* entries are provided for convenience.
;*
;* All parameters are assumed fixed, but only the low 8 bits are used.
;* Any convenient data type may be used as long as it is passed as an
;* 8 or 16 bit parameter.  Specifically, the return value for input
;* may be fixed, fixed(7), bit(8), or bit(16). CHAR(1) is not allowed,
;* since character values use a different return mechanism.
;*
;* To get a character input use inchr;
;*******************************************************************


getp1: ;get single byte parameter to register a
	;modified  from Linker manual routine
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	ldax	d
	ret
;
input:	call	getp1
	sta	inprt+1		;stick in the port number
inprt:	in	0		;this is the correct port now
	mvi	h,0		;in case we want a 16 bit return
	mov	l,a
	ret
;
inchr:	call	getp1
	sta	inprt1+1	;put in the port number
inprt1:	in	0		;get the character
	pop	h		;remove return address from stack
	push	psw		;put character on stack
	inx	sp		;bypass the flags
	mvi	a,1		;one character returned
	pchl			;return
;
outchr:
output:	call	getp1
	sta	outprt+1	;set the port in the output instruction
	call	getp1		;character to register a
outprt:	out	0		;this was modified 
	ret
;
status:	call	getp1		; get port number
	sta	stin+1		; set it into the in instruction
	call	getp1		; get ready test bits
	mov	c,a
	call	getp1		; get bits that must be high
	mov	b,a
stin	in	0		; port number is patched in above
	ana	c
	cmp	b
	mvi	a,80h		; return true if port is ready
	rz
	mvi	a,0		; otherwise return false
	ret
;
	end
