	MULTICOM chaining facility for PLI.

The multicom routines are an off-the-wall sort of chaining facility
for PLI programs.  They were written on request for a special purpose
set of programs.  The way I envisage them being used is as follows:

1.  You have a set of related but separate programs, e.g. the  set
of ARCH programs.

2.  You write a menu program that allows the user to select which
of the set he wants to use.  The menu program, using PUTCOM inserts
that command, followed by the command to return to itself, in the
CPM buffer.  The menu program exits via NEXTCOM, causing the selected
program, say ARCHBLD, to execute.  ARCHBLD advances the buffer via
MOVCOM, executes, and exits via NEXTCOM, which causes the menu 
program to be executed.

3.  The BEGIN program would be patched to automatically load the menu
program and then, of course, renamed, say to ARCH. It's job is to
set up the BDOS pointer so that the other programs do not overwrite
the CCP.

Requirements:

a.  Each of the cooperating programs should include MULTICOM.DCL and be
linked with MULTICOM.REL.  (MULTICOM.ASM is assembled with RMAC.)

b.  Each program should call either PUTCOM  with a command line, or
MOVCOM to advance the command line.  Each program should exit by
calling NEXTCOM.  If the command line is empty, or all the commands
have been processed, NEXTCOM will do a warm boot, reestablishing the
correct BDOS pointer in location 6.

c.  The whole package must be started with a loader based on BEGIN.
One of the first things that a PLI program does is write into the CCP
area.  This must be prevented by changing the BDOS pointer at location
6 and inserting a JMP BDOS just below the CCP.

d.  Each program must be capable of running without the memory that
is sacrificed by not overwriting the CCP (about 2k) plus the memory
taken up by linking in MULTICOM.

There is no real limit except the CCP buffer to the number of commands
that can be chained by one call to PUTCOM.  The commands themselves
can be any legal commands, separated by semi-colons.  Thus, besides
the program to run, they can contain file specifications as input
to the programs.

As I said, these were written for a special application.  I pass them 
on in the hope that someone may find them useful.

				Bob Fisher
				DePaul University
				243 S. Wabash
				Chicago, IL 60604
/**********************************************************

  PL/I declarations for the subroutines in MULTICOM.ASM.

  This package allows multiple commands, separated by semi-colons,
to be placed in the cp/m command buffer.  Cooperating programs
will then be run by the commands in sequence, adjusting the
buffer for the next program.

	by  Bob Fisher
	    De Paul University
	    243 S. Wabash
	    Chicago, IL 60604

***********************************************************/

	dcl putcom entry(char(80) var); /*This inserts the commands*/
	dcl movcom entry;	/*adjust the command buffer*/
	dcl nextcom entry;	/*exit routine to next command*/

/********************************************************************

	PUTCOM allows a program to prepare a recipe of other 
programs and install it in the buffer. The command line should
be in upper case, with separate commands separated by semicolons.

	call putcom('TESTCOM;DIR');

this inserts the commands to run the program TESTCOM and then (if
testcom cooperates) give a directory listing. (The last command
does not have to be a cooperating program, but you should do a warm
boot (^C) afterwards to restore the correct BDOS pointers.)

	MOVCOM adjusts the command buffer.  Cooperating programs should
usually call this (or PUTCOM) exactly once. Each time it is called, 
it moves the buffer forward 1 command.

	NEXTCOM is an exit routine.  It returns control to CP/M
for processing of the next command in the buffer.  Use it to end
your programs. If there are no more commands, it performs a warm boot to
restore the pointers to the BDOS.

Suggestion for use: Your menu program can set up a sequence of commands
ending by calling itself.  You will thus stay in a loop of cooperating
programs. One of the options should be EXIT, which would insert the
empty command, causing a warm boot.

	In order to get the whole thing rolling, it is necessary to run
the BEGIN program or something like it.  See the BEGIN.ASM file for 
instructions.

***********************************************************************/

	NAME	'MULTICOM'
	TITLE	'Multiple command chaining procedures for PL/I.'
;
; By Bob Fisher
;    De Paul University
;    Chicago, IL 
;
; See MULTICOM.DCL for instructions and descriptions.
;
	public	movcom
	public	nextcom
	public	putcom
;
	extrn	?bdos	;bdos entry point

ccplen	equ	0806h	;standard length of cp/m's ccp
delimch	equ	';'	;command delimiter

;put command string into ccp buffer
putcom: mov	e,m	;get string address into d
	inx	h
	mov	d,m
	inx	h
	push	d
	call	getccp	;get address of buffer into h, initialize
	pop	d
	ldax	d	;a = length(command)
	mov	b,a	;b will be a counter
	mov	m,a	;put length into buffer
	ora	a	;empty commands require special action
	jnz	goodcm
	lxi	h,0
	shld	ccpadd	;we put 0 here so next knows what to do
	ret
;now we move the string into the buffer
goodcm:	inx	d	;point to first character
	inx	h	;point to first position in buffer
	call	ldir
	mvi	a,0
	mov	m,a
	ret

nextcom:
	lhld	ccpadd		;get address of ccp into h
	mov	a,h
	ora	l
	jz	0		;if ccpadd=0 then no more commands
	lda	defdrv		;must get def drive into reg c
	mov	c,a
	pchl			;otherwise go to ccp entry point
;
getccp:	lda	?bdos-1
	sta	defdrv
	lhld	?bdos+1		;get ccp address into h
	mov	a,l		;Is this the original, or a mod?
	cpi	6		;original has a 6, our mod produces 0fdh
	jnz	oktogo
	jmp	0		;we can't continue if this is wrong
oktogo:	lxi	d,3
	dad	d
	shld	ccpadd		;store reentry point for nextcom
	lxi	d,6		;find buffer length
	dad	d
	mov	e,m		;de=buff length-1
	inx	d		;de = buff length
	inx	d		;de = buff length + 1
	inx	h		;h = start of buffer - 1
	xchg
	dad	d		;now h points to ccp position pointer
	mvi	m,8		;reset it 
	xchg			;get buffer back into h
	ret
;
movcom:	
	call	getccp		;find the buffer and initialize
	mov	b,m		;length into b
	mov	a,b		; could it be 0? only if movcom is called
	ora	a		; more than once
	jz	nomore
	push	h		;save beginning while we search for next
	inx	h		;command 
findcl:	mov	a,m		;we check each character in buffer for
	inx	h		; the command delimiter
	dcr	b		;adjust count
	jz	nomore		;is there another command?
	cpi	delimch		;this is the command delimiter
	jnz	findcl
;
	xchg			;d now points to first character of next
	pop	h		; command, h points to buffer
	mov	m,b		;move the count in
	inx	h
	inr	b		;for the 0 at the end
;
;simulate a z80 ldir instruction. Move b bytes from d to h
ldir:	ldax	d
	mov	m,a
	inx	h
	inx	d
	dcr	b
	jnz	ldir
	ret
;
;mark the buffer as empty for nextcom
nomore:	pop	h
	lxi	h,0
	shld	ccpadd
	ret
;
defdrv	ds	1
retadr:	ds	2
ccpadd:	ds	2
	end
;Simple loader program for PL/I programs that use the MULTICOM routines.
;(Please exuse the code, it is a quick hack.)
;
; USAGE:
;		BEGIN command
;
; Does the necessary initialization, and runs the program specified
; in the command.  The command must be simply the name of a COM file
; or the drive and COM file. E.G. BEGIN d:strtch.
; 
; If the command is left off, you will be prompted for the command, at which
; time you can enter any legal multicom-type command line (upper or lower
; case.)
;
; Optionally, this program can be patched to be a dedicated loader for
; a specific program.  See the comments below.
;
;					-Bob Fisher
;
CCPLEN	EQU	0806H
dfcb	equ	5ch

; Make patches to allow multicom programs to not overwrite CCP.	
; We write a JUMP BDOS just below the CCP and patch this location into
; location 6.
	LHLD	6
	PUSH	H
	LXI	D,-CCPLEN-3
	DAD	D
	SHLD	6
	MVI	a,0c3h
	mov	m,a
	inx	h
	pop	d
	mov	m,e
	inx	h
	mov	m,d
	inx	h
	push	h	;ccp entry is now on the stack
;
;Include this statement if you want a dedicated loader.  Patch the command
; buffer below.
;	jmp 	fill
;
;Here we check to see if a command was specified.  If so, we move it
; to our buffer, in correct format.
	lda	dfcb+1
	cpi	' '
	jz	getcom
;	
	lxi	d,dfcb
	lxi	h,chbuff
	mvi	m,10
	inx	h
	ldax	d
	inx	d
	jnz	strdrv
	mvi	c,25
	call	5
	inr	a
strdrv:	adi	'A'-1
	mov	m,a
	inx	h
	mvi	m,':'
	inx	h
	mvi	b,10
	call	move

	jmp	fill
;
; No command was given, so we get one.
getcom:	mvi	c,9
	lxi	d,prompt
	call	5
;
	lxi	d,buffer
	mvi	c,10
 	call	5
;
; Transfer the bufferred command line to the CCP buffer, and patch the
; appropriate places.
fill:	pop	h
	push	h
	lxi	d,7
	dad	d
	lxi	d,buffer+1
	ldax	d
	mov	m,a
	inx	h
	inx	d
	mov	b,a
	call	move
	mvi	m,0
;
	POP	H
	PUSH	H
	LXI	D,088H	
	DAD	D
	MVI	M,8
	LDA	4
	MOV	C,A
	ret
;
; Perform an LDIR, translating to upper case as we go.
move:	ldax	d
	cpi	'a'
	jc	upper
	cpi	'z'
	jnc	upper
	sui	'a'-'A'
upper:	mov	m,a
	inx	h
	inx	d
	dcr	b
	jnz	move
	ret
;
prompt:	db	'Command: $'
;
; For a dedicated loader, patch the command into chbuff+1 (change it to
;  db), and put the length of the command in chbuff.
buffer:	db	128	;length byte of command buffer
chbuff:	db	0	; actual length of command
	ds	126
	end
/*Demo test program for the MULTICOM package. 
Type BEGIN STRTCHN to see it work.                 */

start: procedure options(main);
%include 'multicom.dcl';

	dcl command char(80) var;

command = 'D:A;D:B;D:A';
put skip list(command);
call putcom(command);
put skip list('start');
call nextcom;
end;
/*test program for MULTICOM package. See STRTCHN.PLI*/
test: proc options(main);
	%include 'multicom.dcl';

	call	movcom;
	put skip list('TESTA');
	call	nextcom;
	end;
/*Test program for MULTICOM package. See STRTCHN.PLI*/
test: proc options(main);
	%include 'multicom.dcl';

	call	movcom;
	put skip list('TESTB');
	call	nextcom;
	end;
