

; 	FILEFIND.ASM

; Originally written b R Rodma 

; Version 11.m by Ben Miller Jr. WB8LGH.
; Version 11.0 by Dave Hardy

; This program will search all preset user areas of all drives for
; any files matching the command tail, then display those files in
; a DIR-like format.  NOTE THAT A DRIVE NEED NOT BE ACTIVE (logged-in)
; TO BE SEARCHED.  By setting the MINUSR and MAXUSR equates to 0 and
; 32, respectively, this program can be made to list ALL files in
; ALL user areas of ALL drives.

; Example:  FILEFIND *.COM  lists all .COM files on all drives

; This program makes a direct call to the SELDSK routine of the CBIOS
;  to determine a drive's existence without causing a BDOS error.

; NOTE:	  THIS PROGRAM ASSUMES THAT ANY CBIOS 'ILLEGAL DRIVE SELECT'
;	  TRAPS WILL CAUSE THE SYSTEM TO EXECUTE A WARM-BOOT BY JUMPING
;	  TO ADDRESS 0.  If a select error bypasses the warm-boot jump
;	  at address 0, then the trap in this program will not work.

; PLEASE RETURN ANY UPDATES, REPAIRS, ETC. TO TECHNICAL CBBS, Dearborn, MI
;  at (313) 846-6127 (110, 300, 450, 600 Baud, 24 hours) so that we can
;  keep the file properly updated and available to all.

; Modification history (in reverse order to minimize reading time):

;07/30/82 Added several options, in db statements that are looked
;	  at during runtime, such as showsys,showusr,drv1st,maxcol,
;	  multusr,minusr,maxusr,maxdrv(maximun number of drives).
;	  added runtime CP/M, MP/M check of system, changed opening
;	  message. NOTE: I haven't tried all the options, but they
;	  should work. Also set up so file could be assembled with
;	  RMAC,LINK to do a PRL (page reocatiable) file type to be
;	  used on MP/M sytems. The db bytes are after the origin of
;	  of the program ex: 103-thru-10Ah for com files, and ex:
;	  203-thru-20Ah for PRL files.
;	  Here is a plug for a new program i have done, that allows
;	  any MP/M PRL type of program to execute on a CP/M system,
;	  although if the PRL file does a MP/M bdos call, it will
;	  not work with the CP/M system. The program name is
;	  PRLPATCH.ASM, and have a CCP that auto look-up, and
;	  executes a COM, if not found a PRL type of file.
	  B Benn Dougla Mille Jr WB8LGH

;08/02/81 Cleaned up file and removed unnecessary code.  Thanks to
;	  Tom and Shawn for adding some more goodies.
;	  By Dave Hardy

;07/31/81 Modified AVAIL routine to abort only on control-C
;         from the console.  Cleaned up the file, restored
;         original author's name to the heading.
;         By Thomas V. Churbuck

;07/31/81 Added tutorial to be printed if filename (FCB)
;         field (fn.ft tail of the command line) is blank
;         (omitted by the inexperienced user). 
;         By Thomas V. Churbuck

;07/31/81 Substituted IN-LINE PRINT ROUTINE where appro-
;	  priate for all printed messages.  Prints message
;	  on exit if no files were found (matched).
;	  By Thomas V. Churbuck

;07/30/81 Modified AVAIL routine to abort program if any
;	  character is typed from the console.
;	  By Shawn Everson

;07/29/81 Modifed user number routine to include leading
;	  0 when printing user #'s 0-9 to line up printout.
;	  By Shawn Everson

;07/17/81 Removed DRVFIRST routines and replaced with DRV1ST
;	  routines to make code shorter and more efficient. 
;	  Note that although these changes will make FILEFIND
;	  look MP/M compatible, it actually is NOT.
;	  By Dave Hardy

;07/17/81 Modified SHOFIL routines to permit user #-drive OR
;         drive-user # printout to match either MPM or USERLST
;         by providing DRVFIRST conditional
;         By Earl Bockenfeld

;07/12/81 Modified SHOFIL routines to always print leading zero
;	  when MULTUSR is TRUE so that multiple user number displays
;	  will align properly.
;	  By Dave Hardy

;07/08/81 Added MULTUSR routines to allow program to be conditionally
;	  assembled to check a preset range of user areas.  With MINUSR
;	  and MAXUSR (below) set to 0 and 32, respectively, this program
;	  will produce a master directory of EVERY file on EVERY drive
;	  on its host system.  If MULTUSR is set TRUE, then when program
;	  is executed, if current user number is within MINUSR and MAXUSR,
;	  program will check the set range of user areas from MINUSR to MAXUSR.
;	  But if current user number is not within set range, program will
;	  check only current user area.  I did this so that remote callers
;	  could use program to check all remote user areas, but a local
;	  SYSOP could use program for any user area, assuming that
;	  program was located in a public (common) user area.
;	  By Dave Hardy

;07/02/81 Fixed user number print routine to properly display
;	  user numbers 10-15.  By Keith Petersen, W8SDZ

;07/01/81 Changed file name print routine so spaces are not printed
;	  after last filename on a line.  By Keith Petersen, W8SDZ

;05/30/81 Removed stack save routines, so that now the program will
;	  warm-boot back, instead of 'RET'.  This was necessary because
;	  the stack may be garbaged by the CBIOS when the warm-boot trap
;	  is encountered.  Also added check in SHOFIL routine to check for
;	  proper user number before displaying a filename, in case of
;	  public user area (e.g. if BDOS-PAT.ASM is installed).
;	  By Dave Hardy

;05/12/81 Added automatic log-in feature, so that all drives will
;	  be selected, regardless of which were previously logged in.
;	  In systems with illegal drive select traps in their CBIOS,
;	  this would cause a warm-boot as soon as the first illegal drive
;	  is selected, so a trap is used that replaces the warm-boot
;	  pointer at address 1 during execution of this program.  After
;	  execution, the pointer is restored, and the program does a 
;	  'ret' to CP/M.  In systems with no traps in the CBIOS (most 
;	  systems), this program will finish and return to CP/M without
;	  encountering the warm-boot trap.  In either case, the program
;	  should work properly.  Thanks to Ron Fowler for his suggestions.
;	  NOTE: This program will probably no longer work with CP/M
;	  1.4, since most 1.4's don't check for illegal drive selects.
;	  By Dave Hardy

;05/06/81 Fixed BASE equates, added comments, added conditionals
;	  for SYS file and USER number display, added MAXCOL equate
;	  to set number of display columns, eliminated display of
;	  USER number when in USER 0 to make display easier to read,
;	  made miscellaneous changes to make file more readable.
;	  By Dave Hardy

;04/20/81 Renamed from FILE.ASM to FILEFIND.ASM to avoid
;	  confusion with CPMUG FIND.ASM
;	  By Dick Mead

;  Define true and false

FALSE	EQU	0
TRUE	EQU	NOT FALSE

rmac	equ	true	; if assembled with RMAC.

;  Define some miscellaneous values:

CR	EQU	0DH	; ASCII return
LF	EQU	0AH	; ASCII linefeed
bell	equ	07h	; ASCII bell.

	if rmac
extrn	bdos
extrn	base
extrn	fcb
extrn	dmabuf
extrn	cbios
extrn	drive
	endif

	if not rmac
BASE	EQU	0	; Set to base address of your CP/M (normally 0)
BDOS	EQU	BASE+5	; CP/M BDOS entry point
FCB	EQU	BASE+5CH; CP/M file control block address
DMABUF	EQU	BASE+80H; DMA buffer address
cbios	equ	01h	; address of jump table.
drive	equ	04h	; drive storage byte.
	endif

;  Define some BDOS functions:

SETDMA	EQU	26	; Set DMA Address function
SRCHFST	EQU	17	; Search For First function
SRCHNXT	EQU	18	; Search For Next function
CONOUT	EQU	2	; Console Output function
RTNVER	EQU	12	; Return Version Number function
SETUSR	EQU	32	; Set/Get User Code function
CONSTAT	EQU	11	; Get Console Status function
CONIN	EQU	1	; Console Input function
PRINT	EQU	9	; Print String At Console function
get	equ	0ffh	; get user command.
version	equ	0ch	; get version, and type of system.
			; MP/M or CP/M.

	if not rmac
	ORG	BASE+100H
	endif

	jmp	start	; bypass db statements.

;*******************************************
;****** Set the following as desired *******
;*******************************************

showsys	db	0ffh	; TRUE if want to show SYS files
showusr	db	0ffh	; TRUE if want to show user number
drv1st	db	000h	; TRUE if want to print drive before user number
			; FALSE if want to print user number before drive
maxcol	db	4	; Set to number of columns desired in display
multusr	db	0ffh	; TRUE if want to search multiple user numbers
			; FALSE if want to search only current user number

;  The following need to be set only if MULTUSR above is set TRUE:

minusr	db	0	; Set to minimum user number to be checked
maxusr	db	0fh	; Set to maximum user number to be checked

; The maximun number of drives for the system, note if 2.x or greater.
; the system does a check on drives that are not selected, this only
; needs to be modifyed if running 1.4, then set tomaximun number of
; drives.

maxdrv	db	17	; set up fo 2.xor MP/M. use 4 or less for 1.4.

;*******************************************
;********* end of alteration area **********
;*******************************************

start:

;	save old stack pointer.

	lxi	h,0		; set up for saveing stack.
	dad	sp		; get stack pointer.
	shld	stack		; save it.

	LXI	SP,STACK	; Set up new stack.

;	save byte at address base+0.

	lxi	h,base		; force to base page.
	mov	a,m		; get byte.
	sta	first		; need to restore byte later.

;	make the maximun number of columns.

	lda	maxcol		; get columns.
	sta	column		; save count.

	CALL	ILPRT		; Print sign-on message

	DB	CR,LF,'FILEFIND ver 11.m',0

;	see what version of CP/M, or MP/M.

	mvi	c,version	; get CP/M, MP/M version.
	call	bdos		

	mov	a,h		; see if MP/M.
	sta	mpmbyte		; save it.
	mov	a,l		; version number CP/M 1.x or 2.x.
	sta	cpmbyte		; save it.

	lda	mpmbyte		; see if MP/M or CP/M.
	ora	a		; is MP/M if none zero.
	jz	cpm		; go do CP/M message if not.
	lxi	d,msg2		; do MP/M message.
	mvi	c,print		; print it command.
	call	bdos		; go print it.
	lda	mpmbyte		; get mpm version.
	adi	30h		; add ascii offset.
	call	cout		; output first number.
	mvi	a,'.'		; now the seprator.
	call	cout		; out put it.
	lda	cpmbyte		; now the lower version number.
	ani	0fh		; strip upper nibble.
	adi	30h		; add ascii offset.
	call	cout		; go print it.
	lxi	d,msg3		; trailing end of message.
	mvi	c,print		; print command.
	call	bdos		; go print it.
	call	docrlf		; go do cr,lf.
	jmp	bpcpm		; bypass CP/M message.

cpm:
	LXI	D,MSG1
	MVI	C,print
	CALL	BDOS
	lda	cpmbyte		; get cpm version.
	ani	0f0h		; strip upper nibble.
	rar			; rotate right four times.
	rar			
	rar			
	rar			
	adi	30h		; add ascii offset.
	call	cout		; output first number.
	mvi	a,'.'		; now the seprator.
	call	cout		; out put it.
	lda	cpmbyte		; now the lower version number.
	ani	0fh		; strip upper nibble.
	adi	30h		; add ascii offset.
	call	cout		; go print it.
	lxi	d,msg3		; trailing end of message.
	mvi	c,print		; print command.
	call	bdos		; go print it.
	call	docrlf		; go do cr,lf.

bpcpm:
	DB	'Type CTRL-C to abort',CR,LF,CR,LF,0

	LDA	FCB+1		; Check for filename on command line
	CPI	' '
	JNZ	SETUP		; If it's there, then continue
	CALL	ILPRT		; Else, print help message and exit

	db	cr,lf,'This version works with MP/M, CP/M systems.',cr,lf

	DB	CR,LF,'Usage: FILEFIND <filename.type>'
	DB	CR,LF,CR,LF
	DB	'       You must specify the file(s) you',CR,LF
	DB	'       want to find.  Ambiguous file names',CR,LF
	DB	'       may be used.',CR,LF,CR,LF
	DB	'       Example:  FILEFIND MODEM.DOC',CR,LF
	DB	'                 FILEFIND *.ASM',CR,LF,0
	jmp	exit		; Warm-boot back to CP/M

SETUP	LDA	drive		; Save USER/DRIVE number
	STA	UDNUM
	RRC
	RRC
	RRC
	RRC
	ANI	0FH
	STA	CUN		; Save current user number
	STA	CTU		; Save as current try number, too

	lda	multusr		; get multiuser check byte.
	ora	a		; see if zero.
	jz	sboot		; go past if zero.

	lda	cpmbyte		; check to seeif 2.x or later.
	ora	a		; if not zero do get user number.
	jz	sboot		; else go past.

;	get the current user area.

	mvi	e,get		; get command for user.
	mvi	c,setusr	; set/get user command.
	call	bdos		; go do it.
	sta	user		; save it.

	lda	cun		; get current user.
	mov	b,a		; store in b.
	lda	minusr
	CMP	B		; Current user number within range?
	JC	OUTSIDE		; No? then search only current user number
	MOV	B,A
	lda	maxusr
	CMP	B
	JC	OUTSIDE
	lda	minusr
	STA	CTU		; Set Current Try User to MINUSR
	STA	ORIGCTU		; Set original CTU to same
	lda	maxusr
	STA	MAXTEMP		; Set maximum user number to MAXUSR

SBOOT
	lhld	cbios		; get address 1&2 relative to base.
	shld	wboot		; save warm boot address.

	lda	mpmbyte		; see if MP/M.
	ora	a		; see if zero.
	jz	sbboot		; go do CP/M set up.

;	do MP/M xios jump table offset setup.

	inx	h		; go past jump instruction.
	mov	a,m		; get low order byte.
	inx	h		; next byte.
	mov	h,m		; get high order byte.
	mov	l,a		; now have xios jump table.

sbboot:
	LXI	D,18H
	DAD	D
	SHLD	DSKSEL+1	; Get jump to CBIOS DSKSEL routine

;  The following code sets a trap at the warm-boot jump, so that
;  any 'illegal drive select' traps in the CBIOS will be defeated.

	LXI	H,DONE		; Replace warm-boot pointer with trap
	SHLD	cbios		; replace it.

	LXI	D,DMABUF
	MVI	C,SETDMA
	CALL	BDOS		; set DMA address

	XRA	A
	STA	TRYDRV		; Set up to try drive '0' first

TRY:
	MOV	C,A		; Try to select drive
	CALL	DSKSEL
	MOV	A,L
	ORA	H
	JZ	DONE		; If HL=0 then no more drives
	LDA	TRYDRV
	INR	A
	STA	TRYDRV		; Get ready for next drive, too
	STA	FCB		; Store 1+drive# in FCB (1=A, 2=B, etc.)

NXTUSR
	lda	multusr		; get multiuser check byte.
	ora	a		; see if zero.
	jz	avail		; go past if zero.

	LDA	CTU		; Set user to CTU via a BDOS call
	MOV	E,A
	MVI	C,SETUSR
	CALL	BDOS

AVAIL
	MVI	C,CONSTAT	; Check to see if key pressed
	CALL	BDOS
	ORA	A
	JZ	NOPRESS		; If no key pressed, then continue
	MVI	C,CONIN		; If key pressed, then check for abort
	CALL	BDOS
	CPI	'C'-40H		; Is it control-C?
	JNZ	NOPRESS		; If no, then continue
	CALL	ILPRT		; If yes, then print abort message
	DB	bell,CR,LF,LF,'+++ ABORTED',CR,LF,bell,0
	JMP	DONE1		; Then restore warm-boot jmp and UDNUM then exit

NOPRESS LXI	D,FCB
	MVI	C,SRCHFST
	CALL	BDOS		; Check for directory match with FCB
	CPI	0FFH		; "A" register has 0-3 if file found else 0FFH
	JZ	NXT		; Do next drive if no more matches found
	CALL	SHOFIL		; If match found, then display the filename

SNEXT:
	MVI	C,SRCHNXT
	CALL	BDOS		; Check for next match with FCB
	CPI	0FFH	
	JZ	NXT		; No more matches? Then do next drive
	CALL	SHOFIL		; If match found, then display the filename
	JMP	SNEXT		; Continue until no more matches found

NXT	EQU	$

	lda	multusr		; get multiuser check byte.
	ora	a		; see if zero.
	jz	vrsion		; go past if zero.

	LDA	CTU		; Increment current try user number
	INR	A
	STA	CTU
	MOV	B,A
	LDA	maxusr
	CMP	B
	JNC	NXTUSR		; Do next user number if all not done
	LDA	ORIGCTU		; Else reset user number and do next drive
	STA	CTU

vrsion:
	lda	maxdrv		; get maximun number of drives.
	mov	c,a		; put into the c for check.

FOUR	LDA	TRYDRV
	CMP	C
	JC	TRY		; Continue until all drives checked...

;  all done now, return to CP/M

DONE	LDA	MFLAG		; See if any files found
	CPI	0
	JNZ	DONE1		; If yes, then done, so exit
	CALL	ILPRT		; If no, then say none found first
	DB	bell,CR,LF,'+++ file NOT found',CR,LF,bell,0

DONE1
	LHLD	WBOOT		; Restore warm-boot jump
	SHLD	cbios
	LDA	UDNUM		; Restore USER/DRIVE number
	STA	drive
	ANI	0FH
	MOV	C,A		; Select original drive before return so that
	CALL	DSKSEL		;  CP/M won't get confused...

exit:
	lda	user		; get original user number.
	mov	e,a		; put in command area.
	mvi	c,setusr	; command.
	call	bdos		; go do it.

	lda	first		; get first byte, since it was overlayed.
	lxi	h,base		; save it for reboot.
	mov	m,a		; save it.

	lhld	stack		; get old stack.
	sphl			; now into the stack pointer.
	ret			; to system.

OUTSIDE
	lda	multusr		; get multiuser check byte.
	ora	a		; see if zero.
	jz	shofil		; go past if zero.

	LDA	CUN
	STA	CTU		; Set current try user to current user number
	STA	ORIGCTU		; Set original CTU to same
	STA	MAXTEMP		; Set maximum user number to current
	JMP	SBOOT		; and continue...

SHOFIL	MOV	L,A		; Get filename to display from directory record
	MVI	H,0		;  which CP/M puts at DMA address
	DAD	H		; ("A" register has relative position of name
	DAD	H		; within directory record)
	DAD	H
	DAD	H
	DAD	H	; Multiply "A" by 32 to point to start of filename
	LXI	D,DMABUF
	DAD	D	; Now point to filename
	XCHG		; save filename pointer in de

	lda	showsys	; get show the system file byte.
	ora	a	; see if zero.
	jnz	syshow	; go past.

	LXI	H,10
	DAD	D	; Point to SYS file attribute
	MOV	A,M
	ANI	80H	; Check for SYS type file
	RNZ		; Return if SYS attribute set (i.e. don't display)

;  The following code is needed only if BDOS-PAT.ASM is installed in
;  your CP/M.  It makes sure that this program only lists those files
;  that are in the current user area (i.e. if you are in a non-zero
;  user area, it won't list the files in user 0, too).

syshow
	LDA	CTU	; Get current try USER number
	XCHG		; Point HL to user number byte of directory entry
	CMP	M 
	RNZ		; Return if wrong user number (i.e. don't show file)
	XCHG		; Get directory pointer back into DE 

	lda	drv1st	; see if drive first
	ora	a	; if zero.
	jz	dispusr	; go display user if zero.

	LDA	TRYDRV
	ADI	'A'-1
	CALL	cout	; Display drive (A-P)

dispusr
	lda	multusr		; get multiuser check byte.
	ora	a		; see if zero.
	jz	nousr		; go past if zero.

	LDAX	D	; get USER number
	INX	D

	CPI	10	; is USER number = 0 thru 9?
	JNC	NEAT	; If no, then print a leading '1'
	PUSH	PSW	; Save USER number
	MVI	A,' '	; If yes, then print a leading '0'
	CALL	cout
	POP	PSW	; Restore USER number
	JMP	USRL	; Then print second digit of user number

NEAT	SUI	10	; USER number = 10 thru 15
	PUSH	PSW
	MVI	A,'1'
	CALL	cout	; print a leading '1'
	POP	PSW

USRL	ADI	'0'	; make into ASCII number
	CALL	cout	; print digit

NOUSR	EQU	$

	lda	drv1st	; get drive first byte.
	ora	a	; see if zero.
	jnz	pfence	; go do print fence.

	LDA	TRYDRV
	ADI	'A'-1
	CALL	cout	; Display drive (A-P)

pfence:
	MVI	A,':'	; Fence character
	CALL	cout	; Display a ':' to look nice

	MVI	B,8	; (8 characters or less in filename)

PFN	LDAX	D	; Now print the filename...
	INX	D
	CALL	cout	;  ... one character at a time
	DCR	B
	JNZ	PFN	; Continue until all 8 characters displayed
	MVI	A,'.'
	CALL	cout	; Display the '.' before the filetype

	MVI	B,3	; Now do the same for the filetype
PXT	LDAX	D
	INX	D
	CALL	cout
	DCR	B
	JNZ	PXT

	LDA	COLUMN	; Print MAXCOL columns across the screen
	DCR	A
	JZ	DOCRLF
	STA	COLUMN
	CALL	TWOSPC	; Print two spaces to make it neat
	MVI	A,0FFH	; Set MFLAG to remember that a file was found
	STA	MFLAG	; (so that 'NOT FOUND' message will be suppressed)
	RET

DOCRLF
	lda	maxcol	; After last column:
	STA	COLUMN	;  Reset column number
	MVI	A,CR	;   Then print CRLF
	CALL	cout
	MVI	A,LF
	CALL	cout
	RET

TWOSPC	MVI	A,' '
	CALL	cout
	MVI	A,' '	; Fall into cout

cout	PUSH	H	; Send a character to the console
	PUSH	D
	PUSH	B	; Save the registers in case BDOS eats them
	ANI	7FH	; Strip parity bit
	MOV	E,A
	MVI	C,2
	CALL	BDOS	; Print the character in 'A' on the console
	POP	B
	POP	D
	POP	H	; Restore the registers
	RET

; INLINE PRINT ROUTINE

ILPRT	XTHL		; Set HL to point to message

ILPLP	MOV	A,M	; Get a character from message
	CALL	cout	; Output it
	INX	H	; Point to next character
	MOV	A,M	; Check for end of message
	ORA	A	; (00H marks end of message)
	JNZ	ILPLP
	XTHL		; Get proper return address onto stack
	RET		; Then return to program

COLUMN	DB	0	; Column counter
TRYDRV	DB	0	; Number of drive being tried
UDNUM	DB	0	; USER/DRIVE number is saved here
CUN	DB	0	; Currently logged-in user number
MFLAG	DB	0	; Flag set to non-zero if file is found
WBOOT	DW	0000H	; CP/M warm-boot address is saved here
first	db	0	; jump instruction.

CTU	DB	0	; Current try user number
ORIGCTU	DB	0	; Original current try user number
MAXTEMP	DB	0	; Maximum try user number

DSKSEL	DB	0C3H	; Jump to CBIOS's disk select routine
	DW	0000H	; (CBIOS's DSKSEL address is stored here)

MSG1:	db	' - CP/M version $'
MSG2:	db	' - MP/M version $'
msg3:	db	' system',0dh,0ah,0ah,'$'
mpmbyte	db	0	; save MP/M version.
cpmbyte	db	0	; save CP/M version.
user	db	0	; save original user command.

	DS	64	; 32 level stack should be enough room
STACK	DS	2

last	db	0	; here for MP/M prl file.

	END
