;		       DTR.ASM
;		   by Dave McCrady
;	       Edmonton, Alberta RCP/M
;		    403-454-6093
;   (24 Hrs, sporadic, not answered if in local use)
;
; NOTE: Some of this code ziffled from LPRINT.ASM
;	by P.P.H. Lee to avoid re-inventing a
;	wheel.
;
; This program sets the Data Terminal Ready line high or
; low depending on the option specified in the command
; line.
;
; To execute, type:
;
;		    DTR ON     - to set the line high
;		    DTR OFF    - to set the line low
;
; EQUATES:
;
CPORT	EQU	0DCH	; YOUR SYSTEM'S MODEM CONTROL PORT
TFCB	EQU	5CH	; DEFAULT FCB
BOOT	EQU	0H	; CP/M WARM BOOT
;
	ORG	100H
;
DTR	LXI	H,0	; GET OLD STACK
	DAD	SP
	SHLD	STACK	; AND SAVE IT
	LXI	SP,STACK ; SET NEW STACK POINTER
	LXI	H,TFCB+1
	LXI	D,ON	; CHECK FOR ON
	CALL	COMP
	JNZ	DTR1	; BRANCH IF NOT
	XRA	A	; ZERO ACCUMULATOR
	MVI	A,1	; SET IT TO ONE (HIGH)
	OUT	CPORT	; AND SEND IT TO THE MODEM
	XRA	A	; SET ACCUMULATOR BACK TO ZERO
			; SO ZCPR WON'T HANG ....
	JMP	EXIT

DTR1	LXI	H,TFCB+1
	LXI	D,OFF	; CHECK FOR OFF
	CALL	COMP
	JNZ	EXIT	; BRANCH IF NOT
	XRA	A	; ZERO ACCUMULATOR
	MVI	A,0	;
	OUT	CPORT	; AND SEND IT TO THE MODEM
	XRA	A
	JMP	EXIT

EXIT	JMP	BOOT	;BACK TO CP/M

COMP	MVI	C,3	; SET CHARACTER COUNT
COMP1	LDAX	D	; GET TEST CHAR
	CMP	M	; COMPARE WITH INPUT CHAR
	RNZ		; REPEAT IF NOT SAME
	INX	D
	INX	H
	DCR	C
	JNZ	COMP1	; BRANCH IF SOME MORE
	RET

; DATA
ON	DB	'ON '
OFF	DB	'OFF'
	DS	128	; STACK AREA
STACK	DS	2	; OLD STACK
	END
|8)?go)))))3t*= r*