$*m
	title	'diskname.asm - disk directory program'
;	(c) mike blackwell  july 1982
;
;	This program lists a directory of the disk names
;	on the system.  A disk name is a file of the format
;	-???????.???.  Typical disk names could be: 
;	-HELP.A0,  -BASIC.B3, -COMM.C14, etc.   These files
;	are created with the command SAVE 0 <filename>, and
;	serve to identify the general class of programs on the
;	disk/user area.
;
false	equ	0
true	equ	not false
;
;--------------------------------------------------
;	option configuration section
maxusr	equ	16	;max user area to be scanned
maxdrv	equ	5	;max drive to be scanned (A:=1)
printer	equ	false	;default for printer output
console	equ	true	;default for console output
;--------------------------------------------------
;
rowsize	equ	maxusr * 7	;size of a row in table
;
base	equ	0000h	;base of cp/m system
bdos	equ	base+5	;bdos entry point
fcb	equ	base+5ch ;default fcb
tpa	equ	base+0100h
;
cr	equ	0dh
lf	equ	0ah

;
gensep	macro	x
sepln:	db	'      +'
	rept	x
	db	'---------+'
	endm
	db	cr,lf,'$'
	endm
;
genfence macro	x
fenceln: db	'      |'
	rept	x
	db	'         |'
	endm
	db	cr,lf,'$'
	endm
;
genhdr	macro	x
hdrln:	db	'       '
y	set	'A'
	rept	x
	db	'    ',y,'     '
y	set	y+1
	endm
	db	cr,lf,'$'
	endm
;
;	MACRO LIBRARY FOR SYMBOL STACK
;
;	SYMBOL GENERATORS
GENSET	MACRO	SYM,NUM,VAL
;;	GENERATE SYMBOL, SET IT TO VAL
SYM&NUM	SET	VAL
	ENDM
;
GENVAL	MACRO	SYM,NAM,NUM
;;	SET SYMBOL TO GENERATED SYMBOL
SYM	SET	NAM&NUM
	ENDM
;
;	PUSH AND POP MACROS FOR SYMBOLIC VALUES
SYMPSH	MACRO	VAL
SSTKP	SET	0	;; INITIALIZE 'STACK POINTER'
SYMPSH	MACRO	VA	;; REDEFINE
SSTKP	SET	SSTKP+1	;; BUMP POINTER
	GENSET	SSTK,%SSTKP,%VA	;; CREATE STACK ENTRY
	ENDM
	SYMPSH	VAL
	ENDM
;
SYMPOP	MACRO	SYM
	GENVAL	SYM,SSTK,%SSTKP	;; GET VALUE FROM STACK
SSTKP	SET	SSTKP-1
	ENDM
;	MACRO LIBRARY FOR 8-BIT COMPARISON OPERATION
;
TEST?	MACRO	X,Y
;;	UTILTITY MACRO TO GENERATE CONDITION CODES
	IF	NOT NUL X	;;THEN LOAD X
	LDA	X	;;X ASSUMED TO BE IN MEMORY
	ENDIF
	IRPC	?Y,Y	;;Y MAY BE CONSTANT OPERAND
TDIG?	SET	'&?Y'-'0'	;;FIRST CHAR DIGIT?
	EXITM		;;STOP IRPC AFTER FIRST CHAR
	ENDM
	IF	TDIG? <= 9	;;Y NUMERIC?
	SUI	Y	;;YES, SO SUB IMMEDIATE
	ELSE
	LXI	H,Y	;;Y NOT NUMERIC
	SUB	M	;;SO SUB FROM MEMORY
	ENDM
;
LSS	MACRO	X,Y,TL,FL
;;	X LSS THAN Y TEST,
;;	IF TL IS PRESENT, ASSUME TRUE TEST
;;	IF TL IS ABSENT, THEN INVERT TEST
	IF	NUL TL
	GEQ	X,Y,FL
	ELSE
	TEST?	X,Y	;;SET CONDITION CODES
	JC	TL
	ENDM
;
LEQ	MACRO	X,Y,TL,FL
;;	X LESS THAN OR EQUAL TO Y TEST
	IF	NUL TL
	GTR	X,Y,FL
	ELSE
	LSS	X,Y,TL
	JZ	TL
	ENDM
;
EQL	MACRO	X,Y,TL,FL
;;	X EQUAL TO Y TEST
	IF	NUL TL
	NEQ	X,Y,FL
	ELSE
	TEST?	X,Y
	JZ	TL
	ENDM
;
NEQ	MACRO	X,Y,TL,FL
;;	X NOT EQUAL TO Y TEST
	IF	NUL TL
	EQL	X,Y,FL
	ELSE
	TEST?	X,Y
	JNZ	TL
	ENDM
;
GEQ	MACRO	X,Y,TL,FL
;;	X GREATER THAN OR EQUAL TO Y TEST
	IF	NUL TL
	LSS	X,Y,FL
	ELSE
	TEST?	X,Y
	JNC	TL
	ENDM
;
GTR	MACRO	X,Y,TL,FL
;;	X GREATER THAN Y TEST
	IF	NUL TL
	LEQ	X,Y,FL
	ELSE
	LOCAL	GFL	;;FALSE LABEL
	TEST?	X,Y
	JC	GFL
	DCR	A
	JNC	TL
GFL:	ENDM
;	MACRO LIBRARY FOR "DOWHILE" CONSTRUCT
;
GENDTST	MACRO	TST,X,Y,NUM
;;	GENERATE A "DOWHILE" TEST
	TST	X,Y,,ENDD&NUM
	ENDM
;
GENDLAB	MACRO	LAB,NUM
;;	PRODUCE THE LABEL LAB & NUM
;;	FOR DOWHILE ENTRY OR EXIT
LAB&NUM:
	ENDM
;
GENDJMP	MACRO	NUM
;;	GENERATE JUMP TO DOWHILE TEST
	JMP	DTEST&NUM
	ENDM
;
DOWHILE	MACRO	XV,REL,YV
;;	INITIALIZE COUNTER
DOCNT	SET	0	;NUMBER OF DOWHILES
;;
DOWHILE	MACRO	X,R,Y
;;	GENERATE THE DOWHILE ENTRY
	GENDLAB	DTEST,%DOCNT
;;	GENERATE THE CONDITIONAL TEST
	GENDTST	R,X,Y,%DOCNT
	SYMPSH	DOCNT	;;NEXT ENDDO TO GENERATE (STACKED)
DOCNT	SET	DOCNT+1
	ENDM
	DOWHILE	XV,REL,YV
	ENDM
;
ENDDO	MACRO
;;	GENERATE THE JUMP TO THE TEST
	SYMPOP	DOLEV
	GENDJMP	%DOLEV
;;	GENERATE THE END OF A DOWHILE
	GENDLAB	ENDD,%DOLEV
	ENDM
;	MACRO LIBRARY FOR "SELECT" CONSTRUCT
;
	org	tpa
diskname:
	lxi	h,0	;set up new stack
	dad	sp
	shld	stack
	lxi	h,stack
	sphl
;
	call	procopts	;process options
;
	xra	a	;get a zero
	sta	drive	;set current drive to 0
	lxi	h,buff	;buffptr := (buff)
	shld	buffptr
;
	dowhile	drive,leq,maxdrive
;
	xra	a	;user := 0 !!!
	sta	user
	lda	drive	;get drive to work with
	call	setdrv	;* and select it.
;
	dowhile	user,leq,maxuser
;
	lda	user	;get user area to work with
	call	setusr	;* and select it.
;
	call	getname	;get disk name and store it.
;
	lda	user	;user ++
	inr	a
	sta	user
;
	enddo
;
	lda	drive	;drive ++
	inr	a
	sta	drive
;
	enddo
;
;	now we've got them loaded.  pretty-print them.
;
	call	hdr
	call	sep
;
	lxi	h,buff	;buffptr := a(buff) {user 0 col.}
	shld	buffptr
	shld	buffptr2	;and in work copy !!!
;
	xra	a	;for user := 1 to maxuser
	sta	user
	dowhile	user,leq,maxuser
;
	call	fence
	call	names
	call	fence
	call	sep
;
	lhld	buffptr	;ptr to col of next user area
	lxi	d,7	;size of a name
	dad	d
	shld	buffptr
	shld	buffptr2	;also in work copy
;
;
	lda	user	;user ++
	inr	a
	sta	user
;
	enddo	;next user
;
	mvi	c,0	;stop program
	call	bdos

;------------------------------------------------
;subroutines
;
setdrv:
;	select drive whose number is in A.

	mov	e,a
	mvi	c,0eh
	call	bdos
	ret
;
setusr:
;	select user area whose number is in A.

	mov	e,a
	mvi	c,20h
	call	bdos
	ret
;-------------------------------------------------
;
getname:
;	get disk name
	lxi	h,dirbuff	;set dma addr to local buffer
	xchg		;get addr into de
	mvi	c,1ah
	call	bdos
;
	lxi	h,namefcb	;DE := a(fcb)
	xchg
	mvi	c,11h	;srch1st
	call	bdos
;
	inr	a	;255 -> 0
	jnz	fnfound
;
	lhld	buffptr
	xchg
	lxi	h,spaces
	lxi	b,7
	call	move
	jmp	fninc
;
fnfound:
	dcr	a
	add	a	;*32
	add	a
	add	a
	add	a
	add	a
	inr	a	;+2
	inr	a
;
	mov	e,a	;DE=A
	mvi	d,0
	lxi	h,dirbuff	;HL := a(dirbuff)
	dad	d	;HL := HL + DE
	xchg		;DE := HL
	lhld	buffptr	;HL := buffptr
	xchg
	lxi	b,7	;BC := 7
	call	move
;
fninc:
	lhld	buffptr	;HL := buffptr
	lxi	d,7	;HL := HL + 7
	dad	d
	shld	buffptr	;buffptr := HL
;
	ret
;
move:
;	move (HL) to (DE) for length BC
	mov	a,m
	stax	d
	inx	h
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	move
;
	ret
;
hdr:
;	print header line
;
	lxi	d,hdrln	;print hdrln
	call	prnstr
;
	ret	;from hdr:
;
sep:
;	print separator line
;
	lxi	d,sepln
	call	prnstr
;
	ret	;from sep:
;
fence:
;	print fence line
;
	lxi	d,fenceln
	call	prnstr
;
	ret	;from fence
;
names:
;	print names of files in user area 'user'
;
	call	prnuser
;
	lxi	d,fenceln2
	call	prnstr
;
	xra	a	;for n := 0 to maxdrv
	sta	n
	dowhile	n,leq,maxdrive
;
	mvi	e,' '
	call	prnchar
;
	call	prnname
;
	mvi	e,' '
	call	prnchar
	mvi	e,'|'
	call	prnchar
;
	lda	n	;n ++
	inr	a
	sta	n
;
	enddo		;next n
;
	call	crlf
;
	ret	;from names
;
crlf:
;	print cr, lf
;
	mvi	e,cr
	call	prnchar
	mvi	e,lf
	call	prnchar
;
	ret	;from crlf
;
prnuser:
;	print 'user' as 2 decimal digits.
;
	lda	user	;get user
	ora	a	;clear carry, half-carry
;
	daa		;make it decimal
;
	push	psw	;save it
;
	ani	0f0h	;print tens digit
	rrc
	rrc
	rrc
	rrc
	call	prn
;
	pop	psw	;get it back
;
	ani	0fh	;print ones digit
;
prn:	adi	'0'	;ascii bias
	mov	e,a
	call	prnchar
;
	ret	;from prnuser, prn
;
prnname:
	lhld	buffptr2	;ptr to curr name
;
	lxi	d,namebuff	;output buffer
	lxi	b,7	;len of name
	call	move
;
	lxi	d,namebuff	;print it
	call	prnstr
;
	lhld	buffptr2	;pt down one row in this col.
	lxi	d,rowsize
	dad	d
	shld	buffptr2
;
	ret
;
prnchar:
;	print char in reg E
;
	lda	cflag	;console output?
	ora	a
	jz	prnc2
;
	push	d	;save char
;
	mvi	c,2	;con: print
	call	bdos
;
	pop	d	;get char back
prnc2:	lda	pflag	;want lst: too?
	ora	a	;set flags
	rz
;
	mvi	c,5	;lst: write
	call	bdos
;
	ret	;from prnchar
;
prnstr:
;	print string pointed to by DE ending w/ '$'.
;
	lda	cflag	;console output
	ora	a
	jz	prns2
;
	push	d
;
	mvi	c,9
	call	bdos
;
	pop	d
prns2:	lda	pflag
	ora	a
	rz
;
prnstr2:
	ldax	d	;get char into reg a
	push	d	;save de
	mov	e,a	;put it here for bdos call
	mvi	c,5	;lst: print
	call	bdos
	pop	d	;get pointer back
;
	inx	d	;point to next char
	ldax	d	;get next char
	cpi	'$'	;done yet?
	jnz	prnstr2	;no - keep going
;
	ret	;from prnstr
;
procopts:
;	process command line options
;
;	generic command line option getter
;
	lxi	d,fcb + 1	;get 1st option
cont:	ldax	d	;into A
;
	cpi	' '	;done?
	rz		;yes - go home
;
	lxi	h,optbl	;1st table entry
	mvi	b,optblen	;# table entries
;
nextt:	cmp	m	;right entry?
	jz	found	;yes - set flag
;
	inx	h	;point to next entry
	inx	h	;entries are 2 bytes long
	dcr	b	;are we out?
;
	jnz	nextt	;no - keep looking
;
	sta	erropt	;yes - invalid option
	lxi	d,errmsg
	mvi	c,9	;print error message
	call	bdos
;
	mvi	c,0
	call	bdos	;quit program
;
found:	inx	h	;point to flag
	mov	a,m	;get flag
	cma		;flip it
	mov	m,a	;put it back
;
	inx	d	;point to next option in command line
	jmp	cont	;keep at it...
;
;
;
;-------------------------------------------------
;storage
;
n:	db	0	;counter variable
user:	db	0
drive:	db	0
maxuser:  db	maxusr
maxdrive: db	maxdrv
optbl:
	db	'P'	;printer output
pflag	db	printer	;flag
	db	'C'	;console output
cflag	db	console
optblen	equ	($-optbl)/2	;# table entries
;
errmsg:	db	07h,'Invalid option '''
erropt:	db	0,''' - Aborting',cr,lf,'$'
buffptr: dw	0
buffptr2: dw	0	;work copy of buffptr.
	genhdr	maxdrv
	gensep	maxdrv
	genfence maxdrv
fenceln2: db	'    |$'
namebuff: ds	7	;output buffer for file name
	db	'$'	;end marker so we can use prnstr
spaces:	db	'       '
namefcb: db	0,'-??????????',0
	ds	23	;rest of fcb
dirbuff: ds	128	;buffer for dir entry from search first call
	ds	64	;room for a 32 level stack
stack:	dw	0
buff:	ds	maxdrv * maxusr * 7

	end
