/* header for configuration program -- BDS C version
 *
 * Source:  config.h
 * Version: December 20, 1981.
 */

/* Values of control keys go here */

int up1;		/* insert up key */
int up2;		/* move up key */
int down1;		/* insert down key */
int down2;		/* move down key */
int left;		/* cursor left key */
int right;		/* cursor right key */

int ins;		/* enter insert mode key */
int cmnd;		/* enter command mode key */
int edit;		/* enter edit mode key */

int del;		/* delete character key */
int undo;		/* undo editing key */
int delline;		/* delete line key */

int split;		/* split line key */
int join;		/* join lines key */

/* Video screen  and printer characteristics go here */

int scrnl;		/* number of rows on screen */
int scrnw;		/* # of columns on screen */
int haseol;		/* has erase to end of line */
int hasel;		/* has erase line */
int hassup;		/* has hardware scroll up */
int hassdn;		/* has hardware scroll down */
int lwidth;		/* width of list device */

/* Define array which contains the code that the
 * user gives to do special screen functions.
 */

#define BYTEMAX	1000	/* size of byte array */
char bytes[BYTEMAX];
int bytec;		/* index of next free entry */

/* Define indices into bytes[] which point at start
 * of code for each special screen function.
 */

int gotoind;		/* index to gotoxy code */
int eolind;		/* erase to end of line */
int elind;		/* erase line */
int supind;		/* scroll up */
int sdnind;		/* scroll down */

/* Define return codes */

#define	YES	1	/* all ok */
#define NO	2	/* try again */
#define EXIT	3	/* stop the program */

/* Define special characters */

#define CR	13	/* carriage return */
#define LF	10	/* line feed */
#define	TAB	9	/* tab */

/* define output file buffer */

char	outbuf [BUFSIZ];
???????????????????????????????FILE DIVIDER?????????????????????????????
/* Screen editor:  configuration program -- BDS C version
 *
 * Source:  config1.bds
 * Version: December 20, 1981.
 * Transliteration of small-C version of September 6, 1981
 */

#define VERSION "Version 2:  September 6, 1981."

#include bdscio.h
#include config.h


/* This program has 5 parts.
 *
 * Part 1 asks which keys do which special functions.
 * Part 2 asks which special functions the screen has.
 * Part 3 asks what code sequences must be output
 *        to the screen to do the functions in part 2.
 * Part 4 creates the file ed1.ccc from the answers to
 *        Part 1.
 * Part 5 creates the file ed6.ccc from the answers to
 *        Parts 2 and 3.
 */

main()
{
	/* initialize byte count */
	bytec=0;
	/* sign on and give general information */
	signon();
	/* get keyboard information */
	while (part1()==NO) {
		;
	}
	/* get screen features */
	while (part2()==NO) {
		;
	}
	/* get control sequences for screen features */
	while (part3()==NO) {
		;
	}
	/* make sure we want to continue */
	blank();
	plc("You are now ready to create files ");
	pc("ed1.ccc and ed6.ccc.");
	plc("Do you want to proceed ?");
	if (yesno()==NO) {
		return;
	}
	/* write keyboard info to file ed1.ccc */
	if (part4()!=YES) {
		return;
	}
	/* write control sequences for screen features
	 * to file ed6.ccc
	 */
	part5();
	/* sign off and tell about compiling */
	signoff();
}

/* sign on and tell how to abort */

signon()
{
plc("Welcome to the configuration program for the ");
pc("screen editor.");
plc(VERSION);
plc("Hit control-c to exit this program early.");
plc("Hit control-p to send output to the printer.");
}

/* part 1.  find out what keys will be used for
 *          special functions.
 */

part1()
{

blank();
plc("This section deals with your keyboard.");
plc("For each function key, enter the DECIMAL ");
pc("value of the ascii ");
plc("code that you want to assign to that function key.");
plc("Hit carriage return to indicate the default value.");

blank();
plc("Hit any key to get more instructions.");
getchar();

blank();
plc("insert up key:");
indent();
pc("This key inserts a blank line above the current line,");
indent();
pc("then switches the editor to insert mode.");
indent();
pc("The default is line feed (10).");
up1=getval(10);

plc("insert down key:");
indent();
pc("This key inserts a blank line below the current line,");
indent();
pc("then switches the editor to insert mode.");
indent();
pc("The default is carriage return (13).");
down1=getval(13);

plc("up key:");
indent();
pc("This key moves the cursor up,");
indent();
pc("then switches the editor to edit mode.");
indent();
pc("The default is control-u (21).");
up2=getval(21);

plc("down key:");
indent();
pc("This key moves the cursor down,");
indent();
pc("then switches the editor to edit mode.");
indent();
pc("The default is control-d (4).");
down2=getval(4);

plc("left key:");
indent();
pc("This key moves the cursor left. ");
indent();
pc("The default is back space (8).");
left=getval(8);

plc("right key:");
indent();
pc("This key moves the cursor right. ");
indent();
pc("The default is control-r (18).");
right=getval(18);

plc("insert key:");
indent();
pc("This key switches the editor to insert mode.");
indent();
pc("The default is control-n (14).");
ins=getval(14);

plc("edit key:");
indent();
pc("This key switches the editor to edit mode.");
indent();
pc("The default is control-e (5).");
edit=getval(5);

plc("command key:");
indent();
pc("This key switches the editor to command mode.");
indent();
pc("The default is esc (27).");
cmnd=getval(27);

plc("delete character key:");
indent();
pc("This key deletes the character to the left ");
pc("of the cursor.");
indent();
pc("The default is del (127).");
del=getval(127);

plc("delete line key:");
indent();
pc("This key deletes the line on which the cursor rests.");
indent();
pc("The default is control-z (26).");
delline=getval(26);

plc("undo key:");
indent();
pc("This key undoes the editing done on a line.");
indent();
pc("The default is control-x (24).");
undo=getval(24);

plc("split key:");
indent();
pc("This key splits a line into two lines.");
indent();
pc("The default is control-s (19).");
split=getval(19);

plc("join key:");
indent();
pc("This key appends a line to the line above it,");
indent();
pc("then deletes the lower line.");
indent();
pc("The default is control-p (16).");
join=getval(16);

/* recap what the user has typed.
 * ask if everything is all right.
 */

plc("The values of the keyboard keys are:");
plc("insert up:    ");
putdec(up1,3);
plc("insert down:  ");
putdec(down1,3);
plc("up:           ");
putdec(up2,3);
plc("down:         ");
putdec(down2,3);
plc("left:         ");
putdec(left,3);
plc("right:        ");
putdec(right,3);
plc("insert mode:  ");
putdec(ins,3);
plc("command mode: ");
putdec(cmnd,3);
plc("edit mode:    ");
putdec(edit,3);
plc("delete char:  ");
putdec(del,3);
plc("delete line:  ");
putdec(delline,3);
plc("undo:         ");
putdec(undo,3);
plc("split:        ");
putdec(split,3);
plc("join:         ");
putdec(join,3);
plc("are all values correct ?");
return(yesno());
}

/* get features of the video screen */

part2()
{

blank();
plc("This section deals with the video screen.");
plc("The screen MUST have a cursor positioning function,");
plc("but no other special screen functions are required.");

blank();
plc("screen length:");
indent();
pc("How many rows does your screen have ?");
indent();
pc("The default is 16.");
scrnl=getval(16);

blank();
plc("screen width:");
indent();
pc("How many columns does your screen have ?");
indent();
pc("The default is 64.");
scrnw=getval(64);

blank();
plc("printer width:");
indent();
pc("How many columns does your printer have ?");
indent();
pc("The default is 132.");
lwidth=getval(132);

blank();
plc("erase line:");
indent();
pc("Does your screen have a function which erases ");
indent();
pc("the line on which the cursor rests ?");
hasel=yesno();

plc("erase to end of line:");
indent();
pc("Does your screen have a function which erases ");
indent();
pc("from the cursor to the end of the line ?");
haseol=yesno();

plc("hardware scroll up: (line feed)");
indent();
pc("Does your screen have a function that scrolls the");
indent();
pc("screen up when the cursor is on the bottom line ?");
hassup=yesno();

plc("hardware scroll down:");
indent();
pc("Does your screen have a function which scrolls the");
indent();
pc("screen down when the cursor is on the top line ?");
hassdn=yesno();

blank();
plc("You have answered as follows: ");
plc("screen length:            ");
putdec(scrnl,1);
plc("screen width:             ");
putdec(scrnw,1);
plc("printer width:            ");
putdec(lwidth,1);
plc("erase line ?              ");
putyesno(hasel);
plc("erase to end of line ?    ");
putyesno(haseol);
plc("hardware scroll up ?      ");
putyesno(hassup);
plc("hardware scroll down ?    ");
putyesno(hassdn);

blank();
plc("are all these values correct ?");
return(yesno());
}

part3()
{
blank();
plc("This section asks you to supply code sequences for");
plc("the special functions that you said your screen had.");
plc("Enter each sequence one byte at a time.");
plc("End the sequence by typing just a carriage return.");
plc("Indicate each byte by giving a character expression.");
blank();
plc("Hit any character to get more instructions.");
getchar();

blank();
plc("An expression consists of terms separated by + or -.");
plc("Each term is either:");
plc("1.  a decimal number or");
plc("2.  an ascii character in single quotes or");
plc("3.  the letters x or y without quotes.");
plc("Use x and y only for the goto xy code sequence.");
plc("The x represents the desired COLUMN for the cursor.");
plc("The y represents the desired ROW    for the cursor.");
plc("For example, a common sequence for goto x y is:");
plc("   27, '=', y+32, x+32");

blank();
plc("Warning!  make SURE you specify the row and column in");
plc("the correct order for your terminal.");

blank();
plc("Hit any character for more instructions.");
getchar();

blank();
plc("goto x y:");
indent();
pc("Enter code to position the cursor at ROW y and COLUMN x.");
indent();
pc("If you mix up x and y, the screen will be gibberish.");
indent();
pc("0,0 is the top left corner of the screen.");
getbytes(&gotoind);

blank();
plc("Whew! It gets much easier from here on.");

blank();
if (hasel==YES) {

plc("erase line:");
indent();
pc("Enter code to erase the line on which the ");
pc("cursor rests.");
getbytes(&elind);

}

blank();
if (haseol==YES) {

plc("erase to end of line:");
indent();
pc("Enter code to erase from the cursor to the ");
pc("end of the line.");
getbytes(&eolind);

}

blank();
if (hassup==YES) {

plc("hardware scroll up: (line feed)");
indent();
pc("Enter code to scroll the screen up assuming ");
indent();
pc("the cursor is on the bottom line.");
getbytes(&supind);

}

blank();
if (hassdn==YES) {

plc("hardware scroll down:");
indent();
pc("Enter code to scroll the screen down assuming ");
indent();
pc("that the cursor is on the top line.");
getbytes(&sdnind);

}

}

part4()
{

if (fcreat("ed1.ccc",outbuf)==ERROR) {
	plc("open error on ed1.ccc");
	return(EXIT);
}

comment();
plf("Screen editor:  special key definitions");
plf("Source:  ed1.ccc");
plf("This file was created by the configuration program:");
plf(VERSION);
endcom();

blankf();
comment();
plf("Define which keys are used for special edit functions.");
endcom();

blankf();
putdef("UP1",   up1);
putdef("DOWN1", down1);
putdef("UP2",   up2);
putdef("DOWN2", down2);
putdef("LEFT1", left);
putdef("RIGHT1",right);
putdef("INS1",  ins);
putdef("EDIT1", edit);
putdef("ESC1",  cmnd);
putdef("DEL1",  del);
putdef("ZAP1",  delline);
putdef("ABT1",  undo);
putdef("SPLT1", split);
putdef("JOIN1", join);

blankf();
comment();
plf("Define length and width of screen and printer.");
endcom();

blankf();
putdef("SCRNW",scrnw);
putdef("SCRNW1",scrnw-1);
putdef("SCRNL",scrnl);
putdef("SCRNL1",scrnl-1);
putdef("SCRNL2",scrnl-2);
putdef("LISTW",lwidth);
blankf();

putc(CPMEOF,outbuf);
fflush(outbuf);
fclose(outbuf);
return(YES);
}

part5()
{

if (fcreat("ed6.ccc",outbuf)==ERROR) {
	plc("Open error on ed6.ccc");
	return(EXIT);
}

comment();
plf("Screen editor:  terminal output module");
plf("Source:  ed6.ccc");
plf("This file was created by the configuration program:");
plf(VERSION);
endcom();

blankf();
plf("#include ed.h");
plf("#include bdscio.h");
plf("#include ed1.ccc");
plf("#include edext.cc");

blankf();
comment();
plf("Define the current coordinates of the cursor.");
endcom();

/* comment out -----
blankf();
plf("int outx, outy;");
----- end comment out */

blankf();
comment();
plf("Return the current coordinates of the cursor.");
endcom();

blankf();
plf("outgetx()");
beginf();
tab1f(); pf("return(outx);");
endf();

blankf();
plf("outgety()");
beginf();
tab1f(); pf("return(outy);");
endf();

blankf();
comment();
plf("Output one printable character to the screen.");
endcom();

blankf();
plf("outchar(c) char c;");
beginf();
tab1f(); pf("syscout(c);");
tab1f(); pf("outx++;");
tab1f(); pf("return(c);");
endf();

blankf();
comment();
plf("Position cursor to position x,y on screen.");
plf("0,0 is the top left corner.");
endcom();

blankf();
plf("outxy(x,y) int x,y;");
beginf();
tab1f(); pf("outx=x;");
tab1f(); pf("outy=y;");
putbytes(gotoind);
endf();

blankf();
comment();
plf("Erase the entire screen.");
plf("Make sure the rightmost column is erased.");
endcom();

blankf();
plf("outclr()");
if ((hasel==YES)+(haseol==YES)) {

beginf();
plf("int k;");
tab1f(); pf("k=0;");
tab1f(); pf("while (k<SCRNL) {");
tab2f(); pf("outxy(0,k++);");
tab2f(); pf("outdelln();");
tab1f(); pf("}");
tab1f(); pf("outxy(0,0);");
endf();

}
else {

beginf();
plf("int k;");
tab1f(); pf("outxy(0,0);");
tab1f(); pf("k=SCRNL*SCRNW;");
tab1f(); pf("while ((k--)>0) {");
tab2f(); pf("syscout(' ');");
tab1f(); pf("}");
tab1f(); pf("outxy(0,0);");
endf();

} /* end else */

blankf();
comment();
plf("Delete the line on which the cursor rests.");
plf("Leave the cursor at the left margin.");
endcom();

blankf();
plf("outdelln()");
if (hasel==YES) {

beginf();
putbytes(elind);
endf();

}
else {

beginf();
tab1f(); pf("outxy(0,outy);");
tab1f(); pf("outdeol();");
endf();

}

blankf();
comment();
plf("Delete to end of line.");
plf("Assume the last column is blank.");
endcom();

blankf();
plf("outdeol()");
if (haseol==YES) {

beginf();
putbytes(eolind);
endf();

}
else {

beginf();
plf("int k;");
tab1f(); pf("k=outx;");
tab1f(); pf("while (k++<SCRNW1) {");
tab2f(); pf("syscout(' ');");
tab1f(); pf("}");
tab1f(); pf("outxy(outx,outy);");
endf();

}

blankf();
comment();
plf("Return yes if terminal has indicated hardware scroll.");
endcom();

blankf();
plf("outhasup()");
beginf();
tab1f();
if (hassup==YES) {
	pf("return(YES);");
}
else {
	pf("return(NO);");
}
endf();

blankf();
plf("outhasdn()");
beginf();
tab1f();
if (hassdn==YES) {
	pf("return(YES);");
}
else {
	pf("return(NO);");
}
endf();

blankf();
comment();
plf("Scroll the screen up.");
plf("Assume the cursor is on the bottom line.");
endcom();

blankf();
plf("outsup()");
if (hassup==YES) {

beginf();
tab1f(); pf("/* auto scroll */");
tab1f(); pf("outxy(0,SCRNL1);");
putbytes(supind);
endf();

}
else {

beginf();
endf();

}

blankf();
comment();
plf("Scroll screen down.");
plf("Assume the cursor is on the top line.");
endcom();

blankf();
plf("outsdn()");
if (hassdn==YES) {

beginf();
tab1f(); pf("/* auto scroll */");
tab1f(); pf("outxy(0,0);");
putbytes(sdnind);
endf();

}
else {

beginf();
endf();

}

/* make sure last line ends with CR */
plf("");

putc(CPMEOF,outbuf);
fflush(outbuf);
fclose(outbuf);
return(YES);
}

signoff()
{
plc("The configuration process is now complete.");
plc("You are now ready to compile the screen editor.");
return(YES);
}

???????????????????????????????FILE DIVIDER?????????????????????????????
/* Screen editor:  configuration program utilities
 *
 * Source:  config2.bds
 * Version: December 20, 1981.
 */

#include bdscio.h
#include config.h

/* print CR, LF and string to console */

plc(s) char *s;
{

	putchar('\n');
	puts(s);
}

/* print string to console */

pc(s) char *s;
{
	puts(s);
}

/* print yes or no on the console */

putyesno(n) int n;
{
	if (n==YES) {
		pc("yes");
	}
	else if (n==NO) {
		pc("no");
	}
	else {
		pc("syserr");
	}
}

/* put blank line to console */

blank()
{
	plc("");
}

/* start a new line and indent it */

indent()
{
	plc("    ");
}

/* get decimal value from user */

getval(def) int def;	/* default */
{
int val;
char buffer[81];	/* cp/m needs 81 chars */
	while (1) {
		plc("Enter decimal value or carriage return:  ");
		gets(buffer);
		if (buffer[0]==0) {
			return(def);
		}
		else if (number(buffer,&val)==YES) {
				return(val);
		}
	}
}

/* get a yes or no answer from the user */

yesno()
{
char buffer[81];
char c;
	while (1) {
		pc("  ");
		gets(buffer);
		c=tolower(buffer[0]);
		if (c=='y') {
			return(YES);
		}
		else if (c=='n') {
			return(NO);
		}
		else {
			plc("answer yes or no.");
		}
	}
}

/* get each byte of a control sequence */

getbytes(index) int *index;
{
char buffer[81];
char c;
int k;
int j;
	*index=bytec;
	/* do until user says all is well */
	while (1) {
		plc("");
		k=0;
		bytec=*index;
		/* do until no more bytes */
		while (1) {
			pc("Enter byte ");
			putdec(++k,3);
			pc(":  ");
			gets(buffer);
			if (buffer[0]==0) {
				bytes[bytec++]=0;
				break;
			}
			/* put bytes into bytes[] */
			j=0;
			while (bytec<BYTEMAX) {
				c=buffer[j++];
				bytes[bytec++]=c;
				if (c==0) {
					break;
				}
			}
			if (bytec>=BYTEMAX) {
				plc("byte buffer overflow.");
				return;
			}
		}
		pc("Are all bytes correct ?");
		if (yesno()==YES) {
			return;
		}
	}
}

/* file utilities */

/* write one byte to the current output file */

putfile(c) char c;
{
	return (putc(c,outbuf));
}

/* write CR, LF and string to current output file */

plf(s) char *s;
{
	putfile(CR);
	putfile(LF);
	pf(s);
}

/* write string to current output file */

pf(s) char *s;
{
	while (*s!=0) {
		putfile(*s++);
	}
}

/* write start of comment to output file */

comment()
{
	plf("/*");
}

/* write end of comment to output file */

endcom()
{
	plf("*/");
}

/* write blank line to output file */

blankf()
{
	plf("");
}

/* write 1 tab on new line to output file */

tab1f()
{
	putfile(CR);
	putfile(LF);
	putfile(TAB);
}

/* write 2 tabs on new line to output file */

tab2f()
{
	putfile(CR);
	putfile(LF);
	putfile(TAB);
	putfile(TAB);
}

/* write start of procedure body to output file */

beginf()
{
	plf("{");
}

/* write end of procedure body to output file */

endf()
{
	plf("}");
}

/* write #define statement to output file */

putdef(s,n) char *s; int n;
{
char buffer[10];
	plf("#define ");
	pf(s);
	pf(" ");
	itoc(n,buffer,10);
	pf(buffer);
}

/* generate code to do special screen functions.
 * index points into bytes[].
 */

putbytes(index) int index;
{
	while (bytes[index]!=0) {
		if (index>BYTEMAX) {
			plf("syserr: putbytes");
			return;
		}
		tab1f();
		pf("syscout(");
		while (bytes[index]!=0) {
			putfile(bytes[index++]);
		}
		index++;
		pf(");");
	}
}
???????????????????????????????FILE DIVIDER?????????????????????????????
/* Screen editor configurator:  general utilities
 *
 * Source:  config3.bds
 * Version: December 20, 1981.
 */

#include bdscio.h
#include config.h

/* return: is first token in args a number ? */
/* return value of number in *val            */

number(args,val) char *args; int *val;
{
char c;
	c=*args++;
	if (c<'0' || c>'9') {
		return(NO);
	}
	*val=c-'0';
	while (c=*args++) {
		if (c<'0' || c>'9') {
			break;
		}
		*val=(*val*10)+c-'0';
	}
	return(YES);
}

/* convert character buffer to numeric */

ctoi(buf,index) char *buf; int index;
{
int k;
	while ( (buf[index]==' ') +
		(buf[index]==TAB) ) {
		index++;
	}
	k=0;
	while (buf[index]>='0' && buf[index]<='9') {
		k=(k*10)+buf[index]-'0';
		index++;
	}
	return(k);
}

/* put decimal integer n in field width >= w */

putdec(n,w) int n,w;
{
char chars[10];
int i,nd;
	nd=itoc(n,chars,10);
	i=nd;
	while (i++<w) {
		putchar(' ');
	}
	i=0;
	while (i<nd) {
		putchar(chars[i++]);
	}
}

/* convert integer n to character string in str */

itoc(n,str,size) int n; char *str; int size;
{
int absval;
int len;
int i,j,k;
	absval=abs(n);
	/* generate digits */
	str[0]=0;
	i=1;
	while (i<size) {
		str[i++]=(absval%10)+'0';
		absval=absval/10;
		if (absval==0) {
			break;
		}
	}
	/* generate sign */
	if (i<size && n<0) {
		str[i++]='-';
	}
	len=i-1;
	/* reverse sign, digits */
	i--;
	j=0;
	while (j<i) {
		k=str[i];
		str[i]=str[j];
		str[j]=k;
		i--;
		j++;
	}
	return(len);
}
???????????????????????????????FILE DIVIDER?????????????????????????????
???????????????????????????????FILE DIVIDER?????????????????????????????
.cm screen editor:  installation guide
.cm Source:  install.doc
.cm
.he 'install.doc''September 6, 1981'
.fo ''-#-''

   This document tells you how to get the
screen editor up and running on your system.
To do this you need the following:

.nf
1.  A CP/M version 1.4 or 2.2 operation system which
    runs on an 8080, Z-80 or 8085 based computer.

2.  An 8 inch single density floppy disk drive.

3.  At least 48K of central memory.

4.  A video display which has a goto x,y cursor
    positioning function.
.br
.fi

   To get the screen editor up and running on your
system all you need to do is follow these 5 steps.

.ul
Step 1:  Back up the diskette.

   Make a backup copy of your diskette.
Do it now.

.ul
Step 2:  Run the configuration program

   Start the configuration program by typing 'config'
from CP/M.

   The configuration program tailors the screen editor for
your particular keyboard and display screen.
The configuration program asks you three sets of questions.
After you finish answering all the questions the configuration
progrm creates two files which describe your keyboard
and video display.
These two files are included into the screen editor during
step 3.

   The first set of questions ask you what keyboard
keys you want to use for each special function that
the editor uses.
To answer each question you may type either a decimal
number or a carriage return.

   If you type a carriage return the configuration
program will use the default key.
The configuration program will tell you what the
default value is for each key.
I recommend that you use the default value
unless your keyboard does not have the default key.

   If you type a decimal number instead of a carriage
return then you are indicating that you wish to
use the key whose ascii code is the same as that
decimal number.
For example, suppose the configuration program
asks you for the value of the left key.
If you type (say) 11 as a response this means
that the control-k key will be used as the left key.

   Note that the values you enter should either
be less than 32 or be equal to 127.
Avoid values greater than 127 or less than 0.

   After you answer all these questions you
will be asked if all the answers are correct.
If you say no, then you will be asked the same
questions over again.

   Note that you can always use the normal
CP/M line editing functions if you make
a mistake in typing a line.
Also, you can leave the configuration program
by hitting control-c any time that the program
asks for input from you.

   The next set of questions asks what special
built-in functions your display screen has.
Answer each question with a yes or a no.
You may use the letters 'y' or 'n' for yes or no.

   Again, after finishing the questions you will
be asked if you are satisfied with your answers.
If not, type 'no' and you will be given another chance.

   The third and last set of questions asks you
to supply the actual characters that you must
output to your display screen to get the screen
to do the special functions you said it had.
For each special functions, you will be asked to
enter those bytes one at a time.

   For example, let us start with the goto x,y
special function.
This is the only special function that your
display MUST have in order to use the screen editor.
Now suppose that in order to move the cursor to
ROW y and COLUMN x you must output the escape
character (27) followed by an equal sign, followed
by the 32 plus x, followed by 32 plus y.
To do this you would type the following:

.nf
Enter byte 1:  27
Enter byte 2:  '='
Enter byte 3:  x+32
Enter byte 4:  y+32
Enter byte 5:  (return)
.br
.fi

   Note that you type a carriage return to stop entering
bytes.

   Be
.ul
sure
that you enter the row and column numbers in the order that
your terminal expects.
(Many terminals use a sequence in which the row and column
numbers are reversed from the sequence shown above).

   If you do make a mistake in the goto xy sequence
then the screen will not look at
all like it should
when you run the editor in step 5.

   When you have finished with this last section
you will be asked whether you are ready to
create two files.
If you say yes and the configuration program will
erase the two files if they already exist,
create the two files, and then exit.
If you say no the configuration program will exit without
doing anything.
Say yes unless you don't want to erase existing versions
of the two files.

.ul
Step 3:  Compile the editor

   Next, compile the editor using the BDS C compiler.
Either version 1.43 or 1.44 will work.
You will need to compile ed2.bds through ed10.bds,
including ed6.ccc.
The submit file edcomp.sub will do it all at once.

   If you get an error you may have made a mistake
when you typed in the sequences of bytes for the
configuration program.
Such an error will show up when the compiler is compiling
the file ed6.ccc.
If there is an error on file ed6.ccc you must redo step 2.

   Something is wrong with the files on your
disk if you got any other error.
No error you can make using the configuration
program should cause an error which shows up in any
file except ed6.ccc.
Get a fresh copy of the disk from your backup
diskette and start over again from step 2.

.ul
Step 4:  Link the editor

   Use the BDS C clink program to create ed2.com.
The file edlink.sub shows how to call the linker.

.ul
Step 5:  Test and use the editor

   You are now ready to use the editor.
Invoke the editor by typing 'ed2' from CP/M.
It should clear the screen, draw the prompt line at the
top of the screen and tell you what version you are using.

   If that doesn't happen you probably gave the configuration
program the wrong information about the goto x,y cursor
function.
When you specify the goto xy function remember:
x means the COLUMN number, y means the ROW number.
Make
.ul
sure
you have specified the row and column numbers in the order your
terminal expects.
Take a deep breath and repeat steps two through six.

   If the screen looks reasonable, try out all the commands
from the user guide.
Be sure to check whether the hardware screen scrolling
is working properly.

   Note that the configuration program can not handle keyboard
keys that produce more than one character.
If you want to use such keys you will have to modify the file
ed2.bds.
Then, of course, you will have to recompile and link
the new editor.
I recommend that you get the editor working before you attempt
to modify it.

NOVICES GUIDE TO COMPILING AND LINKING
.nf
 - only if you are using CP/M version 1.4, use ED or
   some other editor to comment out the version 2.2
   syscstat(), syscin() and syscout() routines in
   ED8.BDS and uncomment the equivalent version 1.4 routines
 - copy the editor source files and the submit files to	
   an empty disk (PIP A:=B:ED*.* will do it).
   add a copy of BDSCIO.H, the compiler (CC?.COM), linker
   (CLINK.COM), runtime package (C.CCC), library (DEFF?.CRL)
   and finally SUBMIT.COM.
 - boot the system with this disk in drive A and type
   submit edcomp.
 - get a cup of coffee.
 - if all is well, type submit edlink and finish your
   coffee
 - the resulting editor will be called ed2.com

   good luck!

???????????????????????????????FILE DIVIDER?????????????????????????????
