/*
>>:yam7.c 8-13-81
 * File open and close stuff
 * This file assumes operation on a CP/M system
 */
#include "yam.h"


struct fcb {	/* CP/M Version 2 FCB as seen bu the user */
	char	dr;		/* drive number */
	char	fname[8];
	char	ftype[3];		/* corresponds to extension in rt-11 */
	char	ex;	/* file extent normally 0 */
	char s1;	/* reserved for bdos's benefit */
	char s2;	/* likewise, set to 0 on call to open,make,search */
	char	rc;	/* record count for extent[ex]  0...128 */
	char dmap[16];
	char cr;	/* current record to read or write, normally set to 0 by usr */
	unsigned recn;		/* record number */
	char recovf;		/* overflow of above */
};

#define SRCH 17 		/*bdos search for file pattern*/
#define SRCHNXT 18
#define COMPFILSIZ 35
#define SETDMA 26
#define UFNSIZE 15		/* a:foobar12.urk\0 is 15 chars */

openrx(name)
char *name;
{
	char newname[PATHLEN];

	strcpy(newname, name);
	if(!Creamfile && fopen(name, fout) != ERROR) {
		fclose(fout);
		printf("File %s Exists ", name);
		if(Altflag) {
			sprintf(newname, "%s%u", Altname, ++Altnum);
		} else {
			printf("Replace it (y/n)??");
			if(tolower(getchar())!= 'y')
				return ERROR;
		}
	}
	if(fcreat(newname, fout)==ERROR){
		printf("Can't create %s\n", newname);
		return ERROR;
	}
	Rfile= TRUE;
	strcpy(Rname, newname);
	Dumping= !Squelch;
	printf("File %s created%s\n", Rname, Dumping? "" : " recording OFF");
	return 0;
}

closerx(pad)
{
	if(Rfile) {
#ifdef BDSC
		if(pad)
			do
				putc(CPMEOF, fout);
				while(fout._nleft % SECSIZ);
#endif
		fflush(fout);
		fclose(fout);
		printf("%s closed\n", Rname);
		Rfile=FALSE;
	}
}

opentx(name)
char *name;
{
	if(fopen(name, fin)==ERROR){
		printf("Can't open %s\n", name);
		return ERROR;
	}
	Tfile= TRUE;
	strcpy(Tname, name);
	printf("%s Open for Sending\n", Tname);
	return 0;
}

closetx()
{
	if(Tfile) {
		fclose(fin);
		printf("%s closed\n", Tname);
		Tfile=FALSE;
	}
}
/* search the phone file for name */
getphone(name, buffer)
char *name, *buffer;
{
	closetx();

	if(fopen(PHONES, fin)==ERROR) {
		printf("Cannot open %s\n", PHONES);
		return ERROR;
	} else {
		while(fgets(buffer, fin))
			if(cmdeq(buffer, name))
				return OK;
	}
	return ERROR;
}

/* channge default disk and optionally, user number */
chdir(p)
char *p;
{
	unsigned newuser;

	newuser=user; *p=toupper(*p);
	if(index(*p, DISKS)) {
		defdisk= *p - 'A';
		bdos(14, defdisk);
		if(p[1] == 0)
			return;
		if((newuser=atoi(p+1)) <= MAXUSER) {
			bdos(32, newuser);
			user=newuser;
			return;
		}
	}
	printf("Disk %c and/or User %d Illegal\n", *p, newuser);
}

/* fetch default disk and user number */
initdd()
{
	defdisk= bdos(25,0);
	user=bdos(32, 0377);
}

/* Z19 gets to use it's 25th line. */
/*VARARGS*/
pstat(a,b,c)
char *a, *b, *c;
{
#ifdef Z19
	printf("\033x1\033j\033Y8 ");
#endif
	printf(a,b,c);
#ifdef Z19
	printf("\033K\033k");
#else
	printf("\n");
#endif
}
char getcty()
{
	while(!CIREADY)
		;
	return CICHAR&0177;
}

char putcty(c)
char c;
{
	while(!COREADY)
		;
	outp(CDATA, c);
	if(CIREADY) {
		if((c=getcty())==XOFF)
			getcty();
		else
			return c;
	}
	return FALSE;
}

dolist(argc, argp)
char **argp;
{
	int listfile();
	expand(listfile, argc, argp);
}

listfile(name)
char *name;
{
	int c;

	closetx();

	if(fopen(name, fin)==ERROR)
		printf("Cannot open %s\n", name);
	else {
		while((c=getc(fin))!=EOF && c != CPMEOF)
			if((c=putcty(c)))
				break;
		fclose(fin);
	}
	if(c != CAN)
		return OK;
	else
		return ERROR;
}

/* fill buf with count chars padding with ^Z for CPM */
filbuf(buf, count)
char *buf;
{
	register c, m;
	m=count;
	while((c=getc(fin))!=EOF) {
		*buf++ =c;
		if(--m == 0)
			break;
	}
	if(m==count)
		return 0;
	else
		while(--m>=0)
			*buf++ = 032;
	return count;
}

dodir(argc, argp)
char **argp;
{
	int pdirent();
	cfast=0;		/* counter for 4 across format */
	expand(pdirent, argc, argp);
}
pdirent(name)
{
	printf("%-14s%c", name, (++cfast&03)?' ':'\n');
}
/* docomp does a directory listing showing sectors for each matched file
 * and computes total transmission time of matched files in batch mode
 * time is sum of:
 * 	number of files * open/close time (assumed 5 seconds)
 *	time to xmit and ACK each sector assuming no path delay or error
 *	disk i/o time at each end, not dependent on baud rate
 */
docomp(argc,argp)
char **argp;
{
	unsigned compsecs();
	unsigned spm;	/* sectors per minute-baud */
	unsigned dminutes;	/* tenths of minutes */
	cfast=Numsecs=Numblks=0;
	expand(compsecs, argc, argp);

	spm= Baudrate/23;	/* (Baudrate*60)/(10 bits each char * 136 chars) */
	dminutes= (Numfiles/2)+((10*(Numfiles+Numsecs))/spm)+(Numsecs/25);
	printf("\n%u Files %u Blocks %u K\n",
	  Numfiles, Numblks, (Numblks*(SECPBLK/8)));
	printf("%u Sectors %u.%u Minutes Xmsn Time at %u Baud\n",
	  Numsecs, dminutes/10, dminutes%10, Baudrate);

}
/* add file length (in CP/M 128 byte records) to Numsecs */
unsigned compsecs(ufn)
char *ufn;
{
	struct fcb fstat;
	setfcb( &fstat, ufn);
	bdos(COMPFILSIZ, &fstat);
	Numsecs += fstat.recn;
	Numblks += (fstat.recn+SECPBLK)/SECPBLK;
	printf("%-14s%4u%c", ufn,fstat.recn, (++cfast&03)?' ':'\n');
}

expand(fnx, argc, argp)
int (*fnx)();
char **argp;
{
	Numfiles=0;
	if(argc<=0)
		return e1xpand(fnx, "*.*");
	else
		while(--argc>=0)
			if(e1xpand(fnx, *argp++)==ERROR)
				return ERROR;
}

/*
 * e1xpand expands ambiguous pathname afnp
 * calling fnx for each.
 * Modified from: Parameter list builder by Richard Greenlaw
 *                251 Colony Ct. Gahanna, Ohio 43230
 */
e1xpand(fnx, afnp)
int (*fnx)();
char *afnp;	/* possible ambiguous file name*/
{
	struct fcb sfcb;
	char *p, *q, i, byteaddr;
	int filecount, m;
	char tbuf[SECSIZ];
	struct {
		char xYxx[UFNSIZE];		/* unambiguous file name */
	} *fp;
	int strcmp();

	/* build CPM fcb   */
	if(setfcb(&sfcb, afnp) == ERROR) {
		printf("%s is bad pattern\n", afnp);
		return ERROR;
	}

	dumprxbuff();		/* I need the space for building the pathlist */
	clearbuff();		/* so the printer won't try to list dir's */

	/* Search disk directory for all ufns which match afn*/
	for(fp=bufst,filecount=0;; filecount++) {
		bdos(SETDMA, tbuf);
		if((byteaddr=bdos(filecount? SRCHNXT:SRCH, &sfcb))==255)
			break;
		Numfiles++;
		p = fp++;
		if(fp>bufend) {
			printf("Out of Memory for pathname expansion\n");
			return ERROR;
		}
		if(*(afnp+1) == ':') {
			/* Drive spec.*/
			*p++ = *afnp;
			*p++ = ':';
		}

		/*Copy filename from directory*/
		q = tbuf + 32 * (byteaddr % 4);
		for(i =8; i; --i)
			if((*p = 0x7F & *++q) != ' ') ++p;
		*p++ = '.' ;

		/*Copy file extent*/
		for(i = 3; i; --i)
			if((*p = 0x7F & *++q) != ' ') ++p;
		*p = '\0' ;

	}

	qsort(bufst, filecount, UFNSIZE, strcmp);

	for(fp=bufst; --filecount>=0;) {
		p=fp++;
		/* execute desired function with real pathname */
		if((*fnx)(p)==ERROR)
			return ERROR;
	}
}
n", afnp);
		return ERROR;
	}

	dumprxbuf