#include <bdscio.h>
#include <dio.h>
#include "sqcom.h"
#include "usq.h"
#define TRUE 1
#define FALSE 0
#define TAB_VERSION TRUE  
#define BIOS_VERSION TRUE
#define MAXLINES 0 		/* if 0, all lines will be displayed
				   else only MAXLINES will be displayed */

/* Program to print squeeze files formed by sq.com */

/* This program is a modification of USQ by Dick Greenlaw.  The modifications
   were made by Bob Mathias.  

	To Recompile:

		CC1 USQDIO.C -O -E2900
		CC1 UTR.C -O -E2900
		CC1 TYPESQ.C -O -E2900 

		CLINK TYPESQ USQDIO UTR -S


*/

#define VERSION "1.3   07/21/81"

main(argc, argv)
int argc;
char *argv[];
{
	int i,c;
	int getchar();		/* Directed io version */
	char inparg[16];	/* parameter from input */

	dioinit(&argc, argv);	/* obey directed to args */


	/* Initialize output drive to default drive */
	outdrv[0]  = '\0';
	/* But prepare for a specific drive */
	outdrv[1] = ':';
	outdrv[2] = '\0';	/* string terminator */

	/* Process the parameters in order */
	for(i = 1; i < argc; ++i)
		obey(argv[i]);

	if(argc < 2) {
		printf("\n\nTYPESQ is used to print files squeezed by SQ.COM.");
		printf("\nTo run this program, type 'TYPESQ <fn.ext>'\n\n");
		return;
	}
	dioflush();	/* clean up any directed io */
}

obey(p)
char *p;
{
	char *q;

	if(*(p + 1) == ':') {
		/* Got a drive */
		if(isalpha(*p)) {
			if(*(p+2) == '\0') {
				/* Change output drive */
				printf("\nOutput drive =%s",p);
				outdrv[0] = *p;
				return;
			}
		} else {
			printf("\nERROR - Ignoring %s", p);
			return;
		}
	}

	/* Check for ambiguous (wild-card) name */
	for(q = p; *q != '\0'; ++q)
		if(*q == '*' || *q == '?') {
			printf("\nCan't accept ambiguous name %s", p);
			return;
		}

	_doflag = 0;		/* force output to console */
	unsqueeze(p);
}
int col;			/* column position */

bios_putchar(c)
char c;
{
#define LF	0x0a
#define CR	0x0d
#define FF	0x0c
#define TAB	0x09
#define SPACE	0x20
#define CNTRL_C 3
#define CNTRL_S 19
#define	CONST	2
#define CONIN	3
#define CONOUT	4
#define	CHAR_AVAILABLE 255

	int number_of_spaces;
	char t;

	if ( bios(CONST,0)==CHAR_AVAILABLE )
	       {if ( (t=bios(CONIN,0))==CNTRL_C ) 
		   exit();
		else
		if (t==CNTRL_S)
		   {
		   while( bios(CONST,0) != CHAR_AVAILABLE);
		   t=bios(CONIN,0);
		   }
	        }
	if (TAB_VERSION && c==TAB)
		for(number_of_spaces=8-((col-1)&7);number_of_spaces--;col++)
			bios(CONOUT,SPACE);
	else
		{bios(CONOUT,c);
		if (c==CR || c==FF)
			col=1;
		else
		if (c != LF) col++;
		}
}






unsqueeze(infile)
char *infile;
{
#define LINEFEED 0x0a
#define CR	 0x0d
#define FORMFEED 0x0c
#define TAB      0x09

	int line_cnt;
	int early_exit;
	struct _buf inbuff, outbuff;	/* file buffers */
	int i, c;
	char *p;
	unsigned filecrc;	/* checksum */
	int numnodes;		/* size of decoding tree */
	char outfile[16];	/* output file name */

	printf("\n\n");


	if(fopen(infile, &inbuff) == ERROR) {
		printf("Can't open %s\n", infile);
		return;
	}
	/* Initialization */
	crc = 0;
	init_cr();
	init_huff();

	/* Process header */
	if(getw(&inbuff) != RECOGNIZE) {
		printf("%s is not a squeezed file\n", infile);
		goto closein;
	}

	filecrc = getw(&inbuff);

	/* Get original file name */
	p = origname;	/* send it to array */
	do {
		*p = getc(&inbuff);
	} while(*p++ != '\0');

	/* Combine with output drive */
	outfile[0] = '\0';		/* empty */
	strcat(outfile, outdrv);	/* drive */
	strcat(outfile, origname);	/* name */

	printf("\n%s -> %s: ", infile, outfile);
	printf("\n\n");

	numnodes = getw(&inbuff);

	if(numnodes < 0 || numnodes >= NUMVALS) {
		printf("%s has invalid decode tree size\n", infile);
		goto closeall;
	}

	/* Initialize for possible empty tree (SPEOF only) */
	dnode[0].children[0] = -(SPEOF + 1);
	dnode[0].children[1] = -(SPEOF + 1);

	/* Get decoding tree from file */
	for(i = 0; i < numnodes; ++i) {
		dnode[i].children[0] = getw(&inbuff);
		dnode[i].children[1] = getw(&inbuff);
	}

	/* Get translated output bytes and write file */
	line_cnt = 0;
	early_exit = 0;
	col = 1;
	while( ((c = getcr(&inbuff)) != EOF) && (!early_exit) ) {
		crc += c;
		c = c & 0x7f;
		if ( ((c > 0x1f) && (c < 0x7f)) 
		    || c == LINEFEED
		    || (BIOS_VERSION && c == CR)
		    || c == FORMFEED
		    || c == TAB)

			if (BIOS_VERSION) 
			   bios_putchar(c);
			else
		           putchar(c);

		if (c == 0x1a) early_exit = 1;
		else if (MAXLINES)
			if (c == 0x0a)
           		   if (++line_cnt >= MAXLINES)
				{printf("\n\n TYPESQ ABORTED:");
				printf(" Maximum number of lines exceeded");
				printf("\n\n");
				early_exit = 1;
				}
	}


closeall:
closein:
	fclose(&inbuff);
}
