;NEWCAT - DISKETTE CATALOG MAINTANENCE PROGRAM
;ADAPTED BY LEWIS MOSELEY, JR.
;BUILDING ON THE WORK OF WARD CHRISTENSEN IN
;HIS EXCELLENT "QCAT" AND "UCAT" PROGRAMS
;
;VERSION 2.0 OF 3/1/80    MODS TO ORIGINAL
;*UNIFIED QCAT AND UCAT FUNCTIONS INTO 1 PROGRAM.
;*MADE PROGRAM "RECURSIVE".  THUS, YOU CAN FEED IN
;A STACK OF DISKETTES WITHOUT HAVING TO ALTERNATELY
;RUN QCAT (OR FMAP) AND UCAT.
;*DIRECTORY INFO FOR CATALOG UPDATE IS PLACED
;IN AND TAKEN FROM MEMORY, RATHER THAN A TEMPORARY
;DISK FILE "NAMES.SUB", SPEEDS OPERATION.
;
;VERSIONS 2.1 & 2.2: BUG-FIXES AND PROMPT CHANGES
;
;VERSION 2.3: STRIP HI-ORDER BITS FROM FILE NAMES TO KEEP
;FILES WRITTEN VIA CP/M 2.2 FROM SCREWING UP THE SORT ORDER
;
;VERSION 2.4 OF 9/81: ADD HELP FUNCTION, INCREASE DIRECTORY
;TABLE TO MAX OF 512 ENTRIES FOR DD & HARD DISK, CHANGE
;DEFAULTS ON SOME PROMPTS. (BUG: SEE V2.6 MODS)
;
;VERSION 2.5 OF 10/81: ALLOW THE DISK TO BE CATALOGED TO BE
;ON ANY SPECIFIED DRIVE, NOT JUST A: OR B:
;
;VERSION 2.6 OF 12/81: GENERALIZE FURTHER TO ALLOW MAST.CAT TO
;BE OF ANY SPECIFIED DISK AND 'DISK TO BE CAT' TO BE ON ANY
;SPECIFIED DISK.  OOOPS, MUST REDO PART OF V2.4 MODS.  FILE-
;COUNTER WAS AN 8-BIT VALUE AND COULD NOT HANDLE MORE THAN
;256 FILE NAMES IN THE DIRECTORY.  CHANGED TO 16-BIT VALUE.
;MODIFIED HELP TO REFLECT NEW CAPABILITIES.
;
VERSION	EQU	2
MODLEV	EQU	6	;FOR SIGNON
;
;SEE COMMENTS IN HELP MESSAGE AT END OF FILE
;
;ASSEMBLY REQUIRES "MAC" AND THE "SEQIO.LIB" PACKAGE
;
	MACLIB	SEQIO
;
;DEFINE MOVE MACRO FOR CONVENIENCE
;
MOVE	MACRO	?F,?T,?L,?I
	IF	NOT NUL ?F
	LXI	D,?F
	ENDIF
	IF	NOT NUL ?T
	LXI	H,?T
	ENDIF
	IF	NOT NUL ?L
	MVI	B,?L
	ENDIF
	IF	NOT NUL ?I
	LOCAL	H,Z
	CALL	Z
H	DB	?I
Z	MVI	B,Z-H
	POP	D
	ENDIF
	CALL	MOVER
	ENDM
;
COMPARE	MACRO	?F1,?F2,?L
	MVI	B,?L
	LXI	D,?F1
	LXI	H,?F2
	CALL	COMPR
	ENDM
;
BSIZE	EQU	20*1024	;DISK BUFFER SIZE (*2)
;MAKE AS LARGE AS POSSIBLE FOR YOUR SYSTEM, HERE THEY
;ARE 20K EACH, 40K TOTAL
;
IGNSIZE	EQU	1024	;BUFF FOR IGNORED NAMES
TEST	EQU	0	;TESTING?
;
FILERR	SET	EXIT	;EXIT IF ERRORS
;
	ORG	100H		;NORMAL TPA
;
NEWCAT:	POP	H		;SAVE RETURN ADDRESS
	SHLD	EXIT+1
	LXI	SP,STACK
;
	CALL	ILPRT
	DB	'Diskette Catalog Maintenance Utility,'
	DB	' V',VERSION+'0','.',MODLEV+'0'
	DB	CR,LF,LF
	DB	'Type "NEWCAT ?" for help.'		;V2.4
	DB	CR,LF,LF,0

;
	LDA	FCB+1					;V2.4
	CPI	'?'					;HELP WANTED
P1:	JZ	HELP					;JUMP IF SO
;
	LXI	H,EXIT		;DISABLE 'HELP' CODE ('CAUSE IT
	SHLD	P1+1		;WILL BE WRITTEN OVER BY IGNORE TABLE)
;
	MVI	C,QDFC		;WHICH DISK IS LOGGED	;V2.6 BEGINS
	CALL	BDOS		;DISK IN REG A
	LXI	H,CDRIVE	;ASSUME CAT TO BE ON THIS DRIVE
	MOV	M,A
	INX	H		;POINT TO MAST.CAT DRIVE
	MOV	M,A		;ASSUME TO BE ON THIS DRIVE, TOO
	LDA	FCB+16		;DRIVE FOR MAST.CAT SPECIFIED?
	ORA	A
	JZ	NEW2		;NOPE, STICK WITH LOGGED DRIVE
	DCR	A		;ELSE MAKE INTO DRIVE SELECT CODE
	MOV	M,A		;AND STASH FOR USE LATER (IN MDRIVE)
NEW2:	LDA	FCB		;DRIVE FOR DISK TO BE CAT SPECIFIED?
	ORA	A
	JZ	NEW4		;NOPE, STICK WITH LOGGED DRIVE
	DCR	A
	STA	CDRIVE		;DITTO, ABOVE
NEW4:	LDA	CDRIVE		;REGET CAT DRIVE
	CMP	M		;SAME AS MAST.CAT DRIVE
	MVI	A,0		;ASSUME SO
	JZ	NEW6
	DCR	A		;ELSE MAKE NON-ZERO
NEW6:	STA	DRIVE
	JNZ	NEW8		;JUMP IF MULTI-DRIVE SYSTEM
;
; HERE IF INSTRUCTED TO USE THE SAME DRIVE FOR CATALOG AND MAST.CAT
;
	LDA	MDRIVE
	ADI	'A'		;MAKE DRIVE CODE ASCII [A..P]
	STA	DR1		;HOT-PATCH MESSAGE TEXTS
	STA	CDR1
	STA	MDR1
	STA	MDR2
;
	CALL	DISKA		;TELL 'EM TO LEAVE A DISK IN DRIVE A:?
	CALL	ILPRT		;TELL USER ABOUT DRIVE USEAGE
	DB	CR,LF
	DB	'The DISK TO BE CATALOGED and the CATALOG SYSTEM DISK'
	DB	cr,lf
	DB	'will alternately be inserted in Drive '
DR1:	DB	'A:'		;HOT-PATCHED AT RUN-TIME
	DB	CR,LF,LF,0
	JMP	AGAIN
;
; HERE IF DISK TO BE CATALOGED AND MAST.CAT DISK ARE ON DIFFERENT DRIVES
;
NEW8:	LDA	CDRIVE		;HOT PATCH MESSAGE TEXTS WITH
	ADI	'A'		;DRIVE TO BE CATALOGED...
	STA	CDR1
	STA	CDR2
;
	LDA	MDRIVE		;AND MAST.CAT DRIVE
	ADI	'A'	
	STA	MDR1
	STA	MDR2
	STA	MDR3
;
	CALL	DISKA		;TELL 'EM TO LEAVE DISK IN DRIVE A:?
	CALL	ILPRT		;TELL USER ABOUT DRIVE USEAGE
	DB	CR,LF
	DB	'CATALOG SYSTEM DISK *MUST* remain in Drive '
MDR3:	DB	'A:'		;HOT-PATCHED AT RUN TIME
	DB	CR,LF
	DB	'When requested, mount DISK TO BE CATALOGED in Drive '
CDR2:	DB	'A:'		;HOT PATCHED AT RUN-TIME
	DB	CR,LF,LF,0
	JMP	AGAIN
;
DISKA:	LDA	CDRIVE		;DRIVE A FOR CATALOG DISK?
	ORA	A
	RZ			;DONE IF SO
	LDA	MDRIVE		;DRIVE A FOR MAST.CAT?
	ORA	A
	RZ			;DONE IF SO
	CALL	ILPRT		;ELSE TELL USER
	DB	CR,LF
	DB	'A scratch disk *MUST* remain in Drive A:',0
	RET
;
AGAIN:	LXI	SP,STACK	;RESET STACK EACH TIME THRU
	LXI	H,NABUF		;SET UP FILE NAME BUFFER
	SHLD	BUFPTR
	LXI	H,2020H		;GET 2 SPACES
	SHLD	COUNT		;BLANK OUT ENTRY COUNTER
	SHLD	COUNT+2		;(NEEDED FOR MULTIPLE PASSES)
	MVI	A,')'		;FIX IGNORE TABLE
	STA	IGNORE
	XRA	A		;GET A ZERO...
	STA	MIEOFLG		;FIX END-OF-FILE FLAGS
	STA	NAEOFLG
	LXI	H,0		;GET A 16 BIT ZERO
	SHLD	FCT		;TO FILE COUNT
;
CATMSG	CALL	ILPRT
	DB	CR,LF,LF,'Mount DISK TO BE CATALOGED in Drive '
CDR1:	DB	'B:'		;HOT-PATCHED TO SHOW CORRECT DRIVE (V2.5)
	DB	', Ready? (Y/N) ',0
	GET	KEY	;WAIT FOR KEYPUSH
	ANI	5FH	;MAKE UPPER CASE
	CPI	'C'-40H		;ABORT ON CTRL-C
	JZ	EXIT
	CPI	CR		;ACCEPT <CR> AS YES
	JZ	CATMS2
	CPI	'Y'
	JNZ	CATMSG		;ASK AGAIN IF NO MATCH
;
CATMS2:	CALL	CRLF		;ACKNOWLEDGE WITH CR-LF
;
;THE FOLLOWING IS NECESSARY WITH DOUBLE DENSITY SYSTEMS TO
;ALLOW THE SYSTEM TO LOG IN A DISKETTE WITH (POSSIBLY)
;CHANGED DISK CHARACTERISTICS (DENSITY, SECTOR SIZE, ETC)
	MVI	C,RESETDK
	CALL	BDOS		;(EXIT WITH DRIVE A: SELECTED)
;
;SELECT THE DISK TO BE CATALOGED AS EITHER THE ORIGINALLY
;LOGGED DRIVE OR THE DRIVE SPECIFIED AT RUNTIME
	LDA	CDRIVE
	ORA	A		;SET FLAGS
	MOV	E,A
	MVI	C,SELDK
	CNZ	BDOS		;DONT BOTHER RESELECTING DRIVE A:
;
;MAKE FCB ALL '?'
	MOVE	AMB,FCB,13
;
;READ THE DIRECTORY ENTRIES
	LXI	H,NABUF		;POINT TO FILE NAME BUFFER AGAIN
	MVI	C,SRCHF
	JMP	CALLB
LOOP	MVI	C,SRCHN
CALLB	PUSH	H
	LXI	D,FCB
	CALL	BDOS
	POP	H
	INR	A
	JZ	NOMORE
;
;MOVE THE NAME INTO THE BUFFER
;
	DCR	A	;GET BACK ORIG VALUE
	ANI	3
	PUSH	H
	MOV	L,A
	MVI	H,0
	DAD	H	;X32
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,80H
	DAD	D
;HL NOW POINTS TO ENTRY (TABLE ENTRIES WILL BE 14 BYTES EACH)
	XCHG
	INX	D	;SKIP FIRST BYTE
	POP	H
	MOVE	,,8
	MVI	M,'.'
	INX	H
	MOVE	,,3
	MVI	M,0DH
	INX	H
	MVI	M,0AH
	INX	H
;INCREMENT FILE COUNT (16 BIT)
	PUSH	H
	LHLD	FCT
	INX	H
	SHLD	FCT
	POP	H
	JMP	LOOP	;GET NEXT
;
;NO MORE ENTRIES
;
NOMORE	MVI	M,'Z'-40H	;ENDFLAG NAMES BUFFER
;
NEXTS	LHLD	FCT	;GET FILE COUNT
	DCX	H
	SHLD	FCT
	SHLD	TFCT	;SAVE COUNT FOR THIS PASS
	MOV	H,A
	ORA	L	;DONE ALL YET?
	JZ	DONE	;JUMP IF THRU SORTING
;
;ELSE PASS THRU THE BUFF, SORTING IT.
;
	LXI	D,NABUF
COMPAR	LXI	H,14
	DAD	D
	PUSH	D
	PUSH	H
	MVI	B,14	;COMPARE LENGTH
CLCLP	LDAX	D
	CMP	M
	JC	NEXTC
	JNZ	DIFF
SAME	INX	D
	INX	H
	DCR	B
	JNZ	CLCLP
NEXTC	POP	H
	POP	D
	XCHG
NEXTC2	LHLD	TFCT	;DONE ALL FOR THIS PASS YET
	DCX	H
	SHLD	TFCT
	MOV	A,H
	ORA	L
	JNZ	COMPAR	;CHECK NEXT 2 IF NOT
;
;COMPLETED PASS THRU BUFF, DO NEXT PASS IF NEEDED
;
	JMP	NEXTS
;
;UNEQUAL COMPARE
;
DIFF	POP	H
	POP	D	;GET POINTERS
;SWAP
	MVI	B,14
	PUSH	B
SWAP	MOV	C,M
	LDAX	D
	MOV	M,A
	MOV	A,C
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	SWAP
	POP	B
	JMP	NEXTC2
;
;SORT ALL DONE - VERIFY "FLAG" FILE PRESENT
;
DONE	LDA	NABUF
	CPI	'-'
	JZ	NAMEOK
	CALL	ILPRT
	DB	'++MISSING "-NAME.nnn" FILE ON DISK.',CR,LF
	DB	'PUT THE NAME FILE ON THE DISK BEFORE ',CR,LF
	DB	'RUNNING THIS DISK AGAIN.',CR,LF,0
	LDA	DRIVE		;SINGLE DRIVE??
	ORA	A
	JNZ	THRU		;NO, ASK FOR NEXT DISK
	CALL	ILPRT		;ELSE ASK FOR CATALOG DISK
	DB	'Mount CATALOG SYSTEM DISK in Drive '
MDR1:	DB	'A:, press RETURN',0		;HOT-PATCHED AT RUNTIME
	GET	KEY		;WAIT FOR KEYPRESS
	JMP	THRU
;
NAMEOK	LDA	DRIVE		;TWO DRIVES??
	ORA	A
	JNZ	OK1		;YES, PROCEED
	CALL	ILPRT		;ELSE ASK FOR SYSTEM DISK
	DB	CR,LF,'Mount CATALOG SYSTEM DISK in Drive '
MDR2:	DB	'A:, press RETURN',0		;HOT PATCHED AT RUNTIME
	GET	KEY
	CALL	CRLF
;
OK1:	MVI	C,RESETDK	;RESET DISK, KILLING R/O STATUS
	CALL	BDOS		;(AND RESELECTING DRIVE A:)
	LDA	MDRIVE		;THEN SELECT DRIVE FOR MAST.CAT
	ORA	A
	MOV	E,A
	MVI	C,SELDK
	CNZ	BDOS		;DONT BOTHER RESELECTING IF DRIVE A:
;
;NOW UPDATE MAST.CAT
;SEQIO DOES CHARACTER I/O FUNCTIONS
;SET UP THE FILES
;
	FILE	INFILE,MASTIN,,MAST,CAT,BSIZE
	IF	NOT TEST
	FILE	OUTFILE,MASTOUT,,NEW,CAT,BSIZE
	ENDIF
	FILE	SETFILE,BAK,,MAST,BAK
;
INITRD	CALL	READNA		;READ DISK NAME FROM BUFFER
	MOVE	NADAT+1,DKNAME,7	;AND STASH IT
	MOVE	NADAT+9,DKNAME+9,3
;
;READ IN THE NAMES TO BE IGNORED (I.E. NOT
;CATALOGED).  THEY ARE AT THE FRONT OF MAST CAT.
;THEY ARE SIMPLY A LIST OF FILENAME.FILETYPE (CR/LF)
;WITH THE FIRST HAVING A ( BEFORE IT, AND THE
;LAST HAVING A ) AFTER IT.
;
	GET	MASTIN	;GET THE LEADING '('
	JZ	NOMAST		;IF EOF
	CPI	'('
	JNZ	NOIGN
	PUT	MASTOUT
	LXI	H,IGNORE ;POINT TO BUFFER
	LXI	B,IGNSIZE ;FOR BUFFER OVERFLOW TEST
IGNRD	PUSH	B
	PUSH	H
	GET	MASTIN
	JZ	IGNEOF	;UNEXPECTED EOF
	PUSH	PSW	;SAVE CHAR
	PUT	MASTOUT
	POP	PSW
	POP	H
	POP	B
	MOV	M,A
	INX	H
	CPI	')'
	JZ	IGNEND	;TABLE IS LOADED
	DCX	B	;MORE ROOM IN TABLE?
	MOV	A,B
	ORA	C
	JNZ	IGNRD
;TABLE OVERFLOW
	CALL	EREXIT
	DB	'++TOO MANY IGNORE NAMES FOR TABLE',0
NOMAST	CALL	EREXIT
	DB	'++MISSING OR EMPTY MAST.CAT',0
NOIGN	CALL	EREXIT
	DB	'++NO IGNORE NAMES IN MAST.CAT',0
IGNEOF	CALL	EREXIT
	DB	'++EOF READING FOR IGNORE NAMES.'
	DB	0DH,0AH,'MAY BE MISSING ")" AFTER LAST NAME.',0
;
;IGNORE NAMES HAVE BEEN READ INTO TABLE OK
IGNEND	GET	MASTIN
	JZ	IGNEOF
	PUSH	PSW
	PUT	MASTOUT
	POP	PSW
	CPI	0AH
	JNZ	IGNEND	;DELETE CR/LF
;PRIME THE BUFFERS
;
NAMELP	CALL	READNA	;READ NAME INTO NADAT
MASTLP	CALL	READMI	;READ MASTER INTO MIDAT
;IF EOF ON BOTH FILES, WE ARE ALL DONE
COMPLP	LDA	NAEOFLG	;NAME FILE EOF?
	ORA	A
	JZ	NOTEOF	;..NO
	LDA	MIEOFLG	;MASTER IN EOF?
	ORA	A
	JNZ	ALLDONE	;YES, THAT'S IT.
NOTEOF	COMPARE	NADAT,MIDAT,25
	JZ	EQUAL
	JC	WRITEN
;
;MASTER IS LOWER - WRITE IT IF FOR ANOTHER DISK
;
	COMPARE	MIDSK,DKNAME,12 ;SAME DISK?
	JZ	DELMI	;DELETING MIDAT
	MOVE	MIDAT,MODAT,25
	CALL	WRITEMO
	JMP	MASTLP
;
;DELETE MASTER IN
;
DELMI	LXI	D,DELMSG
	LXI	H,MIDAT
	CALL	MESG
	JMP	MASTLP
DELMSG	DB	'DEL: $'
;
;NAME IS LOWER - WRITE IT
;
WRITEN	MOVE	NADAT,MODAT,25
	CALL	WRITEMO
;
;PRINT THAT NAME WAS ADDED
;
	LXI	D,ADDMSG
	LXI	H,NADAT
	CALL	MESG
	CALL	READNA	;READ NEXT NAME
	JMP	COMPLP
ADDMSG	DB	'ADD: $'
;
;BOTH FILES EQUAL
;
EQUAL	MOVE	MIDAT,MODAT,25
	CALL	WRITEMO	;WRITE OUT MASTER
	JMP	NAMELP	;READ BOTH
;
;READ NAME FILE
;
READNA	LXI	H,NADAT
	MVI	B,8
	CALL	READNAC	;READ CHARACTERS
	MVI	M,'.'
	INX	H
	MVI	B,3	;TYPE LENGTH
	CALL	READNAC
	MVI	M,','
;
;IF THIS IS A NAME NOT TO BE CATALOGED,
;READ THE NEXT
;
	LXI	D,IGNORE	;GET IGNORE TABLE
IGNLP	LXI	H,NADAT
	MVI	B,12	;# OF CHARS TO MATCH
IGNCLP	LDAX	D
	CMP	M
	JZ	IGNMAT	;MATCHED
	MOV	A,M	;GET CHAR
	CPI	' '	;SPACE?
	JZ	IGNMAT1
;
;GET NEXT ENTRY
;
IGNEXTE	LDAX	D
	INX	D
	CPI	')'	;END OF TABLE?
	RZ		;..YES, RETURN
	CPI	0AH	;NEXT LINE?
	JNZ	IGNEXTE
	JMP	IGNLP
;
;CHAR MATCHED
;
IGNMAT	INX	D	;SKIP MATCH CHAR
IGNMAT1	INX	H
	DCR	B
	JNZ	IGNCLP	;LOOP UNTIL DONE
;
;NAME IS TO BE DELETED
	JMP	READNA	;READ NEXT NAME
;
;ALL DONE - WRITE EOF TO OUTPUT, ASK IF MORE TO DO
;
ALLDONE	MVI	A,'Z'-40H 	;EOF CHAR
	IF	NOT TEST
	PUT	MASTOUT
	FINIS	MASTOUT
	ENDIF
	FINIS	MASTIN
;
;RUN WAS SUCCESSFUL - SET FINAL FILE DISPOSITIONS
;
	ERASE	BAK		;ERA MAST.BAK
	RENAME	BAK,MASTIN	;REN MAST.BAK=MAST.CAT
	RENAME	MASTIN,MASTOUT	;REN MAST.CAT=MAST.NEW
	CALL	ILPRT
	DB	CR,LF,'MAST.CAT now has '
COUNT	DB	'     Entries.'		;NOTE: COUNT PATCHED IN
	DB	'  THIS UPDATE COMPLETE.',0
THRU:	CALL	ILPRT
	DB	CR,LF,'ANOTHER DISK TO CATALOG (Y/N) ',0
	GET	KEY		;GET KEYPUSH
	ANI	5FH		;CONVERT LOWER CASE
	CPI	CR		;ACCEPT <CR> AS YES
	JZ	AGAIN
	CPI	'Y'
	JZ	AGAIN		;LOOP IF "Y"
	JMP	EXIT		;ELSE THROUGH, EXIT
;
;READ CHARACTERS INTO NAME BUFFER
;
READNAC	LDA	NAEOFLG	;EOF ON NAMES?
	ORA	A
	JNZ	NAEOF	;YES, PAD W/0FFH
	PUSH	H
	PUSH	B
GETNA	CALL	GETNAM		;GET FROM BUFFER, NOT DISK
	CPI	0AH
	JZ	GETNA	;IGNORE LF
	POP	B
	POP	H
	CPI	'.'	;END?
	JZ	NAEND
	CPI	0DH	;END?
	JZ	NAEND
	CPI	'Z'-40H	;EOF?
	JZ	NAEOF
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READNAC
	PUSH	B
	PUSH	H
	CALL	GETNAM		;KILL DELIMITER CHAR
	POP	H
	POP	B
	CPI	'Z'-40H	;EOF?
	RNZ
	STA	NAEOFLG
	RET
NAEND	MVI	M,' '
	INX	H
	DCR	B
	JNZ	NAEND
	RET
NAEOF	MVI	M,0FFH
	INX	H
	DCR	B
	JNZ	NAEOF
	MVI	A,1
	STA	NAEOFLG
	RET
;
;SUBROUTINE TO SIMULATE READING FROM THE OLD NAMES.SUB 
;FILE.  ACTUALLY, THE CHARACTERS COME FROM THE NAMES 
;BUFFER PROVIDED BY THE FIRST PART OF THE PROGRAM
GETNAM:	LHLD	BUFPTR		;GET POINTER TO NABUF
	MOV	A,M		;GET NEXT CHAR
	INX	H		;BUMP THE POINTER
	SHLD	BUFPTR	
	RET
;
;READ MASTER IN NAME
;
READMI	LXI	H,MIDAT
	CALL	MINAME	;GET FILE NAME
	MVI	M,','	;SEPARATOR
	INX	H
	CALL	MINAME	;GET DISK NAME
	RET
;
;READ MASTER IN, 1 FIELD
;
MINAME	MVI	B,8
	CALL	READMIC	;GET CHARS
	MVI	M,'.'
	INX	H
	MVI	B,3
	CALL	READMIC	;GET TYPE
	RET
;
;READ CHARS INTO MASTER NAME
;
READMIC	LDA	MIEOFLG
	ORA	A
	JNZ	MIEOF
	PUSH	H
	PUSH	B
GETMI	GET	MASTIN
	CPI	0AH	;IGNORE LF
	JZ	GETMI	;L/F'S
	POP	B
	POP	H
	CPI	','
	JZ	MIEND
	CPI	'.'
	JZ	MIEND
	CPI	0DH
	JZ	MIEND
	CPI	'Z'-40H	;EOF?
	JZ	MIEOF
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READMIC
	PUSH	B
	PUSH	H
	GET	MASTIN	;GET DELIMITER
	POP	H
	POP	B
	CPI	'Z'-40H	;EOF?
	RNZ
	STA	MIEOFLG
	RET
MIEND	MVI	M,' '
	INX	H
	DCR	B
	JNZ	MIEND
	RET
MIEOF	MVI	M,0FFH
	INX	H
	DCR	B
	JNZ	MIEOF
	STA	MIEOFLG	;SHOW EOF
	RET
;
;WRITE AN ENTRY TO MASTER OUT
;ALSO BUMP COUNT OF ENTRIES WRITTEN
;
WRITEMO	LXI	H,COUNT+3
BUMP	MOV	A,M	;GET COUNT DIGIT
	CPI	' '
	JNZ	BUMPNB
	MVI	A,'0'
BUMPNB	INR	A
	MOV	M,A
	CPI	'9'+1	;TIME TO CARRY?
	JNZ	BUMPD	;..NO, DONE
	MVI	M,'0'
	DCX	H
	JMP	BUMP
BUMPD	LXI	H,MODAT
	MVI	B,25
WRMOL	MOV	A,M
	CPI	' '	;NULL CHAR?
	JZ	WRSKIP
	PUSH	B
	PUSH	H
	IF	NOT TEST
	PUT	MASTOUT
	ELSE
	PUT	CON
	ENDIF
	POP	H
	POP	B
WRSKIP	INX	H	;POINT TO NEXT CHAR
	DCR	B
	JNZ	WRMOL	;LOOP UNTIL DONE
	MVI	A,0DH
	IF	NOT TEST
	PUT	MASTOUT
	ELSE
	PUT	CON
	ENDIF
	MVI	A,0AH
	IF	NOT TEST
	PUT	MASTOUT
	ELSE
	PUT	CON
	ENDIF
	RET
;
;PRINT MESSAGE IN DE, THEN NAME IN HL
;
MESG	PUSH	H
	MVI	C,PRINT
	CALL	BDOS
	POP	H
	MVI	B,12	;NAME + '.' + TYPE
MESGL	PUSH	H
	PUSH	B
	MOV	A,M	;GET CHAR
	CPI	' '
	JZ	MESGS	;SKIP IF ' '
	PUT	CON
MESGS	POP	B
	POP	H
	INX	H
	DCR	B
	JNZ	MESGL
	MVI	A,0DH
	PUT	CON
	MVI	A,0AH
	PUT	CON
	RET
;
;MOVE SUBROUTINE (DE)=>(HL), LEN IN (B)
;MODIFIED MY L.M. TO STRIP HI-ORDER BIT.  SEE NOTE 
;ABOUT VERSION 2.3 MODS AT FRONT OF FILE
;
MOVER	LDAX	D
	ANI	7FH	;STRIP
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVER
	RET
;
;COMPARE ROUTINE (DE)<=>(HL), LENGTH IN B
;
COMPR	LDAX	D
	CMP	M
	RNZ		;RET W/NON ZERO SET
	INX	D
	INX	H
	DCR	B
	JNZ	COMPR
	RET		;ZERO SET, SHOWS =
;
;INLINE PRINT SUBROUTINE
;
ILPRT	XTHL		;GET STARTING ADDR OF STRING TO HL
ILPLP	MOV	A,M
	PUSH	H
	PUT	CON
	POP	H
	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL		;RETURN ADDR TO TOP OF STACK 
	RET
;
CRLF:	CALL	ILPRT		;CARRIAGE RET - LINE FEED
	DB	CR,LF,0
	RET
;
;EXIT WITH ERROR MESSAGE
EREXIT	MVI	A,0DH
	PUT	CON
	MVI	A,0AH
	PUT	CON
	POP	D	;GET MSG ADDR
	MVI	C,PRINT
	CALL	BDOS
EXIT	JMP	$-$	;TO CP/M RETURN ADDR
;
AMB	DB	0,'???????????',0	;LOG DR, MATCH ANY FN.FT, EXT 0
;
NADAT	DB	'XXXXXXXX.YYY,'
DKNAME	DB	'        .   '
MIDAT	DB	'XXXXXXXX.YYY,'
MIDSK	DB	'XXXXXXXX.YYY'
MODAT	DB	'XXXXXXXX.YYY,XXXXXXXX.YYY'
;
; HELP CODE AND TEXT IS OVERLAID BY IGNORE TABLE IN A NORMAL RUN
;
;
HELP:	CALL	CLS				;V2.4 MOD (+V2.6)
	CALL	ILPRT			;FRAME 1
	DB	CR,LF,LF,LF
	DB	'                         NEWCAT'
	DB	CR,LF,LF
	DB	'NEWCAT IS A PART OF THE DISKETTE CATALOG SYSTEM UTILITY.  IT '
	DB	CR,LF
	DB	'READS THE DISK DIRECTORY OF THE "DISK TO BE CATALOGED" AND '
	DB	CR,LF
	DB	'UPDATES THE FILE "MAST.CAT", WHICH IT EXPECTS TO FIND ON THE '
	DB	CR,LF
	DB	'CATALOG SYSTEM DISK.  THE PROGRAM WILL WORK WITH A SINGLE '
	DB	CR,LF
	DB	'DRIVE SYSTEM, BUT IS MUCH EASIER TO USE ON A MULTI-DRIVE '
	DB	CR,LF
	DB	'SYSTEM.  THE "DISK TO BE CATALOGED" AND THE "CATALOG SYSTEM '
	DB	CR,LF
	DB	'DISK" MAY EACH RESIDE ON ANY DESIRED DISK DRIVE BY USING THE '
	DB	CR,LF
	DB	'RUNTIME OPTIONS DESCRIBED IN THE NEXT FRAME.'
	DB	CR,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF
	DB	'HIT ANY KEY TO PROCEED:',0		;END OF FRAME 1
;
	GET	KEY
	CALL	CLS
;
	CALL	ILPRT		;FRAME 2
	DB	CR,LF
	DB	'NEWCAT USEAGE AND SYNTAX:'
	DB	CR,LF,LF
	DB	'NEWCAT         YOU WILL BE ASKED TO ALTERNATELY INSERT THE'
	DB	CR,LF
	DB	'               CATALOG SYSTEM DISK (CONTAINING MAST.CAT) AND'
	DB	CR,LF
	DB	'               THE DISK TO BE CATALOGED IN THE CURRENTLY'
	DB	CR,LF
	DB	'               LOGGED DRIVE.'
	DB	CR,LF,LF
	DB	'NEWCAT B:      MAST.CAT WILL BE FOUND ON THE LOGGED DRIVE,'
	DB	CR,LF
	DB	'               BUT USE THE SPECIFIED DRIVE FOR THE DISK TO'
	DB	CR,LF
	DB	'               BE CATALOGED (DRIVE B: IN THIS EXAMPLE.)'
	DB	CR,LF
	DB	'               IF THE SPECIFIED DRIVE IS THE SAME AS THE'
	DB	CR,LF
	DB	'               CURRENT DRIVE, YOU WILL BE ASKED TO'
	DB	CR,LF
	DB	'               ALTERNATELY INSERT THE DISKS.'
	DB	CR,LF,LF
	DB	'NEWCAT B: C:   MAST.CAT WILL BE FOUND ON THE SECOND'
	DB	CR,LF
	DB	'               SPECIFIED DRIVE (HERE, DRIVE C:), WHILE THE'
	DB	CR,LF
	DB	'               DISK TO BE CATALOGED WILL BE PLACED IN THE'
	DB	CR,LF
	DB	'               FIRST SPECIFIED DRIVE (HERE, DRIVE B:).'
	DB	CR,LF,LF,LF,LF,LF
	DB	'HIT ANY KEY TO PROCEED:',0	;END OF FRAME 2
;
	GET	KEY
	CALL	CLS
;
	CALL	ILPRT				;FRAME 3
	DB	'GETTING STARTED:'
	DB	CR,LF,LF
	DB	'EACH DISKETTE MUST CONTAIN A FLAG FILE WHICH SPECIFIES THE'
	DB	CR,LF
	DB	'DISK NAME AND/OR NUMBER.  THE FIRST CHARACTER OF THE FILE'
	DB	CR,LF
	DB	'NAME OF THE FLAG FILE MUST BE A "-".  CREATE THE FLAG FILE,'
	DB	CR,LF
	DB	'FOR EXAMPLE, BY "SAVE 0 -DISK.001".'
	DB	CR,LF,LF
	DB	'     WHEN YOU FIRST START USING THE SYSTEM, YOU MUST CREATE'
	DB	CR,LF
	DB	'A FILE NAMED "MAST.CAT", AND PLACE IN THIS FILE A LIST OF'
	DB	CR,LF
	DB	'FILE NAMES TO IGNORE IN THE CATALOGING PROCESS. THIS LIST'
	DB	CR,LF
	DB	'SHOULD HAVE 1 NAME PER LINE, AND SHOULD BE ENCLOSED IN'
	DB	CR,LF
	DB	'PARENTHESIS, FOR EXAMPLE:'
	DB	CR,LF,LF
	DB	'	(STAT.COM'
	DB	CR,LF
	DB	'	PIP.COM'
	DB	CR,LF
	DB	'	ED.COM)'
	DB	CR,LF,LF,LF,0		;END OF FRAME 3
;
	JMP	EXIT		;END OF HELP MESSAGE CODE AND TEXT
;
; ROUTINE TO CLEAR TERMINAL SCREEN BY ISSUING 25 CR-LF'S.  PATCH
; TO USE YOUR TERMINAL'S CLEAR-SCREEN CODE IF DESIRED, OR DISABLE
; IF YOU STILL USE A HARD COPY TERMINAL.  CRUDE, BUT IT WORKS.
; ONLY USED FOR HELP, SO OVERLAID BY DATA AREA OTHERWISE.
;
CLS:	MVI	H,25		;HL IS PRESERVED
CLS1:	CALL	CRLF
	DCR	H
	JNZ	CLS1
	RET
;
	ORG	HELP
;
; IGNORE FILE-NAME TABLE OVERLAYS HELP CODE, SINCE ONLY ONE
; OR THE OTHER WOULD BE USED IN ANY RUN
;
IGNORE	DS	1	;DUMMY END OF TABLE MARK STORED HERE EACH PASS
	DS	IGNSIZE		;IGNORE TABLE
;
CDRIVE	DS	1	;DRIVE FOR DISK TO BE CATALOGED
MDRIVE	DS	1	;DRIVE FOR MAST.CAT  **MUST** FOLLOW CDRIVE
DRIVE	DS 	1	;FLAG FOR BOTH DRIVES THE SAME
;
FCT	DS	2	;FILE COUNT
TFCT	DS	2	;FILE COUNT FOR THIS SORT PASS
BUFPTR	DS	2	;NAME BUFFER POINTER
NAEOFLG	DS	1	;NAME BUFFER EOF FLAG
MIEOFLG	DS	1	;MASTER IN EOF FLAG
;
;DISK DIRECTORY ENTRIES STORED HERE (ROOM FOR 256 ENTRIES)
NABUF	DS	(512*14)+1	;FOR D.D./D.S. SYSTEMS
;
	DS	80	;LOTSA STACK SPACE (40 LEVELS)
STACK	EQU	$
;
BUFFERS	EQU	$		;USED BY SEQIO
MEMSIZE	EQU	BUFFERS+@NXTB
;
;BDOS/CBIOS EQUATES 
RDCON	EQU	1
PRINT	EQU	9
RESETDK	EQU	13
SELDK	EQU	14
SRCHF	EQU	17
SRCHN	EQU	18
QDFC	EQU	25		;QUERY CURRENT LOGGED DISK
BDOS	EQU	5
FCB	EQU	5CH 

	END	NEWCAT



