;MBOOT3.ASM FOR MORROW MD3
;USE SETUP.COM ON MD3 CP/M DISK TO SET BAUD RATE PARAMETERS ON SERIAL
;PRINTER PORT...
;
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
BASE	EQU	0
;
EXITCHR	EQU	05H	;EXIT TERM TO CPM
ESC	EQU	1BH	;EXIT TERM TO FILE RECEIVE
;
SPEED	EQU	4	;CPU	SPEED IN MHZ
;
INITREQ	EQU	FALSE	;TRUE IF PORT INIT REQUIRED
;
;MD3 PORTS GO HERE
;
PORT	EQU	0FEH	;MD3	PRINTER/SERIAL PORT
MODSTAT	EQU	PORT+1	;STATUS PORT
MODSNDB	EQU	01H	;BIT TO TEST FOR SEND
MODSNDR	EQU	01H	;VALUE WHEN READY
MODRCVB	EQU	02H	;BIT TO TEST FOR RECEIVE
MODRCVR	EQU	02H	;VALUE	WHEN RECEIVE READY
MODDATA	EQU	PORT	;MODEM DATA PORT
;
;
ERRLIM	EQU	10
;
;
SOH	EQU	1
EOT	EQU	4
ACK	EQU	6
NAK	EQU	15H
CAN	EQU	18H
LF	EQU	10
CR	EQU	13
;
;
BDOS	EQU	BASE+5
FCB	EQU	BASE+5CH
;
	ORG	BASE+100H
;
;CODE BEGINS...
;
LXI	H,0
DAD	SP
SHLD	STACK
LXI	SP,STACK
CALL	INITADR
CALL	ILPRT
DB	'MORROW MD3 MBOOT  - MICRO/ACCESS - MAY 10,1985',CR,LF
DB	CR,LF,'USE SETUP.COM ON MD3 CP/M SYSTEM DISK TO SET BAUD'
DB	CR,LF,'RATE ON SERIAL PRINTER PORT',CR,LF,LF,0
LDA	FCB+1
CPI	' '
JNZ	TERM1
CALL	ILPRT
DB	'==> SPECIFY FILE NAME ',CR,LF,0
JMP	EXIT
;
TERM1:
	CALL	INITMOD
	IN	MODDATA
	IN 	MODDATA
	CALL	ILPRT
	DB	CR,LF,'==> TERMINAL MODE ',CR,LF
	DB	'<CTL>-E EXITS TO SYSTEM, <ESC> BEGINS FILE TRANSFER '
	DB	CR,LF,0
;
TERM:
	CALL	STAT
	JZ	TERML
	CALL	KEYIN
	CPI	EXITCHR
	JZ	EXIT
	CPI	ESC
	JZ	RCVFIL
	OUT	MODDATA
;
TERML:
	IN	MODSTAT
	ANI	MODRCVB
	CPI	MODRCVR
	JNZ	TERM
	IN	MODDATA
	ANI	7FH
	CALL	TYPE
	JMP	TERM
;
RCVFIL:
	CALL	ERASFIL
	CALL	MAKEFIL
	CALL	ILPRT
	DB	'==> FILE OPEN, READY TO RECEIVE',CR,LF,0
;
RCVLP:
	CALL	RCVSECT
	JC	RCVEOT
	CALL	WRSECT
	CALL	INCRSNO
	CALL	SENDACK
	JMP	RCVLP
;
RCVEOT:
	CALL	WRBLOCK
	CALL	SENDACK
	CALL	CLOSFIL
	CALL	ERXIT
	DB	CR,LF,'==> TRANSFER COMPLETE$'
;
RCVSECT:
	XRA	A
	STA	ERRCT
;
RCVRPT:
	MVI	B,SPEED*10
	CALL	RECV
	JC	RCVSERR
	CPI	SOH
	JZ	RCVSOH
	ORA	A
	JZ	RCVRPT
	CPI	EOT
	STC
	RZ
;
RCVSERR:
	MVI	B,SPEED
	CALL	RECV
	JNC	RCVSERR
	MVI	A,NAK
	CALL	SEND
	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	ERRLIM
	JC	RCVRPT
;
RCVSABT:
	CALL	CLOSFIL
	CALL	ERXIT
	DB	'==> UNABLE TO RECEIVE BLOCK'
	DB	CR,LF,' <ABORTING>$'
;
RCVSOH:
	MVI	B,SPEED
	CALL	RECV
	JC	RCVSERR
	MOV	D,A
	MVI	B,SPEED
	CALL	RECV
	JC	RCVSERR
	CMA
	CMP	D
	JZ	RCVDATA
	JMP	RCVSERR
;
RCVDATA:
	MOV	A,D
	STA	RCVSNO
	MVI	C,0
	LXI	H,BASE+80H	;DMA AREA
;
RCVCHR:
	MVI	B,SPEED
	CALL	RECV
	JC	RCVSERR
	MOV	M,A
	INR 	L
	JNZ	RCVCHR
	MOV	D,C
	MVI	B,SPEED
	CALL	RECV
	JC	RCVSERR
	CMP	D
	JNZ	RCVSERR
	LDA	RCVSNO
	MOV	B,A
	LDA	SECTNO
	CMP	B
	JZ	RECVACK
	INR	A
	CMP	B
	JNZ	ABORT
	RET
;
RECVACK:
	CALL	SENDACK
	JMP	RCVSECT
;
SENDACK:
	MVI	A,ACK
;
SEND:	PUSH	PSW
	ADD	C
	MOV	C,A
;
SENDW:
	IN	MODSTAT
	ANI	MODSNDB
	CPI	MODSNDR
	JNZ	SENDW
	POP	PSW
	OUT	MODDATA
	RET
;
ABORT:
	LXI	SP,STACK
;
ABORTL:
	MVI	B,SPEED
	CALL	RECV
	JNC	ABORTL
	MVI	A,CAN
	CALL	SEND
;
ABORTW:
	MVI	B,1
	CALL	RECV
	JNC	ABORTW
	MVI	A,' '
	CALL	SEND
	CALL	ERXIT
	DB	'==> PROGRAM RUN CANCELLED$'
;
INCRSNO:
	LDA	SECTNO
	INR	A
	STA	SECTNO
	RET
;
ERASFIL:
	LXI	D,FCB
	MVI	C,17
	CALL	BDOS
	INR	A
	RZ
	CALL	ILPRT
	DB	'==> FILE EXISTS, ERASE? (Y/N) ',0
	CALL	KEYIN
	PUSH	PSW
	CALL	TYPE
	CALL	CRLF
	POP	PSW
	ANI	5FH
	CPI	'Y'
	JNZ	MXIT
	LXI	D,FCB
	MVI	C,19
	JMP	BDOS
;
MAKEFIL:
	LXI	D,FCB
	MVI	C,22
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'==> UNABLE TO CREATE FILE',CR,LF
	DB	'DIRECTORY FULL$'
;
CLOSFIL:
	LXI	D,FCB
	MVI	C,16
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'==> UNABLE TO CLOSE FILE$'
;
WRSECT:
	LHLD	SECPTR
	XCHG
	LXI	H,BASE+80H
	CALL	MOVE128
	XCHG
	SHLD	SECPTR
	LDA	SECINBF
	INR	A
	STA	SECINBF
	CPI	16
	RNZ
;
WRBLOCK:
	LDA	SECINBF
	ORA	A
	RZ
	MOV	C,A
	LXI	D,DBUF
;
DKWRLP:
	PUSH 	H
	PUSH	D
	PUSH	B
	MVI	C,26
	CALL	BDOS
	LXI	D,FCB
	MVI	C,21
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	ORA	A
	JNZ	WRERR
	LXI	H,80H
	DAD	D
	XCHG
	DCR	C
	JNZ	DKWRLP
	XRA	A
	STA	SECINBF
	LXI	H,DBUF
	SHLD	SECPTR
;
RSDMA:
	LXI	D,BASE+80H
	MVI	C,26
	JMP	BDOS
;
WRERR:
	CALL	RSDMA
	CALL	ILPRT
	DB	'==> ERROR WRITING FILE',CR,LF,0
	JMP	ABORT
;
RECV:
	PUSH	D
MSEC:	LXI	D,12500
;
MWTI:
	IN	MODSTAT
	ANI	MODRCVB
	CPI	MODRCVR
	JZ	MCHAR
	DCR	E
	JNZ	MWTI
	DCR	D
	JNZ	MWTI
	DCR	B
	JNZ	MSEC
	POP	D
	STC
	RET
;
MCHAR:
	IN	MODDATA
	POP	D
	PUSH	PSW
	ADD	C
	MOV	C,A
	POP	PSW
	ORA	A
	RET
;
INITADR:
	LHLD	BASE+1
	LXI	D,3
	DAD	D
	SHLD	VSTAT+1
	DAD	D
	SHLD	VKEYIN+1
	DAD	D
	SHLD	VTYPE+1
	RET
;
INITMOD	EQU	$
;
IF	INITREQ		;SERIAL PORT INITIALIZATION CODE GOES HERE
;
;
;
;
ENDIF
;
;
RET			;SO WE GO BACK REGARDLESS
;
CRLF:
	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
TYPE:
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A
VTYPE:
	CALL	$-$
	POP	H		
	POP	D
	POP	B
	POP	PSW
	RET
;
STAT:
	PUSH	B
	PUSH	D
	PUSH	H
VSTAT:
	CALL	$-$
	POP	H
	POP	D
	POP	B
	ORA	A
	RET
;
KEYIN:
	PUSH	B
	PUSH	D
	PUSH	H
VKEYIN:
	CALL	$-$
	POP	H
	POP	D
	POP	B
	ANI	7FH
	RET
;
ILPRT:
	XTHL
;
ILPLP:
	MOV	A,M
	ORA	A
	JZ	ILPRET
	CALL	TYPE
	INX	H
	JMP	ILPLP
;
ILPRET:
	XTHL
	RET
;
ERXIT:
	POP	D
	MVI	C,9
	CALL	BDOS
;
MXIT:
	CALL	ILPRT
	DB	CR,LF,'==> DON''T FORGET TO DISCONNECT MODEM'
	DB	CR,LF,0
;
EXIT:
	LHLD	STACK
	SPHL
	RET	
;
MOVE128:
	MVI	B,128
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
RCVSNO:	DB	0
SECTNO:	DB	0
ERRCT:	DB	0
EOFLG:	DB	0
SECPTR:	DW	DBUF
SECINBF: DB	0
	DS	60
STACK:	DS	2
DBUF:	EQU	$
;
END


	.  The
;	 end of your last routine should term