;  --- THIS IS AN OVERLAY TO THE FRONT TO THE MODEM ---
;	PROGRAM TO ALLOW EASY CHANGING THE MODEM
;	INTERFACE SECTION.
;
; --- THIS VERSION FOR RS232C PORT ON OSBORN O-1 COMPUTER ---
;	THIS VERSION WILL ALLOW SELECTION OF 300 OR 1200 BAUD
;	WITH THE USUAL BAUDRATE COMMAND STRING
;

;THESE ROUTINES ARE AT THE BEGINNING OF THE PROGRAM SO
;THEY CAN BE PATCHED BY A MONITER WITHOUT RE-ASSEMBLING
;THE PROGRAM.

FALSE	EQU	0
TRUE	EQU	0FFH
;
	ORG	104H
;
IMSAIBYTE	DB FALSE		;true=imsai front panel
FASTCLK		DB FALSE		;4 MHz or greater
BAKUPBYTE	DB TRUE 		;true=make .BAK file
XPRFLG		DB FALSE		;true=no menu, false=print menu
;
; --- CUSTOM MODEM DRIVER ---
;
		JMP	MXINIT	; INIT MODEM ROUTINES (NOT HARDWARE)
IN$MODDATP	JMP	MXIN	; GET DATA FROM MODEM
OUT$MODDATP	JMP	MXOUT	; OUTPUT DATA TO MODEM
IN$STAT		JMP	MXISTAT	; TEST FOR INPUT DATA
OUT$STAT	JMP	MXOSTAT	; TEST IF OK TO OUTPUT DATA
SET$BAUD	JMP	MXSETBAUD ; SETUP BAUDRATE
JMP$INITMOD	JMP	MXINITH	; INIT MODEM HARDWARE
;
MODCTLP	EQU	2A00H	;ALTERNATE PAGE DATA PORT
MODSNDB	EQU	02H	;YOUR BIT TO TEST FOR SEND
MODSNDR	EQU	02H	;YOUR VALUE WHEN READY
MODRCVB	EQU	01H	;YOUR BIT TO TEST FOR RECEIVE
MODRCVR	EQU	01H	;YOUR VALUE WHEN READY
MODDATP	EQU	2A01H	;ALTERNATE PAGE DATA PORT
;
; --- ALL OF THE MODEM ROUTINES MAY ONLY CHANGE ---
;	THE A-REGISTER AND THE FLAGS.  NO OTHER
;	REGISTERS MAY BE CHANGED.
;
; --- INPUT DATA FROM MODEM ---
;
MXIN	CALL	0	; PATCHED TO CALL INPUT ROUTINE
	RET
;
; --- OUTPUT DATA TO MODEM ---
;
MXOUT	CALL	0	; PATCHED TO CALL OUTPUT ROUTINE
	RET
;
; --- TEST IF DATA IS AVAILABLE FROM MODEM ---
;
MXISTAT	CALL	0	; PATCHED TO CALL STATUS ROUTINE
	ANI	MODRCVB
	CPI	MODRCVR	
	RET		; RETURN WITH Z SET IF DATA IS READY
;
; --- TEST MODEM IS READY TO BE SENT NEXT CHAR. ---
;
MXOSTAT	CALL	0	; PATCHED TO CALL STATUS ROUTINE
	ANI	MODSNDB
	CPI	MODSNDR
	RET		; RETURN WITH Z SET IF MODEM IS READY
;
; --- INIT MODEM ROUTINES (NOT HARDWARE) ---
;	THIS ROUTINE NEED NOT PRESERVE ANY
;	OF THE REGISTERS.
;
MXINIT	LXI	D,MSG	; POINT TO MESSAGE
	MVI	C,9
	CALL	05H	; USE BDOS CALL TO PRINT STRING
;
	LHLD	6	; FIND TOP OF USER RAM
	LXI	D,-100H	; STEP DOWN A LITTLE
	DAD	D
	PUSH	H	; SAVE IT
	LXI	D,BDJ	; POINT TO SOURCE OF CODE
	LXI	B,CDLEN+2	; SET LENGTH OF CODE
	XCHG
	DB	0EDH,0B0H ; --- FAKE LDIR
;
	LHLD	6	; GET BDOS ADDRESS BACK
	POP	D
	PUSH	D
	INX	D	; POINT TO ADDRESS POSITION
	XCHG
	MOV	M,E	; PATCH IN ADDRESS
	INX	H
	MOV	M,D
;
	POP	H
	SHLD	6	; TRANSFER BDOS JUMP
;
	LXI	D,OSIN-BDJ
	DAD	D	; COMPUTE ADDRESS OF OSIN ROUTINE
	SHLD	MXIN+1	; PATCH CALL
	LXI	D,OSOUT-OSIN
	DAD	D
	SHLD	MXOUT+1	; PATCH CALL
	LXI	D,OSTAT-OSOUT
	DAD	D
	SHLD	MXISTAT+1
	SHLD	MXOSTAT+1
	RET
;
CR	EQU	0DH
LF	EQU	0AH
MSG:	DB	CR,LF,CR,LF
	DB	' SETUP FOR RS232 PORT ON OSBORN O-1'
	DB	CR,LF,CR,LF,'$'
;
; --- INIT MODEM HARDWARE IF NECESSARY ---
;	THIS ROUTINE MAY BE CALLED SEVERAL TIMES, SO BE
;	SURE THAT THIS WILL NOT HANG UP THE HARDWARE.
;
MXINITH	RET
;
; --- SET HARDWARE BAUDRATE FROM STRING POINTED TO BY---
;	(H,L).  IF THE STRING STARTS WITH AN ASCII SPACE,
;	SET THE BAUDRATE TO THE DEFAULT VALUE.  IF THE
;	REQUEST IS NOT VALID, RETURN WITH CARRY SET.
;
; --- THIS WILL EITHER SETUP FOR 300 OR 1200 BAUD, 300 IF ERROR
MXSETBAUD:
	PUSH	B
	MVI	C,55H	; FOR 1200 BAUD
	MOV	A,M	; GET FIRST STRING CHAR.
	CPI	'1'	; IF 1200 BAUD
	JZ	STBAUD
	CPI	'3'	; TEST IF 300
	JZ	SET300
	CPI	' '	; IF SPACE (SET TO DEFAULT)
	JZ	SET300
	POP	B
	STC		; OTHERWISE ERROR
	RET
SET300:	MVI	C,56H	; FOR 300 BAUD
STBAUD	PUSH	H
	PUSH	D
	CALL	OSET
	POP	D
	POP	H
	POP	B
	XRA	A	; CLEAR CARRY
	RET
;
OSET:	LHLD	1	; GET BIOS+3 ADDRESS
	MVI	L,3CH	; SPECIAL OSBORN ROUTINE
	PCHL		; BRANCH TO IT
;
;
; --- ROUTINES THAT GET COPIED UP TO TOP OF MEMORY ---
;		JUST UNDER THE BDOS
;
BDJ	JMP	0	; THIS GETS PATCHED TO JUMP TO BDOS ENTRY
;
OSIN	DI		; DISABLE INTERRUPTS
	OUT	0	; SWITCH TO ALTERNATE PAGE
	LDA	MODDATP	; GET DATA BYTE
	OUT	1	; SWITCH BACK PAGES
	EI		; RE-ENABLE INTERRUPTS
	RET
;
OSOUT	DI		; DISABLE INTERRUPTS
	OUT	0	; SWITCH TO ALTERNATE PAGE
	STA	MODDATP	; SEND DATA BYTE
	OUT	1	; SWITCH BACK PAGES
	EI		; RE-ENABLE INTERRUPTS
	RET
;
OSTAT	DI		; DISABLE INTERRUPTS
	OUT	0	; SWITCH TO ALTERNATE PAGE
	LDA	MODCTLP	; GET STATUS BYTE
	OUT	1	; SWITCH BACK PAGES
	EI		; RE-ENABLE INTERRUPTS
	RET
CDLEN	EQU	$-BDJ	; LENGTH OF CODE TO COPY
;
;
	ORG	300H	; START OF PROGRAM
; ----------------------------------------------------
