
;			VDM VIDEO DRIVER
;			BY RODERICK W. HART WA3MEZ
;			SEPT 27 1981

;THESE ROUTINES ALLOW FOR STANDARD VIDEO TERMINAL OPERATIONS.
;THE CHARACTER FOR OUTPUT IS IN THE B REGISTER AND ALL REGIST-
;ERS ARE UNALTERED ON RETURN. ROUTINES WILL WORK WITH SOL AND
;CUTTER SYSTEMS USING THE PROCESSOR TECHNOLOGY VDM-1 VIDEO
;MODULE WITHOUT MODIFICATION. CHECK EQUATES TO ENSURE THAT THE
;BOARD ADDRESS IS CORRECT.
;
;05/05/81  ERASE TO END OF LINE, ERASE LINE, AND ERASE TO END
;          OF SCREEN ADDED TO MAKE FULLY COMPATIBLE WITH UCSD
;          PASCAL EDITORS. BY ROD HART WA3MEZ

;09/27/81  INVERSE VIDEO CAPABILITY ADDED. SEE CONTROL CHARACTER
;          TABLE. BY ROD HART WA3MEZ

;	RAM FOR VDM-1 REGISTERS
;	** RSTART 6 IS USED **

;I HAD TO FIND A SUITABLE BLOCK OF RAM, YOU MAY WISH TO CHANGE
;THIS TO AN ADDRESS ABOVE CP/M.

RAM	EQU	30H	;restart 6
NCHAR	EQU	RAM
LINE	EQU	NCHAR+1
BOT	EQU	LINE+1
SPEED	EQU	BOT+1
INPTR	EQU	SPEED+1
ESCFL	EQU	INPTR+2
CURZ	EQU	ESCFL+1

;	VDM-1 SYSTEM EQUATES
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;MAKE SURE THAT THE FOLLOWING EQUATES ARE PROPER FOR YOUR VIDEO
;BOARD BEFORE ASSEMBLING.

VDMPORT	EQU	0C8H
VDMPAGE	EQU	0ECH
VDMBASE	EQU	0EC00H
NXPAGE	EQU	0F0H
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;	SPECIAL CHARACTERS

DOWN	EQU	1AH	;cursor down (cont-Z)
UP	EQU	17H	;cursor up (cont-W)
LEFT	EQU	01H	;cursor left (cont-A)
RIGHT	EQU	13H	;cursor right (cont-S)
CLEAR	EQU	0BH	;clear screen (cont-K)
HOMES	EQU	0EH	;home cursor (cont-N)
MODE	EQU	00H	;alt-mode (@)
USCORE	EQU	5FH	;backspace (underscore)
BACKS	EQU	08H	;backspace (cont-h)
BLANKS	EQU	20H	;null
SPACE	EQU	20H	;null
EREOL	EQU	02H	;erase to end of line (cont-B)
ERLIN	EQU	05H	;erase line (cont-E)
EREOS	EQU	0FH	;erase to end of screen (cont-O)
CX	EQU	18H	;cont-X
ESC	EQU	1BH	;escape (cont-[)
CR	EQU	0DH	;carriage return (cont-M)
LF	EQU	0AH	;linefeed (cont-J)
NORM	EQU	04H	;normal video (cont-D)
INVERT	EQU	06H	;inverted video (cont-F)

	ORG	0FD00H

VDM:	MOV	B,C
	PUSH	H
	PUSH	D
	PUSH	B

;	PROCESS ESC SEQUENCE IF ANY

	LDA	ESCFL
	ORA	A
	JNZ	ESCS

	MOV	A,B
	ANI	7FH
	MOV	B,A
	JZ	GOBK

	LXI	H,TBL
	CALL	TSRCH

GOBACK:	CALL	VDADD
	MOV	A,M
	ORI	80H
	MOV	M,A
	LHLD	SPEED-1
	INR	L
	XRA	A
TIMER:	DCX	H
	CMP	H
	JNZ	TIMER
GOBK:	POP	B
	POP	D
	POP	H
	RET

NEXT:	INX	H
	INX	H

;THIS ROUTINE SEARCHES FOR A MATCH OF THE CHAR IN THE B REG TO
;THE CHAR IN THE TBL POINTED TO BY HL.

TSRCH:	MOV	A,M
	ORA	A
	JZ	CHAR
	CMP	B
	INX	H
	JNZ	NEXT
	PUSH	H
	CALL	CREM
	XTHL
	JMP	DISPT

CHAR:	MOV	A,B
	CPI	7FH
	RZ


OCHAR:	CALL	VDADD

;	MAKE VIDEO INVERSE IF NECESSARY

	PUSH	PSW
	LDA	CURZ
	ORA	B
	MOV	B,A
	POP	PSW

	MOV	M,B
	LDA	NCHAR
	CPI	63
	JC	OK
	LDA	LINE
	CPI	15
	JNZ	OK

;	END OF SCREEN....ROLL UP ONE LINE

SCROLL:	XRA	A
	STA	NCHAR
SROL:	MOV	C,A
	CALL	VDAD
	XRA	A
	CALL	CLIN1
	LDA	BOT
	INR	A
	ANI	0FH
	JMP	ERAS3

;	INCREMENT LINE COUNTER IF NECESSARY

OK:	LDA	NCHAR
	INR	A
	ANI	3FH
	STA	NCHAR
	RNZ
PDOWN:	LDA	LINE
	INR	A
CURSC:	ANI	0FH
CUR:	STA	LINE
	RET

;	RESET INVERSE VIDEO FLAG

INVOF:	MVI	A,0
	STA	CURZ
	RET

;	SET INVERSE VIDEO FLAG

INVON:	MVI	A,80H
	STA	CURZ
	RET

;	ERASE SCREEN

PERSE:	LXI	H,VDMBASE
	MVI	M,80H+' '

	INX	H
ERAS1:	MVI	M,' '
	INX	H
	MOV	A,H
	CPI	NXPAGE
	JC	ERAS1
	STC
PHOME:	MVI	A,0
	STA	LINE
	STA	NCHAR
	RNC


ERAS3:	OUT	VDMPORT
	STA	BOT
	RET

;	ERASE TO END OF LINE

CLREOL:	CALL	CLINE
	RET

;	ERASE LINE

CLRLNE:	CALL	PLEFT
	JNZ	CLRLNE
	CALL	CLREOL
	RET

;	ERASE TO END OF SCREEN

CLREOS:	LDA	NCHAR
	PUSH	PSW
	LDA	LINE
	PUSH	PSW
CREOS1:	MVI	M,' '
	INX	H
	MOV	A,H
	CPI	NXPAGE
	JC	CREOS1
	POP	PSW
	STA	LINE
	POP	PSW
	STA	NCHAR
	RET


CLINE:	CALL	VDADD
	LDA	NCHAR
CLIN1:	CPI	64
	RNC
	MVI	M,' '
	INX	H
	INR	A
	JMP	CLIN1

;	ROUTINE TO MOVE THE CURSOR UP ONE LINE

PUP:	LDA	LINE
	DCR	A
	JMP	CURSC

;	MOVE CURSOR LEFT ONE POSITION

PLEFT:	LDA	NCHAR
	DCR	A
PCUR:	ANI	03FH
	STA	NCHAR
	RET

;	CURSOR RIGHT ONE POSITION

PRIT:	LDA	NCHAR
	INR	A
	JMP	PCUR

;	ROUTINE TO CALCULATE SCREEN ADDRESS

;	ENTRY AT:	RETURNS:

;	VDADD		CURRENT SCREEN ADDRESS
;	VDAD2		ADDRESS OF CURRENT LINE, CHAR <C>
;	VDAD		LINE <A>, CHARACTER POSITION <C>

VDADD:	LDA	NCHAR
	MOV	C,A
VDAD2:	LDA	LINE
VDAD:	MOV	L,A
	LDA	BOT
	ADD	L
	RRC
	RRC
	MOV	L,A
	ANI	3
	ADI	VDMPAGE
	MOV	H,A
	MOV	A,L
	ANI	0C0H
	ADD	C
	MOV	L,A
	RET

;	ROUTINE TO REMOVE CURSOR

CREM:	CALL	VDADD
	MOV	A,M
	ANI	7FH
	MOV	M,A
	RET

;	ROUTINE TO BACKSPACE

PBACK:	CALL	PLEFT
	CALL	VDADD
	MVI	M,' '
	RET

;	ROUTINE TO PROCESS A CARRIAGE RETURN

PCR:	CALL	CLINE
	JMP	PCUR

;	ROUTINE TO PROCESS LINEFEEDS

PLF:	LDA	LINE
	INR	A
	ANI	15
	JNZ	CUR

	JMP	SROL

;	SET ESCAPE PROCESS FLAG

PESC:	MVI	A,-1
	STA	ESCFL
	RET

;	PROCESS ESSCAPE SEQUENCE

ESCS:	CALL	CREM
	CALL	ESCSP
	JMP	GOBACK

ESCSP:	LDA	ESCFL
	CPI	-1
	JZ	SECOND

;	PROCESS THIRD CHAR OF ESC SEQUENCE

	LXI	H,ESCFL
	MVI	M,0
	CPI	2
	JC	SETX
	JZ	SETY
	CPI	8
	JZ	STSPD
	CPI	9
	JC	OCHAR
	RNZ

;	TAB ABSOLUTE TO VALUE IN REG B

SETX:	MOV	A,B
	JMP	PCUR

;	SET CURSOR TO LINE B

SETY:	MOV	A,B
	JMP	CURSC

;	PROCESS SECOND CHR OF ESC SEQUENCE

SECOND:	MOV	A,B
	CPI	3
	JZ	CURET
	CPI	4
	JNZ	ARET2

ARET:	MOV	B,H
	MOV	C,L
ARET1:	POP	H
	POP	D
	PUSH	B
	PUSH	H
	XRA	A
ARET2:	STA	ESCFL
	RET

;	RETURN PRESENT SCREEN PARAMETERS IN BC

CURET:	LXI	H,NCHAR
	MOV	B,M
	INX	H
	MOV	C,M
	JMP	ARET1

; THIS ROUTINE DISPATCHES TO THE ADDRESS AT CONTENTS
; OF HL. HL ARE RESTORED PRIOR TO GOING TO ROUTINE.

DISPT:	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
DISP1:	XTHL
	MOV	A,L
	RET

STSPD:	MOV	A,B
DISPD:	STA	SPEED
	RET

;	DISPLAY DRIVER COMMAND TABLE

; THIS TABLE DEFINES THE CHARACTERS FOR SPECIAL PROCESSING
; IF THE CHARACTER IS NOT IN THE TABLE IT GOES TO SCREEN.

TBL:	DB	CLEAR
	DW	PERSE
	DB	UP
	DW	PUP
	DB	DOWN
	DW	PDOWN
	DB	LEFT
	DW	PLEFT
	DB	RIGHT
	DW	PRIT
	DB	HOMES
	DW	PHOME
	DB	CR
	DW	PCR
	DB	LF
	DW	PLF
	DB	USCORE
	DW	PBACK
	DB	BACKS
	DW	PBACK
	DB	ESC
	DW	PESC
	DB	EREOL
	DW	CLREOL
	DB	ERLIN
	DW	CLRLNE
	DB	EREOS
	DW	CLREOS
	DB	NORM
	DW	INVOF
	DB	INVERT
	DW	INVON
	DB	0

	END

