;  --- PATCH TO CP/M 2.X TO LIST USER # IN DRIVE PROMPT ---
;	    ( VALID FOR CP/M 2.0, 2.1, AND 2.2)
;		BY BRUCE KENDALL (TKI)
;		      7/12/80
;		TIGHTENED UP BY BRUCE RATOFF
;		     11/17/80
;
;	IF YOU HAVE TRIED PLAYING WITH THE  'USER' COMMAND
;	IN CP/M 2.X, YOU MAY HAVE BECOME ANNOYED THAT THERE
;	WAS NO WAY OF TELLING WHAT USER AREA YOU WERE IN.  THIS
;	PATCH SOLVES THIS PROBLEM BY DISPLAYING THE USER NUMBER
;	IN HEX ( A SINGLE CHARACTER SINCE USER # : 0-15 ARE VALID)
;	BETWEEN THE DRIVE NAME LETTER AND THE '>'. THAT IS, A USER
;	LOGGED INTO USER AREA #4 WOULD SEE THE STANDARD CP/M 
;	PROMPT (MODIFIED BY THIS PATCH) AS:
;		A4>       ( INSTEAD OF JUST A>)
;
;
MSIZE	EQU	64	; CP/M SYSTEM SIZE IN KB
;
DELTA	EQU	000H	; OFFSET FROM STD CP/M SIZE
			; THIS WOULD BE SET TO 400H IF
			; THE 20K CP/M WAS ACTUALLY A 19K
			; CP/M (WHEN COMPARED TO THE STD
			; 20K CP/M DESCRIBED IN THE CP/M
			; MANUALS FROM DIGITAL RESEARCH).
;
BIAS	EQU	(MSIZE-20)*1024-DELTA ; OFFSET FROM 20K CP/M
CCP	EQU	3400H+BIAS
;
OFFSET	EQU	980H-CCP ; OFFSET USED WITH  DDT IN 
			; SYSTEM CONFIGURATION (ASSUMES
			; THAT 'CCP' OCCURES AT 980H IN THE
			; SYSGEN MEMORY IMAGE).
;
COUT	EQU	CCP+8CH ; CCP CONSOLE OUTPUT ROUTINE
GTUSR	EQU	CCP+113H ; CCP GET USER # ROUTINE
;
;
	ORG	CCP+38DH
;
	CALL	PATCH	; THIS WAS A   CALL  COUT
;
;
; -----------------------------------------------
; NOTE THE CODE IN THE NEIGHBORHOOD OF THIS PATCH WAS
; USED TO PRINT OUT THE 'A>' PROMPT:
;
; CCP+382H:
;	LXI SP,----
;	CALL	FLUSH	; RESET BUFFERS
;	CALL	GTDRV	; GET DRIVE #
;	ADI	'A'	; ADD IN ASCII BIAS
;	CALL	COUT	; <--- MAKE PATCH HERE
;	MVI	A,'>'	; GET '>'
;	CALL	COUT	; PRINT IT OUT
;	CALL	GTCOMD	; GET CONSOLE COMMAND
;	  .
;	  .
;	  .
; -------------------------------------------------
;
;
	ORG	CCP+15F0H	; PATCH AREA AT END OF BDOS
;
PATCH:	CALL	COUT	; OUTPUT CHAR. IN ACC TO CONSOLE
	CALL	GTUSR	; GET USER #
	ADI	90H	; USE INTEL HEX/ASCII TRICK
	DAA
	ACI	40H
	DAA
	JMP	COUT	; PRINT OUT AND RETURN
;
; ------------------------------------------------------
; NOTE: THE 'GTUSR' COMMAND IS JUST A SHORT ROUTINE:
;
;GTUSR:	MVI	E,0FFH
;	MVI	C,32
;	JMP	05
; ------------------------------------------------------
;
	END
