;CONTRIBUTED TO CP/M USERS' GROUP BY:
;
;               MEMORY MERCHANTS
;               1350 BUFFALO ROAD
;               ROCHESTER NY 14624
;	chg 10/8/81 to 8080 mnemonics (WDE)
;	SYNTAX:
;	PUT filname.typ HHHH G
;	where HHHH is load address wanted (4 hex chars)
;	G is execute after load (optional)
;	returns to cmd. level if not execute
;
	ORG	100H
;
TBUFF	EQU	080H
TFCB	EQU	05CH
BDOS	EQU	  5H
CPM	EQU	  0H
;
BEGIN:	LXI	H,0
	SHLD	LOADAD	;CLEAR FOR DEFAULT
	DAD	SP
	SHLD	OSTACK
	LXI	SP,STACK
	XRA	A
	STA	EXEC	;NO EXECUTE DEFAULT
	STA	HEXAAD	;DEFAULT ADDRESS
	LXI	H,TBUFF+2 ;FILE NAME START
	LXI	D,FILENM ;DESTINATION
FNLOOP:	MOV	A,M
	STAX	D	;MOVE FILE NAME TO SAVE AREA
	CPI	" "
	JZ	HEXAD	;NAME DONE
	INX	H
	INX	D
	JMP	FNLOOP	;FILE NAME LOOPING
;
HEXAD:	LXI	D,HEXAAD+1
	INX	H	;SKIP SPACE
HXLOOP:	MOV	A,M
	STAX	D	;MOVE FIELD 2 TO DEST
	CPI	" "
	JZ	GO	;FIELD 2 DONE
	PUSH	H
	LXI	H,HEXAAD+5
	MOV	A,D
	CMP	H
	JNZ	GOXON
	MOV	A,E
	CMP	L
	JNZ	GOXON
	POP	H
	JMP	GO	;ADDRESS BUFFER FULL, STOP
;
GOXON:
	POP	H
	INX	H
	INX	D
	JMP	HXLOOP
;
GO:	INX	H
	MOV	A,M
	CPI	"G"	;FIELD 3 = G TO EXECUTE
	JNZ	NOGO
	MVI	A,0FFH
	STA	EXEC	;SET EXEC FLAG
NOGO:	LXI	H,HEXAAD+2
;
CCLOOP:	MOV	A,M	;SCAN FOR FIELD END
	CPI	" "
	JZ	HEX	;FOUND END OF FIELD
	INX	H
	JMP	CCLOOP	;LOOP THRU FIELD
;
HEXDIG:	SUI	30H	;ASCII TO BINARY
	JC	HEXERR
	CPI	0AH
	JNC	ALPHA
	RET
;
ALPHA:	SUI	07H
	CPI	10H
	JNC	HEXERR
	RET
;
HEX:	DCX	H	;BACKUP TO LAST CHAR
	MOV	A,M
	CALL	HEXDIG	;CONVERT HEX CHAR
	STA	LOADAD	;SAVE RESULT
	DCX	H
	MOV	A,M	;PREV CHAR
	ORA	A
	JZ	OPEN
	CALL	HEXDIG
	RLC
	RLC
	RLC
	RLC		;LEFT NYBBLE
	MOV	B,A
	LDA	LOADAD
	ADD	B
	STA	LOADAD	;LSB BYTE
	DCX	H
	MOV	A,M	;PREV CHAR
	ORA	A
	JZ	OPEN
	CALL	HEXDIG
	STA	LOADAD+1 ;HI BYTE
	DCX	H
	MOV	A,M	;PREV CHAR
	ORA	A
	JZ	OPEN
	CALL	HEXDIG
	RLC
	RLC
	RLC
	RLC		;LEFT NYBBLE
	MOV	B,A
	LDA	LOADAD+1
	ADD	B
	STA	LOADAD+1 ;HI BYTE
;
OPEN:	MVI	C,15
	LXI	D,TFCB
	CALL	BDOS	;OPEN FILE
	CPI	0FFH
	JZ	FINDERR	;CAN'T FIND IT
	LHLD	LOADAD	;DESTINATION
	SHLD	LOAD
	XCHG
	CALL	SETDMA	;DESTINATION ADDRESS INIT
;
FLREAD:	MVI	C,20
	LXI	D,TFCB
	CALL	BDOS	;READ A SECTOR
	ORA	A
	JNZ	ENDFILE	;DONE READING
	LHLD	LOAD
	LXI	D,0080H
	DAD	D	;INCREMENT READ POINTER
	SHLD	LOAD
	XCHG
	CALL	SETDMA
	JMP	FLREAD
;
SETDMA:	MVI	C,26
	CALL	BDOS
	RET
;
ENDFILE:
	MVI	C,16
	LXI	D,TFCB
	CALL	BDOS	;CLOSE FILE FOR NEATNESS
	LDA	EXEC
	ORA	A
	JZ	DUN	;WARM BOOT
	LHLD	LOADAD
	PCHL		;EXECUTE FILE
;
HEXERR:	MVI	C,9
	LXI	D,HEXMSG
ERXIT:	CALL	BDOS	;MESSAGE TO CONSOLE
DUN:	LHLD	OSTACK
	SPHL		;RESTORE STACK
	JMP	CPM	;TO COMMAND LEVEL
;
HEXMSG:	DB	'ERROR IN HEX ADDRESS  $'
;
FINDERR:
	MVI	C,9
	LXI	D,FILMSG
	JMP	ERXIT
;
FILMSG:	DB	'OPEN ERROR ***** CAN NOT FIND FILE  $'
;
OSTACK:	DS	2	;STACK SAVE SPACE
EXEC:	DS	1	;EXECUTE FLAG
HEXAAD:	DS	6	;HEX BUFFER
FILENM:	DS	13	;NAME NOT USED
LOADAD:	DS	2	;ADDRESS ACCUMULATOR
LOAD:	DS	2	;READ POINTER
	DS	18	;STACK SPACE
STACK:	DS	1
;
	END
