; MXO-PDA10.ASM
;
REV	EQU	10		;overlay revision level
;
; MEX Apple PDA written 23 Aug 85 by W.F.McGee
; based on MXOAJC10.ASM 05/18/84 by D. W. Walker
; and M7-APPDA.ASM by Bill Harnell 02/04/84
; and MXO-PM10.ASM written 04/27/84 by Ron Fowler
;
;
; This is a MEX overlay file for the Apple ][, ][+, or //e
; with a Microsoft Softcard or equivalent CP/M card,
; driving an external modem through the PDA RS232.
; This version also omits provision for changing the data word
; length or parity.  That feature may be added in future
; revisions.  Meanwhile, the format may be hand-coded in the
; modem initialization routines. The default here is 8 data bits,
; 1 stop bit, no parity.
;
;
; NOTE: Most of the comments from Ron Fowler's MXO-PM10.ASM
; have been omitted here to save space.  A copy of that file
; will be very helpful in understanding what's going on here. 
;
;------------------------------------------------------------
;
; Misc equates
;
NO	EQU	0
YES	EQU	0FFH
TPA	EQU	100H
CR	EQU	13
LF	EQU	10
BELL	EQU	7
TAB	EQU	9
ESC	EQU	27
;
; 
; SSC port definitions
;
SLOT	EQU	20H		;slot (for SSC) * 10H 
BASEP	EQU	0E088H+SLOT	;SSC base port
MODDATP	EQU	BASEP		;modem data port
MODCTL1	EQU	MODDATP+5		;modem control port
;
; PDA bit definitions
;
MDRCVB	EQU	00000001B	;modem receive bit (DAV)
MDRCVR	EQU	00000001B	;modem receive ready
MDSNDB	EQU	00100000B	;modem send bit
MDSNDR	EQU	00100000B	;modem send ready bit
;
;
;
;
; MEX service processor stuff ... See MXO-PM10.ASM
;
MEX	EQU	0D00H		;address of the service processor
INMDM	EQU	255		;get char from port to A, CY=no more in 100 ms
TIMER	EQU	254		;delay 100ms * reg B
TMDINP	EQU	253		;B=# secs to wait for char, cy=no char
CHEKCC	EQU	252		;check for ^C from KBD, Z=present
SNDRDY	EQU	251		;test for modem-send ready
RCVRDY	EQU	250		;test for modem-receive ready
SNDCHR	EQU	249		;send a character to the modem (after sndrdy)
RCVCHR	EQU	248		;recv a char from modem (after rcvrdy)
LOOKUP	EQU	247		;table search: see CMDTBL comments for info
PARSFN	EQU	246		;parse filename from input stream
BDPARS	EQU	245		;parse baud-rate from input stream
SBLANK	EQU	244		;scan input stream to next non-blank
EVALA	EQU	243		;evaluate numeric from input stream
LKAHED	EQU	242		;get nxt char w/o removing from input
GNC	EQU	241		;get char from input, cy=1 if none
ILP	EQU	240		;inline print
DECOUT	EQU	239		;decimal output
PRBAUD	EQU	238		;print baud rate
;
;
CONOUT	EQU	2		;simulated BDOS function 2: console char out
PRINT	EQU	9		;simulated BDOS function 9: print string
INBUF	EQU	10		;input buffer, same structure as BDOS 10
;
	ORG	TPA		;we begin
;
;
	DS	3		;MEX has a JMP START here
;
; The following variables are located at the beginning of the program
; to facilitate modification without the need of re-assembly. They will
; be moved in MEX 2.0.
;
PMODEM:	DB	NO		;yes=PMMI modem \ / These 2 locations are not
SMODEM:	DB	NO		;yes=Smartmodem / \ referenced by MEX
TPULSE:	DB	'T'		;T=touch, P=pulse (not referenced by MEX)
CLOCK:	DB	20		;clock speed x .1, up to 25.5 mhz.
MSPEED:	DB	5		;sets display time for sending a file
				;0=110	1=300  2=450  3=600  4=710
				;5=1200 6=2400 7=4800 8=9600 9=19200
BYTDLY:	DB	5		;default time to send character in
				;terminal mode file transfer (0-9)
				;0=0 delay, 1=10 ms, 5=50 ms, 9=90 ms
CRDLY:	DB	3		;end-of-line delay after CRLF in terminal
				;mode file transfer for slow BBS systems
				;0=0 delay, 1=100 ms, 5=500 ms, 9=900 ms
COLUMS:	DB	5		;number of directory columns
SETFL:	DB	YES		;yes=user-defined SET command
SCRTST:	DB	YES		;yes=if home cursor and clear screen
				;routine at CLRSCRN
	DB	0		;was once ACKNAK, now spare
BAKFLG:	DB	NO		;yes=make .BAK file
CRCDFL:	DB	YES		;yes=default to CRC checking
				;no=default to Checksum checking
TOGCRC:	DB	YES		;yes=allow toggling of Checksum to CRC
CVTBS:	DB	NO		;yes=convert backspace to rub
TOGLBK:	DB	YES		;yes=allow toggling of bksp to rub
ADDLF:	DB	NO		;no=no LF after CR to send file in
				;terminal mode (added by remote echo)
TOGLF:	DB	YES		;yes=allow toggling of LF after CR
TRNLOG:	DB	NO		;yes=allow transmission of logon
				;write logon sequence at location LOGON
SAVCCP:	DB	YES		;yes=do not overwrite CCP
LOCNXT:	DB	NO		;yes=local cmd if EXTCHR precedes
				;no=not local cmd if EXTCHR precedes
TOGLOC:	DB	YES		;yes=allow toggling of LOCNXTCHR
LSTTST:	DB	YES		;yes=allow toggling of printer on/off
				;in terminal mode. Set to no if using
				;the printer port for the modem
XOFTST:	DB	NO		;yes=allow testing of XOFF from remote
				;while sending a file in terminal mode
XONWT:	DB	NO		;yes=wait for XON after sending CR while
				;transmitting a file in terminal mode	
TOGXOF:	DB	YES		;yes=allow toggling of XOFF testing
IGNCTL:	DB	YES		;yes=do not send control characters
				;above CTL-M to CRT in terminal mode
				;no=send any incoming CTL-char to CRT
EXTRA1:	DB	0		;for future expansion
EXTRA2:	DB	0		;for future expansion
BRKCHR:	DB	'@'-40H		;^@ = Send a 300 ms. break tone
NOCONN:	DB	'N'-40H		;^N = Disconnect from phone line
LOGCHR:	DB	'L'-40H		;^L = Send logon
LSTCHR:	DB	'P'-40H		;^P = Toggle printer
UNSVCH:	DB	'R'-40H		;^R = Close input text buffer
TRNCHR:	DB	'T'-40H		;^T = Transmit file to remote
SAVCHR:	DB	'Y'-40H		;^Y = Open input text buffer
EXTCHR:	DB	'^'-40H		;^^ = Send next character
;
	DS	2
;
INCTL1:	LDA	MODCTL1		;in modem status port
	RET
	DB	0,0,0,0,0,0	;spares if needed for non-PMMI
;
OTDATA:	STA	MODDATP		;out modem data port
	RET
	DB	0,0,0,0,0,0	;spares if needed for non=PMMI
;
INPORT:	LDA	MODDATP		;in modem data port
	RET
	DB	0,0,0,0,0,0	;spares if needed for non-PMMI
;
MASKR:	ANI MDRCVB ! RET	;bit to test for receive ready
TESTR:	CPI MDRCVR ! RET	;value of receive bit when ready
MASKS:	ANI MDSNDB ! RET	;bit to test for send ready
TESTS:	CPI MDSNDR ! RET	;value of send bit when ready
;
;
	DS	12
;
;
LOGON:	DS	2		;needed for MDM compat, not ref'd by MEX
DIALV:	JMP	PDIAL		;dial digit in A (see info at PDIAL)
DISCV:	JMP	GOODBYE
GOODBV:	JMP	GOODBYE
INMODV:	JMP	NITMOD		;initialization. Called at cold-start
NEWBDV:	JMP	PBAUD		;set baud rate
NOPARV:	DS	3		;set modem for no-parity
PARITV:	DS	3		;set modem parity
SETUPV:	JMP	SETCMD		;SET cmd: jump to a RET if you don't write SET
SPMENV:	DS	3		;not used with MEX
VERSNV:	JMP	SYSVER		;Overlay's voice in the sign-on message
BREAKV:	JMP	PBREAK		;send a break
;
;
ILPRTV:	DS	3		;replace with MEX function 9
INBUFV:	DS	3		;replace with MEX function 10
ILCMPV:	DS	3		;replace with table lookup funct. 247
INMDMV:	DS	3		;replace with MEX function 255
NXSCRV:	DS	3		;not supported by MEX (returns w/no action)
TIMERV:	DS	3		;replace with MEX function 254
;
CLREOS:	LXI	D,EOSMSG
	MVI	C,PRINT
	CALL	MEX
	RET
;
CLS:	LXI	D,CLSMSG
	MVI	C,PRINT
	CALL	MEX
	RET
;
;------------------------------------------------------------
;
;	*** END OF FIXED FORMAT AREA ***
;
;------------------------------------------------------------
;
; Modem initialization.  
;
NITMOD:	
ITMOD:	DI			;disable interrupts
	XRA	A
	STA	MODDATP+1
	MVI	A,80H
	STA	MODDATP+3	;line control register
	STA	MODDATP+3	;
SPSPD	MVI	A,60H
	STA	MODDATP		;set for 1200 baud
MSPSPD:	MVI	A,00H
	STA	MODDATP+1
	MVI	A,03H		;8-bit, 1 stop, no parity
	STA	MODDATP+3	;line control register
	MVI	A,01H		
	STA	MODDATP+4	;set DTR
	EI
	RET
;
; PDA send-break routine
;
PBREAK:	MVI	A,40H		;send BREAK
	STA	MODDATP+3
	JMP	GOODBYE1
GOODBYE:
	XRA	A
	STA	MODDATP+4	;set DTR and RTS low
	MVI	A,40H		;send break
	STA	MODDATP+3
GOODBYE1:
	LXI	B,300H		;wait 300 msec
	MVI	C,TIMER
	CALL	MEX
	MVI	A,03H		;reset for 8 bits etc
	STA	MODDATP+3
	MVI	A,01H		;set DTR high
	STA	MODDATP+4
	RET
;
; exit routine
;
DUMMY:	RET			;we don't need one
;
PDIAL:	RET
;------------------------------------------------------------
;
;
; Sign-on message
;
SYSVER:	LXI	D,SOMESG
	MVI	C,PRINT
	CALL	MEX
CARRSH:	LXI	D,NOMESG		;tell about carrier
	CALL	CARRCK			;check for it
	MVI	C,PRINT
	CNZ	MEX			;print the "NO" if no carrier
	LXI	D,CARMSG		;print "carrier present"
	MVI	C,PRINT
	CALL	MEX
	RET
;
PBAUD:	PUSH	H			;used in CALL and SET BAUD
	PUSH	D			;enters with A=decoded MSPEED value
	PUSH	B
	MOV	E,A			;SAVE IT
	MVI	D,0
	LXI	H,OFFTABL		
	DAD	D
	MOV	A,M
	ORA	A			;check to see whether supported
	JZ	PBEXIT
	MOV	A,E			;yes, update MBAUD
	STA	MSPEED
	MOV	A,M
	MOV	E,A
	LXI	H,BTABLE		;get word to write
	DAD	D
	MOV	A,M
	STA	SPSPD+1
	INX	H
	MOV	A,M
	STA	MSPSPD+1
	CALL	NITMOD			;and intialize the modem
	STC
	CMC				;clear carry
	JMP	PBEXIT+1
PBEXIT:	STC				;set carry
	POP	B
	POP	D
	POP	H
	RET
OFFTABL:
	DB	0,2,4,6,0,10,12,14,16,18
BTABLE:
B110:	DW	0417H	;from p 27 of manual
B300: 	DW	0180H
B450:	DW	0100H
B600:	DW	00C0H
B710:	DW	0000H	;dont support 710 b/s
B1200:	DW	0060H
B2400:	DW	0030H
B4800:	DW	0018H
B9600:	DW	000CH
B19200:	DW	0006H


SOMESG:	DB	'Apple PDA RS232 V. '
	DB	REV/10+'0'
	DB	'.'
	DB	REV MOD 10+'0'
	DB	': $'
;
NOMESG:	DB	'no $'
CARMSG:	DB	'carrier present',CR,LF,'$'
;
;
; check the PDA for carrier-present (NZ=no)
;
CARRCK:	LDA	MODDATP+6	;called RSLD in UART documentation
	XRI	0FFH
	ANI	80H
	ORA	A
	RET
;
; Newline on console
;
CRLF:	MVI	A,CR
	CALL	TYPE
	MVI	A,LF		;fall into TYPE
;
; type char in A on console
;
TYPE:	PUSH	H		;save 'em
	PUSH	D
	PUSH	B
	MOV	E,A		;align output character
	MVI	C,CONOUT	;print via MEX
	CALL	MEX
	POP	B
	POP	D
	POP	H
	RET
;
; strings to clear-to-end-of-screen, and clear-screen
;
EOSMSG:	DB	ESC,'Y$'		;clear to end-of-screen
CLSMSG:	DB	ESC,'*$'		;clear whole screen
;
;------------------------------------------------------------
;
;
;
; The remainder of this overlay implements a very versatile
; SET command -- if you prefer not to write a SET for your
; modem, you may delete the code from here to the END statement.
;
;
; Control is passed here after MEX parses a SET command.
;
SETCMD:

	CALL 	CARRCK		;first check for carrier
	JZ	CARRON		;if carrier, jmp to on msg and print
	MVI	C,SBLANK	;any arguments?
	CALL	MEX
	JC	SETSHO		;if not, go print out values
	LXI	D,CMDTBL	;parse command
	CALL	TSRCH		;from table
	PUSH	H		;any address on stack
	RNC			;if we have one, execute it
	POP	H		;nope, fix stack
SETERR:	LXI	D,SETEMS	;print error
	MVI	C,PRINT
	CALL	MEX
	RET
;
CARRON:	LXI	D,CONMSG	;print carrier on msg
	MVI	C,PRINT
	CALL	MEX
	RET
;
CONMSG:	DB	CR,LF,'Carrier on...can not set',CR,LF,'$'
SETEMS:	DB	CR,LF,'SET command error',CR,LF,'$'
;
; SET command table ... note that tables are constructed of command-
; name (terminated by high bit=1) followed by word-data-value returned
; in HL by MEX service processor LOOKUP.  Table must be terminated by
; a binary zero.
;
; Note that LOOKUP attempts to find the next item in the input stream
; in the table passed to it in HL ... if found, the table data item is
; returned in HL; if not found, LOOKUP returns carry set.
;
CMDTBL:	DB	'?'+80H			;"set ?"
	DW	STHELP
	DB	'BAU','D'+80H		;"set baud"
	DW	STBAUD
;
	DB	0		;<<=== table terminator
;
; SET <no-args>: print current statistics
;
SETSHO:	LXI	H,SHOTBL	;get table of SHOW subroutines
SETSLP:	MOV	E,M		;get table address
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D		;end of table?
	ORA	E
	RZ			;exit if so
	PUSH	H		;save table pointer
	XCHG			;adrs to HL
	CALL	GOHL		;do it
	CALL	CRLF		;print newline
	MVI	C,CHEKCC	;check for console abort
	CALL	MEX
	POP	H		;it's done
	JNZ	SETSLP		;continue if no abort
	RET
;
GOHL:	PCHL
;
; table of SHOW subroutines
;
SHOTBL:	DW	CARRSH
	DW	BDSHOW
	DW	0		;<<== table terminator
;
; SET ?  processor
;
STHELP:	CALL 	CLS			;clear screen
	LXI	D,HLPMSG
	MVI	C,PRINT
	CALL	MEX
	RET
;
; The help message
;
HLPMSG:	DB	CR,LF,'SET Commands, PDA version:',CR,LF
	DB	CR,LF,'SET BAUD 300 , 600, 1200, 2400'
	DB	CR,LF,'        4800 , 9600,19200 b/s '
	DB	CR,LF,LF,'$'
;
; SET BAUD processor
;
STBAUD:	MVI	C,BDPARS	;function code
	CALL	MEX	
	JC	SETERR		;invalid code
	CALL	PBAUD		;try to set it
	JC	SETERR		;unsupported code
BDSHOW:	CALL	ILPRT		;display baud
	DB	'Baud rate:',TAB,' ',0
	LDA	MSPEED
	MVI	C,PRBAUD	;use MEX routine
	CALL	MEX
	RET

;
TSRCH:	MVI	C,LOOKUP	;get function code
	JMP	MEX		;pass to MEX processor
;
; Print in-line message ... blows away C register
;
ILPRT:	MVI	C,ILP		;get function code
	JMP	MEX		;go do it
	
	END


	