{*****************************************************************************}
{                              Martin Stanley                                 }
{                           305 St George Street                              }
{                         Toronto, Ontario M5R-2R2                            }
{                               416 961-4778                                  }
{                                                                             }
{                                                                             }
{                 An implementation of matrix multiplication                  }
{                 using the linked list array representation.                 }
{                                                                             }
{           Please report any interseting changes or bugs, etc.               }
{                                                                             }
{*****************************************************************************}
{                                                                             }
{            Copyright 1982 by Martin Stanley all rights reserved.            }
{                                                                             }
{Thi softwar i place i th publi domai fo publi use I i NOԠ t }
{b use i an wa fo financia (monetar o otherwise gai o profi }
{withou m expres writte permission Failur t obtai permissio i a }
{infringement of copyright.                                                  }
{                                                                             }
{*****************************************************************************}

                   {NOTE: array dimensions start on index 1}


program matrix2;

const
    m = 4;                      {A's row size, C's row size}
    n = 3;                      {B's row size, A's column size}
    p = 2;                      {B's column size, C's column size}
    tab = ' ';                  {spacing for graphic representation}
    width = 2;                  {print width of largest array dimension}
    testRuns = 20;              {# of runs of problem to obtain average time}
    outputFlag = true;          {true if graphic representation is desired}

type
    cellValue = integer;        {array contents}
    index = integer;            {index to row and col #}

    matrixCellPtr = ^ matrixCell;       {the pointer to any array entry}
                         
    matrixCell =                {the array entry}
        record           
            value: cellValue;           {the contents}
            rowNo: index;
            colNo: index;       
            nextInCol: matrixCellPtr;   {pointer to next in col}
            nextOnRow: matrixCellPtr    {pointer to next on row}
        end;    

    mDirectory = array[1..m] of matrixCellPtr;  {row and column directories}
    nDirectory = array[1..n] of matrixCellPtr;
    pDirectory = array[1..p] of matrixCellPtr;

var
    dataA, dataB: text; {input files for elements of A and B} 

    i: 1..m;                    {iteration variables}
    j: 1..p;
    k: 1..n;

    sum: cellValue;     {holds the partial and fianl result of each mult.}
    newCell: matrixCellPtr;     {name for the newly allocated element}

    rowDirA, rowDirC: mDirectory;       {the row and column directories}
    colDirA, rowDirB: nDirectory;
    colDirB, colDirC: pDirectory;

    curCellA, curCellB, curCellC: matrixCellPtr; {to keep track of position}
    curCol: integer;               {used to keep track of position for output}

    loopCost: integer;          {overhead of empty loop}
    time: integer;              {hold time variables}
    time2: integer;

    test: 1..testRuns;          {counter for test loop}



    function clock:integer;             { you will have to make a function to}
                                        { read your clock. If you don't have a}
    begin                               { system clock, you will have to count}
       clock := 0                       { the basic units. This is probably }
    end;                                { more accurate anyway. }



    procedure initializeA;

    var
        curRow: integer;        {used to keep track of which column}
        colPtr: matrixCellPtr;  {position holder for column directory}
        curCell: matrixCellPtr; {current entry}
        row, col: index;
        val: cellValue;         {value field of an entry}
        numElements: integer;   {used to count the number of non-zero elements}

    begin
        reset('testdata.1b', dataA);       {prepare for input}

        curCell := nil;         {initialize}
        curRow := 0;
        numElements := 0;

        if not eof(dataA) then begin        {check if empty}
            writeln('Initializing A');
        end else begin 
                 writeln('testdata.1b is empty. Cannot proceed.')
        end;

        while not eof(dataA) do begin       {read data}
            readln( dataA, row, col, val);
            numElements := numElements + 1;
    
                         {create and link from row}

            if curRow <> row then begin         {row has changed or 1st row}
                new(newCell);                   {make new element}
                rowDirA[row] := newCell;        {set row directory to point 
                                                  to the new element}
                curCell := rowDirA[row];        {adjust 'current' pointers}
                curRow := row
            end else begin                      {same row}
                new(newCell);
                curCell^.nextOnRow := newCell;  {link to new element}
                curCell := curCell^.nextOnRow   {move to it}
            end;
            
                         {link through column}

            if colDirA[col] = nil then begin    {no entries in this column yet}
                colDirA[col] := curCell;        {set column directory to point 
                                                       to the new element}
                colPtr := curCell               {adjust 'current' pointers}
            end else begin                {there are entries here already}
                colPtr := colDirA[col];   {set pointer to begining of column}
                while (colPtr^.nextInCol  <> nil) do    {move to end of column}
                    colPtr := colPtr^.nextInCol;
                colPtr^.nextInCol := curCell    {and link new element}
            end;

                         {initialize this entry}

            curCell^.rowNo := row;
            curCell^.colNo := col;
            curCell^.value := val
        end;
               writeln('Array A contains ',numElements:4,' non-zero elements');
    end;    {initialize}




    procedure initializeB;         {note: same comments apply as for A above}

    var
        curRow: integer;
        colPtr: matrixCellPtr;
        curCell: matrixCellPtr;
        row, col: index;
        val: cellValue;
        numElements: integer;

    begin
        reset('testdata.2b', dataB);

        curCell := nil;
        curRow := 0;
        numElements := 0;

        if not eof(dataB) then begin
            writeln('Initializing B');
        end else 
            begin
                 writeln('testdata.2b is empty. Cannot proceed.')
        end;

        while not eof(dataB) do begin
            readln(dataB, row, col, val);
            numElements := numElements + 1;
    
                         {create and link from row}

            if curRow <> row then begin 
                new(newCell);
                rowDirB[row] := newCell;
                curCell := rowDirB[row]; 
                curRow := row
            end else begin
                new(newCell);
                curCell^.nextOnRow := newCell;
                curCell := curCell^.nextOnRow
            end;
            
                         {link through column}

            if colDirB[col] = nil then begin
                colDirB[col] := curCell;
                colPtr := curCell
            end else begin
                colPtr := colDirB[col];
                while (colPtr^.nextInCol  <> nil) do
                    colPtr := colPtr^.nextInCol;
                colPtr^.nextInCol := curCell
            end;

                         {initialize this entry}

            curCell^.rowNo := row;
            curCell^.colNo := col;
            curCell^.value := val
        end;
              writeln('Array B contains ',numElements:4, ' non-zero elements');
    end;    {initialize}


        

    procedure overhead;         {find overhead}

    begin
        loopCost := clock;                      {initial time}
        for test := 1 to testRuns do 
            null;                               {empty loop}
        time := clock;                          {time after loop}
        loopCost := time - loopCost             {actual elapsed time}
    end;    {overhead}




    procedure multiply;
 
    var
        difference: index;{used to test if at proper position in both matrices}
        curRow: index;          {position holder}
        colPtr: matrixCellPtr;  {used to move through column for linking}
        col, row: index;        

    begin
        for i := 1 to m do begin                {loop for each row of A}
            curCellC := nil;                    {initialize}
            curRow := 0;
            row := i;                           {hold value of current row}

            for j := 1 to p do begin            {loop for each col of B}
                sum := 0;                       {initialize}
                col := j;
                curCellA := rowDirA[i];         {point to A's rows}
                curCellB := colDirB[j];         {point to B's columns}

                         {compute partial sum}

                while (curCellA <> nil) and (curCellB <> nil) do begin   
                                   {while not at end of A's row or B's col}
                    difference := (curCellA^.colNo - curCellB^.rowNo);   
                                        {see if they are properly coordinated}

                    if (difference = 0) then begin     {ok to sum}
                        sum := (curCellA^.value * curCellB^.value) + sum;
                        curCellA := curCellA^.nextOnRow;
                        curCellB := curCellB^.nextInCol
                    end
                    else                          {not ok}
                        if (difference > 0) then  {move to next "B"}
                            curCellB := curCellB^.nextInCol
                        else                      {move to next "A"}
                            curCellA := curCellA^.nextOnRow
                end;
 
         
                         {Install by moving along each row, column by column}

                if (sum <> 0) then begin          {only if result is non-zero}

                    if (curRow <> row) then begin {if new row or first time}
                        new(newCell);             {new element}
                        rowDirC[row] := newCell;  {link with row directory}
                        curCellC := rowDirC[row]; {adjust 'current' pointers}
                        curRow := row 

                    end else begin         {entries already exist in this row}
                        new(newCell);                   {new element}
                        curCellC^.nextOnRow := newCell; {link to new element}
                        curCellC := curCellC^.nextOnRow {move to it}
                    end;

                         {Link through column}

                    if (colDirC[col] = nil) then begin  {if none in this row}
                        colDirC[col] := curCellC;       {point to new entry}
                        colPtr := curCellC   {adjust 'current' pointers}
                    end else begin           {some in this row already}
                        colPtr := colDirC[col];  {start at beginning of column}
                        while (colPtr^.nextInCol <> nil) do      {move to end}
                            colPtr := colPtr^.nextInCol;
                        colPtr^.nextInCol := curCellC   {link it}
                    end;        
      
                         {initialize this entry}
                                
                    curCellC^.rowNo := i;               {A;s current row}
                    curCellC^.colNo := j;               {B's current column}
                    curCellC^.value := sum
                end     {install C}
            end     {B's columns}
        end     {A's rows}
    end;



begin {* main *}

    initializeA;

    if (outputFlag) then begin                  {if output switch on}

                         {print A}
        writeln('Matrix A is:');
        writeln;
    
        for i := 1 to m do begin                {for each row}
            write('A[',i:width,']',tab);
            curCellA := rowDirA[i];             {start at beginning}
            curCol := 1; 
            if curCellA <> nil then 
            begin
                 while(curCellA <> nil) do begin  {while not at end of row}
                      if curCellA^.colNo <> curCol then 
                                             {next entry not in next col}
                           write('0':width,tab)
                      else begin             {positioned in correct col} 
                            write(curCellA^.value: width, tab);
                            curCellA := curCellA^.nextOnRow 
                                                       {move to next entry}
                            end;        
                      curCol := curCol + 1;             {move to next col} 
                      end
                  end;
            writeln
        end    {print A}
    end;




    initializeB;


    if (outputFlag) then begin                  {if output switch on}

                         {print B}
        writeln('Matrix B is:');
        writeln;
    
        for k := 1 to n do begin                {for each row}
            write('B[',k:width,']',tab);
            curCellB := rowDirB[k];
    
    
            curCol := 1; 
            if curCellB <> nil then    
            begin
                 while(curCellB <> nil) do begin  {while not at end of row}
                      if curCellB^.colNo <> curCol then 
                                                  {next entry not in next col}
                           write('0':width,tab)
                      else begin                  {positioned in correct col} 
                            write(curCellB^.value: width, tab);
                            curCellB := curCellB^.nextOnRow 
                                                  {move to next entry}
                            end; 
                      curCol := curCol + 1;              {move to next col} 
                      end
                  end;
            writeln
        end    {print B}
    end;


    overhead;                                   {find overhead}

    time := clock;                              {reset timer}
    writeln('The time at start is...', time);

                         {finally}
    for test := 1 to testRuns do begin          {loop over problem}
        multiply;                               {do it}
    end; {testRuns}
                         {done}

    time2 := clock;
    time := (time2 - time - loopCost) div testRuns;

    writeln('The time at finish is...', time2);
    writeln('The number of test runs was ', testRuns);
    writeln('The average time for each run was ...', time);
    writeln;

    if (outputFlag) then begin

                         {print C}
        writeln('Matrix C is:');
        writeln;
        
        for i := 1 to m do begin                        {for each row}
            write('C[', i: width, ']', tab);
            curCellC := rowDirC[i];
            curCol := 1; 

            if curCellC <> nil then                     {if there are entries}
            begin
                 while(curCellC <> nil) do begin  {while not at end of row}
                      if curCellC^.colNo <> curCol then 
                                                  {next entry not in next col}
                           write('0':width,tab)
                      else begin                  {positioned in correct col} 
                            write(curCellC^.value: width, tab);
                            curCellC := curCellC^.nextOnRow 
                                                       {move to next entry}
                            end; 
                      curCol := curCol + 1;              {move to next col} 
                      end
            end;
            writeln
        end
    end
end.    {* matrix2 *}
                                                                                                                                