;
;TITLE 'SENDOUT UTILITY FOR CP/M AND PMMI MODEM 4/8/81 AAJ'
;
;THIS ROUTINE WRITTEN BY AL JEWER AND RELEASED IN PUBLIC
;DOMAIN 4/8/81. 
;
;THIS CP/M TRANSIENT COMMAND IS INVOKED IN THIS MANNER:
;
;A>SENDOUT XMODEM S FILENAME.TYP
;
;IN THIS EXAMPLE, THE STRING "XMODEM S FILENAME.TYP"
;WILL BE SENT OUT THE MODEM PORT TO A REMOTE SYSTEM.
;THIS IS FOR USE IN:
;
;		1) TRANSFERRING MULTIPLE PROGRAMS TO & FROM
;			REMOTE USING A SUBMIT FILE
;
;		2) SENDING COMMANDS WITHOUT HAVING TO
;			ENTER & EXIT THE "MODEM" PROGRAM
;
;THE STRING CAN BE UP TO 127 CHARACTERS LONG, AND IS 
;ECHOED TO THE LOCAL CONSOLE AS IT IS SENT.
;
;THE PROGRAM WILL WAIT FOR A ">" CHARACTER BEFORE IT
;SENDS THE LINE, TO ALLOW THE REMOTE TO BE READY FOR
;THE COMMAND LINE. AS THE LINE IS SENT, THE PROGRAM 
;WILL CHECK THE CHARACTERS ECHOED BACK TO ASSURE THAT
;THE COMMAND LINE HAS BEEN TRANSMITTED PROPERLY.
;IF AN ERROR IS DETECTED, THE PROGRAM WILL SEND OUT
;A ^U FOLLOWED BY A CARRIAGE RETURN, THEN RETRY 
;SENDING THE LINE, UNTIL A PROPER TRANSMISSION IS MADE.
;
;UPDATES: (IN REVERSE ORDER TO MINIMIZE READING TIME)
;
;15-JAN-81 MODIFIED BY JOHN LIMPERT TO ADD MEMORY
;	   MAPPED I/O FOR THE APPLE ][ WITH A D.C.
;	   HAYES MICROMODEM IN SLOT #2. SET APPLE
;	   TRUE FOR THIS CONFIGURATION.
;
;10-DEC-81 MODIFIED BY AL JEWER TO REMOVE REFERENCE TO
;	   LOCAL CONSOLE PORT (FUNCTION NOW PERFORMED 
;	   BY BIOS CALLS)
;	   ALSO ADDED RETRY COUNTER TO GIVE UP IF PHONE
;	   LINE GETS TOO HORRIBLE.
;
;23-NOV-81 MODIFIED BY JOHN LABOVITZ. ADDED SOME
;	   SIGNON MESSAGES, AND ABILITY TO ABORT
;	   BY A ^C.
;
;15-AUG-81 MODIFIED BY HOWARD BOOKER TO INCLUDE
;	   CONDITIONAL EQUATES FOR THE DC HAYES
;	   80-103A MODEM CARD.
;
;10-APR-81 REWRITTEN BY AL JEWER TO CHECK ECHOED
;	   STRING FOR VALID TRANSFER.
;
;08-APR-81 MODIFIED BY TOM JORGENSON FOR SUPPORT
;	   OF OTHER MODEM/PORT TYPES (ESP. H89)
;
;ANY QUESTIONS OR COMMENTS:
;
;	AL JEWER
;	PO BOX 123
;	WHITEWATER, WI. 53190
;
;	(414) 473-7263 (HOME)
;	(414) 563-9539 (WORK)
;
;BASE DEFINITION, CHANGE THIS TO 4200H IF ALTERNATE CP/M
;(RELOCATED) VERSION SUCH AS HEATH/LIFEBOAT OR TRS-80
;
BASE	EQU	0	;BASE OF MEMORY SEGMENT
;
;THESE SHOULD BE O.K. AS IS
;
BOOT	EQU	BASE	;JUMP HERE TO REBOOT CP/M
BDOS	EQU	BASE+5	;BDOS FUNCTION CALL ADDRESS
BUFFER	EQU	BASE+80H ;INPUT LINE BUFFER
CONOUT	EQU	2	;CP/M CONSOLE OUTPUT FROM E
PLINE	EQU	9	;CP/M PRINT STRING AT (DE)
CSTAT	EQU	11	;CP/M CONSOLE STATUS
CONIN	EQU	1	;CP/M CONSOLE INPUT
CR	EQU	0DH	;ASCII CHARACTERS
LF	EQU	0AH
CTLU	EQU	'U'-40H ;CONTROL-U
CTLC	EQU	'C'-40H ;CONTROL-C
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
FASTCLK EQU	FALSE	;TRUE IF 4MHZ OR GREATER
;
RETRYS	EQU	32	;RETRY THIS MANY TIMES BEFORE GIVING UP
;
;CHOOSE YOUR MODEM/PORT TYPE HERE:
;
APPLE	EQU	TRUE	;TRUE, IF APPLE WITH MMII
H89	EQU	FALSE	;TRUE, IF H89
PMMI	EQU	FALSE	;TRUE, IF PMMI
DCH	EQU	FALSE	;TRUE, IF DCH
;
	IF	PMMI
;
;CHANGE THE FOLLOWING IF YOUR PMMI IS NOT AT THE 
;STANDARD BASE ADDRESS OF 0C0H.
;
TPORT	EQU	0C0H	;THIS IS STATUS PORT
DPORT	EQU	TPORT+1 ;DATA I/O PORT
POTBMT	EQU	1	;XMIT BUFFER EMPTY FLAG
PODAV	EQU	2	;DATA AVAILABLE FLAG
;
	ENDIF		;PMMI
;
	IF	H89
;
;SHOULD USE THESE AS LONG AS YOU CONFORM
;TO STD PORT ADDRESS (330Q)
;
TPORT	EQU	335Q	;STATUS PORT (8250 UART)
DPORT	EQU	330Q	;DATA PORT
POTBMT	EQU	040Q	;THRE BIT (TX BUFFER EMPTY)
PODAV	EQU	001Q	;DATA AVAILABLE FLAG
;
	ENDIF		;H89
;
	IF DCH
;
;STANDARD DC HAYES MODEL 80-103A PORTS
;
TPORT	EQU	81H	;STATUS PORT (TR1602 UART)
DPORT	EQU	80H	;DATA PORT
POTBMT	EQU	02H	;THRE BIT (TX BUFFER EMPTY)
PODAV	EQU	01H	;DATA AVAILABLE FLAG
;
	ENDIF		;DCH
;
	IF APPLE
;
;APPLE ][ WITH MICROMODEM IN SLOT #2
;
MM$CSR	EQU	0E0A6H	;ACIA CSR
MM$BUF	EQU	0E0A7H	;ACIA DATA BUFFER
MM$TRE	EQU	02H	;TRANSMIT REGISTER EMPTY BIT
MM$DAV	EQU	01H	;RECEIVER DATA AVAILABLE BIT
;
	ENDIF		;APPLE
;
ORG	BASE+100H	;START OF TPA
;
START:	LXI	SP,STACK ;SET SAFE STACK
	CALL	ILPRT	;SAY HELLO TO THE FOLKS
	DB	'SENDOUT V. 7.0  --  Type ^C to ABORT',CR,LF,0
	MVI	A,RETRYS ;SET RETRY COUNTER 
	STA	TRYNUM	;TO ITS INITIAL VALUE
	LHLD	1	;GET WARM BOOT ADDRESS
	LXI	D,4	;PLUS 1 TABLE POSITION & 1 JMP
	DAD	D	;GIVES CONSTAT VECTOR AT (HL)
	MOV	E,M	;LO BYTE OF CONSTAT
	INX	H	;POINT TO HI BYTE
	MOV	D,M	;CONSTAT VECTOR NOW IN DE
	XCHG		;CONSTAT VECTOR NOW IN HL
	SHLD	CST+1	;INIT THE CONSTAT CALL
	LXI	H,2	;DISTANCE TO NEXT VECTOR
	DAD	D	;THIS IS CONIN VECTOR AT (HL)
	MOV	E,M	;LO BYTE OF CONIN
	INX	H	;POINT TO HI BYTE
	MOV	D,M	;CONIN VECTOR NOW IN DE
	XCHG		;CONIN VECTOR NOW IN HL
	SHLD	CIN+1	;INIT THE CONIN CALL
	JMP	PDATA	;JUMP TO TEST CURRENT CHARACTER
;
PIN:	LXI	B,8000H ;TIME COUNTER TO B
	LXI	H,TRYNUM ;POINT TO RETRY COUNTER
	DCR	M	;BUMP IT
	JNZ	PLOOP	;CONTINUE IF NOT EXHAUSTED
	CALL	ILPRT	;ELSE PRINT THE BAD NEWS
	DB	CR,LF,'Can''t send string -- Aborting.....',CR,LF,0
	JMP	BOOT	;AND KICK OUT
;
PLOOP:	PUSH B		;SAVE THE TIMEOUT COUNTER
CST:	CALL	$-$	;THIS IS INITED TO STATUS ADDR. IN BIOS
			;(WE DO THIS TO SAVE TIME IN LOOP)
	ORA	A	;KEY PRESSED?
	JZ	PLOOP1	;CONTINUE IF NO KEYPRESS
CIN:	CALL	$-$	;THIS IS INITED TO CONSOLE INPUT ADDR.
			;IN BIOS
	CPI	CTLC	;EXIT REQUEST?
	JNZ	PLOOP1	;CONTINUE IF NOT
	CALL	ILPRT	;ELSE EXIT
	DB	CR,LF,'SENDOUT aborted by ^C'
	DB	CR,LF,'Returning to CP/M...',0
	JMP	BOOT
;
PLOOP1: POP	B	;RESTORE THE TIMEOUT COUNTER
	DCX	B	;COUNT THE LOOP
	MOV	A,B	;CHECK FOR DONE
	ORA	C
	JZ	TRYAGN	;JUMP IF TIMED OUT
;
	IF	FASTCLK
	XTHL		;WASTE TIME ON FAST SYSTEMS
	XTHL
	XTHL
	XTHL
	ENDIF		;FASTCLK
;
	IF	NOT APPLE
PL2:	IN	TPORT	;GET THE STATUS PORT
	ANI	PODAV	;WE GOT A CHARACTER?
	JZ	PLOOP	;LOOP TILL TIMEOUT OR DATA RECEIVED
	ENDIF		;NOT APPLE
;
	IF	APPLE
PL2:	LDA	MM$CSR	;GET THE STATUS
	ANI	MM$DAV	;WE GOT A CHARACTER?
	JZ	PLOOP	;LOOP TILL TIMEOUT OR DATA RECEIVED
	ENDIF		;APPLE
;
	IF	NOT APPLE
PDATA:	IN	DPORT	;GET THE CHARACTER
	ANI	7FH	;DROP PARITY BIT JUST IN CASE
	MOV	E,A	;ECHO IT TO THE CRT
	CALL	CRTOUT
	CPI	'>'	;DISK PROMPT?
	JNZ	PIN	;LOOP TILL PROPER CHARACTER RECEIVED
	ENDIF		;NOT APPLE
;
	IF	APPLE
PDATA:	LDA	MM$BUF	;GET THE CHARACTER
	ANI	7FH	;DROP PARITY BIT JUST IN CASE
	MOV	E,A	;ECHO IT TO THE CRT
	CALL	CRTOUT
	CPI	'>'	;DISK PROMPT?
	JNZ	PIN	;LOOP TILL PROPER CHARACTER RECEIVED
	ENDIF		;APPLE
;
;WE HAVE NOW RECEIVED A ">" CHARACTER, SO THE REMOTE SYSTEM
;IS READY TO RECEIVE THE COMMAND LINE.
;
	LXI	H,BUFFER ;POINT TO COMMAND LINE BUFFER
	MOV	B,M	;GET THE CHARACTER COUNT
	MOV	A,B	;ALSO TO A REGISTER
	ORA	A	;ZERO LENGTH?
	JZ	ERROR	;RETURN IF SO
	DCR	A	;LENGTH OF 1? (THIS WOULD BE SPACE ONLY)
	JZ	ERROR	;IGNORE THIS TOO
	INR	B	;ADD 1 FOR FINAL CR
	INX	H	;SKIP THE LEADING SPACE
;
LOOP:	INX	H	;POINT TO NEXT CHARACTER
	DCR	B	;COUNT THE CHARACTER
	JNZ	NOTDUN	;JUMP IF NOT FINISHED
	MVI	E,LF	;SEND LINE FEED TO LOCAL CONSOLE
	CALL	CRTOUT
	JMP	BOOT	;DONE!
;
NOTDUN: MVI	A,1	;CHECK FOR LAST CHARACTER
	CMP	B
	JNZ	GO	;JUMP IF NOT LAST ONE
	MVI	M,CR	;MAKE LAST CHARACTER CARRIAGE RETURN
;
GO:	MOV	C,M	;GET CHARACTER
	CALL	POUT	;SEND OUT THE MODEM
	LXI	D,0	;TIME COUNTER TO D
;
	IF	NOT APPLE
RECLP:	IN	TPORT	;CHECK FOR CHARACTER
	ANI	PODAV	;CHARACTER RECEIVED?
	ENDIF		;NOT APPLE
;
	IF	APPLE
RECLP:	LDA	MM$CSR	;CHECK FOR CHARACTER
	ANI	MM$DAV	;CHARACTER RECEIVED?
	ENDIF		;APPLE
;
	JNZ	GOTONE	;JUMP IF WE GOT A CHARACTER
	DCX	D	;COUNT THE TIMER
	MOV	A,D
	ORA	E
	JZ	TRYAGN	;JUMP IF TIMED OUT
;
	IF	FASTCLK
	MVI A,14	;WASTE TIME IF AT 4 MHZ
WASTE:	DCR A		;COUNT THE LOOP
	JNZ WASTE	;AND LOOP TILL DONE
	ENDIF		;FASTCLK
;
	JMP	RECLP	;CONTINUE WAITING
;	
	IF	NOT APPLE
GOTONE: IN	DPORT	;GET THE CHARACTER
	ANI	7FH	;DROP PARITY
	ENDIF		;NOT APPLE
;
	IF	APPLE
GOTONE:	LDA	MM$BUF	;GET THE CHARACTER
	ANI	7FH	;DROP PARITY
	ENDIF		;APPLE
;
	MOV	E,A
	CALL	CRTOUT	;DISPLAY TO LOCAL CONSOLE
	CMP	M	;IS IT THE SAME AS WHAT WE SENT?
	JZ	LOOP	;JUMP IF OK
;
TRYAGN: MVI	C,CTLU	;CANCEL THE LINE
	CALL	POUT
	MVI	C,CR	;THEN GET NEW PROMPT
	CALL	POUT
	JMP	PIN
;
	IF	NOT APPLE
POUT:	IN	TPORT	;GET PHONE STATUS PORT
	ANI	POTBMT	;MASK FOR XMIT BUFFER EMPTY
	JZ	POUT	;WAIT FOR PHONE
	MOV	A,C	;SEND THE CHARACTER
	OUT	DPORT
	RET
	ENDIF		;NOT APPLE
;
	IF	APPLE
POUT:	LDA	MM$CSR	;GET PHONE STATUS
	ANI	MM$TRE	;MASK FOR XMIT BUFFER EMPTY
	JZ	POUT	;WAIT FOR PHONE
	MOV	A,C	;SEND THE CHARACTER
	STA	MM$BUF
	RET
	ENDIF		;APPLE
;
CRTOUT: PUSH	H	;SAVE AFFECTED REGISTERS
	PUSH	B
	PUSH	PSW
	MVI	C,CONOUT
	CALL	BDOS	;SEND TO CONSOLE
	POP	PSW
	POP	B
	POP	H
	RET
;
ERROR:	CALL	ILPRT
	DB	CR,LF,'Command error.'
	DB	CR,LF,'Format: SENDOUT string'
	DB	CR,LF,'Where "string" is any string to'
	DB	CR,LF,'send out to the modem.',0
	JMP	BOOT	;GO BYE BYE
;
ILPRT:	XTHL		;SAVE HL, GET MSG
	PUSH	B	;SAVE B
ILPLP:	MOV	E,M	;GET CHAR
	CALL	CRTOUT	;PRINT IT
	INX	H	;POINT TO NEXT
	MOV	A,M	;GET IT
	ORA	A	;TEST FOR END
	JNZ	ILPLP	;NOPE, LOOP
	POP	B	;YUP, RESTORE...
	XTHL		;...
	RET		;AND RETURN
;
TRYNUM: DS 1		;RETRY CONTER STORAGE
	DS 60		;STACK AREA
STACK	EQU	$
;
	END	START
