		ORG	100H
BDOS:		EQU	5
BIOS:		EQU	1
SELECT:		EQU	1BH
TRACK:		EQU	1EH
SECTOR:		EQU	21H
SETDMA:		EQU	24H
READ:		EQU	27H
WRITE:		EQU	2AH
SECTRAN:	EQU	30H

BEGIN:		LXI	SP,STACK		;SET STACK
		LXI	D,INITMES		;POINT TO SIGNON MESSAGE
		MVI	C,9			;CPM PRINT STRING FUNCTION
		CALL	BDOS
		LDA	80H			;SEE IF ANY COMMAND
		ORA	A
		JZ	BADDR			;IF NO, THEN BAD DRIVE
		LDA	082H			;CHECK FIRST BYTE OF
		SUI	'A'			;DEFAULT FILE BLOCK
		CPI	4			;IF IT'S LESS THAN 4
		JC	OKGO			;CONTINUE, ELSE
BADDR:		LXI	D,BADDRIVE		;POINT TO BAD DRIVE MESSAGE
		MVI	C,9			;DISPLAY IT,
		CALL	BDOS
		JMP	0			;AND ABORT

OKGO:		STA	DRIVE			;WE NOW HAVE A VALID DRIVE
		LXI	D,LOADMES		;POINT TO LOAD MESSAGE
		MVI	C,9
		CALL	BDOS			;AND DISPLAY IT
		LDA	DRIVE			;RELOAD DRIVE
		MOV	E,A			;AND MOVE INTO E
		MVI	C,14			;SELECT DISK
		CALL	BDOS
		MVI	C,31			;FIND DISKPARM
		CALL	BDOS
		SHLD	DPB			;DISK PARAMETER BLOCK
; THE FIRST BYTE OF THE DPB CONTAINS THE LSB OF THE NUMBER OF SECTORS
; ON THE SELECTED DISK. THE FOLLOWING TECHNIQUE WILL WORK FOR ALL BUT
; DISK FORMATTED WITH MORE THAN 255 SECTORS/TRACK (IE HARD DISKS.).
		MOV	A,M			;GET LSB OF # OF SECTORS
		STA	SECPT			;SECTORS PER TRACK
		INX	H			;POINT TO NUMBER OF DIRECTORY
		INX	H			;ENTRIES
		INX	H			;(DPB+7)
		INX	H
		INX	H
		INX	H
		INX	H
		MOV	E,M			;GET LSB
		INX	H			;POINT TO MSB
		MOV	D,M			;GET MSB
		XCHG
		inx	h			;add one to get real # (2.4)
		SHLD	DIRECT			;ACTUAL # OF DIRECTORY ENTRIES
		XRA	A			;CLEAR CARRY
		MOV	A,H			;DIVIDE BY FOUR
		RAR				;BY SUCCESSIVE RRC'S
		MOV	H,A
		MOV	A,L
		RAR
		MOV	L,A
		XRA	A			;CLEAR CARRY
		MOV	A,H
		RAR
		MOV	H,A
		MOV	A,L
		RAR
		MOV	L,A
		INX	H			;ADD ONE, SO READ 1 EX. SEC.
		INX	H			;OR 2
		INX	H			;OR 3
		INX	H			;OR 4
		SHLD	RSECT			;DIRECT/4 (4 ENTRIES/SECTOR)
		LDA	DRIVE			;GET DRIVE NUMBER
		MOV	C,A			;PREPARE TO SELECT
		MVI	A,SELECT
		CALL	FUNC			;SELECT DRIVE
		MOV	E,M			;HL POINT TO INTERNAL
		INX	H			;TRANSLATE TABLE (SKEW)
		MOV	D,M			;AS FIRST TWO BYTES
		XCHG
		SHLD	SKEW			;STORE SKEW TABLE ADDRESS
		LHLD	RSECT			;GET NUMBER OF SECTORS IN DIR
		PUSH	H
		POP	B			;STORE IN BC
		LDA	FIRSEC			;GET FIRST SECTOR TO READ
		MOV	E,A			;STORE IN E
		push	b
		LHLD	DPB			;GET ADDRESS OF DPB
		LXI	B,13			;ADD 13 TO GET RES. TRKS
		DAD	B
		mov	a,m
		inx	h
		mov	h,m
		mov	l,a
		shld	dirtrk
		pop	b
		lxi	h,buffer
LOOP:		PUSH	B			;SAVE REGISTERS
		PUSH	D
		PUSH	H
		PUSH	H
		POP	B
		push	d
		MVI	A,SETDMA		;HAVE DMA SET TO CUR. BUF.
		CALL	FUNC
		pop	d
		MOV	C,E			;PREPARE FOR SKEW
		MVI	B,0
		LHLD	SKEW			;GET SKEW TABLE ADDRESS
		xchg
		MVI	A,SECTRAN
		CALL	FUNC			;SKEW SECTORS
		PUSH	H
		POP	B
		MVI	A,SECTOR		;SET SECTOR NUMBER
		CALL	FUNC
		lhld	dirtrk
		push	h
		pop	b
		MVI	A,TRACK			;SET TRACK NUMBER
		CALL	FUNC
		MVI	A,READ			;READ SECTOR
		CALL	FUNC
		ORA	A			;IF NON ZERO, ERROR HAS
		JNZ	ERROR			;OCCURED. ABORT.
		POP	H
		LXI	D,128			;PREPARE TO ADD 128
		DAD	D			;TO HL SO HL CONTAINS
		POP	D			;NEXT BUFFER LOCATION
		INR	E			;ADD 1 TO CURRENT SECTOR
		LDA	SECPT			;CHECK AGAINST MAX #/TRK
		CMP	E
		JNZ	LOOP2			;IF OK, SKIP
		push	h
		lhld	dirtrk
		inx	h
		shld	dirtrk
		pop	h
		LDA	FIRSEC			;AND ZERO SECTOR
		MOV	E,A
LOOP2:		POP	B			;GET # OF SECTORS TO READ
		DCX	B			;SUBTRACT ONE
		MOV	A,B
		ORA	C
		JNZ	LOOP			;IF NOT DONE, LOOP

; WE HAVE NOW READ IN ALL SECTORS OF THE DIRECTORY, SPACED AT
; 32 BYTE INTERVALS IN THE BUFFER. THE SORT ROUTINE CAN NOW PROCESS
; THIS 'BUFFER'
		LXI	D,SORTMES		;ELSE POINT TO SORT MESSAGE
		MVI	C,9
		CALL	BDOS			;AND DISPLAY IT
		CALL	SORT			;AND SORT IT

		LXI	D,SAVEMES		;POINT TO WRITE MESSAGE
		MVI	C,9
		CALL	BDOS			;AND DISPLAY IT
		LHLD	RSECT			;GET NUMBER OF SECTORS IN DIR
		PUSH	H
		POP	B			;STORE IN BC
		LDA	FIRSEC			;GET FIRST SECTOR TO WRITE
		MOV	E,A			;STORE IN E
		push	b
		LHLD	DPB			;GET ADDRESS OF DPB
		LXI	B,13			;ADD 13 TO GET RES. TRKS
		DAD	B
		mov	a,m
		inx	h
		mov	h,m
		mov	l,a
		shld	dirtrk
		POP	B
		LXI	H,BUFFER		;POINT TO BUFFER
LOOP3:		PUSH	B			;SAVE REGISTERS
		PUSH	D
		PUSH	H
		PUSH	H
		POP	B
		MVI	A,SETDMA		;HAVE DMA SET TO CUR. BUF.
		CALL	FUNC
		MOV	C,E			;PREPARE FOR SKEW
		MVI	B,0
		LHLD	SKEW			;GET SKEW TABLE ADDRESS
		xchg
		MVI	A,SECTRAN
		CALL	FUNC			;SKEW SECTORS
		PUSH	H
		POP	B
		MVI	A,SECTOR		;SET SECTOR NUMBER
		CALL	FUNC
		lhld	dirtrk
		push	h
		pop	b
		MVI	A,TRACK			;SET TRACK NUMBER
		CALL	FUNC
		LXI	B,0			;Directory write is too
						;slow, so changed to reg.w
		MVI	A,WRITE			;WRITE SECTOR
		CALL	FUNC
		ORA	A			;IF NON ZERO, ERROR HAS
		JNZ	ERROR			;OCCURED. ABORT.
		POP	H
		LXI	D,128			;PREPARE TO ADD 128
		DAD	D			;TO HL SO HL CONTAINS
		POP	D			;NEXT BUFFER LOCATION
		INR	E			;ADD 1 TO CURRENT SECTOR
		LDA	SECPT			;CHECK AGAINST MAX #/TRK
		CMP	E
		JNZ	LOOP4			;IF OK, SKIP
		push	h
		lhld	dirtrk
		inx	h
		shld	dirtrk
		pop	h
		LDA	FIRSEC			;AND ZERO SECTOR
		MOV	E,A			;REGISTER
LOOP4:		POP	B			;GET # OF SECTORS TO WRITE
		DCX	B			;SUBTRACT ONE
		MOV	A,B
		ORA	C
		JNZ	LOOP3			;IF NOT DONE, LOOP

		LXI	D,ACTM1
		MVI	C,9
		CALL	BDOS
		LHLD	DIRECT
		SHLD	M1
		PUSH	H
		POP	B
		CALL	BINDEC
		LXI	D,ACTM2
		MVI	C,9
		CALL	BDOS
		LXI	H,BUFFER		;POINT TO BUFFER
		LXI	D,0
		LXI	B,0
CHECKLP:	MOV	A,M
		CPI	0E5H			;IF FIRST BYTE IS E5H
		JZ	CHECKDEL		;THEN IT MUST BE DELETED
		INX	B
		JMP	CHECKOK
CHECKDEL:	INX	D
CHECKOK:	PUSH	D
		LXI	D,32
		DAD	D
		POP	D
		PUSH	H
		LHLD	M1
		DCX	H
		SHLD	M1
		MOV	A,L
		ORA	H
		POP	H
		JNZ	CHECKLP
		PUSH	D
		CALL	BINDEC
		LXI	D,ACTM3
		MVI	C,9
		CALL	BDOS
		POP	B
		CALL	BINDEC
		LXI	D,ACTM4
		MVI	C,9
		CALL	BDOS

ABORT:		JMP	0			;DONE, SO EXIT.

FUNC:		PUSH	H			;EXECUTE BIOS FUNTION DIRECTLY
		PUSH	D
		LHLD	BIOS
		DCX	H
		DCX	H
		DCX	H
		MOV	E,A
		MVI	D,0
		DAD	D
		POP	D
		XTHL
		RET

ERROR:		LXI	D,ERRORMES		;DISPLAY ERROR MESSAGE,
		MVI	C,9			;AND ABORT
		CALL	BDOS
		JMP	ABORT

BINDEC:		PUSH	B
		POP	H
		LXI	D,SWITCH
		PUSH	D
		INX	D
		INX	D
		INX	D
		INX	D
		PUSH	D
		LXI	B,0A05H			;C=5,B=10
BDLP:		CALL	DIV
		ADI	30H			;CONVERT TO ASCII
		STAX	D
		DCX	D
		DCR	C
		JNZ	BDLP
		POP	D
		INX	D
		MVI	A,'$'
		STAX	D
		POP	D
		MVI	C,4
BDLP1:		LDAX	D
		CPI	'0'
		JNZ	BDEXIT
		INX	D
		DCR	C
		JNZ	BDLP1
BDEXIT:		MVI	C,9
		CALL	BDOS
		RET


DIV:		PUSH	B
		XRA	A
		MVI	C,17
		JMP	DVSTART
DVLP:		SUB	B
		JP	NREST
		ADD	B
DVSTART:	DAD	H
		RAL
		JMP	DVCONT
NREST:		DAD	H
		RAL
		INX	H
DVCONT:		DCR	C
		JNZ	DVLP
		RAR
		POP	B
		RET



						;FROM A CBASIC LISTING
SORT:		LHLD	DIRECT
		SHLD	M1			;SHELL/METZNER
						;FROM A CBASIC LISTING
SORT1:		LHLD	M1
		XRA	A
		MOV	A,H
		RAR
		MOV	H,A
		MOV	A,L
		RAR
		MOV	L,A
		SHLD	M1
		ORA	H
		RZ
		XCHG
		LHLD	DIRECT
		DCX	H			;2.4
		MOV	A,L
		SUB	E
		MOV	L,A
		MOV	A,H
		SBB	D
		MOV	H,A
		SHLD	K1
		LXI	H,0
		SHLD	J1

SORT2:		LHLD	J1
		SHLD	I1

SORT3:		LHLD	I1
		XCHG
		LHLD	M1
		DAD	D
		SHLD	L1
		CALL	COMP
		JZ	SORT4
		JC	SORT4
		CALL	EXCH
		LHLD	M1
		XCHG
		LHLD	I1
		MOV	A,L
		SUB	E
		MOV	L,A
		MOV	A,H
		SBB	D
		MOV	H,A
		SHLD	I1
		JM	SORT4
		ORA	L
		JZ	SORT4
		JMP	SORT3

SORT4:		LHLD	J1
		INX	H
		SHLD	J1
		XCHG
		LHLD	K1
		CALL	CMPDEHL
		JC	SORT1
		JMP	SORT2


COMP:		LHLD	I1
		DAD	H		;*2
		DAD	H		;*4
		DAD	H		;*8
		DAD	H		;*16
		DAD	H		;*32
		XCHG
		LXI	H,BUFFER
		DAD	D
		SHLD	ADDR1
		PUSH	H
		LHLD	L1
		DAD	H		;*2
		DAD	H		;*4
		DAD	H		;*8
		DAD	H		;*16
		DAD	H		;*32
		XCHG
		LXI	H,BUFFER
		DAD	D
		SHLD	ADDR2
		POP	D
		MVI	B,15		;COMPARE ON 15 BYTES
COMP1:		LDAX	D
		CMP	M
		RNZ
		INX	H
		INX	D
		DCR	B
		JNZ	COMP1
		RET

EXCH:		LHLD	ADDR1
		XCHG
		LHLD	ADDR2
		MVI	C,32
EXCH1:		MOV	B,M
		LDAX	D
		MOV	M,A
		MOV	A,B
		STAX	D
		INX	D
		INX	H
		DCR	C
		JNZ	EXCH1
		RET

MULT:		LXI	H,0	;MULTIPLY DE * A, RET DE
		MVI	B,8
MULT1:		DAD	H
		RLC
		JNC	NOC
		DAD	D
NOC:		DCR	B
		JNZ	MULT1
		PUSH	H
		POP	D
		RET

CMPDEHL:	MOV	A,H
		CMP	D
		RNZ
		MOV	A,L
		CMP	E
		RET

BADDRIVE:	DB	10,13,'Bad drive.$'
ERRORMES:	DB	10,13,'Read/Write Error!','$'
LOADMES:	DB	10,13,'Loading directory track.$'
SORTMES:	DB	10,13,'Sorting directory.$'
SAVEMES:	DB	10,13,'Writing directory track.$'
ACTM1:		DB	10,13,10,13,'Of the $'
ACTM2:		DB	' possible files, $'
ACTM3:		DB	' are active, and $'
ACTM4:		DB	' are deleted or inactive.$'
INITMES:	DB	10,13,'Sortdir Version 2.7        Alpha One Micro-Consulting Ltd.'
		DB	10,13,'$'

DRIVE:		DB	0
SKEW:		DW	0	;SKEW TABLE ADDRESS, OR ZERO IF NONE
DPB:		DW	0	;DISK PARAMETER BLOCK
FIRSEC:		DB	0	;FIRST SECTOR ON TRACK
SECPT:		DW	0	;SECTORS PER TRACK
DIRECT:		DW	0	;ACTUAL DIRECTORY ENTRIES
RSECT:		DW	0	;READ DIRECTORY SECTORS
dirtrk:		dw	0	;currect directory track
SWITCH:		DB	0	;EXCHANGES OCCURED
ADDR1:		DW	0	;ADD OF I%
ADDR2:		DW	0	;ADD OF J%
I1:		DW	0
J1:		DW	0
K1:		DW	0
L1:		DW	0
M1:		DW	0
		DS	100
STACK:		EQU	$
BUFFER:		EQU	$
		END	100H
                                                                                                                                