; Parsing benchmark for 8080/8085.
;   Parsing loop is repeated COUNT times.
;
; Assumptions:
;    - no more than N operators will be stacked during parsing.

COUNT   equ     10000
N       equ     20

; CP/M I/O equates:

BDOS    equ     0005h
PRNSTR  equ     09h

CR      equ     0dh
LF      equ     0ah

       org     0100h

; Save CP/M's stack pointer and set up our stack:

start:
       lxi     h,0
       dad     sp
       shld    stksav
       lxi     sp,stktop

; Do the parsing operation COUNT times.

       lxi     d,begmsg
       mvi     c,PRNSTR
       call    BDOS
       lxi     h,-COUNT
       shld    cnt

; Parsing code.

parse   lxi     d,input         ; point to input expression
       lxi     h,output        ; point to output buffer
       lxi     b,0             ; push a 0 with prio. 0
       push    b
       ldax    d               ; get first character
loop1   cpi     '('             ; is it a '('?
       jnz     parse1          ; no
       mvi     c,1             ; '(' has prio. 1
       jmp     parse9          ; go stack it
parse1  cpi     'A'             ; < 'A' (i.e. is it an operator)?
       jc      parse4          ; yes, go handle operator
       mov     m,a
       inx     h               ; stuff variable into output
       jmp     parse10
parse4  mvi     b,2             ; find the priority of the operator
       cpi     ')'             ; and get it into B
       jz      parse45
       mvi     b,3
       cpi     '+'
       jz      parse45
       cpi     '-'
       jz      parse45
       mvi     b,4
parse45 mov     a,b             ; put new prio into A
parse46 pop     b               ; pop old op. and prio.
       cmp     c               ; compare priorities
       jz      parse47         ; if same prio. output old op.
       jnc     parse7          ; jump if new op is higher priority
parse47 mov     m,b             ; add op. to output buffer
       inx     h
       jmp     parse46         ; continue popping
parse7  cpi     2               ; new char a close paren?
       jz      parse10         ; yes, discard it and the open
parse8  push    b               ; re-stack the old operator
parse9a mov     c,a             ; new op.'s prio.
       ldax    d
parse9  mov     b,a             ; and the new op. itself
       push    b               ; stack the new op. & its prio.
parse10 inx     d               ; move up to next input char
       ldax    d               ; get next input char
       cpi     ' '             ; ' ' at end of input
       jnz     loop1           ; keep going until all done

; Now flush any operators remaining on the stack.

loop2   pop     psw             ; get top of stack
       ana     a               ; stack now empty?
       jz      done            ; yes, go do it again
       mov     m,a             ; add op. to output buffer
       inx     h
       jmp     loop2           ; keep flushing

; Check to see if we have done it enough times.

done    lhld    cnt
       inr     l
       jnz     l1
       inr     h
l1      shld    cnt
       jnz     parse           ; go do it again

; All done. Print out the resulting string.

       lxi     d,output
       mvi     c,PRNSTR
       call    BDOS
       lxi     d,crlf
       mvi     c,PRNSTR
       call    BDOS

; Restore CP/M's stack pointer and return.

       lhld    stksav
       sphl
       ret

; The input string:

input   db      'A+B*(X-Y/(B+Q-R)/P*L*M+N+O)-(((Z))/D) '
output  db      '$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$'

begmsg  db      'Starting to parse now.'
crlf    db      CR,LF,'$'

; Variables used:

stksav  ds      2               ; save CP/M's stack pointer
cnt     ds      2               ; main loop counter
       ds      2*N             ; stack for us to use
stktop:

       end
                                                                                                                                