/*

Filesize functions:

	sfsize	-  Sequential I/O method (cp/m 1.4)
	rfsize	-  Random I/O method (cp/m 2.x)

P.A. Mongelluzzo (9/13/82)

*/

#include <a:bdscio.h>

/*
**********
* sfsize *
**********

File size function - sequential read (cp/m 1.4) method.

*/

sfsize(fname)

char	*fname;

{

int	fd;				/* file descriptor */
int	i;				/* scratch */
int	nsects;				/* count of sectors */
char	buf[SECSIZ];			/* buffer 1 sector */

	if ((fd = open(fname,0)) == ERROR)
	  return(ERROR);

	nsects = 0;

	while (i = read(fd, buf, 1)) {
	  if (i == ERROR)
	    return (ERROR);
	  nsects = nsects + i;
	}

	close(fd);
	return (nsects);

}

/*
**********
* rfsize *
**********

File size function - Random I/O method (cp/m 2.2).

*/

rfsize(fname)

char	*fname;

{

int	fd;				/* file descriptor */
int	nsects;				/* count of sectors */

	if ((fd = open(fname,0)) == ERROR)
	  return (ERROR);

	rcfsiz(fd);
	nsects = rtell(fd);

	close(fd);

	return (nsects);

}
                                                                                                                   