;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;						;
;	 Diskfile to Tape conversion program	;
;	       for the EXIDY SORCERER		;
;	written by H.-R. OBERHAGE  08.01.1981	;
;						;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Creates tape files of a maximum length of 32 kB
;
CONINP	EQU	1
LIFTHD	EQU	12
OPENFL	EQU	15
READFL	EQU	20
;
CHEAD	EQU	47H
HTYPE	EQU	6
HXEQ	EQU	11
;
BDOS	EQU	0005H
TFCB	EQU	005CH
TBUFF	EQU	0080H
;
TFCBCR	EQU	TFCB+32
;
GETIY	EQU	0E1A2H
MSGOUT	EQU	0E1BAH
CRLF	EQU	0E205H
ERRMSG	EQU	0E3DDH
SAVE	EQU	0E638H
;
	ORG	STKSPC-64
	DEFS	64
;
;
	ORG	0A170H
STKSPC:	LD	HL,0
	ADD	HL,SP
	LD	(OLDSTK),HL
	LD	SP,STKSPC
	LD	DE,TFCB
	LD	C,OPENFL
	CALL	BDOS
	CP	0FFH
	LD	A,0
	JP	Z,ERROR
	LD	(FILCOU),A
	LD	(TFCBCR),A
	LD	A,80H
	LD	(IBFFPT),A
	CALL	GETIY
	LD	(IY+CHEAD+HTYPE),'C'
	XOR	A
	LD	(IY+CHEAD+HXEQ),A
	LD	(IY+CHEAD+HXEQ+1),A
	PUSH	IY
	POP	DE
	PUSH	DE
	LD	HL,SAVECM
	LD	BC,22
	LDIR
	LD	DE,5
	POP	HL
	ADD	HL,DE
	EX	DE,HL
	LD	HL,TFCB+1
	LD	B,3
FILNAM:	LD	A,(HL)
	CP	30H
	JR	NC,NAMCHR-$
	LD	A,'_'
NAMCHR:	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	FILNAM-$
	LD	(PRNOPL),DE
	LD	HL,8
	ADD	HL,DE
	LD	(SVNDPL),HL
MOTCTL:	CALL	CRLF
	LD	HL,MTRMSG
	CALL	MSGOUT
	LD	C,CONINP
	CALL	BDOS
	LD	B,0
	AND	5FH
	CP	'N'
	JR	Z,NOMCTL-$
	CP	'Y'
	JR	NZ,MOTCTL-$
	INC	B
	CALL	CRLF
	CALL	TAPEON
NOMCTL:	LD	A,B
	LD	(MTRFLG),A
	CALL	CRLF
NXTFLE:	LD	HL,0100H-1
FILMEM:	CALL	GETBYT
	JR	C,DONE-$
	INC	HL
	LD	(HL),A
	LD	DE,00FEH+8000H
	EX	DE,HL
	OR	A
	SBC	HL,DE
	EX	DE,HL
	JR	NC,FILMEM-$
	CALL	CASWRT
	JR	NXTFLE-$
DONE:	LD	A,H
	CP	01H
	JR	NZ,CLOSIT-$
	LD	A,L
	OR	A
CLOSIT:	CALL	NZ,CASWRT
	LD	A,(MTRFLG)
	OR	A
	CALL	NZ,TAPOFF
	LD	HL,(PRNOPL)
	DEC	HL
	LD	DE,CREAT1+2
	LD	BC,3
	LDDR
	LD	B,6
NAMADJ:	INC	DE
	DJNZ	NAMADJ-$
	LD	A,(FILCOU)
	CP	1
	JR	Z,LASTFL-$
	INC	HL
	LD	DE,CREAT1+8
	LD	BC,5
	LDIR
LASTFL:	EX	DE,HL
	LD	(HL),0DH
	INC	HL
	LD	(HL),00H
	CALL	CRLF
	LD	HL,CREATD
FINISH:	CALL	MSGOUT
	CALL	CRLF
	LD	HL,(OLDSTK)
	LD	SP,HL
	JP	0000H
;
CASWRT:	PUSH	HL
	EX	DE,HL
	LD	HL,(SVNDPL)
	CALL	DTHASC
	LD	C,LIFTHD
	CALL	BDOS
	LD	A,(FILCOU)
	ADD	A,1
	DAA
	LD	(FILCOU),A
	LD	HL,(PRNOPL)
	CALL	ATHASC
	LD	A,(MTRFLG)
	OR	A
	CALL	Z,TAPEON
	PUSH	IY
	POP	HL
	PUSH	HL
	CALL	MSGOUT
	POP	HL
	CALL	SAVE
	LD	A,(MTRFLG)
	OR	A
	CALL	Z,TAPOFF
	POP	HL
	RET
TAPEON:	LD	HL,RDYTAP
	CALL	MSGOUT
	PUSH	BC
	LD	C,CONINP
	CALL	BDOS
	POP	BC
	CALL	CRLF
	RET
TAPOFF:	LD	HL,STPTAP
	CALL	MSGOUT
	RET
;
DTHASC:	LD	A,D
	CALL	ATHASC
	LD	A,E
ATHASC:	PUSH	AF
	AND	0F0H
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	ATHAS2
	POP	AF
	AND	0FH
ATHAS2:	CP	10
	JR	C,ATHAS3-$
	ADD	A,'A'-'9'-1
ATHAS3:	ADD	A,'0'
	LD	(HL),A
	INC	HL
	RET
;
GETBYT:	LD	A,(IBFFPT)
	CP	80H
	JR	NZ,GET1ST-$
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	DE,TFCB
	LD	C,READFL
	CALL	BDOS
	POP	BC
	POP	DE
	POP	HL
	OR	A
	JR	Z,GET1ST-$
	CP	1
	SCF
	RET	Z
	LD	A,1
	JR	ERROR-$
GET1ST:	LD	E,A
	LD	D,0
	INC	A
	LD	(IBFFPT),A
	PUSH	HL
	LD	HL,TBUFF
	ADD	HL,DE
	LD	A,(HL)
	POP	HL
	CP	A
	RET
;
ERROR:	LD	HL,OPENER
	OR	A
	JR	Z,PRTERR-$
	LD	HL,READER
PRTERR:	CALL	CRLF
	CALL	MSGOUT
	LD	HL,ERRMSG
	JP	FINISH
;
;
OLDSTK:	DEFS	2
IBFFPT:	DEFB	80H
FILCOU:	DEFB	0
MTRFLG:	DEFB	0
PRNOPL:	DEFS	2
SVNDPL:	DEFS	2
;
SAVECM:	DEFM	'SAVE xxx00 0100 0100'
	DEFB	0DH
	DEFB	00H
RDYTAP:	DEFM	'Ready tape. Press any key when done.'
	DEFB	00H
STPTAP:	DEFM	'Stop tape.'
	DEFB	0DH
	DEFB	00H
CREATD:	DEFM	'File(s) created on tape:'
	DEFB	0DH
	DEFM	'                          '
CREAT1:	DEFM	'xxx01 - xxxzz'
	DEFB	0DH
	DEFB	00H
READER:	DEFM	'- Can''t read record '
	DEFB	00H
OPENER:	DEFM	'- Can''t open file '
	DEFB	00H
MTRMSG:	DEFM	'Do you have a cassette motor control (Y/N) ? '
	DEFB	00H
	END	STKSPC
                                                                                                                                                                                                                                                                