SORT(1)             UNIX Programmer's Manual              SORT(1)



NAME
     sort - sort or merge files

SYNOPSIS
     sort [ -mubdfinrtx ] [ +pos1  [ -pos2 ] ] ...  [ -o name ] [
     -T directory ] [ name ] ...

DESCRIPTION
     Sort sorts lines of all the named files together and writes
     the result on the standard output.  The name `-' means the
     standard input.  If no input files are named, the standard
     input is sorted.

     The default sort key is an entire line.  Default ordering is
     lexicographic by bytes in machine collating sequence.  The
     ordering is affected globally by the following options, one
     or more of which may appear.

     b    Ignore leading blanks (spaces and tabs) in field com-
          parisons.

     d    `Dictionary' order: only letters, digits and blanks are
          significant in comparisons.

     f    Fold upper case letters onto lower case.

     i    Ignore characters outside the ASCII range 040-0176 in
          nonnumeric comparisons.

     n    An initial numeric string, consisting of optional
          blanks, optional minus sign, and zero or more digits
          with optional decimal point, is sorted by arithmetic
          value.  Option n implies option b.

     r    Reverse the sense of comparisons.

     tx   `Tab character' separating fields is x.

     The notation +pos1 -pos2 restricts a sort key to a field
     beginning at pos1 and ending just before pos2.  Pos1 and
     pos2 each have the form m.n, optionally followed by one or
     more of the flags bdfinr, where m tells a number of fields
     to skip from the beginning of the line and n tells a number
     of characters to skip further.  If any flags are present
     they override all the global ordering options for this key.
     If the b option is in effect n is counted from the first
     nonblank in the field; b is attached independently to pos2.
     A missing .n means .0; a missing -pos2 means the end of the
     line.  Under the -tx option, fields are strings separated by
     x; otherwise fields are nonempty nonblank strings separated
     by blanks.




Printed 1/4/85          10 February 1983                        1






SORT(1)             UNIX Programmer's Manual              SORT(1)



     When there are multiple sort keys, later keys are compared
     only after all earlier keys compare equal.  Lines that oth-
     erwise compare equal are ordered with all bytes significant.

     These option arguments are also understood:

     c    Check that the input file is sorted according to the
          ordering rules; give no output unless the file is out
          of sort.

     m    Merge only, the input files are already sorted.

     o    The next argument is the name of an output file to use
          instead of the standard output.  This file may be the
          same as one of the inputs.

     T    The next argument is the name of a directory in which
          temporary files should be made.

     u    Suppress all but one in each set of equal lines.
          Ignored bytes and bytes outside keys do not participate
          in this comparison.

EXAMPLES
     Print in alphabetical order all the unique spellings in a
     list of words.  Capitalized words differ from uncapitalized.

             sort -u +0f +0 list

     Print the password file (passwd(5)) sorted by user id number
     (the 3rd colon-separated field).

             sort -t: +2n /etc/passwd

     Print the first instance of each month in an already sorted
     file of (month day) entries.  The options -um with just one
     input file make the choice of a unique representative from a
     set of equal lines predictable.

             sort -um +0 -1 dates

FILES
     /usr/tmp/stm*, /tmp/*    first and second tries for tem-
     porary files

SEE ALSO
     uniq(1), comm(1), rev(1), join(1)

DIAGNOSTICS
     Comments and exits with nonzero status for various trouble
     conditions and for disorder discovered under option -c.




Printed 1/4/85          10 February 1983                        2






SORT(1)             UNIX Programmer's Manual              SORT(1)



BUGS
     Very long lines are silently truncated.





















































Printed 1/4/85          10 February 1983                        3
