rem - program VBS.BAS
rem - Verify Bank Statement
rem - copyright 1982, by Peter C. Hawxhurst
rem - revised 07/27/1982
rem - variable tabulation ************************
rem   a   = transaction amount
rem   a1$ = account type 1
rem   a2$ = account type 2
rem   a3$ = account type 3
rem   b   = bank statement balance
rem   b1  = account 1 balance
rem   b2  = account 2 balance
rem   b3  = account 3 balance
rem   c   = transaction code
rem   d$  = transaction date
rem   n   = transaction number
rem   q1$ = question 1 - transaction received
rem   q2$ = question 2 - data verifies
rem   q3$ = question 3 - cancel transaction
rem   q4$ = question 4 - other transactions
rem   s1  = end switch
rem   s2  = first pass switch
rem   s3  = file error switch
rem   t   = transaction tax percentage
rem   t1  = budget debit total
rem   t2  = budget credit total
rem   t3  = allowance debit total
rem   t4  = allowance credit total
rem   t5  = savings debit total
rem   t6  = savings credit total
rem   t$  = transaction description
rem   v   = transaction cancellation code
rem   x%  = file rename value
rem - program structure **************************
gosub 100 : rem - housekeeping
10 if s1=1 then 20
gosub 200 : rem - process
goto 10
20 gosub 300 : rem - end of job
chain "SSPM"
100 rem - housekeeping subroutine ****************
dim t$(26)
let s2=1
let s4=1
open "B:CSF.DAT" as 1
if end #1 then 110
goto 120
110 gosub 400 : rem - file error
120 if s1=1 then 190
create "B:TRANS" as 2
open "B:SDF.DAT" as 3
read #3;a1$,b1,a2$,b2,a3$,b3
close 3
read #1;n,d$,c,t$,a,v,t
190 return
200 rem - process subroutine *********************
if s2=0 and v=0 then 210
if s2=0 then 211
if s4=0 then 204
let s4=0
print chr$(27)+")";
print chr$(27)+"="+chr$(49)+chr$(38);
print "Creating transaction file - ";
print "please wait"
print chr$(27)+"(";
204 if v=1 then 220
let s2=0
gosub 3000 : rem - screen
205 gosub 15000 : rem - cursor
input "Enter account number or 0 for all >";q9$
if q9$="0" then 211
let x$=q9$
gosub 7000 : rem - numeric check
if e1=1 then print chr$(7)
if e1=1 then 205
if val(q9$)=int(val(q9$)) then 207
206 print chr$(7)
goto 205
207 if val(q9$)>0 and val(q9$)<4 then 211
goto 206
210 gosub 4000 : rem - clear
211 if v=1 then 220
if val(q9$)=0 then 215
if val(q9$)=1 and c<3 then 215
if val(q9$)=2 and c=3 then 215
if val(q9$)=2 and c=4 then 215
if val(q9$)=3 and c>4 then 215
goto 220
215 gosub 500 : rem - interrogate
if v=1 then 220
if c=1 then let t1=t1+a
if c=2 then let t2=t2+a
if c=3 then let t3=t3+a
if c=4 then let t4=t4+a
if c=5 then let t5=t5+a
if c=6 then let t6=t6+a
220 print #2;n,d$,c,t$,a,v,t
if end #1 then 230
goto 240
230 gosub 600 : rem - other trans
240 if s1=1 then 290
read #1;n,d$,c,t$,a,v,t
290 return
300 rem - end of job subroutine ******************
if s3=1 then 390
close 2
delete 1
x%=rename ("B:CSF.DAT","B:TRANS")
gosub 15000 : rem - cursor
input "Enter statement balance >";b
print chr$(26)
print "STATEMENT BALANCE";
print tab (35);" ";
print using "######.##";b
print
print "DEPOSITS NOT DEBITED";
print tab(35);" ";
print using "######.##";t1+t3+t5
print
print "LESS WITHDRAWALS NOT CREDITED";
print tab(35);" ";
print using "######.##";t2+t4+t6
print
print "CURRENT BALANCE";
print tab(34);" ";
print using "$$#####.##";b+t1+t3+t5-t2-t4-t6
print
print
if q9$="0" then print "Run CASH BALANCES SUMMARY ";
if q9$="0" then print "for breakdown by account."
gosub 15000 : rem - cursor
input "Press - RETURN - to return to menu";line q$
390 return
400 rem - file error subroutine ******************
print
print "ERROR - NO DATA ON FILE!!!"
print
input "Press - RETURN - to return to menu";line q$
close 1
close 2
delete 2
let s1=1
return
500 rem - interrogate subroutine *****************
510 print chr$(27)+"="+chr$(38)+chr$(53);n
print chr$(27)+"="+chr$(38)+chr$(71);d$
print chr$(27)+"="+chr$(40)+chr$(53);
if c=1 then print a1$;" - DEPOSIT"
if c=2 then print a1$;" - WITHDRAWAL"
if c=3 then print a2$;" - DEPOSIT"
if c=4 then print a2$;" - WITHDRAWAL"
if c=5 then print a3$;" - DEPOSIT"
if c=6 then print a3$;" - WITHDRAWAL"
print chr$(27)+"="+chr$(42)+chr$(53);t$
print chr$(27)+"="+chr$(44)+chr$(53);
print using "$$####.##";a
print chr$(27)+"="+chr$(44)+chr$(76);t
if q2$="N" then 530
520 gosub 15000 : rem - cursor
input "Transaction received (y/n) >";q1$
q1$=ucase$(q1$)
if q1$<>"Y" and q1$<>"N" then 520
if q1$="N" then 590
530 gosub 15000 : rem - cursor
input "Does data verify (y/n) >";q2$
q2$=ucase$(q2$)
if q2$<>"Y" and q2$<>"N" then 530
if q2$="Y" then 540
gosub 14000 : rem - correct
goto 530
540 gosub 15000 : rem - cursor
input "Cancel transaction (y/n) >";q3$
q3$=ucase$(q3$)
if q3$<>"Y" and q3$<>"N" then 540
if q3$="Y" then let v=1
if q3$="N" then let v=0
590 return
600 rem - other transactions subroutine **********
610 gosub 15000 : rem - cursor
620 print "Are there other transactions ";
input "to record (y/n) >";q4$
q4$=ucase$(q4$)
if q4$<>"Y" and q4$<>"N" then 610
if q4$="N" then 680
gosub 5000 : rem - input
gosub 15000 : rem - cursor
630 input "Is above data correct (y/n) >";q2$
q2$=ucase$(q2$)
if q2$<>"Y" and q2$<>"N" then 630
if q2$="N" then gosub 14000 : rem - correct
if q2$="N" then goto 630
let v=1
let t=0
print #2;n,d$,c,t$,a,v,t
goto 610
680 let s1=1
return
3000 rem screen subroutine ************************
print chr$(26)
print chr$(27)+")";
print tab(2);"STATEMENT VERIFICATION";
print tab(36);"Entry No: ";tab(46);" ";
let p=p+1
print using "##";p
print
print tab(1);" ";
for i%=1 to 48
print "-";
next i%
print
print tab(27);"(1)";tab(47);"(2)"
print tab(2);"Transaction Number: ";
print tab(33);"Date: "
print tab(27);"(3)"
print tab(4);"Transaction Code: "
print tab(27);"(4)"
print tab(9);"Description: "
print tab(27);"(5)";tab(47);"(6)"
print tab(2);"Transaction Amount: ";
print tab(35);"Tax Rate: ";tab(49);"%"
print
print tab(1);" ";
for i%=1 to 48
print "-";
next i%
print
print
print tab(2);"Accounts: ";"1 = ";a1$;" 2 = ";a2$;
print " 3 = ";a3$
print
print tab(2);"Transaction Type: ";
print tab(21);"D = Deposit";tab(36);"W = Withdrawal"
print chr$(27)+"(";
return
4000 rem - clear subroutine ***********************
print chr$(27)+"="+chr$(38)+chr$(53);
for i%=1 to 9
print " ";
next i%
print chr$(27)+"="+chr$(38)+chr$(71);
for i%=1 to 10
print " ";
next i%
print
print chr$(27)+"="+chr$(40)+chr$(53);
for i%=1 to 27
print " ";
next i%
print
print chr$(27)+"="+chr$(42)+chr$(53);
for i%=1 to 27
print " ";
next i%
print
print chr$(27)+"="+chr$(44)+chr$(53);
for i%=1 to 9
print " ";
next i%
print chr$(27)+"="+chr$(44)+chr$(78);
print "  "
print chr$(27)+"="+chr$(34)+chr$(78);
print "  ";
let p=p+1
print chr$(27)+"="+chr$(34)+chr$(78);
print using "##";p
return
5000 rem - input subroutine ***********************
gosub 6000 : rem - trans number
gosub 8000 : rem - date
gosub 10000 : rem - code
gosub 11000 : rem - description
gosub 12000 : rem - amount
gosub 13000 : rem - tax rate
5900 return
6000 rem - trans number subroutine ****************
6100 gosub 15000 : rem - cursor
input "Enter transaction number >";n$
if len(n$)>9 then 6200
goto 6300
6200 gosub 15000 : rem - cursor
print chr$(27)+")";
print "Error - number too long; 9 digits max!!!"
print tab(1);" ";
input "Press - RETURN - to retry >";line q$
print chr$(27)+"(";
goto 6100
6300 let x$=n$
gosub 7000 : rem - numeric check
if e1=0 then 6400
goto 6100
6400 print chr$(27)+"="+chr$(38)+chr$(53);
for i%=1 to 9
print " ";
next i%
print
print chr$(27)+"="+chr$(38)+chr$(53);
print n$
let n=val(n$)
return
7000 rem - numeric check subroutine ***************
let e1=0
let x=0
let y=0
let z=0
let y=y+match(".",x$,1)
for i%=1 to len(x$)
let z=z+i%
next i%
if y=0 then 7100
let z=z+1
7100 for i%=1 to len(x$)
let x=x+match("#",x$,i%)
next i%
if x=z then 7900
let e1=1
gosub 15000 : rem - cursor
print chr$(27)+")";
print "Error - non numeric data!!!"
print tab(1);" ";
input "Press - RETURN - to retry >";line q$
print chr$(27)+"(";
7900 return
8000 rem - date subroutine ************************
8100 gosub 15000 : rem cursor
input "Enter transaction date (MM/DD/YYYY) >";d$
gosub 9000 : rem - date verification
if e1=0 then 8200
goto 8100
8200 print chr$(27)+"="+chr$(38)+chr$(71);
print d$
return
9000 rem - date verification subroutine ***********
let e1=0
if len(d$)>10 then 9100
let x=0
for i%=1 to 10
let x=x+match("#",d$,i%)
next i%
if x<>57 then 9100
let p1$=left$(d$,2)
let p2$=mid$(d$,4,2)
let p3$=right$(d$,4)
if val(p1$)<1 then 9100
if val(p1$)>12 then 9100
if val(p2$)<1 then 9100
if val(p3$)<1 then 9100
if val(p1$)=9 and val(p2$)>30 then 9100
if val(p1$)=4 and val(p2$)>30 then 9100
if val(p1$)=6 and val(p2$)>30 then 9100
if val(p1$)=11 and val(p2$)>30 then 9100
if val(p1$)=2 and val(p2$)>29 then 9100
if val(p3$)/4=int(val(p3$)/4) then 9900
if val(p1$)=2 and val(p2$)>28 then 9100
goto 9900
9100 gosub 15000 : rem - cursor
print chr$(27)+")";
print "Error - improper date!!!"
print tab(1);" ";
input "Press - RETURN - to retry >";line q$
print chr$(27)+"(";
let e1=1
9900 return
10000 rem - code subroutine ***********************
10100 gosub 15000 : rem - cursor
input "Enter account number from above >";c1$
let x$=c1$
gosub 7000
if e1=1 then 10100
if val(c1$)<>int(val(c1$)) then 10200
if val(c1$)>0 and val(c1$)<4 then 10300
10200 gosub 15000 : rem - cursor
print chr$(27)+")";
input "Error!!! Press - RETURN - to retry >";line q$
print chr$(27)+"(";
goto 10100
10300 gosub 15000 : rem - cursor
input "Enter transaction type from above >";c2$
let c2$=ucase$(c2$)
if c2$<>"D" and c2$<>"W" then 10200
if c2$="D" then 10400
if c2$="W" then 10700
10400 if val(c1$)<>1 then 10500
let c=1
goto 10800
10500 if val(c1$)<>2 then 10600
let c=3
goto 10800
10600 let c=5
goto 10800
10700 let c=val(c1$)*2
10800 print chr$(27)+"="+chr$(40)+chr$(53);
if c=1 then print "BUDGET DEPOSIT - ";
if c=2 then print "BUDGET WITHDRAWAL - ";
if c=3 then print "PERSONAL DEPOSIT - ";
if c=4 then print "PERSONAL WITHDRAWAL - ";
if c=5 then print "SAVINGS DEPOSIT - ";
if c=6 then print "SAVINGS WITHDRAWAL - ";
print c
return
11000 rem - description subroutine ****************
11100 gosub 15000 : rem - cursor
input "Enter description >";t$
let t$=ucase$(t$)
if len(t$)<26 then 11200
gosub 15000 : rem - cursor
print chr$(27)+")";
print "Error - description too long!!!"
print tab(1);" ";
input "Press - RETURN - to retry >";line q$
print chr$(27)+"(";
11200 print chr$(27)+"="+chr$(42)+chr$(53);
print chr$(27)+"R";
print chr$(27)+"="+chr$(42)+chr$(53);
print t$
return
12000 rem - amount subroutine *********************
12100 gosub 15000 : rem - cursor
input "Enter transaction amount >";a$
if len(a$)<10 then 12200
gosub 15000 : rem - cursor
print chr$(27)+")";
print "Error - amount too large!!!"
print tab(1);" ";
input "Press - RETURN - to retry >";line q$
print chr$(27)+"(";
goto 12100
12200 let x$=a$
gosub 7000 : rem - numeric check
if e1=1 then 12100
print chr$(27)+"="+chr$(44)+chr$(53);
let a=val(a$)
print using "######.##";a
return
13000 rem - tax rate subroutine *******************
13100 gosub 15000 : rem - cursor
input "Enter tax rate as XX % >";t1$
let t1$=left$(t1$,2)
let x$=t1$
gosub 7000 : rem - numeric check
if e1=1 then 13100
print chr$(27)+"="+chr$(44)+chr$(76);
let t=val(t1$)
print using "###";t
return
14000 rem - correct subroutine *********************
14200 gosub 15000 : rem - cursor
input "Enter number of item to correct >";q3$
let x$=q3$
gosub 7000 : rem - numeric check
if e1=1 then 14200
if val(q3$)>0 and val(q3$)<7 then 14400
goto 14200
14400 if val(q3$)=int(val(q3$)) then 14500
goto 14200
14500 on val(q3$) gosub 6000,8000,10000,11000,12000,13000
14900 return
15000 rem - cursor subroutine *********************
print chr$(27)+"="+chr$(53)+chr$(33);
print chr$(27)+"R";
print chr$(27)+"="+chr$(54)+chr$(33);
print chr$(27)+"R";
print chr$(27)+"="+chr$(53)+chr$(33);
return
