; Program QSHOW24 based on SHOW by A. R. Miller,
; Published in INTERFACE AGE, Nov. 1981, p. 112 + 170ff.
; Prepared with modifications by W. Silvert, Mar. 1983.
;
; In original version LMAX=22 (display 22 rather
;than 24 lines) and a message was printed to push the
;space bar to continue (see suppressed code on 4
;lines preceeding FREEZE:. Additional code was added
;to check full type of COM files, since original 
;version would not print any other COx types. The high
;bit is zeroed for printing WordStar files, and bells
;are suppressed. 
;
; Note use of CP/M function 6 for input to suppress
;problems with on-screen echoing. 
;
; Original comments are capitalized. Mine are in lower case.
; Not all original comments are included.
;
ORG     100H
LMAX    EQU     24      ;MAX LINES/SCREEN
;
BDOS    EQU     5       
CONS    EQU     6       ;was 1 in original version
TYPEF   EQU     2
PBUF    EQU     9
BRKF    EQU     11
OPENF   EQU     15
READF   EQU     20
;
FCB     EQU     5CH
BUFF    EQU     80H
;
CR      EQU     0DH     ;CARRIAGE RETURN
LF      EQU     0AH     ;LINE FEED
EOF     EQU     1AH
;
; FILE-CONTROL BLOCK DEFINITIONS
;
FCBFN   EQU     FCB+1   ;NAME
FCBFT   EQU     FCB+9   ;TYPE
FCBCR   EQU     FCB+32  ;NEXT RECORD
;
; SAVE OLD STACK, SET UP NEW ONE
;
START:  LXI     H,0
        DAD     SP
        SHLD    OLDSP   ;SAVE STACK
        LXI     SP,STACK
        CALL    SETUP
        CPI     255
        JZ      NOFILE
        LXI     D,LMES
        CALL    PRINT
        MVI     A,80H
        STA     IBP     
        LXI     H,0
;
GLOOP:  PUSH    H
        CALL    GNB
        POP     H
        JC      FINIS
        MOV     B,A
        CPI     EOF
        JZ      FINIS   
        CALL    PCHAR
        MOV     A,B
        ANI     7FH
        CPI     CR
        JNZ     GLOOP
;
        LDA     LCOUNT
        INR     A
        STA     LCOUNT
        CPI     LMAX
        JNZ     GLOOP
;
; FREEZE SCREEN (code for display currently suppressed)
;
;       PUSH    D
;       LXI     D,LMES  ;MESSAGE (if used)
;       CALL    PRINT   ;        (if used)
;       POP     D
        CALL    READ    ;GET THE CHARACTER
        ANI     7FH
        CPI     ' '     ;BLANK
        JNZ     FINIS   ;ABORT
        XRA     A
        STA     LCOUNT
        MVI     A,CR
        CALL    PCHAR
        JMP     GLOOP
;
NOFILE: LXI     D,OPNMSG
        CALL    PRINT
;
FINIS:  CALL    CRLF
        LHLD    OLDSP
        SPHL    
        RET
;
READ:   PUSH H
        PUSH D
        PUSH B
TRY6:   MVI     C,CONS
        MVI     E,0FFH  ;input for CP/M fn 6
        CALL    BDOS
        ORA     A       ;was a key pressed?
        JZ      TRY6
        POP B
        POP D
        POP H
        RET
;
CRLF:   MVI     A,CR
        CALL    PCHAR
        MVI     A,LF
;
PCHAR:  PUSH H
        PUSH D
        PUSH B
        MVI     C,TYPEF
        ANI     7FH     ;set high bit to zero
        MOV     E,A
        CPI     7       ;is the character BEL?
        JZ      NOBEL        
        CALL    BDOS
NOBEL:  POP B
        POP D
        POP H
        RET
;
PRINT:  MVI     C,PBUF
        JMP     BDOS
;
GNB:    LDA     IBP
        CPI     80H
        JNZ     GBYTE
;
        CALL    DISKR
        ORA     A
        JZ      GBYTE
        STC
        RET
;
GBYTE:  MOV     E,A
        MVI     D,0
        INR     A
        STA     IBP
        LXI     H,BUFF
        DAD     D
        MOV     A,M
        ORA     A
        RET
;
SETUP:  XRA     A
        STA     FCBCR
;
; CHECK FOR COM FILE               
;
        LHLD    FCBFT   ;FILE TYPE
        MOV     A,L     ;FIRST CHARACTER
        CPI     'C'
        JNZ     SET2
        MOV     A,H     ;SECOND CHARACTER
        CPI     'O'
        JNZ     SET2
        LHLD    FCBFT+2 ;third char of type
        MOV     A,L
        CPI     'M'
        JNZ     SET2
;
; ABORT IF TYPE=COM
;
        LXI     D,CMES
        CALL    PRINT
        JMP     FINIS
;
SET2:   LXI     D,FCB
        MVI     C,OPENF
        JMP     BDOS
;
; READ DISK FILE RECORD
;
DISKR:  PUSH H
        PUSH D
        PUSH B
        LXI     D,FCB
        MVI     C,READF
        CALL    BDOS
        POP B
        POP D
        POP H
        RET
;
; STORAGE AREA
;
OPNMSG: DB      CR,LF
        DB      'Cannot find file - ERROR$'
CMES:   DB      'Cannot print .COM file'
LMES:   DB      CR,LF
        DB      'QSHOW24, WLS 83/3/5',LF
        DB      'SPACE to continue, else quit...'
        DB      CR,LF,LF,'$'
;
LCOUNT: DB      0       ;LINES PER SCREEN
IBP:    DS      2
OLDSP:  DS      2
;
        DS      30
STACK:
        END                                                                                                                                                                                                                                                                