;SCREEN.ASM - written 02/19/84 by Anthony L. Bruni
;This program dumps the current contents of the screen to
;the lst: device.  Written for Osborne Computers.
;
;*********************************************************
;        equates    equates    equates    equates       **
;*********************************************************
true	equ	0ffffh				       ;**
false	equ	not true			       ;**
;*********************************************************
;		USER DEFINEABLE OPTIONS			**
;*********************************************************
exec	equ	false		;false for osborne 1	**
cpl	equ	52		;lines per screen	**
				;52 for ozzy 1 without	**
				;80 col. modification	**
compr	equ	true		;true if you want the	**
				;printer output in	**
				;compressed mode	**
				;(using Epson control	**
				;codes)			**
formf	equ	false		;true for form feed	**
				;after printout		**
;*********************************************************
;		NO MODS AFTER HERE			**
;*********************************************************
bdos	equ	0005h		;bdos entry point	**
cr	equ	0dh		;carriage return	**
lf	equ	0ah		;line feed		**
ff	equ	0ch		;form feed		**
lps	equ	24		;lines per screen	**
cmpr	equ	15		;epson compressed switch**
norm	equ	18		;cancel compressed	**
;
if	exec
addr	equ	0C000h
	endif
;
if	not exec
addr	equ	0F000h
	endif
;
	org	0100h		;where else?
;
start:
if	exec
	in	0		;exec bank switching
	sta	oldio		;routine
	ori	40h
	out	0
	endif
;
	lxi	h,0		;save the CCP's stack
	dad	sp
	shld	exstack
	lxi	sp,stak		;set up internal one
	mvi	b,cpl		;b holds cpl count
	mvi	d,lps		;d holds lps count
	lxi	h,addr		;the first screen loc.
;
if	compr
	mvi	e,cmpr		;turn on compressed
	call	chrout		;print mode
	endif
;
loop:
	mov	a,m		;read the byte here
	ani	07fh		;strip inv. video bit
	mov	e,a		;the char must be here
	call	chrout		;print it
	inx	h		;point to next location
	dcr	b		;one less char in line
	jnz	loop		;print another char if
				;not done.
	mvi	e,cr		;send a cr/lf to the
	call	chrout		;lst: device
	mvi	e,lf
	call	chrout
	mvi	c,48+(80-cpl)	;offset for start of
				;next line
	dad	b		;skip screen posn's not
				;shown (128-80 = 48)
	dcr	d		;one less line to print
	jz	exit		;if none left, exit
	mvi	b,cpl		;restore b to counter
	jmp	loop		;keep going
;
chrout:				;send the character
	push h! push d! push b	;save local environment
	mvi	c,5		;function to output a
	call	bdos		;byte to lst:
	pop b! pop d! pop h	;restore environment
	ret
;
exit:	
if	compr
	mvi	e,norm		;cancel compressed mode
	call	chrout
	endif
;
if	formf
	mvi	e,ff		;send form feed to lst:
	call	chrout
	endif
;
if	exec
	lda	oldio		;get old banks enabled
	out	0		;and reset them
	endif
;
	lhld	exstack		;restore ext. stack
	sphl
	ret			;return to CCP
;
oldio:	db	0		;save a space for this
exstack: dw	0		;space for ext. SP
;
;	internal stack area
	ds	32		;space for a small stack
stak:
;
	end	0100h
