/*
	osbdscio.h = bdscio.h modified for
		    the Osbourne 1

	by:	Dan Sunday
		7473 Broken Staff
		Columbia, MD 21044
		(301)-730-6838

	date:	4-11-82
 */
/*
	The BDS C Standard I/O header file --  v1.44	4/3/81

	This file contains global definitions, for use in all C programs
	in PLACE of (yechhh) CONSTANTS. Characteristics of your system 
	such as video screen size, interface port numbers and masks,
	buffered I/O allocations, etc., should all be configured just
	once within this file. Any program which needs them should
	contain the preprocessor directive:

		#include "bdscio.h"

	near the beginning. 

	Go through and set this stuff as soon as you get the package,
	and most terminal-dependent sample programs should run better.

*/


/*
	Some console (video) terminal characteristics:
	(configured for the Osbourne 1)
*/

#define TWIDTH	52	/* # of columns	*/
#define TLENGTH	24	/* # of lines	*/

#define ESC	'\033'	/* Standard ASCII 'escape' character	*/
#define DEL	'\177'
#define RUB_OUT	DEL

#define CTRL	037 &			/* Control Mask */
#define BELL	(CTRL 'G')
#define TAB	(CTRL 'I')
#define CR	(CTRL 'M')		/* Carriage Return */
#define BS	(CTRL 'H')		/* Back Space */
#define LF	(CTRL 'J')		/* Line Feed */
#define VT	(CTRL 'K')		/* Vertical Tab */
#define FF	(CTRL 'L')		/* Form Feed */

#define SOH	(CTRL 'A')
#define STX	(CTRL 'B')
#define ETX	(CTRL 'C')
#define EOT	(CTRL 'D')
#define ENQ	(CTRL 'E')
#define ACK	(CTRL 'F')
#define NAK	(CTRL 'U')
#define SYN	(CTRL 'V')
#define CAN	(CTRL 'X')

/* Osbourne CP/M Cursor Controls */
#define LEFT	BS		/* Cursor Left */
#define RIGHT	FF		/* Cursor Right */
#define UP	VT		/* Cursor Up */
#define DOWN	LF		/* Cursor Down */

/* Osbourne Console Control Strings */
#define CLEARS	"\032"
#define SHI	"\033)"	/* start half intensity */
#define EHI	"\033("	/* end half intensity */
#define SGR	"\033g"	/* start graphics mode */
#define EGR	"\033G"	/* end graphics mode */
#define SUL	"\033l"	/* start underlining */
#define EUL	"\033m"	/* end underlining */

#define IC	"\033Q"	/* insert character */
#define IL	"\033E"	/* insert line */
#define DC	"\033W"	/* delete character */
#define DL	"\033R"	/* delete line */
#define CL	"\033T"	/* clear to end of line */

#define CUR	"\033="	/* set cursor */
#define SCR	"\033S"	/* set screen */
#define LOCK	"\033#"	/* lock keyboard */
#define UNLOCK "\033\""	/* unlock keyboard */

/*
	Modem Constants
*/
#define SPECIAL	ESC
#define ABORT	(-1)
#define TIMEOUT	(-2)

/*
	General purpose Symbolic constants:
*/

#define BASE	0	/* Base of CP/M system RAM (0 or 0x4200)  */
#define SECSIZ	128	/* Sector size for CP/M read/write calls */
#define MAXLINE	128	/* Longest line of console input expected */

#define ON	1
#define OFF	0
#define TRUE	1
#define FALSE	0
#define YES	1
#define NO	0
#define NONE	0
#define NULL	0
#define OK	0
#define ERROR	(-1)
#define EOF	(-1)
#define CPMEOF	(CTRL 'Z')


/*
   The NSECTS symbol controls the compilation of the buffered
   I/O routines within STDLIB2.C, allowing each user to set the
   buffer size most convenient for his system, while keeping
   the numbers totally invisible to the C source programs using
   buffered I/O (via the BUFSIZ defined symbol.) For larger
   NSECTS, the disk I/O is faster...but more ram is taken up.
   Note that pre-1.4 versions of the library functions
   were not set up to support this customizable buffer size,
   and always compiled as if NSECTS were 1 in this version. To
   change the buffer size allocation, follow these steps:

     1) Alter NSECTS to the desired value here in bdscio.h
     2) Re-compile STDLIB1.C and STDLIB2.C
     3) Use CLIB to combine STDLIB1.CRL and STDLIB2.CRL to make
  	a new DEFF.CRL.

   Make sure you use declare all your I/O buffers with the a
   statement such as:
  		char buf_name[BUFSIZ];
  	 instead of the older and now obsolete:
  		char buf_name[134];
   	(and always #include "bdscio.h" in your programs!)
*/

#define NSECTS 8	/* Number of sectors to buffer up in ram */

#define BUFSIZ (NSECTS * SECSIZ + 6 )	/* Don't touch this */

#define FILE	struct _buf

struct _buf {				/* Or this...	    */
	int _fd;
	int _nleft;
	char *_nextp;
	char _buff[NSECTS * SECSIZ];
};



/*
	If you plan to use the high-level storage allocation functions
	from the library ("alloc" and "free") then:

	  1) Uncomment (enable) the "ALLOC_ON" definition, and
	     comment out the "ALLOC_OFF" definition from this file.

	  2) Re-compile STDLIB1.C, and use CLIB to transfer "alloc"
	     and "free" into the DEFF.CRL library file.

	  3) THIS IS IMPORTANT!!! Include the statement:

		_allocp = NULL;	   /* initialize allocation pointer */

	     somewhere in your "main" function PRIOR to the first use
	     of the "alloc" function. DON'T FORGET THIS INITIALIZATION!!

	Remember to include bdscio.h in ALL files of your C program.

	The lack of static variables is the reason for all this junk.
*/

/* only ONE of the following two lines should be uncommented */
/***
#define ALLOC_OFF 1	/* disables storage allocation if uncommented */
 ***/
#define ALLOC_ON 1	/* enables storgage allocation if uncommented */


#ifdef ALLOC_ON			/* if storage allocation enabled, */

struct _header  {
	struct _header *_ptr;
	unsigned _size;
 };

struct _header _base;		/* declare this external data to  */
struct _header *_allocp;	/* be used by alloc() and free()  */

#endif
