;
;	PRNTON.ASM -- Console print enable program
;		      01/05/84 Version -- Kim Levitt
;
;		This tiny program will set up a BIOS patch so that all
;	console output is also redirected to the printer. Unlike the
;	cntrl-P function, it is not disabled by a warm boot or starting
;	MBASIC, etc. It is set up so it should work on any CP/M system,
;	as long as the reserved bytes 50H-57H in page zero are not being
;	used for any other purpose. (Thanks to Barry Cole for basic idea
;	and previous programs which worked similarly.) Printer output
;	is disabled via a cold boot.
;
	ORG	100H
;
	PUSH	PSW	;SAVE REGS
	PUSH	H
;
; PUT CODE AT 50H IN PAGE ZERO
;
	MVI	A,0C5H	;PUSH BC
	STA	50H
	MVI	A,0CDH	;CALL
	STA	51H
	MVI	A,0C1H	;POP BC
	STA	54H
	MVI	A,0C3H	;JUMP
	STA	55H
;
; COPY VECTORS FROM BIOS TABLE
;
	LHLD	1
	MVI	L,0DH	; HL=ADDR OF CONOUT ADDR IN JUMP TABLE
	PUSH	H	; SAVE FOR USE BELOW
	MOV	A,M
	STA	52H
	INX	H
	MOV	A,M
	STA	53H
	INX	H
	INX	H	; HL=ADDR OF LSTOUT ADDR IN JUMP TABLE
	MOV	A,M
	STA	56H
	INX	H
	MOV	A,M
	STA	57H
;
; PATCH CALL TO 50H
;
	POP	H	; ADDR OF CONOUT IN JUMP TABLE
	MVI	A,50H
	MOV	M,A
	INX	H
	MVI	A,0
	MOV	M,A	; MAKE JMP CONOUT TO JMP 50H
;
	POP	H	;RESTORE REGS
	POP	PSW
	RET		;RETURN TO CCP
;
	END
