;  MODULE:  VFILERSC
;  AUTHOR:  RICHARD CONN
;  VERSION:  1.0
;  DATE:  18 July 83
;  PREVIOUS VERSIONS:  None
;  NOTE:  This is the patch file for VFILER.  It allows the user to install
;	his terminal-specific function routines.  This file is to be assembled
;	by the user and integrated into VFILER.COM via DDT.  Once complete,
;	VFILER must be installed further via GENINS.
;

;
;  An entry point to send the character in A to the screen is provided at
;  location 300H in VFILER.  No registers are affected by calling the
;  routine at this address.
;
TYPE	EQU	300H

;
;  Special ASCII Characters Used
;
ESC	EQU	1BH
CTRLZ	EQU	'Z'-'@'
UP	EQU	'K'-'@'		; user-defined cursor up
DOWN	EQU	'V'-'@'		; user-defined cursor down
RIGHT	EQU	'L'-'@'		; user-defined cursor right
LEFT	EQU	'H'-'@'		; user-defined cursor left
SCR$FOR	EQU	'F'-'@'		; user-defined screen forward
SCR$BAC	EQU	'A'-'@'		; user-defined screen backward

;
;  The following JUMP Table MUST be located at 200H in VFILER.  This accesses
;  the required routines.
;
	ORG	200H		; base page for screen routines
	JMP	CLS		; clear screen on CRT
	JMP	GOTOXY		; position cursor at row/col
	JMP	EREOL		; erase to end of line

;
;  The following table is copied by VFILER on startup to define the special
;  characters generated by arrow keys on the user's terminal for cursor
;  movement.  This table is for the TVI 950.  If you do not wish to set
;  additional definitions, set all of these values to '@'.
;
	DB	UP,DOWN,RIGHT,LEFT	;cursor up, down, right, left
	DB	SCR$FOR,SCR$BAC		;screen forward, backward

;
; Screen Routines (for TVI 950)
;   The following are sample routines implemented for the TVI 950.
;   NO REGISTERS are to be affected by these routines except for the PSW.
;   The GOTOXY routine is the only one which receives passed parameters.
; HL is used to pass them, and the value range is 1-24 for H and 1-80 for L.
;

;  clear screen
CLS:
	MVI	A,CTRLZ		;clear screen
	JMP	TYPE

;  position cursor (H=row, L=col) where 1,1=upper left
GOTOXY:
	MVI	A,ESC		;ESCape
	CALL	TYPE
	MVI	A,'='
	CALL	TYPE
	MOV	A,H		;row
	ADI	' '
	CALL	TYPE
	MOV	A,L		;column
	ADI	' '
	JMP	TYPE

;  erase to end of line (output 50 spaces if you don't have this function)
EREOL:
	MVI	A,ESC		;ESCape
	CALL	TYPE
	MVI	A,'T'
	JMP	TYPE

	END
