;
;dasmtdl.asm  revised with 8080 mnemonics  10-9-84 msb
;DASMTDL.MAC from DASM.TDL (ver. 3.0)
;The following routine is the disassembler module for TDL Mnemonics in DASM.
;It is included during the assembly of DASM by M80.
;
	IF1
	.PRINTX	/DASM with TDL Mnemonics/
	ENDIF
;
;  This is the Header to be printed for this module by DASM
;
HEADER:
	DEFB	'DASM for TDL Mnemonics',0dh,0ah
	DEFB	'	Derived from ZZSOURCE/RESOURCE',0dh,0ah
	DEFB	0dh,0ah,'$',0
;
;  This is the main Disassembler module; the instruction to be disassembled
;    is pted to by PC
;
DASM:	CALL	HSYM		;write a symbol if it exists, then put PC
	LD	HL,(RPLPTR)	;IS THIS ENTIRE LINE TO BE REPLACED?
	LD	A,H
	OR	L
	JP	Z,DASM1
	LD	B,(HL)
	INC	HL
	DEC	B
	CALL	NWLN0
DASM1:	LD	HL,(PC)							
	EX	DE,HL		;DE hold the PC
	LD	HL,(OFFSET)
	ADD	HL,DE		;HL is now the biased PC
	LD	(BIASED),HL
	EX	DE,HL
	INC	HL
	LD	(PC),HL		;the new PC (next byte)
	EX	DE,HL		;DE is byte after instruction address
	LD	B,(HL)		;get the current byte
	LD	HL,OPC
	CALL	GTCD
	CALL	TYPEOC
;
;........TYPE 1, 2, AND 3 ARE 1-BYTE INSTRUCTIONS.
;
	CP	4
	JP	C,OLDPC
;
;........TYPE 9, A, B AND C ARE 1-BYTE INSTRUCTIONS.
;
	CP	9
	JP	C,XTND		;not a 1-byte
	CP	0DH
	JP	C,OLDPC		;is a 1-byte
XTND:	INC	HL
	CP	6
	JP	C,NEWPC		;types 4 & 5 are 2 byte
	CP	9
	JP	NC,NEWPC	;types d, e, f, etc. -2 bytes or more
	INC	HL		;3 bytes for 6, 7, and 8.
NEWPC:	LD	(PC),HL
OLDPC:	PUSH	DE
	LD	E,A
	LD	D,0
	LD	HL,JMPTBL
	ADD	HL,DE		;add 3*opcode type to JMPTBL to
	ADD	HL,DE		;.. get routine jump vector address
	ADD	HL,DE
	POP	DE
	PUSH	HL		;push address
	LD	HL,(BIASED)
	RET			;'return' to routine 
;
;  GO TO JUMP TABLE + 3*(OPCODE TYPE).
;
JMPTBL:	JP	TZERO
	JP	TONE
	JP	TTWO
	JP	TTHREE
	JP	TFOUR
	JP	TFIVE
	JP	TSIX
	JP	TSEVEN
	JP	TEIGHT
	JP	TNINE
	JP	TTEN
	JP	TELEVEN
;				New decode routines
	JP	T12		;bit, res, set
	JP	T13		;djnz, jmpr
	JP	T14		;jrxx
	JP	T15		;the 'cb' series
	JP	T16		;'db' generation
	JP	T17		;the 'dd' series
	JP	T18		; "  'fd'    "
	JP	T19		; "  'ed'    "
	JP	T20		;  2 byte dd/fd
	JP	T21		;  "   "    "
	JP	T22		;  "   "    "
	JP	T23		;  3 byte dd/fd
	JP	T24		;  "   "    "
	JP	T25		;  "   "    "
	JP	T26		;  LXIii nn
	JP	T27		;  LIiiD, SIxxD
	JP	T28		;  mvi	d(ii),n
	JP	T29		;  the 4 byte 'cb' series
	JP	T30		;  inc/dec/repeat group
	JP	T31		;  4 byte direct store	
;
GTCD:	LD	DE,6
;
;  FIND THE OPCODE FOR THIS BYTE.
;
NXTCD:	ADD	HL,DE
	LD	A,(HL)		;get mask
	AND	B
	INC	HL		;point to compare byte.
	CP	(HL)
	JP	NZ,NXTCD
	INC	HL
	LD	A,(HL)		;get type
	LD	(OPCTP),A
	RET	
;
;  TYPE THE OPCODE MNEMONIC.
;
TYPEOC:	LD	B,4		;maximum of 4 characters to type
TYPEC1:	INC	HL
	LD	A,(HL)
	CP	'.'		;do not type '.'
	CALL	NZ,COUT
	dec	b
	jp	NZ,TYPEC1	; **
	LD	HL,(PC)
	LD	A,(OPCTP)
	RET	
;
;  SIMPLE ONE BYTE INSTRUCTIONS.
;
TZERO:	JP	DCRLF
;
;  ARITHMETIC AND LOGICAL INSTRUCTIONS.
;
TONE:	CALL	TAB
REG0:	CALL	PREG0
	JP	DCRLF
;
;  DCR AND INR INSTRUCTIONS.
;
TTWO:	CALL	TAB
	CALL	PREG1
	JP	DCRLF
;
;  DOUBLE REGISTER NON-IMMEDIATES.
;
TTHREE:	CALL	TAB
	LD	E,'H'
	CALL	PXREG
	JP	DCRLF
;
;  THE 'MVI' INSTRUCTIONS.
;
TFOUR:	CALL	TAB
	CALL	PREG1
T4PT:	CALL	COMMA
	JP	BYTWO
;
;  REGISTER IMMEDIATES (EXCEPT MVI) AND IN & OUT.
;
TFIVE:	CALL	TAB
BYTWO:	LD	HL,(BIASED)
	INC	HL
	LD	(BIASED),HL
DTABYT:	LD	A,(HL)
	CP	' '
	JP	C,NOTASC
	CP	5BH
	JP	NC,NOTASC
;
;...ONLY TYPE 4 & 5 WITH ASCII DATA BYTES GET HERE.
;
	LD	A,(HL)
	CALL	PASCII
	LD	A,''''
	CALL	COUT
	LD	A,(XCSW)	;IS SYMBOL COMMENTING ON?
	OR	A
	JP	Z,DCRLF
	CALL	TAB
	CALL	SEMI
;
;..THE DATA BYTE SHOULD NOT BE PRINTED AS ASCII.
;
NOTASC:	LD	A,(HL)
	CP	0AH
	JP	C,NTSC0
	CALL	PASHEX
	LD	A,'H'
	CALL	COUT
	JP	DCRLF
NTSC0:	ADD	A,'0'
	CALL	COUT
	JP	DCRLF
;
;  THE LXI INSTRUCTION.
;
TSIX:	CALL	TAB
	LD	E,'H'
	CALL	PXREG
T6PT:	CALL	COMMA
;
;  READ THE 2 BYTES AFTER BIASED INTO DE.
;
TWOBYTE:LD	HL,(BIASED)
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	CALL	PRNTDE
	JP	DCRLF
;
;  UNCONDITIONAL JUMPS AND 3-BYTERS WITH ADDRESSES.
;
TSEVEN:	CALL	TAB
	JP	TWOBYTE
;
;  CONDITIONAL CALLS AND JUMPS.
;
TEIGHT:	LD	E,0EH
	CALL	PRNTCND
	LD	HL,(BIASED)
	JP	TSEVEN
;
;  THE CONDITIONAL RETURNS...
;
TNINE:	LD	E,0EH
	CALL	PRNTCND
	JP	DCRLF
;
;  THE RST INSTRUCTION.....
;
TTEN:	CALL	TAB
	LD	A,(HL)
	RRA	
	RRA	
	RRA	
	AND	7
	OR	'0'
	CALL	COUT
	JP	DCRLF
;
TELEVEN:CALL	TAB
	CALL	PREG1
T11PT:	CALL	COMMA
	LD	HL,(BIASED)
	LD	A,(HL)
	JP	REG0
;				ADDED Z-80 ROUTINES
T12:	CALL	TAB		;bit, res, set
	CALL	PBIT
	JP	T11PT
PBIT:	LD	A,(HL)
	RRA	
	RRA	
	RRA	
	AND	7
	ADD	A,'0'
	JP	COUT
T13:	CALL	TAB		;djnz & jmpr
	INC	HL
	LD	A,(HL)
	LD	E,A
	LD	D,0
	LD	HL,(PC)
	OR	A
	JP	P,PSTV
	DEC	D
PSTV:	ADD	HL,DE
	EX	DE,HL
	CALL	PRNTDE
	JP	DCRLF
T14:	LD	E,6		;conditional relative jumps
	CALL	PRNTCND
	LD	HL,(BIASED)
	JP	T13
T15:	INC	HL		;the 'cb' series
	LD	B,(HL)
	LD	(BIASED),HL	;new current byte
	LD	HL,OPC2-6
	CALL	GTCD		;octyp is either 1, 10h or 0ch	
	CALL	TYPEOC
	JP	OLDPC
T16:	LD	HL,(PC)		;a 'db', so back up the pc
	DEC	HL
	LD	(PC),HL
	LD	HL,(BIASED)
	DEC	HL		;back up here too
	JP	PRDB
T17:	LD	E,'X'		;the 'dd' series 
T170:	PUSH	DE
	INC	HL
	LD	(BIASED),HL	;second byte of instruction
	LD	B,(HL)
	LD	HL,OPC3-6
	CALL	GTCD
	CALL	TYPEOC
	POP	DE
	CP	23
	JP	C,OLDPC
	INC	HL
	CP	26
	JP	C,NEWPC
	INC	HL
	JP	NEWPC
T18:	LD	E,'Y'		;the 'fd' series
	JP	T170
T19:	INC	HL		;the 'ed' series
	LD	(BIASED),HL
	LD	B,(HL)
	LD	HL,OPC4-6
	CALL	GTCD
	CALL	TYPEOC
	CP	1FH
	JP	C,OLDPC
	INC	HL
	INC	HL
	JP	NEWPC
T21:	CALL	TAB		;pop x, push x
T20:	LD	A,E		;xtix, etc.
	CALL	COUT
	JP	DCRLF
T22:	LD	A,E
	CALL	COUT
	CALL	TAB
	CALL	PXREG
	JP	DCRLF
T23:	CALL	TAB
T231:	CALL	PDISP
	CALL	PINDX
	JP	DCRLF
PDISP:	INC	HL		;print displacement
	LD	A,(HL)
	CALL	PASHEX
	LD	A,'H'
	JP	COUT
PINDX:	LD	A,'('		;print '(x)'
	CALL	COUT
	LD	A,E
	CALL	COUT
	LD	A,')'		;
	JP	COUT
T24:	CALL	TAB		;mov r,d(ii)
	CALL	PREG1
	CALL	COMMA
	LD	HL,(BIASED)
	JP	T231
T25:	CALL	TAB		;mov d(ii),r
	CALL	PDISP
	CALL	PINDX
	JP	T11PT
T26:	CALL	TAB
	LD	A,E
	CALL	COUT
	JP	T6PT
T27:	LD	A,E
	CALL	COUT
	LD	A,'D'
	CALL	COUT
	JP	TSEVEN
T28:	CALL	TAB		;mvi	d(ii),n
	CALL	PDISP
	CALL	PINDX
	LD	(BIASED),HL
	JP	T4PT
T29:	INC	HL
	INC	HL
	LD	B,(HL)
	LD	HL,OPC2-6
	PUSH	DE
	CALL	GTCD
	POP	DE
	LD	A,B		;get o.c.
	AND	7
	CP	6
	JP	NZ,ILLEG
	CALL	TYPEOC
	LD	HL,(BIASED)
	CP	0CH
	JP	C,T23
	JP	Z,DD12
ILLEG:	LD	HL,(PC)
	DEC	HL
	DEC	HL
	LD	(PC),HL
	JP	T16
DD12:	CALL	TAB
	INC	HL
	INC	HL
	CALL	PBIT
	CALL	COMMA
	DEC	HL
	DEC	HL
	JP	T231
T30:	LD	A,(HL)
	AND	8
	LD	A,'I'
	JP	Z,T301
	LD	A,'D'
T301:	CALL	COUT
	LD	A,(HL)
	AND	10H
	JP	Z,DCRLF
	LD	A,'R'
	CALL	COUT
	JP	DCRLF
T31:	LD	E,'H'
	CALL	PXREG
	LD	A,D
	RRCA	
	LD	D,A
	LD	A,'C'
	DEC	D
	JP	M,T311
	LD	A,'E'
	DEC	D
	JP	M,T311
	LD	A,'L'
	DEC	D
T311:	CALL	NZ,COUT
	LD	A,'D'
	CALL	COUT
	JP	TSEVEN
;
;  THE END OF Z80 ADDITIONS.
;
;  ROUTINES TO PRINT VARIOUS CHARACTERS
;
COMMA:	LD	A,','
	JP	COUT
TAB:	LD	A,9
	JP	COUT
SEMI:	LD	A,';'
	JP	COUT
PRDB:	CALL	PSTG
	DEFB	'DB',9,0
	JP	DTABYT
;
;...PRINT THE CONDITION CODE LETTERS FOR THIS INSTRUCTION.
;
PRNTCND:	LD	A,(HL)
	RRA	
	RRA	
	AND	E
	LD	HL,CNDTAB
	CALL	SKIP
	LD	A,(HL)
	CALL	COUT
	INC	HL
	LD	A,(HL)
	CP	'.'
	CALL	NZ,COUT
	RET	
;
;...PRINT A LEADING QUOTE AND THEN THE ASCII
;  (PRINT '' FOR ').
;
PASCII:	PUSH	AF
	LD	A,''''
	CALL	COUT
	POP	AF
	CP	''''
	JP	NZ,COUT
	PUSH	AF
	CALL	COUT
	POP	AF
	JP	COUT
;
;...PRINT THE FALUE FOR A DOUBLE REGISTER.
;
PXREG:	LD	A,(HL)
	RRA	
	RRA	
	RRA	
	AND	6
	LD	D,A
	CP	4
	JP	NZ,TAGN
	LD	A,E
	JP	COUT
TAGN:	CP	6
	JP	NZ,PREG
	LD	A,(HL)
	AND	0CFH
;
;......IS IT A POP?
;
	CP	0C1H
	JP	Z,PPSW
;
;......IS IT A PUSH?
;
	CP	0C5H
	JP	Z,PPSW
	LD	A,'S'
	CALL	COUT
	LD	A,'P'
	JP	COUT
PPSW:	CALL	PSTG
	DEFB	'PSW',0
	RET	
;
;...READ A BYTE AND PRINT ITS DEST. REGISTER.
;
PREG1:	LD	A,(HL)
	RRA	
	RRA	
	RRA	
	JP	PREG
;
;...READ A BYTE AND PRINT ITS SOURCE REGISTER.
;
PREG0:	LD	A,(HL)
PREG:	LD	HL,REGTAB
	AND	7
	CALL	SKIP
	LD	A,(HL)
	JP	COUT
;
;...ADVANCE H & L BY (A).
;
SKIP:	ADD	A,L
	LD	L,A
	RET	NC
	INC	H
	RET	
;
;...PRINT THE VALUE IN A AS HEX,
;   WITH A LEADING ZERO IF NECESSARY.
;
PASHEX:	CP	0A0H
	JP	C,PHEX
	PUSH	AF
	LD	A,'0'
	CALL	COUT
	POP	AF
	JP	PHEX
;
;...PRINT A SYMBOLIC VALUE FOR (DE)
;
PRNTDE:	PUSH	DE
	CALL	SYMSCH
	POP	DE
	JP	NC,SYMTCH
	LD	A,(BUILD)
	OR	A
	JP	Z,NOBLD
	PUSH	DE
	CALL	BLDSYM
	POP	DE
	JP	NOBLD
SYMTCH:	CALL	PRNT
PDERTN:	LD	A,(XCSW)	;SYMBOL COMMENTING?
	OR	A
	RET	Z
	CALL	TAB
	CALL	SEMI
NOBLD:	LD	A,D
	OR	E
	LD	A,'0'
	JP	Z,NOBLD1
	LD	A,D
	OR	A
	JP	Z,NOBLD2
	CALL	PASHEX
	LD	A,E
	CALL	PHEX
NOBLD0:	LD	A,'H'
NOBLD1:	CALL	COUT
	RET	
NOBLD2:	LD	A,E
	CP	0AH
	JP	C,NOBLD3
	CALL	PASHEX
	JP	NOBLD0
NOBLD3:	ADD	A,'0'
	JP	NOBLD1
;
;...PRINT THE STRING AT (HL) FOR (B) CHARACTERS.
;
PRNT:	LD	A,(HL)
	CALL	COUT
	INC	HL
	dec	b
	jp	NZ,PRNT		; **
	RET	
;
;  OPCODE TABLES
;
CNDTAB:	DEFB	'NZZ.NCC.POPEP.M.'
REGTAB:	DEFB	'BC'
OPC:	DEFB	'DEHLMA'
	DEFB	0FFH,0CEH,5,'ACI.'
	DEFB	0F8H,88H,1,'ADC.'
	DEFB	0F8H,80H,1,'ADD.'
	DEFB	0FFH,0C6H,5,'ADI.'
	DEFB	0F8H,0A0H,1,'ANA.'
	DEFB	0FFH,0E6H,5,'ANI.'
	DEFB	0C7H,0C4H,8,'C...'
	DEFB	0FFH,0CDH,7,'CALL'
	DEFB	0FFH,2FH,0,'CMA.'
	DEFB	0FFH,3FH,0,'CMC.'
	DEFB	0F8H,0B8H,1,'CMP.'
	DEFB	0FFH,0FEH,5,'CPI.'
	DEFB	0FFH,27H,0,'DAA.'
	DEFB	0CFH,9,3,'DAD.'
	DEFB	0C7H,5,2,'DCR.'
	DEFB	0CFH,0BH,3,'DCX.'
	DEFB	0FFH,0F3H,0,'DI..'
	DEFB	0FFH,0FBH,0,'EI..'
	DEFB	0FFH,76H,0,'HLT.'
	DEFB	0FFH,0DBH,5,'IN..'
	DEFB	0C7H,4,2,'INR.'
	DEFB	0CFH,3,3,'INX.'
	DEFB	0C7H,0C2H,8,'J...'
	DEFB	0FFH,0C3H,7,'JMP.'
	DEFB	0FFH,3AH,7,'LDA.'
	DEFB	0EFH,0AH,3,'LDAX'
	DEFB	0FFH,2AH,7,'LHLD'
	DEFB	0CFH,1,6,'LXI.'
	DEFB	0C0H,40H,0BH,'MOV.'
	DEFB	0C7H,6,4,'MVI.'
	DEFB	0FFH,0,0,'NOP.'
	DEFB	0F8H,0B0H,1,'ORA.'
	DEFB	0FFH,0F6H,5,'ORI.'
	DEFB	0FFH,0D3H,5,'OUT.'
	DEFB	0FFH,0E9H,0,'PCHL'
	DEFB	0CFH,0C1H,3,'POP.'
	DEFB	0CFH,0C5H,3,'PUSH'
	DEFB	0C7H,0C0H,9,'R...'
	DEFB	0FFH,17H,0,'RAL.'
	DEFB	0FFH,1FH,0,'RAR.'
	DEFB	0FFH,0C9H,0,'RET.'
	DEFB	0FFH,0FH,0,'RRC.'
	DEFB	0FFH,7,0,'RLC.'
	DEFB	0C7H,0C7H,0AH,'RST.'
	DEFB	0F8H,98H,1,'SBB.'
	DEFB	0FFH,0DEH,5,'SBI.'
	DEFB	0FFH,22H,7,'SHLD'
	DEFB	0FFH,0F9H,0,'SPHL'
	DEFB	0FFH,32H,7,'STA.'
	DEFB	0EFH,2,3,'STAX'
	DEFB	0FFH,37H,0,'STC.'
	DEFB	0F8H,90H,1,'SUB.'
	DEFB	0FFH,0D6H,5,'SUI.'
	DEFB	0FFH,0EBH,0,'XCHG'
	DEFB	0F8H,0A8H,1,'XRA.'
	DEFB	0FFH,0EEH,5,'XRI.'
	DEFB	0FFH,0E3H,0,'XTHL'
;
	DEFB	0FFH,008H,0,'EXAF'
	DEFB	0FFH,0D9H,0,'EXX.'
	DEFB	0FFH,010H,0DH,'DJNZ'
	DEFB	0FFH,018H,0DH,'JMPR'
	DEFB	0E7H,020H,0EH,'JR..'
	DEFB	0FFH,0CBH,0FH,'....';THE 'CB' SERIES
	DEFB	0FFH,0DDH,11H,'....'; "  'DD'    "
	DEFB	0FFH,0FDH,12H,'....'; "  'FD'    "
	DEFB	0FFH,0EDH,13H,'....'; "  'ED'    "
OPC2:	DEFB	0F8H,0,1,'RLCR'
	DEFB	0F8H,8,1,'RRCR'
	DEFB	0F8H,10H,1,'RALR'
	DEFB	0F8H,18H,1,'RARR'
	DEFB	0F8H,20H,1,'SLAR'
	DEFB	0F8H,28H,1,'SRAR'
	DEFB	0F8H,38H,1,'SRLR'
	DEFB	0C0H,40H,0CH,'BIT.'
	DEFB	0C0H,80H,0CH,'RES.'
	DEFB	0C0H,0C0H,0CH,'SET.'
	DEFB	0,0,10H,'....'
OPC3:	DEFB	0FFH,0E3H,14H,'XIT.'
	DEFB	0FFH,0E9H,14H,'PCI.'
	DEFB	0FFH,0F9H,14H,'SPI.'
	DEFB	0FFH,0E1H,15H,'POP.'
	DEFB	0FFH,0E5H,15H,'PUSH'
	DEFB	0CFH,9,16H,'DAD.'
;
	DEFB	0FFH,23H,15H,'INX.'
	DEFB	0FFH,2BH,15H,'DCX.'
	DEFB	0FFH,34H,17H,'INR.'
	DEFB	0FFH,35H,17H,'DCR.'
	DEFB	0FFH,86H,17H,'ADD.'
	DEFB	0FFH,8EH,17H,'ADC.'
	DEFB	0FFH,96H,17H,'SUB.'
	DEFB	0FFH,9EH,17H,'SBB.'
	DEFB	0FFH,0A6H,17H,'ANA.'
	DEFB	0FFH,0AEH,17H,'XRA.'
	DEFB	0FFH,0B6H,17H,'ORA.'
	DEFB	0FFH,0BEH,17H,'CMP.'
	DEFB	0C7H,046H,18H,'MOV.'
	DEFB	0F8H,070H,19H,'MOV.'
;
	DEFB	0FFH,021H,1AH,'LXI.'
	DEFB	0FFH,022H,1BH,'SI..'
	DEFB	0FFH,02AH,1BH,'LI..'
	DEFB	0FFH,036H,1CH,'MVI.'
	DEFB	0CBH,0CBH,1DH,'....'
	DEFB	0,0,010H,'....'
OPC4:	DEFB	0FEH,070H,010H,'....';PREVENTS 'INP M'
	DEFB	0FFH,044H,0,'NEG.'
	DEFB	0FFH,045H,0,'RETN'
	DEFB	0FFH,046H,0,'IM0.'
	DEFB	0FFH,056H,0,'IM1.'
	DEFB	0FFH,05EH,0,'IM2.'
	DEFB	0FFH,047H,0,'STAI'
	DEFB	0FFH,04DH,0,'RETI'
	DEFB	0FFH,04FH,0,'STAR'
	DEFB	0FFH,057H,0,'LDAI'
	DEFB	0FFH,05FH,0,'LDAR'
	DEFB	0FFH,067H,0,'RRD.'
	DEFB	0FFH,06FH,0,'RLD.'
	DEFB	0CFH,042H,3,'DSBC'
	DEFB	0CFH,04AH,3,'DADC'
	DEFB	0C7H,040H,2,'INP.'
	DEFB	0C7H,041H,2,'OUTP'
	DEFB	0E7H,0A0H,1EH,'LD..'
	DEFB	0E7H,0A1H,1EH,'CC..'
	DEFB	0E7H,0A2H,1EH,'IN..'
	DEFB	0E7H,0A3H,1EH,'OUT.'
	DEFB	0CFH,043H,1FH,'S...'
	DEFB	0CFH,04BH,1FH,'L...'
	DEFB	0,0,010H,'....'
;
;  END OF OPCODE TABLES
;
