;		   SAP30.ASM ver. 0.2
;		  EXPERIMENTAL VERSION
;			1/16/81
;		    (revised 8/27/81)
;
;	SAP - SORT AND PACK CP/M DISK DIRECTORY
;
;	ORIGINALLY WRITTEN BY L.E. HUGHES - 8080SDC
;
;	MODIFIED 8/27/81 BY AL JEWER & SHAWN EVERSON
;		1) TO ALLOW FOR ENORMOUS NUMBER OF 
;		   DIRECTORY ENTRIES. 
;		2) COMMENTS RESEQUENCED TO DECREASE
;		   READING TIME.
;
;	MODIFIED 1/16/81 BY RON FOWLER
;		1) TO USE CPM DISK PARAMETER BLOCK
;		   (MAKE UNIVERSAL)
;		2) IMPROVE READABILITY BY RE-
;		   STRUCTURING THE CODE
;		3) MAKE COMPATIBLE WITH WARD CHRIST-
;		   ENSONS DISK CATALOG SYSTEM
;		4) ADD TRAP FOR MP/M
;
;	MODIFIED 1/9/81 BY KEITH PETERSEN, W8SDZ
;		1)TO CLEAN UP FILE AND ADD MORE COMMENTS
;
;	MODIFIED 10/23/80 BY KEITH PETERSEN, W8SDZ
;		1)TO TEST FOR READ AND WRITE ERRORS.
;		2)GENERAL CODE CLEANUP
;		3)TO IMPROVE METHOD OF GETTING SECTOR
;		  NUMBERS FROM SKEW TABLE.
;
;	MODIFIED 5/22/80 BY KEITH PETERSEN, W8SDZ.
;		1)FOR CP/M-2, TO CORRECT IMPROPER SORT
;		  CAUSED BY CP/M-2 FILE ATTRIBUTES.
;
;	MODIFIED 8/14/79 BY KEITH PETERSEN, W8SDZ
;		1)TO ALLOW FOR 128 DIRECTORY ENTRIES
;
;	MODIFIED 2/14/79 BY JAMES PREST, WA8SEL
;		1) TO ALLOW COMMAND SPECIFYING DRIVE
;		   NAME.  DEFAULT IS TO CURRENTLY
;		   LOGGED-IN DRIVE.
; 
;			COMMAND EXAMPLES:
;		SAP	   SAP THE CURRENT DRIVE
;		SAP A:	   SAP THE 'A' DRIVE
;		SAP B:	   SAP THE 'B' DRIVE
;		SAP C:	   SAP THE 'C' DRIVE
;		SAP D:	   SAP THE 'D' DRIVE
;		   (OTHER DRIVE NAMES TRAPPED OUT)
; 
;	MODIFIED 2/2/79 BY KEITH PETERSEN, W8SDZ
;		1) JUMP TO WARM BOOT ON EXIT
;		   TO ELIMINATE R/O STATUS OF
;		   DRIVE AFTER RUNNING SAP.
;		2) SET FOR 32 SECTORS FOR MICROPOLIS MOD II
;
;	MODIFIED 5/30/78 BY B.R. RATOFF
;		1) PICK UP VECTORS FOR ANY SIZE SYSTEM
;		2) HANDLE NULL EXTENTS OF NON-NULL FILES
;			PROPERLY
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
BDOS	EQU	5
GETDSK	EQU	25	;BDOS "GET DISK #" FUNCTION
DPBLEN	EQU	15	;SIZE OF CPM2 DISK PARM BLOCK
FCB	EQU	5CH
CR	EQU	0DH
LF	EQU	0AH
; 
	ORG	100H
;
	JMP	VECTRS	;JMP AROUND IDENTIFICATION MSG
;
	DB	'SAP2D EXP V0.3 8/27/81'
;
; OBTAIN BIOS VECTORS
;
VECTRS: JMP	GETVEC
;
	DS	53		;ROOM FOR JUMP VECTORS
;
WBOOTE	EQU	VECTRS+3	;DO NOT CHANGE THESE EQUATES
CSTS	EQU	VECTRS+6
CI	EQU	VECTRS+9
CO	EQU	VECTRS+12
LO	EQU	VECTRS+15
PO	EQU	VECTRS+18
RI	EQU	VECTRS+21
HOME	EQU	VECTRS+24
SELDSK	EQU	VECTRS+27
SETTRK	EQU	VECTRS+30
SETSEC	EQU	VECTRS+33
SETDMA	EQU	VECTRS+36
READ	EQU	VECTRS+39
WRITE	EQU	VECTRS+42
LSTS	EQU	VECTRS+45	;<<== ONLY IN CPM2
SECTRN	EQU	VECTRS+48	;<<==  "    "  "
;
GETVEC: LXI	D,WBOOTE
	LHLD	1
	MVI	B,53
	CALL	MOVE
;
;	PROGRAM STARTS HERE
;
START:	LHLD	BDOS+1
	SPHL		;PUT STACK AT TOP OF TPA
	CALL	ILPRT	;PRINT MSG:
	DB	CR,LF,' SAP experimental ver 0.3'
	DB	CR,LF,0
	MVI	C,12		;CHECK FOR CP/M VER 2.0
	CALL	BDOS	
	MOV	A,H		;HL = 0020H IF CP/M VER 2.0
	ORA	A		;CHECK FOR MPM
	JZ	NOTMPM
	CALL	ILPRT
	DB	CR,LF,'Sorry, SAP not usable under MPM',0
	JMP	0
NOTMPM: ORA	L		;TEST FOR H=0
	STA	VERFLG
;
SAP:	CALL	SETUP
	CALL	RDDIR
	CALL	CLEAN
	CALL	SORT
	CALL	PACK
	CALL	WRDIR
	CALL	ILPRT
	DB	CR,LF,'++DONE++',CR,LF,0
	JMP	0
;
;	SETUP FOR SELECTING DRIVE AND
;	LOADING DISK PARM BLOCK
;
SETUP:	LDA	FCB
	DCR	A
	JP	GOSEL	;NOT DEFAULT
	MVI	C,GETDSK
	CALL	BDOS	;  SO QUERY BDOS FOR DRIVE
GOSEL:	MOV	C,A
	CALL	SELDSK
	LDA	VERFLG	;IF CPM 1.4
	ORA	A
	JZ	CPM14	;IF 1.4, THEN DO IT THE 1.4 WAY
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	XCHG
	SHLD	SECTBL
	XCHG
	LXI	D,8	;OFFSET TO DPB WITHIN HEADER
	DAD	D	; RETURNED BY SELDSK IN CPM2
	MOV	A,M	;GET ADRS OF DPB
	INX	H
	MOV	H,M
	MOV	L,A
	LXI	D,DPB	;POINT TO DEST: OUR DPB
	MVI	B,DPBLEN
	CALL	MOVE
	RET
;
CPM14:	LHLD	BDOS+1
	MVI	L,0
	MVI	A,(JMP)
	STA	SECTRN
	PUSH	H
	LXI	D,15	;SECTRAN OFFSET FROM BDOS IN CPM 1.4
	DAD	D
	SHLD	SECTRN+1
	POP	H
	LXI	D,3AH	;OFFSET FROM BDOS TO 1.4 DPB
	DAD	D
	MVI	D,0
	MOV	E,M
	INX	H
	XCHG
	SHLD	SPT
	XCHG
	MOV	E,M
	INX	H
	XCHG
	SHLD	DRM
	XCHG
	MOV	A,M
	INX	H
	STA	BSH
	MOV	A,M
	INX	H
	STA	BLM
	MOV	E,M
	INX	H
	XCHG
	SHLD	DSM
	XCHG
	MOV	E,M
	INX	H
	XCHG
	SHLD	AL0
	XCHG
	MOV	E,M
	XCHG
	SHLD	SYSTRK
	RET
;
CLEAN:	LXI	H,0		;I = 0
;
CLNLOP: SHLD	I
	CALL	INDEX		;HL = BUF + 16 * I
	MOV	A,M		;JUMP IF THIS IS A DELETED FILE
	CPI	0E5H
	JZ	FILL$E5
	LXI	D,12
	DAD	D		;HL = HL + 12
	MOV	A,M		;CHECK EXTENT FIELD
	ORA	A
	JNZ	CLBUMP		;SKIP IF NOT EXTENT ZERO
	INX	H		;POINT TO RECORD COUNT FIELD
	INX	H
	MOV	A,M		;GET S2 BYTE (EXTENDED RC)
	ANI	0FH		;  FOR CPM2, 0 FOR CPM1
	MOV	E,A
	INX	H
	MOV	A,M		;CHECK RECORD COUNT FIELD
	ORA	E
	JNZ	CLBUMP		;JUMP IF NON-ZERO
	LHLD	I		;CLEAR ALL 32 BYTES OF
	CALL	INDEX		;  DIRECTORY ENTRY TO E5
	INX	H
	MOV	A,M		;GET FIRST CHAR OF FILENAME
	DCX	H		;  WARD CHRISTENSONS CAT PGMS
	CPI	'-'		;  HAVE DISKNAME OF ZERO LENGTH
	JZ	CLBUMP		;  THAT START WITH '-', DON'T DELETE
;
FILLE5: MVI	C,32		;NUMBER OF BYTES TO CLEAR
;
FILLOP: MVI	M,0E5H		;MAKE IT ALL E5'S
	INX	H
	DCR	C
	JNZ	FILLOP
;
CLBUMP: LHLD	DRM		;GET COUNT OF FILENAMES
	INX	H
	XCHG
	LHLD	I		;OUR CURRENT COUNT
	INX	H
	PUSH	H
	CALL	SUBDE		;SUBTRACT
	POP	H
	JC	CLNLOP		;LOOP TILL ALL CLEANED
	RET
;
;	SORT THE DIRECTORY
;
SORT:	CALL	ILPRT
	DB	CR,LF,'Sorting and packing directory...',0
	LXI	H,0		;I = 0
	SHLD	I
;
SORT1:	LHLD	I		;J = I + 1
	INX	H
	SHLD	J
;
SORT2:	CALL	COMP		;IF NAME(J)<NAME(I), SWAP
	CC	SWAP
	LHLD	J		;J = J + 1
	INX	H
	SHLD	J
	XCHG
	LHLD	DRM
	INX	H
	XCHG
	PUSH	H
	CALL	SUBDE		;IF J < DRM GOTO SORT2
	POP	H
	JC	SORT2
	LHLD	I		;I = I + 1
	INX	H
	SHLD	I
	XCHG
	LHLD	DRM
	XCHG
	CALL	SUBDE		;IF I < DRM GOTO SORT1
	JC	SORT1
	RET
;
PACK:	LXI	H,0		;I = 0
;
PACK2:	SHLD	I
	CALL	INDEX		;HL = BUF + 16 * I
	LXI	D,9
	DAD	D		;HL = HL + 9
	MOV	A,M		;JUMP IF FILETYPE NOT 'X$$'
	SUI	'0'		;  WHERE 0.LE.X.LE.9
	JC	PACK3
	CPI	10
	JNC	PACK3
	STA	J
	INX	H
	MOV	A,M
	CPI	'$'
	JNZ	PACK3
	INX	H
	MOV	A,M
	CPI	'$'
	JNZ	PACK3
	INX	H		;SET EXTENT NUMBER TO X
	LDA	J
	MOV	M,A
	DCX	H		;SET FILETYPE TO '$$$'
	MVI	M,'$'
	DCX	H
	MVI	M,'$'
	DCX	H
	MVI	M,'$'
;
PACK3:	LHLD	I		;I = I + 1
	INX	H
	XCHG
	LHLD	DRM
	INX	H
	XCHG
	PUSH	H
	CALL	SUBDE
	POP	H		;LOOP UNTIL I > DRM
	JC	PACK2
	RET
;
;	READ AND WRITE DIRECTORY ROUTINES
;
RDDIR:	CALL	ILPRT
	DB	CR,LF,'Reading directory...',0
	XRA	A
	JMP	DODIR
WRDIR:	CALL	ILPRT
	DB	CR,LF,'Writing directory back '
	DB	'to disk...',0
	MVI	A,1
DODIR:	STA	WRFLAG
	LHLD	SYSTRK
	CALL	DOTRAK	;SET THE TRACK
	LXI	H,0
	SHLD	SECTOR
	LHLD	DRM	;NUMBER OF DIR ENTRIES
	INX	H	;RELATIVE TO 1
	CALL	ROTRHL	;DIVIDE BY 4
	CALL	ROTRHL	;  TO GET SECTOR COUNT
	SHLD	DIRCNT
	LXI	H,BUF
	SHLD	ADDR	;FOR DMA ADDRESS
;
DIRLOP: LHLD	SECTOR	;GET SECTORS PER TRACK
	INX	H
	XCHG
	LHLD	SPT	;CURRENT SECTOR
	CALL	SUBDE	;  SECTOR - SPT
	XCHG
	JNC	NOTROV
;
;	TRACK OVERFLOW, BUMP TO NEXT
;
	LHLD	TRACK
	INX	H
	CALL	DOTRAK
	LXI	H,1	;REWIND SECTOR NUMBER
NOTROV: CALL	DOSEC	;SET CURRENT SECTOR
	LHLD	ADDR
	MOV	B,H	;SET UP DMA ADDRESS
	MOV	C,L
	CALL	SETDMA
	LDA	WRFLAG	;TIME TO FIGURE OUT
	ORA	A	;  IF WE ARE READING
	JNZ	DWRT	;  OR WRITING
;
;	READ
	CALL	READ
	ORA	A	;TEST FLAGS ON READ
	JNZ	RERROR	;NZ=ERROR
	JMP	MORE	;GOOD READ, GO DO MORE
;
;	WRITE
DWRT:	MVI	C,1	;FOR CPM2 DEBLOCKING BIOS'S
	CALL	WRITE
	ORA	A	;TEST FLAGS ON WRITE
	JNZ	WERROR	;NZ=BAD DIRECTORY WRITE
;
;	GOOD READ OR WRITE
MORE:	LHLD	ADDR	;BUMP DMA ADRS FOR NEXT PASS
	LXI	D,80H
	DAD	D
	SHLD	ADDR
	LHLD	DIRCNT	;COUNTDOWN ENTRIES
	DCX	H
	SHLD	DIRCNT
	MOV	A,H	;TEST FOR ZERO LEFT
	ORA	L
	JNZ	DIRLOP	;LOOP TILL ZERO
;
;	DIRECTORY I/O DONE, RESET DMA ADDRESS
;
	LXI	B,80H
	CALL	SETDMA
	RET
;
;COME HERE IF WE GET A READ ERROR
;
RERROR: CALL	ILPRT	;PRINT:
	DB	'++READ ERROR++',CR,LF
	DB	'Exiting to CP/M - NO CHANGE made',CR,LF,0
	JMP	0
;
;COME HERE IF WE GET A WRITE ERROR
;
WERROR: CALL	ILPRT	;PRINT:
	DB	'++WRITE ERROR++',CR,LF
	DB	'Exiting to CP/M - '
	DB	'directory left in UNKNOWN condition',CR,LF,0
	JMP	0
;
;	TRACK AND SECTOR UPDATE ROUTINES
;
DOTRAK: SHLD	TRACK
	MOV	B,H
	MOV	C,L
	CALL	SETTRK
	RET
DOSEC:	SHLD	SECTOR
	MOV	B,H
	MOV	C,L
	LHLD	SECTBL
	XCHG
	DCX	B
	CALL	SECTRN
	MOV	B,H
	MOV	C,L
	LDA	VERFLG
	ORA	A
	RZ
	CALL	SETSEC
	RET
;
COMP:	LHLD	I		;HL = BUF + 16 * I
	CALL	INDEX
	PUSH	H
	LHLD	J		;HL = BUF + 16 * J
	CALL	INDEX
	XCHG
	POP	H
	MVI	C,13		;NUMBER OF BYTES TO COMPARE
;
COMP1:	MOV	A,M		;GET NEXT BYTE
	ANI	7FH		;REMOVE ATTRIBUTES
	MOV	B,A		;SAVE IN B
	LDAX	D
	ANI	7FH		;REMOVE ATTRIBUTES
	CMP	B		;COMPARE CHARACTER
	RNZ			;RETURN IF NOT EQUAL
	INX	D
	INX	H
	DCR	C		;LOOP THRU FIRST 13 BYTES
	JNZ	COMP1
	XRA	A		;CLEAR FLAGS AND EXIT
	RET
;
;
SWAP:	LHLD	I
	CALL	INDEX
	PUSH	H
	LHLD	J
	CALL	INDEX
	XCHG
	POP	H
	MVI	C,32
;
SWAP1:	LDAX	D
	MOV	B,A
	MOV	A,M
	STAX	D
	MOV	M,B
	INX	D
	INX	H
	DCR	C
	JNZ	SWAP1
	RET
;
INDEX:	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,BUF
	DAD	D
	RET
;
;	PRINT A STRING: ADDRESS IS ON TOP OF STACK
;
ILPRT:	XTHL		;GET ADR FROM STACK
	MOV	A,M	;GET CHARACTER
	INX	H	;POINT TO NEXT ADR
	XTHL		;RESTORE TO STACK
	ORA	A	;ARE WE DONE?
	RZ		;YES, RETURN PAST STRING
	PUSH	H	;IN CASE CBIOS CLUBBERS IT
	MOV	C,A	;CHARACTER TO C FOR CP/M
	CALL	CO	;PRINT CHARACTER
	POP	H
	JMP	ILPRT	;CONTINUE
;
;	UTILITY SUBTRACTION SUBROUTINE...
;	HL=HL-DE
;
SUBDE:	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
;
;	DIVIDE HL BY 2
;
ROTRHL: ORA	A	;CLEAR CARRY
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	RET
;
;	MOVE UTILITY SUBROUTINE
;
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET

;
;	DATA AREA
;
MAPPTR: DS	2
ADDR:	DS	2
I:	DS	2
J:	DS	2
TRACK:	DS	2
SECTOR: DS	2
VERFLG: DS	1
WRFLAG: DS	1
DIRCNT: DS	2
SECTBL: DS	2
;
;	DISK PARAMETER BLOCK:
;
DPB:
SPT:	DS	2
BSH:	DS	1
BLM:	DS	1
EXM:	DS	1
DSM:	DS	2
DRM:	DS	2
AL0:	DS	1
AL1:	DS	1
CKS:	DS	2
SYSTRK: DS	2
;
;	END OF DISK PARAMETER BLOCK
;
BUF:
;
	END
;
