
;<DP.SHAPIN>DD.S80.19,  9-Oct-80 09:37:17, Edit by DP.SHAPIN
;	TITLE	DISK DIRECTORY DISPLAY FROM NOCCC
;					BY S J SINGER
; MODIFIED BY LORIN S. MOHLER TO DISPLAY 64 FILES
;    REV 9/16/79
;      BETTER DISPLAY FORMAT - COMPRESSES THE ROWS
;	SOME TERMINALS DO NOT RESPOND TO CR,LF,LF (CHANGED TO CR,LF,CR,LF)
; REV 9/23/79  MORE DISPLAY FORMAT CHANGES
; REV 9/25/79 STILL MORE DISPLAY FORMAT CHANGES
; 10/6/80 ADDED BIAS TO ASSEMBLE FOR MODIFIED CP/M, T. SHAPIN
; 10/9/80 FIXED TEST FOR LAST SECTOR IN DIRECTORY, T.SHAPIN
;
;
;	DD IS A CPM UTILITY THAT DISPLAYS A DISK DIRECTORY IN A MORE
;READABLE FORM. THE DIRECTORY IS READ FROM THE SPECIFIED DISK, SORTED
;THEN DISPLAYED IN A 3 COLUMN FORMAT. BOTH THE FILE NAMES AND FILE SIZES
;IN 1 K GROUPS ARE DISPLAYED.
;	THE PRESENT VERSION OF D HAS CERTAIN MINOR LIMITATIONS WHICH
;MAY BE EASILY REMOVED IF THEY CAUSE PROBLEMS.
;
;	1.  ONLY 48 FILES ARE DISPLAYED. THIS LIMIT IS SUFFICIENT FOR
;	    ALMOST ALL DISKS AND LEAVES ROOM ON THE SCREEN FOR EDITING.
;	    TO CHANGE THE NO OF LINES DISPLAYED, CHANGE THE LINES VARIABLE
;	    IN THE DATA ALLOCATION SECTION OF THE PROGRAM. FOR EXAMPLE
;	    TO DISPLAY A MAXIMUM OF 54 FILES CHANGE LINES TO 18.
;	2.  THE PRESENT VERSION READS GROUPS 0 AND 1 DIRECTLY FOR SPEED.
;	    IF A DISK IS SET UP FOR MORE THAN 64 FILES OR THE BLOCK FORMAT
;	    IS CHANGED THE READ ROUTINE WILL HAVE TO BE MODIFIED.
;
;	OCCASIONALLY THE FILE NAMES WILL BE DISPLAYED WITH THE FORMAT
;SCRAMBLED OR THE SPACE REMAINING ON THE DISK WILL NOT AGREE WITH THAT REPORTED
;BY THE STAT UTILITY. THIS ALMOST ALWAYS MEANS THE DISK DIRECTORY HAS BEEN
;MESSED UP SOMEHOW. USUALLY THE PROBLEM CAN BE CORRECTED BY COPYING ALL THE
;FILES TO ANOTHER DISK USING PIP.
;	D WAS ASSEMBLED USING THE NEW CP/M MACRO ASSEMBLER AND USES A LARGE
;NUMBER OF MACROS. THESE ARE CONTAINED IN A LIBRARY CALLED MACRO.LIB WHICH
;IS REQUIRED IF THE PROGRAM IS TO BE REASSEMBLED.
;	THE STANDARD VERSION OF 'DD' IS CONFIGURED FOR A DISPLAY SCREEN OF
;24 BY 80 CHARACTERS. A CONDITIONAL ASSEMBLY SWITCH IS INCLUDED TO CONFIGURE
;THE DISPLAY FOR A 16 BY 64 SIZE SCREEN WITH A SMALLER MAXIMUM NUMBER OF
;FILES. SET THE SWITCH TO TRUE FOR SMALLER SCREENS.
;	VDM	EQU	0FFH
;
;
;
;		COMMAND FORMAT
;
;	DD			DISPLAY DIRECTORY OF LOGGED DISK
;	DD A			DISPLAY DIRECTORY OF DISK A
;	DD B			DISPLAY DIRECTORY OF DISK B
;	DD C			DISPLAY DIRECTORY OF C
;       DD D			DISPLAY DIRECTORY OF D
;
;
VDM:	EQU	0FFH		;CONDITIONAL ASSEMBLY SWITCH SET TRUE IF
;				 16 BY 64 SCREEN
;
;	MACLIB	MACRO		;INCLUDE MACRO LIBRARY
;BIAS	EQU	4000H	; FOR MODIFIED CP/M SYSTEM
BIAS	EQU	0	; FOR STANDARD CP/M SYSTEM
BDOS	EQU	5+BIAS
FCB	EQU	5CH+BIAS
CR	EQU	0DH
LF	EQU	0AH
;
	ORG	100H+BIAS		;SET PROG START
	LXI	H,0
	DAD	SP		;GET OLD STACK POINTER
	SHLD	OLDSTK		;SAVE IT
	LXI	SP,NEWSTK	;LOAD NEW STACK POINTER
;
;
	LXI	H,PDIR	;ZERO STORAGE AREA
	MVI	B,0	;
ZERDIR:	MVI	M,0	;
	INX	H	;
	DCR	B	;
	JNZ	ZERDIR	;
;
	JMP	DIR
;
;   GRPTS  CONVERT CPM GROUP AND SECTOR NUMBER TO TRK AND SEC
;
GRPTS:	MVI	H,0		;ZERO H
	LDA	G		;GROUP NO
	MOV	L,A		;TO L
	MOV	D,H		;ZERO	D
	DAD	H
	DAD	H
	DAD	H		;SHIFT LEFT 3
	LDA	S		;GET SECTOR NO
	MOV	E,A		;TO DE
	DAD	D		;HL HAS G*8+S
	LXI	D,-26		;DIVISOR
	MVI	A,1		;CONTAINS DIVIDEND
DIV:	DAD	D		;SUB 26
	INR	A
	JC	DIV		;LOOP TILL MINUS
	LXI	D,TABLE+26	;INDEX INTO TABLE
	DAD	D
	STA	TRACK		;STORE TRACK NO
	MOV	A,M		;GET SECTOR NO
	STA	BSEC		;SAVE IN BEGINNING SECTOR
	STA	ESEC		;SAVE IN END SECTOR TOO
	RET
;
;    START OF DIRECTORY ROUTINE READ IN GROUPS 0 AND 1 AND STORE
;    DIRECTORY FILE NAMES NOT FLAGGED E5.  IF EXTENT NOT ZERO STORE
;    OVER PREVIOUS FILE NAME. TABLE OF POINTERS WILL BE BUILT IN PDIR
;
DIR:	;DISKIO	?DRIVE
	MVI	C,19H
	CALL	BDOS
	STA	NEWDRV
	LDA	81H+BIAS
	ORA	A		;CHECK IF INPUT BUFFER EMPTY
	JZ	DDD
	LXI	H,82H+BIAS		;POINT TO INPUT BUFFER
	CALL	GETDRV
	STA	NEWDRV		;STORE DRIVE CODE
DDD:
	;PRINT	<CR,LF>	;
	JMP	QQ01
QQ02:	DB	CR,LF
	DB	'$'
QQ01:	LXI	D,QQ02
	MVI	C,9
	CALL	BDOS
DIR2:	XRA	A
	STA	S		;SECTOR COUNT
	STA	G		;GROUP 0 = DIRECTORY
	STA	COUNT		;COUNT OF DIRECTORY ENTRIES
	MVI	A,16+1	; 4 ENTRIES/SECTOR X 16 SECTORS =
	STA	DSCNT	; 64 MAX DIR ENTRIES. DIR SECT. CNT.
	;FILL	PDIR,PDIR+130	;ZERO DIRECTORY POINTER TABLE
	LXI	H,PDIR
	MVI	C,83H
	MVI	E,0
QQ06:	MOV	M,E
	INX	H
	DCR	C
	JNZ	QQ06
	LXI	H,DIRBUF	;POINTS TO DIRECTORY BUFFER
	SHLD	OUTB
	LXI	H,PDIR		;POINTER TABLE
	SHLD	IPOINT
	LDA	NEWDRV
	MOV	E,A
	;DISKIO	LOGIN		;LOG IN NEW DRIVE NO
	MVI	C,0EH
	CALL	BDOS
DIR4:	LDA	DSCNT	; IF THIS IS PAST THE LAST
	DCR	A	; DIRECTORY SECTOR, THEN
	STA	DSCNT	; IF AT END,
	JZ	SORT	; GO SORT WHAT WE FOUND
	LXI	H,80H+BIAS		;POINTS TO INPUT BUFFER
	SHLD	INB
	CALL	GRPTS		;COMPUTE TRACK AND SECTOR NO FROM G AND S
	;SETSEC	BSEC		;SET SECTOR
	LDA	BSEC
	ORA	A		;CHECK ZERO
	STC
	JZ	QQ08
	CPI	27		;CHECK > 26
	CMC
	JC	QQ08
	MOV	C,A		;MOVE TO C
	LHLD	1+BIAS
	MVI	L,21H
	SHLD	QQ09+1
QQ09:	CALL	0+BIAS
	;SETTRK	TRACK		;SET TRACK
QQ08:	LDA	TRACK
	CPI	77
	CMC
	JC	QQ10
	MOV	C,A
	LHLD	1+BIAS
	MVI	L,1EH
	SHLD	QQ11+1
QQ11:	CALL	0+BIAS
;	CALLBIOS DREAD		;READ DIRECT
QQ10:	LHLD	1+BIAS
	MVI	L,27H
	SHLD	QQ12+1
QQ12:	CALL	0+BIAS
DIR6:	LHLD	OUTB		;LOAD DESTINATION POINTER
	XCHG			;PUT IT IN DE
	LHLD	INB		;LOAD SOURCE POINTER
	MVI	A,0E5H		;FLAG BYTE
	CMP	M		;TEST FIRST BYTE
	JNZ	DIR8
;  THE FOLLOWING TEST ONLY WORKS IF SECTORS WERE INITIALIZED TO E5E5.
;	INX	H
;	CMP	M		;TEST SECOND BYTE
;	JZ	SORT		;SORT DIRECTORY
	JMP	DIR12
DIR8:	INX	H
	;SAVE	H,D
	PUSH	H
	PUSH	D
	LXI	D,11		;EXTENSION OFFSET
	DAD	D
	MOV	A,M
	ORA	A
	JZ	DIR10		;IF EXTENT ZERO CONTINUE
	LXI	H,0		;ELSE, SEARCH FOR SAME NAME AND SWITCH
	SHLD	J		;INITIALIZE INDEX
DIR9:	;DLOAD	PDIR,J
	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	MOV	A,H
	ORA	L
	JZ	DIR10		;ERROR TABLE EMPTY
	XCHG
	LHLD	INB		;POINTER TO NEW DIR ENTRY
	;SAVE	D,H
	PUSH	D
	PUSH	H
	INX	H
	;MATCH	,,11		;COMPARE 11 CHARAACTERS
	JMP	QQ13
QMATCH:	INR	C
QQ14:	DCR	C
	RZ
	LDAX	D
	SUB	M
	RNZ
	INX	H
	INX	D
	JMP	QQ14
QQ13:	MVI	C,11
	CALL	QMATCH
	;RESTORE	H,D
	POP	H
	POP	D
	JZ	SWITCH		;STORE NEW ENTRY OVER OLD
	;INDEX	J,2		;INCR ;INDEX BY 2
	LHLD	J
	LXI	D,2
	DAD	D
	SHLD	J
	JMP	DIR9
SWITCH:	INX	H
	;MOVE	,,15		;OVERWRITE OLD ENTRY
	JMP	QQ18
QMOVE:	MOV	A,B
	ORA	C
	RZ
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	JMP	QMOVE
QQ18:	LXI	B,15
	CALL	QMOVE
	;RESTORE	H
	POP	H
	JMP	DIR12
DIR10:	;RESTORE	D,H
	POP	D
	POP	H
	;MOVE	,,15		;MOVE THE DIRECTORY ENTRY
	LXI	B,15
	CALL	QMOVE
	LDA	COUNT
	INR	A
	STA	COUNT		;INCR COUNT OF DIRECTORY ENTRIES
	LHLD	OUTB
	;DSTORE	0,IPOINT	;INDEXED STORE HL
	PUSH	H
	LHLD	IPOINT
	XCHG
	LXI	H,0
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	;INDEX	OUTB,16
	LHLD	OUTB
	LXI	D,16
	DAD	D
	SHLD	OUTB
	;INDEX	IPOINT,2
	LHLD	IPOINT
	LXI	D,2
	DAD	D
	SHLD	IPOINT
DIR12:	;INDEX	INB,32		;INCR POINTERS
	LHLD	INB
	LXI	D,32
	DAD	D
	SHLD	INB
	LXI	D,100H+BIAS
	;CPHL			;LIMIT OF 4 ENTRIES
	MOV	A,H
	CMP	D
	JNZ	QQ22
	MOV	A,L
	CMP	E
QQ22:	JNZ	DIR6
	LDA	S
	INR	A
	STA	S		;INCR DIRECTORY SECTOR COUNT
	JMP	DIR4		;READ ANOTHER BLOCK FROM DIRECTORY
;
;    THIS ROUTINE PRINTS THE DIRECTORY IN 3 COLUMNS. NO OF LINES
;    PRINTED IS CONTROLED BY VARIABLE LINES. ALL DIRECTORY NAMES
;    ARE PRESENT IN TABLE BUT ONLY A MAXIMUM OF 3*LINES WILL BE
;    PRINTED.
;
DIR14:	LXI	H,0
	SHLD	W		;INITIALIZE ALLOCATION
	SHLD	I		;INITIALIZE INDEX
;
	LDA	COUNT	;CALC THE LINES TO DISPLAY
	MVI	L,0	;INITIALIZE QUOTIENT
DIVD:	INR	L	;
	SBI	3	;COLUMNS
	JNC	DIVD	;
DIVD1:	MVI	H,0	;
	SHLD	CDBC	;
;
DIR16:	;DLOAD	PDIR,I		;INDEX LOAD POINTER
	LHLD	I
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	;DJZ	ENDFIL		;EXIT IF POINTER ZERO
	MOV	A,H
	ORA	L
	JZ	ENDFIL
	CALL	DIR20		;CALL PRINT ROUTINE
	IF	VDM
	;PRINT	'      '
	JMP	QQ23
QQ24:	DB	'      '
	DB	'$'
QQ23:	LXI	D,QQ24
	MVI	C,9
	CALL	BDOS
	ELSE
	;PRINT	'          '
	ENDIF		;
;
; POINTER TO COLUMN 2
	LHLD	CDBC	;COUNT DIV BY COLUMNS
	DAD	H	;*2
	XCHG		;
	LHLD	I	;GET INDEX
	DAD	D	;ADD IN
	LXI	D,PDIR	;GET POINTER FOR TABLE
	DAD	D	;POINT TO ENTRY TO DISPLAY
	MOV	E,M	;GET POINTER
	INX	H	;
	MOV	D,M	;
	XCHG		;
;
	;DJZ	DIR18		;NO PRINT IF ZERO
	MOV	A,H
	ORA	L
	JZ	DIR18
	CALL	DIR20		;PRINT IT
	IF	VDM
	;PRINT	'      '
	JMP	QQ28
QQ29:	DB	'      '
	DB	'$'
QQ28:	LXI	D,QQ29
	MVI	C,9
	CALL	BDOS
	ELSE
	;PRINT	'          '
	ENDIF
;
; POINTER TO COLUMN 3
	LHLD	CDBC	;GET DIRECTORY COUNT
	DAD	H	;
	DAD	H	;*4
	XCHG		;
	LHLD	I	;GET INDEX
	DAD	D	;
	LXI	D,PDIR	;
	DAD	D	;
	MOV	E,M	;
	INX	H	;
	MOV	D,M	;
	XCHG		;
;
	;DJZ	DIR18
	MOV	A,H
	ORA	L
	JZ	DIR18
	CALL	DIR20		;CALL PRINT ROUTINE
DIR18:	;PRINT	CRLF,$
	LXI	D,CRLF
	MVI	C,9
	CALL	BDOS
	;INDEX	I,2		;INCR ;INDEX BY 2
	LHLD	I
	LXI	D,2
	DAD	D
	SHLD	I
;
; CHECK INDEX LIMIT
	XCHG		;
	LHLD	CDBC	;GET DIRECTORY ENTRY COUNT
	DAD	H	;*2
	XCHG		;
;
	;CPHL
	MOV	A,H
	CMP	D
	JNZ	QQ39
	MOV	A,L
	CMP	E
QQ39:	JZ	ENDFIL		;EXIT WHEN INDEX 32
	JMP	DIR16		;PRINT SOME MORE
;
;    SUBROUTINE TO PRINT A SINGLE DIRECTORY ENTRY
;
DIR20:	MVI	C,8		;NAME LENGTH
DIR21:	CALL	MOUT		;PRINT ONE CHARACTER
	JNZ	DIR21		;PRINT SIZE

	PUSH	H		;SAVE POINTER
	;PRINT	' '		;OPEN IT UP
	JMP	QQ40
QQ41:	DB	' '
	DB	'$'
QQ40:	LXI	D,QQ41
	MVI	C,9
	CALL	BDOS
	POP	H		;RESTORE POINTER

	MVI	C,3		;TYPE LENGTH
DIR22:	CALL	MOUT		;PRINT TYPE
	JNZ	DIR22		;

DIR24:	MOV	A,M		;EXTENSION TO A
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;MULTIPLY BY 16
	MOV	B,A		;SAVE IN B
	INX	H
	INX	H
	INX	H		;ADD 3
	MOV	A,M		;GET RECORD COUNT
	RRC
	RRC
	RRC			;SHIFT RIGHT 3
	PUSH	PSW
	ANI	1FH		;EXTRACT
	LXI	H,0
	MOV	L,A		;NO TO HL TO PRINT
	POP	PSW
	ANI	0E0H		;EXTRACT
	JZ	DIR26
	INX	H
DIR26:	MOV	A,L
	ADD	B
	MOV	L,A
	;SAVE	H
	PUSH	H
	LXI	D,100	;LESS THAN 100?
	;CPHL		;
	MOV	A,H
	CMP	D
	JNZ	QQ45
	MOV	A,L
	CMP	E
QQ45:	JM	DIR28	;YES
	;PRINT	' '	;100 OR GREATER
	JMP	QQ46
QQ47:	DB	' '
	DB	'$'
QQ46:	LXI	D,QQ47
	MVI	C,9
	CALL	BDOS
	JMP	DIR30	;
DIR28:	LXI	D,10	;LESS THAN 10?
	;CPHL
	MOV	A,H
	CMP	D
	JNZ	QQ51
	MOV	A,L
	CMP	E
QQ51:	JM	DIR29	;YES
	;PRINT	'  '
	JMP	QQ52
QQ53:	DB	'  '
	DB	'$'
QQ52:	LXI	D,QQ53
	MVI	C,9
	CALL	BDOS
	JMP	DIR30
DIR29:	;PRINT	'   '
	JMP	QQ57
QQ58:	DB	'   '
	DB	'$'
QQ57:	LXI	D,QQ58
	MVI	C,9
	CALL	BDOS
DIR30:	POP	H
	PUSH	H
	XCHG
	LHLD	W
	DAD	D
	SHLD	W
	POP	H
	;DECOUT
	JMP	QQ62
QDECOUT: PUSH	B		;PUSH STACK
	PUSH	D
	PUSH	H
	LXI	B,-10
	LXI	D,-1
QQ63:	DAD	B
	INX	D
	JC	QQ63
	LXI	B,10
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	QDECOUT
	MOV	A,E
	ADI	'0'
	MOV	E,A
	MVI	C,2
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
QQ62:	CALL	QDECOUT
	;PRINT	'k'
	JMP	QQ64
QQ65:	DB	'k'
	DB	'$'
QQ64:	LXI	D,QQ65
	MVI	C,9
	CALL	BDOS
	RET
;
MOUT:	;SAVE	B,H		;;SAVE REGISTERS
	PUSH	B
	PUSH	H
	MVI	C,2
	MOV	E,M		;CHAR TO BE PRINTER
	CALL	BDOS		;CALL BDOS
	;RESTORE	H,B		;;RESTORE THE REGISTERS
	POP	H
	POP	B
	INX	H		;
	DCR	C		;
	RET			;
;
;    THIS ROUTINE RESTORES DRIVE B
;
FIXB:	LDA	NEWDRV		;CHECK DRIVE NO
	ORA	A
	RZ			;RETURN IF DRIVE A
	LDA	NEWDRV		;SELECT DRIVE B
	MOV	E,A
	;DISKIO	LOGIN
	MVI	C,0EH
	CALL	BDOS
	XRA	A
	STA	TNUM		;SELECT TRACK ZERO
	INR	A		;SELECT SECTOR 1
	STA	SNUM
	;SETSEC	SNUM
	LDA	SNUM
	ORA	A		;CHECK ZERO
	STC
	JZ	QQ69
	CPI	27		;CHECK > 26
	CMC
	JC	QQ69
	MOV	C,A		;MOVE TO C
	LHLD	1+BIAS
	MVI	L,21H
	SHLD	QQ70+1
QQ70:	CALL	0+BIAS
	;SETTRK	TNUM
QQ69:	LDA	TNUM
	CPI	77
	CMC
	JC	QQ71
	MOV	C,A
	LHLD	1+BIAS
	MVI	L,1EH
	SHLD	QQ72+1
QQ72:	CALL	0+BIAS
	;CALLBIOS DHOME		;HOME DRIVES
QQ71:	LHLD	1+BIAS
	MVI	L,18H
	SHLD	QQ73+1
QQ73:	CALL	0+BIAS
	;CALLBIOS DREAD		;READ TRACK ZERO DIRECT
	LHLD	1+BIAS
	MVI	L,27H
	SHLD	QQ74+1
QQ74:	CALL	0+BIAS
	RET
;
;    THIS IS THE EXIT POINT FROM THE PROGRAM. PRINT NO OF FILES AND
;    SPACE REMAINING, RELOAD OLD STACK POINTER AND RETURN BACK TO CCP.
;
ENDFIL:
	IF	VDM
	;PRINT	<CR,LF,'           DRIVE: '>
	JMP	QQ75
QQ76:	DB	CR,LF,'           DRIVE: '
	DB	'$'
QQ75:	LXI	D,QQ76
	MVI	C,9
	CALL	BDOS
	ELSE
	;PRINT	<CR,LF,'                 DRIVE: '>
	ENDIF
	LDA	NEWDRV		;DRIVE NUMBER
	CALL	PRNDRV		;PRINT DRIVE NAME
	;PRINT	<'     '>	;
	JMP	QQ80
QQ81:	DB	'     '
	DB	'$'
QQ80:	LXI	D,QQ81
	MVI	C,9
	CALL	BDOS
	LXI	H,0
	LDA	COUNT
	MOV	L,A
	;DECOUT
	CALL	QDECOUT
	;PRINT	' FILES    '
	JMP	QQ85
QQ86:	DB	' FILES    '
	DB	'$'
QQ85:	LXI	D,QQ86
	MVI	C,9
	CALL	BDOS
	LHLD	W
	MOV	A,L
	CMA
	INR	A		;NEGATE
	ADI	240
	MOV	L,A
	;DECOUT
	CALL	QDECOUT
	;PRINT	<'k BYTES FREE'>
	JMP	QQ90
QQ91:	DB	'k BYTES FREE'
	DB	'$'
QQ90:	LXI	D,QQ91
	MVI	C,9
	CALL	BDOS
	IF	NOT VDM
	;PRINT	CRLF,$
	ENDIF
EF1:	LHLD	OLDSTK
	SPHL			;RELOAD OLD STACK POINTER
	RET			;RETURN TO CCP WITHOUT REBOOT
;
DSKERR:	;PRINT	<CR,LF,'ERROR - SELECT DRIVE A, B, C, OR D'>
	JMP	QQ95
QQ96:	DB	CR,LF,'ERROR - SELECT DRIVE A, B, C, OR D'
	DB	'$'
QQ95:	LXI	D,QQ96
	MVI	C,9
	CALL	BDOS
	JMP	EF1		;EXIT
;
;    THIS SECTION DOES THE ACTUAL SORTING OF THE DIRECTORY. DURING THE
;    INPUT OF THE DIRECTORY NAMES, A TABLE OF ADDRESS POINTERS PDIR
;    WAS CONSTRUCTED. THE SORT ROUTINE SORTS THE ADDRESS POINTERS
;    RATHER THAN THE ACTUAL DIRECTORY.
;    THIS IS AN IMPLEMENTATION OF C. A. R. HOARE'S QUICKSORT ALGORITHM.
;    THE ALGORITHM IS VERY FAST AND GENERALLY USEFUL, HOWEVER CAUTION
;    SHOULD BE USED WITH LARGE FILES. THE ALGORITHM IS RECURSIVE AND
;    THE STACK SPACE REQUIRED IS PROPORTIONAL TO THE NO OF ITEMS TO BE
;    SORTED.
;
SORT:	LDA	COUNT		;NO OF ENTRIES IN DIR
	ORA	A
	JZ	ENDFIL		;EXIT IF DIRECTORY EMPTY
	DCR	A
	LXI	H,0		;ZERO HL
	MOV	L,A
	DAD	H
	SHLD	LAST		;END OF ARRAY
	LXI	H,0
	SHLD	FIRST		;START OF ARRAY
	LXI	H,0FFFFH
	PUSH	H		;FLAG FOR STACK EMPTY
	LHLD	FIRST
	PUSH	H
	LHLD	LAST
	PUSH	H		;STACK CONTAINS FIRST AND LAST INDICES
;
;    NOW POP STACK AND KEEP CALLING SPLIT RECURSIVELY TILL STACK EMPTY
;
SORT2:	POP	H
	MOV	A,H
	CPI	0FFH
	JZ	DIR14		;GO TO PRINT ROUTINE
	SHLD	J
	SHLD	LAST
	POP	H
	SHLD	I
	SHLD	FIRST
	CALL	SPLIT
	LHLD	I
	XCHG
	LHLD	FIRST
	;CPHL
	MOV	A,H
	CMP	D
	JNZ	QQ100
	MOV	A,L
	CMP	E
QQ100:	JZ	SORT4
	PUSH	H		;I ON STACK
	DCX	D
	DCX	D
	PUSH	D		;J ON STACK
SORT4:	LHLD	J
	XCHG
	LHLD	LAST
	;CPHL
	MOV	A,H
	CMP	D
	JNZ	QQ101
	MOV	A,L
	CMP	E
QQ101:	JZ	SORT8
	INX	D
	INX	D
	PUSH	D		;NEW I ON STACK
	PUSH	H		;NEW J ON STACK
SORT8:	JMP	SORT2
;
;    SPLIT SUBROUTINE DOES A SINGLE PARTITION ON AN ARRAY OF POINTERS
;
SPLIT:	;HALF	I
	JMP	QQ102
QHALF:	XRA	A
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	RET
QQ102:	LHLD	I
	CALL	QHALF
	XCHG
	;HALF	J
	LHLD	J
	CALL	QHALF
	DAD	D
	MOV	A,L
	ANI	0FEH
	MOV	L,A
	SHLD	K		;K=I+J/2
	;DLOAD	PDIR,K
	LHLD	K
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	W		;W IS POINTER TO PARTITION ELEMENT OF PDIR
SPLIT2:	;DLOAD	PDIR,I		;GET ITEM FROM LEFT
	LHLD	I
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	XCHG
	LHLD	W		;PARTITION ELEMENT
	;MATCH	,,11		;CONPARE KEYS
	MVI	C,11
	CALL	QMATCH
	JP	SPLIT4
	;INDEX	I,2		;INCR I
	LHLD	I
	LXI	D,2
	DAD	D
	SHLD	I
	JMP	SPLIT2
SPLIT4:	;DLOAD	PDIR,J		;GET ITEM FROM RIGHT
	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	XCHG
	LHLD	W		;PARTITION ELEMENT
	XCHG
	;MATCH	,,11		;COMPARE KEYS
	MVI	C,11
	CALL	QMATCH
	JP	SPLIT6
	;INDEX	J,-2
	LHLD	J
	LXI	D,-2
	DAD	D
	SHLD	J
	JMP	SPLIT4		;LOOP BACK
SPLIT6:	LHLD	I
	XCHG
	LHLD	J
	;CPHL			;COMPARE I AND J
	MOV	A,H
	CMP	D
	JNZ	QQ109
	MOV	A,L
	CMP	E
QQ109:	RZ			;RET IF I = J
	;DLOAD	PDIR,I		;SWITCH POINTERS
	LHLD	I
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	;SAVE	H
	PUSH	H
	;DLOAD	PDIR,J
	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	;DSTORE	PDIR,I
	PUSH	H
	LHLD	I
	XCHG
	LXI	H,PDIR
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	;RESTORE	H
	POP	H
	;DSTORE	PDIR,J
	PUSH	H
	LHLD	J
	XCHG
	LXI	H,PDIR
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	SPLIT2
;
;
;    GETDRV  SEARCH COMMAND STRING FOR DRIVE NAME AND RETURN CODE
;    A:=0 B:=1 C:=2 D:=3   CARRY SET IF DRIVE PRESENT
;    GETDRV IS CALLED WITH HL POINTING TO STARTING POSITION FOR SEARCH
;
GETDRV:	;SAVE			;SAVE REGS
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,DSKNAME	;POINT TO NAME TABLE
	MVI	C,0		;DRIVE NUMBER
GD1:	;SAVE
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	B,2		;STRING LENGTH
	MVI	C,1		;SUBSTRING LENGTH
	;INSTR
	JMP	QQ110
QINSTR:	MOV	A,B
	SUB	C
	CMC
	RNC
	MOV	B,A
QQ111:	PUSH	B
	PUSH	D
	PUSH	H
	CALL	QMATCH
	POP	H
	POP	D
	POP	B
	JZ	QQ112
	ANA	A
	DCR	B
	RM
	INX	H
	JMP	QQ111
QQ112:	MVI	B,0
	DAD	B
	STC
	RET
QQ110:	CALL	QINSTR
	;RESTORE
	POP	H
	POP	D
	POP	B
	JC	GD3		;FOUND NAME ON CARRY
	MOV	A,C		;DRIVE NO TO A
	CPI	3		;CHECK LIMIT
	JZ	DSKERR	;HASTY EXIT
	INR	C		;INCR DRIVE NO
	INX	D		;POINT TO NEXT NAME
	JMP	GD1		;LOOP FOR 4 DRIVES
GD3:	MOV	A,C		;DRIVE NO TO A
	;RESTORE
	POP	H
	POP	D
	POP	B
	RET
;
DSKNAME:	DB	'A'		;TABLE OF DISK NAMES
	DB	'B'
	DB	'C'
	DB	'D'
	DB	0	;FILLER
;
;    PRNDRV  PRINT DRIVE NAME CORRESPONDING TO CODE IN A REG
;    0=A 1=B 2=C 3=D  >3 ERROR
;
PRNDRV:	;SAVE
	PUSH	B
	PUSH	D
	PUSH	H
	CPI	4		;CHECK RANGE
	JP	PRDR3		;ERROR IF > 3
	ADI	'A'		;CALC LETTER TO PRINT
	;CHAROUT			;PRINT IT
	MVI	C,2
	MOV	E,A
	CALL	BDOS
PRDR1:	;RESTORE
	POP	H
	POP	D
	POP	B
	RET
PRDR3:	;PRINT	<CR,LF,'ILLEGAL DRIVE SPECIFIED',CR,LF>
	JMP	QQ117
QQ118:	DB	CR,LF,'ILLEGAL DRIVE SPECIFIED',CR,LF
	DB	'$'
QQ117:	LXI	D,QQ118
	MVI	C,9
	CALL	BDOS
	JMP	PRDR1
;
;
;   DATA ALLOCATIONS
;
SPACE:	DB	' $'		;ASCII SPACE
CRLF:	DB	CR,LF,'$'	;ASCII CR LF
CRLF2:	DB	CR,LF,CR,LF,'$'	;ASCII CR LF LF
I:	DW	0		;PSEUDO INDEX REGISTER
J:	DW	0		;PSEUDO INDEX REGISTER
K:	DW	0		;PSEUDO INDEX REGISTER
FIRST:	DW	0		;START OF ARRAY
LAST:	DW	0		;END OF ARRAY
W:	DW	0		;STORAGE FOR PARTITION INDEX
LINE:	DW	0		;LINE NUMBER FOR LISTING
IPOINT:	DW	00		;VARIABLE BUFFER POINTER
INBUF:	DS	10		;USED AS CONSOLE INPUT BUFFER
LASTIN:	DB	0		;LAST CONSOLE INPUT CHAR
INFLAG:	DB	0		;FLAG, RET FOR MORE CONSOLE INPUT
DRVNO:	DB	0		;STORAGE FOR ORIGINALLY LOGGED DRIVE
NEWDRV:	DB	0		;STORAGE FOR NEW DRIVE NO
TRACK:	DB	0		;SELECTED TRACK
BSEC:	DB	0		;SELECTED BEGINNING SECTOR
ESEC:	DB	0		;SELECTED ENDING SECTOR
TNUM:	DB	0		;TRACK NO FOR VALIDATE
SNUM:	DB	0		;SECTOR NO FOR VALIDATE
VALFLG:	DB	0		;VALIDATION ERROR FLAG
^LG:	DB	0		;CPM GROUP NO
S:	DB	0		;SECTOR NO WITHIN GROUP G
DSCNT:	DB	0	; COUNT OF DIR. SECTORS TO BE READ
COUNT:	DB	0		;COUNT OF DIRECTORY ENTRIES
CDBC:	DW	0		;DIRECTORY COUNT DIV BY COLUMNS
OLDSTK:	DW	0		;STORAGE FOR OLD STACK POINTER
ENDSTK:	DS	60		;STORAGE FOR NEW STACK
NEWSTK:	DW	0		;NEW STACK
INB:	DW	0		;STORES POINTER TO INPUT BUFFER AREA
OUTB:	DW	0		;STORES POINTER TO DIRECTORY BUFFER AREA
TABLE:	DB	01H		;SECTOR LOOK UP TABLE
	DB	07H
	DB	0DH
	DB	13H
	DB	19H
	DB	05H
	DB	0BH
	DB	11H
	DB	17H
	DB	03H
	DB	09H
	DB	0FH
	DB	15H
	DB	02H
	DB	08H
	DB	0EH
	DB	14H
	DB	1AH
	DB	06H
	DB	0CH
	DB	12H
	DB	18H
	DB	04H
	DB	0AH
	DB	10H
	DB	16H
PDIR:	DW	0		;POINTER TABLE TO DIRECTORY (64 ENTRIES MAX)
DIRBUF:	EQU	PDIR+134	;START OF AREA USED TO STORE AND SORT DIRECTORY
	END
@ LF LF
I:	DW	0		;PSEUDO INDEX REGISTER
J:	DW	0		;PSEUDO