;
; 	CALLS.ASM	version 1.0  as of 09/07/81
;       By Dave Hardy
;
;
;  Print number of log-in attempts and log-ins.
;  For use with BYE.ASM to allow remote callers to
;  see number of log-ins and log-in attempts
;
;  Note that the addresses of the number of log-in attempts
;  and the number of log-ins must be hard coded into this program.
;
;  Define some miscellaneous values:
CR	EQU	0DH	;ASCII carriage return
LF	EQU	0AH	;ASCII linefeed
BDOS	EQU	5	;CP/M BDOS jump address
CONOUT	EQU	2	;CP/M BDOS CONSOLE OUTPUT function
PRNSTR	EQU	9	;CP/M BDOS PRINT STRING function
;
NATMPT	EQU	0E54AH	;Address of LOG-IN attempts counter in BYE program
NCALS	EQU	0E54BH	;Address of LOG-IN counter in BYE program
;
	ORG	0100H	;for standard CP/M
;
START	LDA	NATMPT	;Get number of log-in attempts
	CALL	HXNUM	;Print it
	LXI	D,NATMP	;Print message
	MVI	C,PRNSTR
	CALL	BDOS
;
	LDA	NCALS	;Get number of log-ins
	CALL	HXNUM	;Print it
	LXI	D,NCALL	;Print message
	MVI	C,PRNSTR
	CALL	BDOS
	RET
;
;  Print the number in A as 2 ASCII characters on the screen
;
HXNUM	PUSH	PSW	;Save the character for second part
	ANI	0F0H	;Get first digit of number
	RRC
	RRC
	RRC
	RRC
	ADI	'0'	;Make it ASCII 
	MOV	E,A
	MVI	C,CONOUT
	CALL	BDOS	;Print it via BDOS CONOUT function
	POP	PSW	;Get second digit of number
	ANI	0FH
	ADI	'0'	;Make it ASCII
	MOV	E,A
	MVI	C,CONOUT
	JMP	BDOS	;Print it, too 
;
NATMP	DB	' attempted log-ins',CR,LF,'$'
NCALL	DB	' successful log-ins',CR,LF,'$'
;
	END
