??????????????????????????????????????????????????????????????????
THE FOLLOWING FILES ARE IN THIS PACKED FILE
YAM.H
YAM1.C
YAM2.C
YAM3.C
YAM5.C
YAM7.C
YAM8.ASM
YAMHELP.MSS
YAMMORE2.DOC
YAMSYS.H
YAMX89XM.H
YAM.SUB
YAMHELP.T
YAMX.SUB
XYAMSYS.H
??????????????????????????????????????????????????????????????????





/*
>>: yam.h
*/
#include "a:BDSCIO.H"
#include "b:yamsys.h"		/* installation specific stuff */

#define VERSION "2.241 Rev 10-8-81"
#define FLAVOR "---"     /* I ADDED THIS LINE */

#ifndef XMODEM
#define lprintf printf
#endif
/*
 * yam	-Yet Another Modem program
 *		Chuck Forsberg 7-16-81
 *
 *	Design goals: A general program performing the functions
 *	of MODEM, BYE, and XMODEM, portable to non-timesharing
 *	systems.
 *
 *	Coding style is/was aimed at portability and clarity.
 *	File transfer routines are written without timing assumptions
 *   allowing error free high speed operation even if view selected
 *
 *	Comments to me at:
 *	Chuck Forsberg
 *		Computer Development Inc
 *		6700 S.W. 105th
 *		Beaverton OR 97005 503/646-1599
 *		Home 503/621-3406 Voice
 *		RBBS RCP/M 503/621-3193	(latest source code)
 *		  At 300, 450, or 1200 bps(212modem)	Random hours
 *		Portland ABBS 503/224-6409 or CBBS NW 503/284-5260
 *		Source TCE022, CPS 70715,131
 *		RTTY Autostart 3627.5 "ZCZC WRU WA7KGX CR/LF msg... NNNN"
 *
 *	Files:
 *		yam.h		header and globals
 *		yamsys.h	Modem port adresses, installation specific data
 *		yam1.c		First time initialization
 *					Main command decoding
 *		yam2.c		Christensen protocol handler
 *		yam3.c		Conversation with data capture
 *					File xmsn w/o error checking.
 *
 *		yam5.c		Misc modem related functions, such as baudrate
 *		yam7.c		Disk i/o open,close, directory
 *					Wild card expansion, CP/M related stuff
 *		yam8.asm	CRCK calculation routine.
 *
 *		compiled with -e 5A00 for all files and -o for yam[235]
 *		(-e 6000 for XYAM)
 */

#ifdef CPM
char defdisk;		/* default disk */
char user;
#define PATHLEN 20	/* plenty long */
#endif

#ifdef BDSC
#define FLAG char
FILE fin,fout;		/* #define FILE struct _buf */
int logfd;		/* used by logfile */
#define stdin 0
#define stdout 1
#define stderr 1
char cfast;	/* BDS C fastest access is to extern's */
char checksum;	/* delcared here for speed */
unsigned oldcrc;	/* accumulates CRC checksum */
int wcj, firstch;
#endif

#define CMDLEN 132

#define ENQ 005
#define CAN ('X'&037)
#define XOFF ('s'&037)
#define XON ('q'&037)
#define SOH 01
#define EOT 4
#define ACK 6
#define NAK 025
#define TIMEOUT (-2)
#define ERRORMAX 5
#define RETRYMAX 5

/* declare all globally used functions not returning int */
char putcty(), *index(), *cisubstr();

FLAG Quiet;
char Ttycol, Lpcol;	/* column for tab expansion */
unsigned Numsecs;	/* Number of 128 byte sectors, used by compsec */
unsigned Numblks;	/* Number of CP/M blocks, used by compsec */
unsigned Numfiles;	/* Total number of files expanded */
unsigned Secpblk;	/* Number of sectors per block */
FLAG Rfile;		/* receiving into a file */
FLAG Tfile;		/* transmitting from a file */
FLAG Batch;		/* Batch (multi-file) xfer */
FLAG Creamfile;		/* true means o.k. to blast old file on rx */
FLAG Txgo;		/* file sending start/stop (XON/XOFF) */
FLAG Dumping;		/* not Squelched ^R */
FLAG Pflag;		/* printing the rx stuff */
FLAG Ctlview;		/* Term function shows control chars as ^char */
FLAG View;	/* View data being transmitted/received if file xfer */
FLAG Echo;	/* Echo modem data back to itself only in chat */
FLAG Hdx;	/* Half Duplex connection -no echo from far end */
FLAG Chat;	/* treat kbd \r as crlf when chatting */
FLAG Gototerm;	/* go to term after file xfer */
FLAG Exoneof;	/* exit from term() when finished with file */
/* Following flags affect data as it is written to file, not captured */
FLAG Image;	/* Tell it like it is. */
FLAG Zeof;	/* Terminate data capture & close file on ^Z */
FLAG Squelch;	/* Turn capture on after ^R, off before ^T */
char *Txmoname;		/* asciz string corresponding to Txeoln mode */
FLAG Txeoln;	/* what to do at the end of a line */
#define EOL_NOTHING 0	/* send it all as is */
#define EOL_CR	1		/* send /r only */
#define EOL_NL	2		/* send \n only */
#define EOL_CRWAIT 3	/* send \r then wait for \n echo */
#define EOL_CRPROMPT 4	/* send \r then wait for silence. */
#define TX_BINARY 0200	/* don't stop on CPMEOF or whatever **/

/* For controls based on time since last RX char mostly */
unsigned Timeout;	/* measure of how long since last rx char */
unsigned Tpause;	/* when ++Timeout==Tpause, do something ... */
FLAG Xoffflg;		/* !=0 if we sent XOFF to stop the bubble machine */
FLAG Waitecho;		/* Wait for echo to stop when sending file */

/* If Waitbunch, Wait for Throttle loops each waitnum tx chars */
FLAG Waitbunch;
unsigned Waitnum;	/* do Waitecho each time chars_sent == Waitnum */
unsigned Throttle;
FLAG Txwait;		/* used with throttle */
unsigned Txtimeout;	/* counted down to 0, then Txwait becomes false */

unsigned T1pause;	/* for setting 0.1 second timeout for readline */
char Lastrx;		/* last char received, for detecting CAN CAN */

/*
 * start, end, input, output, printer-output pointers and marker
 * used with data capture
 */
char *bufst, *bufend, *bufcq, *bufcdq, *buffcdq, *bufpcdq, *bufmark;
unsigned Free;		/* Number of characters free in capture buf */
unsigned Low;		/* when free==low, send the XOFF */
unsigned Bufsize;
FLAG Wrapped;		/* Circular buffer insertion pointer has wrapped around */
char Dport,Sport;	/* data and status port addresses */
char Mstatus;		/* contents of modem error register if modem error */
unsigned Baudrate;  /* current baudrate */
FLAG Originate;	/* Originate mode requested */
FLAG Parity;
#define SEND8 0	/* RAW on Unix */
#define NORMAL 1	/* cooked o.k. on Unix */
	/* following would be CBREAK on Unix */
#define EVEN7 2
#define ODD7 3
#define EVEN8 4
#define ODD8 5

char cmdbuf[CMDLEN+2], *cp;  /* for commands entered directly (not argv) */
char Rname[PATHLEN], Tname[PATHLEN];	/* saved file names */
char Phone[80];		/* phone number read in from file */

/*
 * Unix is a trademark of Western Electric
 * CP/M, Digital Research
 * Coherent, Mark Willams Co., Chicago IL
 * IDRIS, Whitesmiths Co.
 */

/*
Some #DEFINES you should know about:
	DEFBAUD if not defined, baudrate is read from the port
	RESTRICTED disallows downloading of $SYS|TAG2 files, upload .com>.obj
	LOGFILE logs all file xmsn attempts, also is the file
	TERMRESET string initializes terminal to desired mode
	PHONES file with phone numbers
	FILE means struct _buf for BDS C
*/
??????????????????????????????????????????????????????????????????
/*
>>:yam1.c
 * Mainline for yam 10-4-81 */

#include "b:yam.h"
#define MAXARGS 20

main(argc, argv)
char **argv;
{
	int c;
	char *args[MAXARGS], **argp, **argq, *nextcmd, *p;

	nextcmd=NULL;
	printf("%s %s\n", FLAVOR, VERSION);
	init();
	if(argc>MAXARGS)
		goto usage;
	/* copy given arguments to our own array */
	for(argp=argv,argq=args,c=argc; --c>=0;)
		*argq++ = *argp++;
#ifdef TERMRESET
	lprintf(TERMRESET);
#endif
	for(;;) {
		if(argc < 2) {
			if(nextcmd)
				cp=nextcmd;
			else {
#ifdef XMODEM
				printf("\nxYAM(%c%d)", defdisk+'A', user);
#else
				printf("\n>>>%c%d:", defdisk+'a', user);
#endif
				gets(cmdbuf);
#ifdef TERMRESET
				lprintf(TERMRESET);
#endif
				cp=cmdbuf;
			}
			if(nextcmd=index(';', cp))
				*nextcmd++ =0;	/*  ; separates commands */
			else if(nextcmd=index('\\', cp))
				*nextcmd++ =0;	/*  \ separates commands */

			argp= &args[1]; argc=1;
			for(;;) {
				if(isgraphic(*cp)) {
					*argp++ = cp;
					argc++;
					while(isgraphic(*cp))
						cp++;
				}
				while(*cp==' ' || *cp=='\t')
					*cp++ =0;
				if(*cp > ' ')
					continue;
				*cp=0;
				break;
			}
		}
		for(argp= &args[1]; --argc>0; ) {
			uncaps(*argp);
			cp= *argp++;

			Gototerm=Batch=Creamfile=Echo=Chat=View=Quiet=FALSE;
#ifdef CPM
			if(index(':', cp)) {
				chdir(cp);
				continue;
			}
#endif
			switch(*cp++) {
			case 'b':
				if(cmdeq(cp, "ye")) {
					bye();
					continue;
				}
				else if(setbaud(atoi(cp)))
					goto usage;
				continue;
			case 'c':
#ifndef RESTRICTED
				if(cmdeq(cp, "all") && --argc ==1) {
					uncaps(*argp);	/* make name lcase */
					if(getphone(*argp++,Phone)==ERROR)
						goto usage;
					else if(dial(Phone)==ERROR)
						goto usage;
					continue;
				}
#endif
#ifdef XMODEM
				if(cmdeq(cp, "hat")) {
					chat();
					continue;
				}
#endif
				if(cmdeq(cp, "lose")) {
					dumprxbuff();
					closerx(TRUE); closetx(TRUE);
					continue;
				}
				if(cmdeq(cp, "rck")) {
					docrck( --argc, argp);
					argc=0; continue;
				}
				goto usage;
			case 'd':
				if(cmdeq(cp, "ir")) {
#ifndef CDOS
					if(cp[2])
						docomp(--argc, argp);
					else
#endif
						dodir(--argc, argp);
					argc=0;
				}
				else if(setval(0)==ERROR)
					goto usage;
				continue;
			case 'e':
				if(setval(~0)==ERROR)
					goto usage;
				continue;
			case 'f':
				closetx(TRUE);
				if(setval(~0)==ERROR)
					goto usage;
				if(--argc<=0 || opentx(*argp++)==ERROR)
					goto usage;
				if(Squelch)
					/* frame file with ^R T if Squelch */
					outp(Dport, 022);
				term(0);
				if(Squelch)
					outp(Dport, 024);
				continue;
			case 'i':
				if(cmdeq(cp, "nit")) {
					init(); argc=nextcmd=0; continue;
				}
				else
					goto usage;
			case '?':
			case 'h':
				listfile(HELPFILE); continue;
			case 'k':
				if(cmdeq(cp, "ill")) {
					clearbuf();
					continue;
				}
				else
					goto usage;
			case 'l':
				if(cmdeq(cp, "ist")) {
listit:
					dolist( --argc, argp); argc=0; continue;
				}
				else
					goto usage;
#ifndef RESTRICTED
			case 'm':
				Sport=(Dport=atoi(cp))+SPORT-DPORT;
				readbaud(); continue;
#endif
			case 'o':
#ifdef TERMRESET
				lprintf(TERMRESET);
#endif
				onhook();
				if(cmdeq(cp, "ff")) {
					exit(0);
				}
				printf("On Hook"); continue;
			case 'p':
				if(setparm(cp)==ERROR)
					goto usage;
				continue;
			case 'r':
				if(cmdeq(cp, "eset")) {
#ifdef TERMINIT
					lprintf(TERMINIT);
#endif
					closetx(TRUE);
					dumprxbuff(); closerx(TRUE);
#ifdef CPM
					bdos(13,0);bdos(14,defdisk);
#endif
					/* change buffer size for debugging */
					if(--argc>0) {
						bufend= bufst + atoi(*argp++);
						clearbuf();
						dostat();
					}
					continue;
				}
				if(cmdeq(cp, "ep")) {
					replot(argc>1 ? (--argc,atoi(*argp++)) : 0);
					continue;
				}
				if(cmdeq(cp, "ew")) {
					rewindcb(); continue;
				}
				if(chkbvq()==ERROR)
					goto usage;
				if(argc<2)
					Batch=TRUE;
				psxfer(wcreceive(--argc, argp));
				if(Gototerm)
					term();
				argc=0; continue;
			case 's':
				if(*cp == 0 && argc==1) {
					dostat();
					continue;
				}
				if(argc<2 || chkbvq()==ERROR)
					goto usage;
				if( argc > 2
				  || index('?',*argp) || index('*',*argp))
					Batch=TRUE;
#ifdef XMODEM
				/* tell 'em how long it will take! */
				if(Baudrate<=1200)
					docomp(argc-1, argp);
#endif
				psxfer(wcsend(--argc, argp));
				if(Gototerm)
					term();
				argc=0; continue;
			case 't':
				if(cmdeq(cp, "ype"))
					goto listit;
				if(--argc > 0) {
					dumprxbuff(); closerx(TRUE);
					if(opencapt(*argp++)==ERROR)
						goto usage;
				}
				switch(setval(~0)) {
				case ERROR:
					goto usage;
				case OK:
					term();
				case TRUE:
					/* remain in command mode if t..c  */
					break;
				}
				continue;
			case 'w':
				dumprxbuff(); continue;
			case 'x':
				continue;	/* in case you said "XMODEM" */
			case 0:
			default:
				goto usage;
			}
			continue;
		}
		continue;
usage:
		printf("Type HELP for instructions");
		nextcmd=argc=0; continue;
	}
}

chkbvq()
{
	while(*cp)
		switch(*cp++) {
		case 'b':
			Batch=TRUE; break;
		case 'q':
			Quiet=TRUE; break;
#ifndef RESTRICTED
		case 't':
			Gototerm=TRUE; break;
		case 'v':
			View=TRUE; break;
		case 'y':
			Creamfile=TRUE; break;
#endif
		default:
			return ERROR;
		}
	return FALSE;
}
setval(value)
unsigned value;
{
	FLAG dumped;
	dumped=FALSE;
	while(*cp)
		switch(*cp++) {
		case 'a':
			Chat=value; break;
		case 'b':
			Txeoln= value&TX_BINARY; Txmoname="BINARY"; break;
		case 'c':
			dumprxbuff(); closerx(dumped=TRUE); break;
		case 'e':
			Echo=value; break;
		case 'f':
			Hdx= !value; break;
		case 'g':
			Txgo= value; break;
		case 'h':
			Hdx=value; break;
		case 'i':
			Image=value; break;
		case 'l':
			Pflag=value; break;
		case 'n':
			Txeoln =value&EOL_NL; Txmoname="NL ONLY"; break;
		case 'p':
			Txeoln =value&EOL_CRPROMPT;
			Txmoname="WAIT FOR PROMPT"; break;
		case 'r':
			Txeoln =value&EOL_CR; Txmoname="CR ONLY"; break;
		case 's':
			Squelch=value; break;
		case 't':
			Waitbunch=value; break;
		case 'v':
			Ctlview=value; break;
		case 'w':
			Txeoln= value&EOL_CRWAIT;
			Txmoname="CR WAIT FOR NL"; break;
		case 'x':
			Exoneof=value; break;
		case 'z':
			Zeof=value; break;
		default:
			return ERROR;
		}
	return dumped;
}

init()
{
#ifdef BDSC
	char *endext(), *topofmem(), *codend(), *externs();
	if(codend() > externs()) {	/* check for bad -e value! */
		printf("urk"); exit();
	}
#endif
	initdd();		/* fetch default disk and user number */
	bufst=endext();
	bufend=topofmem()-1024;	/* fudge so we don't crash ... */
	Dport=DPORT; Sport=SPORT;
#ifndef DEFBAUD
	readbaud();
#else
	Baudrate=DEFBAUD;
#endif
#ifndef XMODEM
	setbaud(Baudrate);
#endif
	Mstatus=0;	
	Ctlview=Rfile=Tfile=Pflag=FALSE;
	Image=Waitbunch=Exoneof=Hdx=Zeof=Squelch=FALSE;
	Txgo=TRUE;
	Parity= NORMAL;
	Originate= TRUE;
	Txeoln= EOL_NOTHING;
	Low= 400;
	Tpause=1500*CLKMHZ; Throttle=80*CLKMHZ; T1pause=311*CLKMHZ;
	Waitnum=1;
	clearbuf();
}

clearbuf()
{
	Xoffflg=Wrapped= FALSE;
	buffcdq=bufcq=bufcdq=bufpcdq=bufmark= bufst;
	Bufsize=Free= bufend-bufst-1;
}


cmdeq(s,p)
char *s, *p;
{
	while(*p)
		if(*s++ != *p++)
			return 0;
	return 1;
}

dostat()
{

		printf("Capture %s Receiving %s ",
		 Dumping?"ON":"SQUELCHED", Rfile?Rname:"<nil>");
		if(Image)
			printf("Transparency mode ");
		if(Squelch)
			printf("^R ^T Squelch ");
		if(Zeof)
			printf("EOF on ^Z");
		printf("\n");

	if(Txeoln==EOL_NOTHING)
		Txmoname="IMAGE";

	printf("%sSending %s in %s mode\n",
	 Txgo? "" : "Pausing in ", Tfile?Tname:"<nil>", Txmoname);
	printf("%sWaiting %d loops every %u chars  Pause=%u\n",
	 Waitbunch?"":"NOT ",Throttle, Waitnum, Tpause);

	printf("Printer %s  ", Pflag?"ON":"OFF");
	if(Hdx)
		printf("Half Duplex ");
	printf("At %u baud data port %d.\n", Baudrate, Dport);
	printf("%u of %u chars used %u free%s\n",
	  Bufsize-Free, Bufsize, Free, Wrapped?" POINTERS WRAPPED":"");
	printf("bufst=%x bufcq=%x bufcdq=%x buffcdq=%x bufpcdq=%x bufend=%x\n",
	 bufst, bufcq, bufcdq, buffcdq, bufpcdq, bufend);
}

isgraphic(c)
{
	if(c>' ' && c<0177)
		return TRUE;
	else
		return FALSE;
}

/*
 * index returns a pointer to the first occurrence of c in s,
 * NULL otherwise.
 */
char *index(c, s)
char c,*s;
{
	for(; *s; s++)
		if(c== *s)
			return s;
	return NULL;
}
psxfer(status)
{
	lpstat("File transfer(s) %s",
	 status==ERROR?"ABORTED BY ERROR" : "successful");
}

setparm(p)
char *p;
{
	if(*p)
		switch(*p++) {
		case 'p':
			Tpause=atoi(p); break;
		case 't':
			Throttle=atoi(p); break;
		case 'w':
			Waitnum=atoi(p); break;
		default:
			return ERROR;
 	}
	return 0;
}
/* make strings lower case */
uncaps(s)
char *s;
{
	while(*s)
		*s = tolower(*s++);
}
????????????????????????????????????????????????????????????????

/*
>>:yam2.c 8-13-81
 * Ward Christensen Protocol handler for sending and receiving
 * ascii and binary files.
 */

#include "b:yam.h"
#define WCEOT (-2)



wcsend(argc, argp)
char **argp;
{
	int wcs();

	if(Batch) {
		if(expand(wcs, argc, argp)==ERROR)
			goto fubar;
		if(wctxpn("")==ERROR)
			goto fubar;
	}
	else {
		for(; --argc>=0;) {
			if(opentx(*argp++)==ERROR)
				goto fubar;
			if(wctx()==ERROR)
				goto fubar;
		}
	}
	return OK;
fubar:
	closetx();
	sendline(CAN);sendline(CAN);sendline(CAN);
	return ERROR;
}

wcs(name)
char *name;
{
	if(opentx(name)==ERROR)
		return ERROR;
	if(wctxpn(name)!= ERROR)
		return wctx();
	else {
		return ERROR;
	}
}


wcreceive(argc, argp)
char **argp;
{
	char rpn[SECSIZ];		/* rx path name */
	if(Batch || argc==0) {
		printf("Batch Mode...");
		for(;;) {
			if(wcrxpn(rpn)== ERROR)
				goto fubar;
			if(*rpn==0)
				return OK;
			if(wcrx(rpn)==ERROR)
				goto fubar;
		}
	}
	else
		for(; --argc>=0;) {
			if(wcrx(*argp++)==ERROR)
				goto fubar;
		}
	return OK;
fubar:
	sendline(CAN);sendline(CAN);sendline(CAN);
	closerx(TRUE);
	return ERROR;
}
/*
 * Fetch a pathname from the other end as a C ctyle ASCIZ string.
 * Length is indeterminate as long as less than SECSIZ
 * a null string represents no more files
 */
wcrxpn(rpn)
char *rpn;	/* receive a pathname */
{
	char rname[SECSIZ];


	sendline(NAK);
	if(wcgetsec(rname, 500)==ERROR) {
		printf("Pathname fetch failed\n");
		return ERROR;
	}
	strcpy(rpn, rname);
	sendline(ACK);
	return OK;
}

wctxpn(name)
char *name;
{
	char *p;

	pstat("Awaiting inital pathname NAK");
	if(readline(400)==ERROR)			/* wait for inital nak */
		return ERROR;
	/* don't send drive specification */
	if(p=index(':', name))
		name= ++p;
	if(wcputsec(name, 0)==ERROR) {
		printf("Can't send pathname %s\n", name);
		return ERROR;
	}
	return OK;
}

/*
 * Adapted from CMODEM13.C, written by
 * Jack M. Wierda and Roderick W. Hart
 */

wcrx(name)
char *name;
{
	int sectnum, sectcurr, sectcomp;
	char rxbuf[128];

	if(openrx(name)==ERROR)
		return ERROR;
	sectnum=0;
	sendline(NAK);			/* Start the bubble machine */

	for(;;) {
		sectcurr=wcgetsec(rxbuf, (sectnum&0177)?50:130);
		if(sectcurr==(sectnum+1 &0377)) {

			sectnum++;
			for(cp=rxbuf,wcj=128; --wcj>=0; )
				if(putc(*cp++, fout)==ERROR) {
					printf("\nDisk Full\n");
					return ERROR;
				}
			if(View)
				for(cp=rxbuf,wcj=128;--wcj>=0;)
					putchar(*cp++);
			else if(!Quiet)
				printf("%s", (sectcurr&63)?"*":"*\n");
			sendline(ACK);
		}
		else if(sectcurr==sectnum) {
			pstat("Received dup Sector %d",sectcurr);
			sendline(ACK);
		}
		else if(sectcurr==WCEOT) {
			sendline(ACK);
			/* don't pad the file any more than it already is */
			closerx(FALSE);
			return OK;
		}
		else {
			printf(" Sync Error\n");
			return ERROR;
		}
	}
}

/*
 * wcgetsec fetches a Ward Christensen type sector.
 * Returns sector number encountered or ERROR if valid sector not received,
 * or CAN CAN received
 * or WCEOT if eot sector
 * time is timeout for first char, set to 4 seconds thereafter
 ***************** NO ACK IS SENT IF SECTOR IS RECEIVED OK **************
 *    (Caller must do that when he is good and ready to get next sector)
 */

wcgetsec(rxbuf, time)
char *rxbuf;
int time;
{
/* BDSC
	register checksum, wcj, firstch;
*/
	int sectcurr,errors;

	for(Lastrx=errors=0; errors<RETRYMAX; errors++) {
		do
			firstch=readline(time);
			while(firstch != SOH && firstch != TIMEOUT && firstch != EOT
			  && firstch != CAN);
		if(firstch==SOH) {
			sectcurr=readline(1);
			if((sectcurr+readline(1))==255) {
				checksum=0;
				for(cp=rxbuf,wcj=128; --wcj>=0; ) {
					checksum += (*cp++ = readline(1));
				}
				if(((checksum-readline(1))&0377)==0)
					return sectcurr;
				else
					pstat("Checksum Error #%d", errors);
			}
			else
				pstat("Sector number garbled #%d", errors);
		}
		else if(firstch==EOT)
			return WCEOT;
		else if(firstch==CAN) {
			if(Lastrx==CAN) {
				printf("Sender CANcelled\n");
				return ERROR;
			} else {
				Lastrx=CAN;
				continue;
			}
		}
		else if(firstch==TIMEOUT)
			pstat("SOH Timeout #%d", errors);

		Lastrx=0;
		while(readline(1)!=TIMEOUT)
			;
		sendline(NAK);
		time=40;
	}
	/* try to stop the bubble machine. */
	sendline(CAN);sendline(CAN);sendline(CAN);
	return ERROR;
}

wctx()
{
	int sectnum, attempts;
	char txbuf[SECSIZ];

	pstat("Awaiting initial NAK");
	while((firstch=readline(400))!=NAK && firstch!=TIMEOUT && firstch!=CAN)
		;
	if(firstch==CAN)
		return ERROR;
#ifdef STATLINE
	pstat("");
#endif

	sectnum=1;
	while(filbuf(txbuf, SECSIZ)) {
		if(wcputsec(txbuf, sectnum)==ERROR) {
			return ERROR;
		} else {
			if(View)
				for(cp=txbuf,wcj=128;--wcj>=0;)
					putchar(*cp++);
			else if(!Quiet)
				printf("%s", (sectnum&63)?"*":"*\n");
			sectnum++;
		}
	}
	closetx();
	attempts=0;
	do {
		sendline(EOT);
		purgeline();
		attempts++;
	}
		while((readline(100) != ACK) && attempts < RETRYMAX);
	if(attempts == RETRYMAX) {
		printf("\nNo ACK on EOT; Aborting... ");
		return ERROR;
	}
	else
		return OK;
}

wcputsec(txbuf, sectnum)
char *txbuf;
{
/* BDSC
	register checksum, wcj, firstch;
*/
	int attempts;

	firstch=0;	/* part of logic to detect CAN CAN */

	for(attempts=0; attempts <= RETRYMAX; attempts++) {
		Lastrx= firstch;
		sendline(SOH);
		sendline(sectnum);
		sendline(-sectnum-1);
		checksum=0;
		for(wcj=SECSIZ,cp=txbuf; --wcj>=0; ) {
			sendline(*cp);
			checksum += *cp++;
		}
		sendline(checksum);
		purgeline();

		firstch=readline(100);
		if(firstch==CAN && Lastrx==CAN) {
			printf("\nReceiver CANcelled transmission ");
			return ERROR;
		}
		else if(firstch==ACK)
			return OK;
		else if(firstch==TIMEOUT)
			pstat("Timeout on sector ack attempt %d", attempts);
		else
			pstat("Got 0%o for sector ACK attempt %d", firstch, attempts);
	}
	printf("No ACK on sector; Abort ");
	return ERROR;

}
????????????????????????????????????????????????????????????????


/*
>>:yam3.c 10-8-81
 *
 * two-way conversation with remote -whatever.
 * Printer is buffered such that it needn't be as fast as the baudrate
 * as long as it eventually gets a chance to catch up.
 * This buffering also allows one to write the received data out to disk
 * after the conservation has started.
 */
#include "b:yam.h"

term()
{
#ifndef BDSC
	register char cfast;
#endif
	register c, cc;
	unsigned register charsent;
	sayterm();
	charsent=0;
	Waitecho=Txwait=FALSE;
	for(;;) {
		if(MIREADY) {
			*bufcq++ = MICHAR;
			Timeout=0;
			if(bufcq >= bufend) {
				Wrapped=TRUE;
				bufcq=bufst;
			}
			if(--Free == Low)
				outp(MODATA, Xoffflg=XOFF);
			else if(Free==0)
				goto belch;
			continue;
		}
		if(COREADY && bufcdq != bufcq) {
			switch(cfast= (*bufcdq & 0177) ) {
			 case '\b':
				 if(Ttycol)
					--Ttycol;
				break;
			case '\t':
				if(++Ttycol & 07)
#ifdef CDATA
					outp(CDATA, ' ');
#else
					bios(4,' ');
#endif
				else
					goto chuckit;
				continue;
			case '\r':
				Ttycol=0; break;
			case '\n':
				if(Txeoln==EOL_CRWAIT)
					Waitecho=FALSE;
				break;
cxoff:
			case XOFF:
#ifdef STATLINE
				if(Tfile)
					pstat("Sending stopped by XOFF");
#endif
				Txgo=FALSE; break;
cxon:
			case XON:
				Txgo=TRUE;
#ifdef STATLINE
				if(Tfile)
					lpstat("Sending '%s'", Tname);

#endif
				break;
#ifdef XMODEM
			case CPMEOF:
				pstat("");
				return;
			case 007:
				break;
#endif
			default:
				if(
#ifndef XMODEM
				 Ctlview &&
#endif
				 cfast<040) {
					putchar('^'); putchar(cfast|0100);
					Ttycol += 2;
					goto chuckit;
				}
				else
					++Ttycol; break;
			}
#ifdef RXNONO
			if( !index(cfast, RXNONO))
#endif
#ifdef CDATA
				outp(CDATA, cfast);
#else
				bios(4, cfast);
#endif
			if(Echo) {
				sendline(cfast);
				if(Chat && cfast== '\r')
					sendline('\n');
			}
chuckit:
			if(++bufcdq >= bufend)
				bufcdq=bufst;
			continue;
		}
		if(Pflag && bufpcdq!=bufcq && POREADY) {
#ifdef CPM
			bios(5, (*bufpcdq++ & 0177));
#else
			foobar...
#endif
			if(bufpcdq >= bufend)
				bufpcdq=bufst;
		}
		if(CIREADY) {
			switch(cfast= CICHAR&0177){
			 case ENQ:
				 if(moment())	/* ^E ^E quick sends one */
					break;
				pstat(""); return;
			case XON:
				if(Tfile && !Txgo)
					goto cxon;
				break;
			case XOFF:
				if(Tfile && Txgo)
					goto cxoff;
				break;
			case 'v'&037:
				if(moment())
					break;
				replot(TLENGTH<<1); sayterm(); continue;
			case '\r':
				if(Hdx)
					printf("\n");
				if(Chat)
					sendline('\n');
				break;
			default:
				break;
			}
			outp(MODATA, cfast);
			if(Hdx) {
#ifdef CDATA
				while(!COREADY)
					;
				outp(CDATA, cfast);
#else
				bios(4, cfast);
#endif
			}
			continue;
		}
		if(MOREADY) {
			if(Tfile && !Txwait && !Waitecho && Txgo) {
				c= getc(fin);
#ifdef CPM
				if(c==EOF || (c==CPMEOF && Txeoln != TX_BINARY))
#else
				if(c==EOF)
#endif
				{
					closetx(FALSE);
#ifdef XMODEM
					pstat(""); return;
#else
					if(Exoneof)
						return;
					sayterm();
#endif
				}
				if(Waitbunch && ++charsent==Waitnum) {
					charsent=0;
					if(Waitnum>1) {
						Waitecho=TRUE; Timeout=0;
					} else {
						Txwait=TRUE; Txtimeout=Throttle;
					}
				}

				if(c=='\r') {	/* end of line processing */
					switch(Txeoln) {
					case EOL_NL: continue;
					case EOL_CRPROMPT:
					case EOL_CRWAIT:
						Waitecho=TRUE; Timeout=0;
					case EOL_CR:
						if((cc=getc(fin))!='\n')
							ungetc(cc, fin);
						break;
					}
				}
				outp(MODATA, c);
				continue;
			}
		}
		if(++Timeout == Tpause) {
			Waitecho=FALSE;
belch:
			if(Xoffflg) {
				dumprxbuff();
				if(MIREADY) {
					lpstat("OVERRUN: DATA LOST");
					return;
				}
				if(bufcdq != bufcq)
					continue;
				if(Pflag && bufpcdq != bufcq)
					continue;
				Free=Bufsize-1;
				Xoffflg=FALSE;
				outp(MODATA, XON);
			}
#ifdef CDO
			if(CDO) {
				pstat("Carrier Lost");
				return;
			}
#endif
		}
		if(--Txtimeout==0)
			Txwait=FALSE;
	}
}

/* display the appropriate status information */
sayterm()
{
#ifdef TERMRESET
	lprintf(TERMRESET);
#endif
	if(Tfile)
		lpstat("Sending '%s' %s", Tname, Txgo?"":"Stopped");
	if(Rfile)
		pstat("Term Receiving '%s'", Rname);
	else
		pstat("Term Function");
}

/* open a capture file and set the removal pointer to get max goods */
opencapt(name)
char *name;
{
	dumprxbuff(); closerx(TRUE);
	if(openrx(name)==ERROR)
		return ERROR;
	if(buffcdq<bufst)
		buffcdq=bufst;
	if(Wrapped)
		buffcdq=bufcq+1;
	if(buffcdq >= bufend)
		buffcdq=bufst;
/*	dumprxbuff(); */
}


dumprxbuff()
{
	register c;

	if(!Rfile || buffcdq==NULL)
		return OK;
	while(buffcdq != bufcq) {
		c= *buffcdq++;
		if(buffcdq >= bufend)
			buffcdq=bufst;
		if(!Image) {
			switch(c &= 0177) {
			 case 0:
				 continue;
			case 032:		/* ^Z or CPMEOF */
				if(Zeof) {
					closerx(TRUE);
					return;
				}
				else
#ifdef CPM
					continue;
#else
					break;
#endif
			case 022:
				if(Squelch) {
					Dumping=TRUE;
					continue;
				}
				break;
			case 024:
				if(Squelch) {
					Dumping=FALSE;
					continue;
				}
				break;
			default:
				break;
			}
		}
		if(Dumping || Image)
			if(putc(c, fout)==ERROR) {
				printf("\nDisk Full\n");
				closerx(FALSE);
				return ERROR;
			}
	}
	Free=Bufsize-1;
	return OK;
}

rewindcb()
{
	bufcdq=buffcdq=bufpcdq=Wrapped?bufcq+1:bufst;
}

/*
 * replot redisplays the buffer contents thru putcty allowing XOFF
 * number will represent how many lines to go back first 
 */
replot(number)
{
	char *s, c;
	int count, shorts;

fromtop:
	shorts=0;
	bufmark=Wrapped?bufcq+1:bufst;

	if(number) {
		s=bufcq;
backsome:
#ifdef TERMINIT
		/* backing up is confusing unless screen is cleard first */
		lprintf(TERMINIT);
#endif
		for(;;) {
			--s;
			if(s<bufst) {
				if(Wrapped)
					s= bufend-1;
				else {
					s=bufst;
					break;
				}
			}
			if(s==bufcq)
				break;
			if((*s&0177)=='\n' && --number<=0)
				break;
		}
		bufmark=s;
	}
	s=bufmark;
nextscreen:
#ifdef T4014
	/* Do the big flash on the 4014 or 4012 */
	printf("\033\014");
	sleep(CLKMHZ * 5);
#endif
	count=TLENGTH - shorts;
	shorts =0;
nextline:
	while(s != bufcq) {
		cfast= *s++ & 0177;
		if(s >= bufend)
			s=bufst;
		if(c=putcty(cfast))
			goto choose;
		if(cfast=='\r' && --count<=0)
			break;
	}

#ifdef STATLINE
	pstat("Replot cmd?");
#endif
	c=getcty();
#ifdef STATLINE
	pstat("");
#endif
choose:
/* Treat Control chars and letters the same */
	switch((c|0140)&0177) {
	case 'b':
		number=0; goto fromtop;
	case 'v':	/* control-v or v */
	case 'h':	/* backspace */
		number=TLENGTH-2; s=bufmark; goto backsome;
	case 0140:		/* space bar */
		shorts=2; bufmark=s; goto nextscreen;
	case 'p':
		number=1; s=bufmark; goto backsome;
	case 'n':
	case 'j':	/* linefeed */
		bufmark=s; count=1; goto nextline;
	default:
		return;
	}
}

/*
 * moment waits a moment and returns FALSE, unless a character is hit,
 * in which case that character is returned
 */
moment()
{
	int c;
	for(c=300*CLKMHZ; --c>0;)
		if(kbhit())
			return(getchar());
	return FALSE;
}
chat()
{
#ifdef XMODEM
	printf("Ring My Chimes, Maybe I'll Come\n");
	printf("Exit chat with ^Z\n");
#endif
	Chat=Ctlview=Hdx=Echo=TRUE;
	term();
}
????????????????????????????????????????????????????????????????


/*
>>:yam5.c 10-10-81
 * Modem related functions. If your modem supports baudrate setting,
 * and hangup, write your own routines here.
 * If your modem supports an autocall, put that routine here also
 * define MODEMSTUFF to suppress default baud rate related functions.
 * define AUTOCALL in your autocall routine to suppress the default
 * which merely prints the phone number and recommended baud rate.
 */

/*
 * setbaud(nbaud) If legal rate, set modem registers and Baudrate
 */
#include "b:yam.h"

#DEFINE AUTODIAL TRUE
#DEFINE PMMI TRUE

#ifdef TUART
#define MODEMSTUFF
/*
 * set baud rate for modem driven by Cromenco TUART
 */
setbaud(nbaud)
unsigned nbaud;
{
	char command, baudcmd;
	command=0;
	switch(nbaud) {
	case 110: baudcmd=0001;break;
	case 150: baudcmd=0202;break;
	case 300: baudcmd=0204;break;
	case 1200: baudcmd=0210;break;
	case 2400: baudcmd=0220;break;
	case 4800: baudcmd=0240;break;
	case 9600: baudcmd=0300;break;
	case 19200: baudcmd=0220;command=020;break;
	case 38400: baudcmd=0240;command=020; break;
	default:
		return ERROR;
	}
	outp(Sport, baudcmd);
	outp(Sport+2, command);
	Baudrate=nbaud;
	return 0;
}
readbaud()
{
	Baudrate=DEFBAUD;
}

/* Bye disconnects the line and allows another call */
bye()
{
	outp(Sport+2, 03);	/* turn on break */
	sleep(40/CLKMHZ);	/* wait two seconds */
	setbaud(Baudrate);
}

/* onhook disconnects the line for good */
onhook()
{}	/* no way to go on hook with this setup */
#endif
#ifdef Z89
#define MODEMSTUFF
/*
 * Routine to set baud rate for 8250 driven modem port
 */
setbaud(nbaud)
unsigned nbaud;
{
	unsigned bcmd;

	if(nbaud==0)
		return ERROR;
	bcmd= 57600;		/* 1.8432 Mhz clock */
	bcmd /= (nbaud/2);	/* this must be done unsigned! */
	outp(Dport+3, 0203);    /* enable divisor latch */
	outp(Dport, bcmd);
	outp(Dport+1, (bcmd>>8));
	/* 8 data bits, 1 stop bit (2 if 110 baud), disable divisor latch */
	outp(Dport+3, nbaud==110? 07:03);
	/* turn on dtr and rts, also output2 is baudrate is 1200 or more */
	outp(Dport+4, nbaud>=1200?017:03);
	Baudrate=nbaud;
/*
	printf("bcmd=%d bcmdms=0%o bcmdls=0%o\n",bcmd,(bcmd>>8),(bcmd&0377));
*/
	return OK;
}
/* fetch the baudrate from the modem port */
readbaud()
{
	char dp3;
	unsigned div;

	dp3=inp(Dport+3);
	outp(Dport+3, 0200|dp3);
	div= inp(Dport) | (inp(Dport+1)<<8);	/* fetch divisor */
	outp(Dport+3, dp3);	/* restore uart modes */
	Baudrate=57600;		/* be sure all this remains unsigned! */
	Baudrate /= div;
	Baudrate <<= 1;
}

/* Bye hangs up the line and then resets for another call */
bye()
{
	onhook();
	sleep(40/CLKMHZ);
	setbaud(Baudrate);
}

/* onhook goes off line for good */
onhook()
{
	outp(Dport+4, 0);
}

#endif
#ifdef TRSII
#define MODEMSTUFF
/*
 * set baud rate for modem driven by TRS 80 MOD II with Pickles & Trout CP/M
 */
setbaud(nbaud)
unsigned nbaud;
{
	char calla(), command, baudcmd, regB, regC, regD, regE, regH, regL;
	command=0;
	switch(nbaud) {
	case 110: baudcmd=0;break;
	case 150: baudcmd=2;break;
	case 300: baudcmd=3;break;
	case 600: baudcmd=4;break;
	case 1200: baudcmd=5;break;
	case 2400: baudcmd=6;break;
	case 4800: baudcmd=7;break;
	case 9600: baudcmd=8;break;
	default:
		return ERROR;
	}
	regB = 0;		/* setup  serial ports */
	regC = 0;		/* port a, parity odd and disabled */
	regD = 0xe6;		/* DTR,RTS high, 8-bit wds, 1 stop */
	regE = baudcmd;		/* baud rate */
	regH = 19;		/* Xmit off char */
	regL = 17;		/* Xmit on-off handshaking; X-on char */
	calla(0x40,0,(regH << 8 | regL),(regB << 8 | regC),
			(regD << 8 | regE));   /* call P&T special function */
	Baudrate=nbaud;
	return 0;
}
readbaud()
{
	Baudrate=DEFBAUD;
}

/* Bye disconnects the line and allows another call */
bye()
{
	onhook();
	sleep(40/CLKMHZ);	/* wait two seconds */
	setbaud(Baudrate);
}

/* onhook disconnects the line for good */
onhook()
{
	char calla();
	calla(0x40,0,0,0x40,0);	/* set DTR, RTS low */
}
#endif
#ifdef PMMI

#define MODEMSTUFF
setbaud(nbaud)
{
	char baudcmd;
	switch(nbaud) {
	case 110: baudcmd=142;break;
	case 300: baudcmd=52;break;
	case 450: baudcmd=34;break;
	case 600: baudcmd=26;break;
	case 710: baudcmd=22;break;
	default:
		return ERROR;
	}
	outp(Sport+2,baudcmd);
	 /* turn on data terminal below 300 */
	if(nbaud<301) outp(Sport+3,0x7F);
	 /* above 300 baud */
	if(nbaud>300) outp(Sport+3,0x5F);
	mysleep(10);
	Baudrate=nbaud;
	return 0;
}
onhook()
{
	outp(Sport+3,0x3F); /* idle modem */
	outp(Sport,0);      /* go onhook */
	mysleep(100);	    /* 10 secs to go on */
}
bye()
{
	onhook();
	setbaud(Baudrate);
}
readbaud()
{
	Baudrate=DEFBAUD;
}
#endif

#ifndef MODEMSTUFF
setbaud()
{}	/* INSERT ROUTINE HERE IF AVAILABLE */
onhook()
{}	/* INSERT ROUTINE HERE IF AVAILABLE */
bye()
{}	/* INSERT ROUTINE HERE IF AVAILABLE */
readbaud()
{
	Baudrate=DEFBAUD;
}
#endif

/*
 * Readline from MODEM13.C rewritten to allow much higher
 * baud rates.
 * Timeout is in deciseconds (1/10th's)
 * For top speed, character ready is checked in many places.
 * returns TIMEOUT if kbd character is ready.
 *
 * There are three versions of readline, the first is used if
 * there is a separate register for error conditions. The second
 * is used if error condx are in the same register asrx data ready.
 * The last, and quickest, does not check error conditions.
 */
#ifdef MIERROR
/* version for separate error register. NOT TESTED */
readline(decisecs)
{
	if(MIREADY) {
		if(MIERROR)
			goto fubar;
		else
			return MICHAR;
	}
	while(--decisecs>=0) {
		if(MIREADY) {
			if(MIERROR)
				goto fubar;
			else
				return MICHAR;
		}
		if(CDO)
			return TIMEOUT;
		if(CIREADY) {
			CICHAR;		/* dismiss character */
			return TIMEOUT;
		}
		for(Timeout=T1pause; --Timeout; )
			if(MIREADY) {
				if(MIERROR)
					goto fubar;
				else
					return MICHAR;
			}
	}
	return TIMEOUT;
fubar:
	MICHAR;		/* throw the turkey away */
	MI_ERROR_RESET;
	return ERROR;
}

#define READLINE
#endif

#ifdef MIREADYERROR
/* Version for 8250, 8251, 2651, etc. with all bits in one register */
readline(decisecs)
{
	if((Mstatus=inp(Sport))&MIREADYMASK)
		goto getit;
	while(--decisecs>=0) {
		if((Mstatus=inp(Sport))&MIREADYMASK)
			goto getit;
		if(CDO)
			return TIMEOUT;
		if((Mstatus=inp(Sport))&MIREADYMASK)
			goto getit;
		if(CIREADY) {
			CICHAR;		/* dismiss character */
			return TIMEOUT;
		}
		if((Mstatus=inp(Sport))&MIREADYMASK)
			goto getit;
		for(Timeout=T1pause; --Timeout; )
			if((Mstatus=inp(Sport))&MIREADYMASK) {
getit:
				if(Mstatus&MIERRORMASK) {
					MICHAR;		/* chuck it */
					inp(Sport);	/* reset err bits */
					return ERROR;
				}
				else
					return MICHAR;
			}
	}
	return TIMEOUT;
}
#define READLINE
#endif

#ifndef READLINE
readline(decisecs)
{
	if(MIREADY)
		return MICHAR;
	while(--decisecs>=0) {
		if(MIREADY)
			return MICHAR;
		if(CIREADY) {
			CICHAR;		/* dismiss character */
			return TIMEOUT;
		}
		if(MIREADY)
			return MICHAR;
		for(Timeout=T1pause; --Timeout; )
			if(MIREADY)
				return MICHAR;
	}
	return TIMEOUT;
}
#endif

sendline(data)
char data;
{
	while(!MOREADY)
		;
	outp(MODATA, data);
}
purgeline()
{
	while(MIREADY)
		MICHAR;
}

/* default "autodial" routine */
#ifndef AUTODIAL
dial(name)
char *name;
{
	char *s;
/*#ifdef CAFPERSONAL
	Sport=(Dport=216)+(SPORT-DPORT);
#endif
*/	if((s=cisubstr(name, "\tb")))
		if(!setbaud(atoi(s+2)))
			printf("Baudrate set to %u: ", Baudrate);
	printf("%s", name);
	return OK;
}
#endif

#ifdef AUTODIAL		/* PMMI AUTODIAL ROUTINES */
dial(name)
char *name;
{
	char *s,*n,c, conflg;
	int chinp, pause;
	conflg= FALSE;
dagain:	n=cisubstr(name, "\t")+1;
	if((s=cisubstr(name, "\tb")))
	printf("%s\n", name);
	else return;
	printf("\nWAITING FOR DIAL TONE\n");
	if(!dtdet()){
		printf(" NO DIAL TONE \n");
		onhook();
		return;
	}
	printf(" DIALING-- \n");
	while((c=*n) != 'b'){
		printf("%c",c);
		if (isdigit(c)) click(c);
		++n;
		if(kbhit()) {
			onhook();
			return;
		}
	}

/* number has been dialed now check for an answer */
	printf("Waiting for answer ");
	pause=25;
	outp(Sport+3,0x7f);
	mysleep(10);
	outp(Sport,0x5d);
	while(inp(Sport+2)&4){
		printf(".");
		mysleep(10);
		--pause;
		if (kbhit()) pause=0;
		if (pause==0) break;
	}
	if(pause==0){
		onhook();
		printf("\n\0x07 No Answer !!");
		if (conflg) goto dagain;
		printf("\n Call again ?(Y) Continous ?(C)-");
		chinp=tolower(getchar());
		printf("\n\n");
		if(chinp== 'c'){ conflg = TRUE;
			goto dagain;
		}
		if (chinp== 'y') goto dagain;
		return;
	}
	
	printf("\7\7\7\N COMPUTERS ARE ON LINE \7\7\7\N");
	if(!setbaud(atoi(s+2)))
		printf("\n Baudrate set to %u: ", Baudrate);
	outp(Sport,0x1D);  /* off hook originate mode */
	outp(Sport,0x5C); /*setup usart */
	mysleep(10);

	return OK;
}

dtdet(){
	int	pause;
	pause=20;
	outp(Sport,1);  /* off hook */
	outp(Sport+3,0x2f); /* set det filters */
	while(inp(Sport+2)&1){
		printf(".");
		mysleep(5);
		if((pause--)==0) return FALSE;
	}
	return TRUE;
}
click(num)
char num;
{
unsigned number;
	number = num - '0';
	if (number == 0) number = 10;
		outp(Sport+2,0xFA);
		while(inp(Sport+2) & 0x80);
		while((inp(Sport+2)&0x80)^0x80);
	while (number-- ){
		outp(Sport,1);
		while(inp(Sport+2) & 0x80);
		outp(Sport,0);
		while((inp(Sport+2)&0x80)^0x80);
	}
	outp(Sport,1);
	mysleep(5);
}
#endif


/* added so kbhit() could interupt dialing */
mysleep(decsec)
int	decsec;
{
int	delay;
	delay=30000;
	while(decsec--)
		while (delay) delay--;
return delay;
}

????????????????????????????????????????????????????????????????


/*
>>:yam7.c 10-5-81
 * File open and close stuff
 * This file assumes operation on a CP/M system
 */
#include "b:yam.h"
/* dpb dph blocks from CP/M Interface Guide Sect 6.5 */

struct dpb {	/* CP/M Version 2 Disk Parameter Block */
	unsigned dpb_spt;	/* sectors per track */
	char dpb_bsh;		/* block shift factor */
	char dpb_blm;
	char dpb_exm;		/* EXtent Mask */
	unsigned dpb_dsm;	/* Highest block number on this disk */
	unsigned dpb_drm;	/* total number of directory entries -1 */
	unsigned dpb_al;	/* bit field corresponding to direc blocks */
	unsigned dpb_cks;	/* size of the directory check vector */
	unsigned dpb_off;	/* number of reserved tracks on this disk */
};

char *call();

struct dph {	/* CP/M Version 2 Disk Parameter Header */
	char **dph_xlt;		/* logical to physical xlat vector */
	int dph_ooo;
	char *dph_dirbuf;	/* 128 byte scratchpad for directory use */
	struct dpb *dph_dpb;	/* disk param block for this type of disk */
	char **dph_csv;		/* scratch area for detecting changed disks */
	char *dph_alv;		/* pointer to bit vector alloc map for disk */
};

struct fcb {	/* CP/M Version 2 fcb AS SEEN BY THE USER */
	char	dr;		/* drive number */
	char	fname[8];	/* fname[1] used by TAG2 */
	char	ftype[3];	/* ftype[1] 8th bit set for $SYS */
	char	ex;		/* file extent normally 0 */
	char s1;		/* reserved for bdos's benefit */
	char s2;		/* likewise, =0 on call to open,make,search */
	char	rc;		/* record count for extent[ex]  0...128 */
	char dmap[16];
	char cr;		/* current record, initialized to 0 by usr */
	unsigned recn;		/* highest record number */
	char recovf;		/* overflow of above */
};

/* following are BIOS calls */
#define CONST 2			/* bios console char ready */
#define CONIN 3			/* bios cons char input */
#define CONOUT 4		/* bios cons char output */

/* following are BDOS calls */
#define BDOS 5			/* address used to call bdos */
#define SELDSK 14		/* bdos select disk 0=default disk */
#define SRCH 17 		/* bdos search for file pattern*/
#define SRCHNXT 18		/* search for next occurrence */
#define GETDEFDISK 25		/* get current disk  (0-15) */
#define SETDMA 26		/* set address for read, write, etc. */
#define GETALLOCP 27		/* get address of allocation vector */
#define SETATTRIB 30		/* update file attributes */
#define GETDPBP 31		/* get DPB address for disk */
#define SETGETUSER 32		/* set or get user number */
#define COMPFILSIZ 35		/* compute file size into recn and recovf */
#define UFNSIZE 15		/* a:foobar12.urk\0 is 15 chars */

openrx(name)
char *name;
{

#ifdef RESTRICTED
	char *s;
	if(s=cisubstr(name, ".com"))	/* upload .com files as .obj */
		strcpy(s, ".OBJ");
	if(cisubstr(name, "$$$"))
		return ERROR;		/* don't allow upload of $$$.sub */
	for(s=name; *s; )
		if(*s++ > 'z')
			return ERROR;	/* no garbage names please */
#endif
	unspace(name);
	lprintf("'%s' ", name);		/* show the name right away */
	if(!Creamfile && fopen(name, fout) != ERROR) {
		fclose(fout);
		printf("Exists ", name);
#ifdef XMODEM
		return ERROR;
#else
		printf("Replace it (y/n)??");
		if(tolower(getchar())!= 'y')
			return ERROR;
#endif
	}
	if(fcreat(name, fout)==ERROR){
		printf("Can't create %s\n", name);
		return ERROR;
	}
	Rfile= TRUE;
	strcpy(Rname, name);
	Dumping= !Squelch;
	lprintf("Created%s\n", Dumping? "" : " recording OFF");
	return OK;
}

closerx(pad)
{
	if(Rfile) {
		if(!Quiet)
			lpstat("Closing %s", Rname);
#ifdef BDSC
		if(pad)
			do
				putc(CPMEOF, fout);
				while(fout._nleft % SECSIZ);
#endif
		fflush(fout);
		fclose(fout);
		Rfile=FALSE;
#ifdef LOGFILE
		logfile(Rname, pad?'*':'r');	/* record file xmsn */
#endif
	}
}

opentx(name)
char *name;
{
	struct fcb *fp, *fcbaddr();
	lprintf("'%s' ", name);
	unspace(name);
	if(fopen(name, fin)==ERROR){
		printf("Can't open %s\n", name);
		return ERROR;
	}
#ifdef RESTRICTED
	if(cisubstr(name, ".bad")
	 || (fp=fcbaddr(fin._fd))==ERROR
	 || (fp->fname[1] & 0200)	/* tag2 */
	 || (fp->ftype[1] & 0200)	/* $SYS */
	 ) {
	 	fclose(fin); printf("\n'%s' Not for Distribution\n", name);
		return ERROR;
	}
#endif
	Tfile= TRUE;
	strcpy(Tname, name);
	lprintf("Open\n");
	return OK;
}

/* closetx(status) call with status != 0 if incomplete file xmsn */
closetx(status)
{
	if(Tfile) {
		fclose(fin);
		if(!Quiet)
			lpstat("%s closed", Tname);
#ifdef LOGFILE
		if(!status)
			logfile(Tname, 's');		/* record file xmsn */
#endif
		Tfile=FALSE;
	}
}
/* search the phone file for name */
getphone(name, buffer)
char *name, *buffer;
{
	closetx(TRUE);

	if(fopen(PHONES, fin)==ERROR) {
		printf("Cannot open %s\n", PHONES);
		return ERROR;
	} else {
		while(fgets(buffer, fin))
			if(cmdeq(buffer, name)) {
				fclose(fin);
				return OK;
			}
	}
	printf("Can't find data for %s\n", name);
	fclose(fin);
	return ERROR;
}

/* channge default disk and optionally, user number */
chdir(p)
char *p;
{
	unsigned newuser;
	struct dpb *dp;

	newuser=user; *p=toupper(*p);
	if(index(*p, DISKS)) {
		defdisk= *p - 'A';
		bdos(SELDSK, defdisk);
#ifdef CDOS
		return;
#else
		dp=call(BDOS, 0, 0, GETDPBP, defdisk);
		Secpblk= 1 << dp->dpb_bsh;
		printf("%u kb Free on %c", getfree(defdisk), defdisk+'A');
		if(!isdigit(p[1]))
			return;
		if((newuser=atoi(p+1)) <= MAXUSER) {
			bdos(SETGETUSER, newuser);
			user=newuser;
			return;
		}
#endif
	}
	printf("Disk %c and/or User %d Illegal\n", *p, newuser);
}

/* fetch default disk and user number */
initdd()
{
	Secpblk=SECPBLK;
	defdisk= bdos(GETDEFDISK,0);
#ifdef CDOS
	user=0;
#else
	user=bdos(SETGETUSER, 0377);
#endif
}

/*
 * Z19 gets to use it's 25th line. pstat starts at 48th char
 * note that a call to lpstat will erase what pstat displays
 */
/*VARARGS*/
pstat(a,b,c)
char *a, *b, *c;
{
#ifdef Z19
	lprintf("\033x1\033j\033Y8P");
#endif
	lprintf(a,b,c);
#ifdef Z19
	lprintf("\033K\033k");
#else
	lprintf("\n");
#endif
}

/*
 * Z19 gets to use it's 25th line. lpstat starts at col 1
 * Rest of line is erased
 */
/*VARARGS*/
lpstat(a,b,c)
char *a, *b, *c;
{
#ifdef Z19
	lprintf("\033x1\033j\033Y8 ");
#endif
	lprintf(a,b,c);
#ifdef Z19
	lprintf("\033K\033k");
#else
	lprintf("\n");
#endif
}
char getcty()
{
	return bios(CONIN,0);
}
char putcty(c)
char c;
{
#ifdef RXNONO
	if( !index(c, RXNONO))
#endif
		bios(CONOUT, c);
	if(bios(CONST,0)) {
		if((c=bios(CONIN,0))==XOFF)
			bios(CONIN,0);
		else
			return c;
	}
	return FALSE;
}

dolist(argc, argp)
char **argp;
{
	int listfile();

#ifdef XMODEM

	printf("^S pauses, ^K skips to next file, ^X terminates\n");

#endif

	expand(listfile, argc, argp);
}

listfile(name)
char *name;
{
	int c;

#ifdef XMODEM
	printf("\nListing '%s'\n\022", name);
#endif
	closetx(TRUE);
	if(opentx(name)==ERROR)
		return ERROR;
	else {
		while((c=getc(fin))!=EOF && c != CPMEOF) {
			if( !(c=putcty(c)))
				continue;
			if(c==003 || c==CAN || c==013) {
				c=0; break;
			}
		}
		/* record complete xmsn iff terminated by (CPM)EOF */
		closetx(c==0);
#ifdef XMODEM
		sendline(024);	/* squelch in case user downloading */
#endif		
	}
	/* cancel rest of files if ^C ^X */
	if(c==003 || c==CAN)
		return ERROR;
	else
		return OK;
}

/* fill buf with count chars padding with ^Z for CPM */
filbuf(buf, count)
char *buf;
{
	register c, m;
	m=count;
	while((c=getc(fin))!=EOF) {
		*buf++ =c;
		if(--m == 0)
			break;
	}
	if(m==count)
		return 0;
	else
		while(--m>=0)
			*buf++ = 032;
	return count;
}

dodir(argc, argp)
char **argp;
{
/*	printf("Directory\n");*/
	int pdirent();
	cfast=0;		/* counter for 4 across format */
	expand(pdirent, argc, argp);
}
pdirent(name)
{
	printf("%-14s%c", name, (++cfast&03)?' ':'\n');
}
#ifndef CDOS
/* docomp does a directory listing showing sectors for each matched file
 * and computes total transmission time of matched files in batch mode
 * time is sum of:
 * 	number of files * open/close time (assumed 5 seconds)
 *	time to xmit and ACK each sector assuming no path delay or error
 *	disk i/o time at each end, not dependent on baud rate
 */
docomp(argc,argp)
char **argp;
{
	unsigned compsecs();
	unsigned spm;	/* sectors per minute-baud */
	unsigned dminutes;	/* tenths of minutes */
	cfast=Numsecs=Numblks=0;
/*	printf("Directory\n");*/
	expand(compsecs, argc, argp);

	spm= Baudrate/23;	/* (Baudrate*60)/(10 bits each char * 136 chars) */
	dminutes= Numfiles+((10*(Numfiles+Numsecs))/spm)+(Numsecs/20);
	printf("\n%u Files %u Blocks %u K\n",
	  Numfiles, Numblks, (Numblks*(Secpblk/8)));
	printf("%u Sectors %u.%u Minutes Xmsn Time at %u Baud\n",
	  Numsecs, dminutes/10, dminutes%10, Baudrate);

}
/* add file length (in CP/M 128 byte records) to Numsecs */
unsigned compsecs(ufn)
char *ufn;
{
	struct fcb fstat;
	printf("%-14s", ufn);
	unspace(ufn);
	setfcb( &fstat, ufn);
	bdos(COMPFILSIZ, &fstat);
	Numsecs += fstat.recn;
	Numblks += (fstat.recn+Secpblk)/Secpblk;
	printf("%4u%c",fstat.recn, (++cfast&03)?' ':'\n');
	return fstat.recn;
}
#endif

expand(fnx, argc, argp)
int (*fnx)();
char **argp;
{
	char name[PATHLEN], *s;
	Numfiles=0;

	if(argc<=0)
		return e1xpand(fnx, "*.*");
	else
		while(--argc>=0) {
			/* change b: to b:*.*     */
			strcpy(name, *argp++);
			if((s=index(':', name)) && *++s == 0)
				strcpy(s, "*.*");
			if(e1xpand(fnx, name)==ERROR)
				return ERROR;
		}
	return OK;
}

/*
 * e1xpand expands ambiguous pathname afnp
 * calling fnx for each.
 * Modified from: Parameter list builder by Richard Greenlaw
 *                251 Colony Ct. Gahanna, Ohio 43230
 */
e1xpand(fnx, afnp)
int (*fnx)();
char *afnp;	/* possible ambiguous file name*/
{
	struct fcb sfcb, *pfcb;
	FLAG first;
	char *p, *q, i, byteaddr;
	int filecount, m;
	char tbuf[SECSIZ];
	struct {
		char xYxx[UFNSIZE];		/* unambiguous file name */
	} *fp;
	int strcmp();


	/* build CPM fcb   */
	unspace(afnp);
	if(setfcb(&sfcb, afnp) == ERROR) {
		printf("%s is bad pattern\n", afnp);
		return ERROR;
	}

	if(Wrapped || (bufend-bufcq)<2048) {
		dumprxbuff();		/* I need the space for building the pathlist */
		clearbuff();		/* so the printer won't try to list dir's */
		bufmark=bufst;
	} else
		bufmark=bufcq;

	/* Search disk directory for all ufns which match afn*/
	for(fp=bufmark,filecount=0,first=TRUE;; fp++,filecount++) {
tryanother:
		bdos(SETDMA, tbuf);
		/* seems CP/M outta know whether to use SRCH or SRCHNXT !! */
		byteaddr=bdos(first? SRCH:SRCHNXT, &sfcb); first=FALSE;
		if(byteaddr==255)
			break;
		/* calculate pointer to filename fcb returned by bdos */
		pfcb = (tbuf + 32 * (byteaddr % 4));
#ifdef RESTRICTED
		/* check for $SYS or tag bit on 2nd byte of filename (TAG2) */
		if((pfcb->fname[1]&0200) ||(pfcb->ftype[1]&0200))
			goto tryanother;
#endif
		Numfiles++;
		p = fp;
		if(fp>bufend) {	/* Note: assumes some slop after bufend! */
			printf("Out of Memory for pathname expansion\n");
			return ERROR;
		}
		if(*(afnp+1) == ':') {
			/* Drive spec.*/
			*p++ = *afnp;
			*p++ = ':';
		}

		/*Copy filename from directory*/
		q = pfcb;
		for(i =8; i; --i)
			*p++ = (0177& *++q);
		*p++ = '.' ;

		/*Copy file extent*/
		for(i = 3; i; --i)
			*p++ = (0177& *++q);
		*p = '\0' ;

	}
	if(filecount==0) {
		printf("'%s' NOT FOUND\n", afnp);
		return ERROR;
	}

	qsort(bufmark, filecount, UFNSIZE, strcmp);

	for(fp=bufmark; --filecount>=0;) {
		p=fp++;
		/* execute desired function with real pathname */
		if((*fnx)(p)==ERROR)
			return ERROR;
	}
	return OK;
}

/*
 * cisubstr(string, token) searches for lower case token in string s
 * returns pointer to token within string if found, NULL otherwise
 */
char *cisubstr(s, t)
char *s,*t;
{
	char *ss,*tt;
	/* search for first char of token */
	for(ss=s; *s; s++)
		if(tolower(*s)==*t)
			/* compare token with substring */
			for(ss=s,tt=t; ;) {
				if(*tt==0)
					return s;
				if(tolower(*ss++) != *tt++)
					break;
			}
	return NULL;
}
#ifdef XMODEM

/*
 * lprintf is like regular printf but uses direct output to console
 * This prevents status printouts from disrupting file transfers, etc.
 */

lprintf(a,b,c,d,e,f)
char *a, *b, *c, *d, *e, *f;
{
	char lbuf[CMDLEN], *s;
	/* format data into lbuf */
	sprintf(lbuf, a,b,c,d,e,f);
	/* now send lbuf to console directly */
	for(s=lbuf; *s; ) {
		if(*s=='\n') {
			while(!COREADY)		/* expand \n to \r\n */
				;
			outp(CODATA, '\r');
		}
		while(!COREADY)
			;
		outp(CODATA, *s++);
	}
}
#endif

/* copy string s onto itself deleting spaces "hello there" > "hellothere" */
unspace(s)
char *s;
{
	char *p;
	for(p=s; *s; s++)
		if(*s != ' ')
			*p++ = *s;
	*p++ =0;
}

#ifdef LOGFILE
/*
 * logfile keeps a record of files transmitted.
 * Mode is 's' for send file, 'r' for receive file, 't' for type file
 * Lifted from xcmodem by J. Wierda,R. Hart, and W. Earnest
 */
#define RPB 4	/* log records per buffer */
#define LRL 32	/* logical rec length LRL*RPB == SECSIZ */
logfile(name, mode)
char *name;
char mode;
{
	struct fcb *fcbaddr(),*fp;
	int fd,rnum,bnum,thedisk;
	char *i, *lrec, lbuf[SECSIZ+2];

	/* find out what disk was used */
	thedisk=defdisk + 'a';
	if(i=index(':', name)) {
		thedisk = *name;
		name= ++i;
	}
	bdos(SETGETUSER, 0);	/* get it from user 0 */
	fd=open(LOGFILE,2);
	if(fd == ERROR) {	/* if file absent, create and initialize it */
		fd = creat(LOGFILE);
		if(fd == ERROR)
			return;
		else {
			rnum=1;
			fp=fcbaddr(fd);
			fp->fname[1] |= 0200;	/* set TAG2 bit */
			fp->ftype[1] |= 0200;	/* set SYS bit */
			bdos(SETATTRIB, fp);	/* and update attributes */
		}
	}
	else {
		read(fd, lbuf, 1);
		rnum=atoi(lbuf)+1;
	}
	setmem(lbuf, SECSIZ, 0);
	sprintf(lbuf, "%d\r\n", rnum);
	seek(fd,0,0);
	write(fd, lbuf, 1);		/* update last record number */
	bnum=rnum/RPB;
	rnum=(rnum%RPB)*LRL;
	seek(fd, bnum, 0);
	if(rnum==0)
		setmem(lbuf, SECSIZ, 0);
	else
		read(fd, lbuf, 1);
	sprintf(&lbuf[rnum], "\r\n%c %5u	%c%2d %-14s",
	 mode, Baudrate, thedisk, user, name);
	seek(fd, bnum, 0);
	write(fd,lbuf,1);
	close(fd);
	bdos(SETGETUSER, user);
}
#endif


docrck(argc, argp)
char **argp;
{
	int crckfile();

	expand(crckfile, argc, argp);
}

/* Accumulate and print a "crck" for a file */
crckfile(name)
char *name;
{
	unsigned crck();
	char crbuf[SECSIZ]; int fd,st;

	printf("%14s ", name); unspace(name);
	if((fd=open(name, 0))==ERROR)
		return ERROR;

	oldcrc=0;
	while((st=read(fd, crbuf, 1)) ==1)
			oldcrc=crck(crbuf, SECSIZ, oldcrc);
	close(fd);
	if(st != 0)
		printf("READ ERROR ");
	else
		printf("CRCK= %04x\n", oldcrc);
	return OK;
}

/* return total free kilobytes of disk */
unsigned getfree(disk)
{
	struct dpb *dp;
	/* unsigned */ char v, c, *s;
	unsigned total, count;

	bdos(SELDSK, disk);
	dp=call(BDOS, 0, 0, GETDPBP, disk);
	s=call(BDOS, 0, 0, GETALLOCP, disk);
	total=0;
	count=dp->dpb_dsm+1;
	for(;;) {
		v= *s++;
		for(c=0200; c; c>>=1) {
			if((v & c)==0)
				++total;
			if(--count ==0) {
				bdos(SELDSK, defdisk);
				return total << dp->dpb_bsh-3;
			}
		}
	}
}
????????????????????????????????????????????????????????????????


;>>:yam8.asm 9-30-81
;
;CRCK is a program to read any CP/M file and print
;a CYCLIC-REDUNDANCY-CHECK number based on the
;CCITT standard polynominal:
;   X^16 + X^15 + X^13 + X^7 + X^4 + X^2 + X + 1
;
;Useful for checking accuracy of file transfers.
;More accurate than a simple checksum.
;
;**************************************************
;
;	unsigned crck(buffer, bufsize, oldcrc)
;
;	At start of packet, oldcrc is set to 0
;
;	crc is accumulated by:
;		oldcrc=crck(buffer, bufsize, oldcrc);
;
;	crck for file is final value of oldcrc
;
;	A Short Hostory of this function and crckfile() in yam7.c"
;
;	1.  First version used getc and called crck once per char.
;	this took 39.2 seconds to crck all the yam C files (12357)
;
;	2.  Then crckfile was recoded to use read() instead of getc.
;	Time: 19.1 seconds
;
;	3.  Several small changes in crckfile were unsuccessful in
;	reducing this time.
;
;	4.  crck and crckfile recoded to call crck once per sector.
;	This reduced time to 11.7 seconds, same as crck itself.
;	That is the current version.  Note that the CRC polynomial used
;	here is somewhat unusual; the only thing I know sure is that
;	the answers agree with those given by the CRCK program -hence the
;	function name.
;
	maclib bds
	maclib cmac

	direct
	define crck
	enddir

	prelude crck

	call	arghak
	push	b
bytlop:	lhld	arg1
	mov	c,m
	inx	h		;fetch (next) byte from buffer
	shld	arg1
	lhld	arg3		; get accumulated checksum
;
;---------------------------------------------
;An 8080 routine for generating a CYCLIC-
;REDUNDANCY-CHECK.  Character leaves that
;character in location REM.  By Fred Gutman.
;From 'EDN' magazine, June 5, 1979 issue, page 84.
;
DIVP:
	MOV	A,H
	ANI	128	;Q-BIT MASK
	PUSH	PSW	;SAVE STATUS
	DAD	H	;2 X R(X)
	mov	a,c
	ADD	L
	MOV	L,A
	POP	PSW
	reloc	JZ,QB2	;IF Q-BIT IS ZERO
	MOV	A,H
	XRI	0A0H	;MS HALF OF GEN. POLY
	MOV	H,A
	MOV	A,L
	XRI	97H	;LS HALF OF GEN. POLY
	MOV	L,A
QB2:
	shld	arg3	;store in accumulator
	lhld	arg2
	dcx	h
	shld	arg2	;count number of bytes in buffer
	mov	a,h
	ora	l
	reloc	jnz,bytlop
	lhld	arg3	;return with accumulated crck in HL
	pop	b	;pull up ur shorts
	RET

	postlude crck
????????????????????????????????????????????????????????????????


@Style(TopMargin 1 lines, BottomMargin 1 lines,LeftMargin 1 chars,
HeaderSpacing 1 lines, FooterSpacing 1 lines,
Indent 0 chars)
@Comment(This file is intended as text input for Scribble, a product
of Mark of the Unicorn Inc.)
@Center'YAM (Yet Another Modem program)'
@Center'by Chuck Forsberg'

Yam performs a number of "Super-Terminal" functions.
It may be regarded as a (not proper) superset of MODEM7.
Commands and subcommands are listed below.

@Description<
bm@\
Set baudrate to m. Example: "b19200"

call name@\
Dial the telephone number corresponding to name.
If autodial is not supported, the telephone number and preferred
baudrate are displayed.  It is not necessary to type the entire name as it
appears in the file.
Example: "call tcbbs" or "call tc"

cd name@\
Change Directory to name.  For CP/M systems, name consists of a one
letter disk designator followed by an optional user number.
Example: "cd b0"

cpm@\
Dump cpature buffer if a recrive file is open, close files and return to
operating system.
^C will also get you there, but much more abruptly.

dir [pattern ...]@\
Display pathnames matching pattern alphabetized across the page.
The usual ambiguous filenames are allowed under CP/M provided a correct
version of setfcb() is used.
Since dir or any other commands which accept a pattern use the circular buffer
for filename expansion, be sure to write out any captured data first!
Example: "dir" "dir *.c" "dir *.c *.h"

dirr [pattern ...]@\
Displays the directory with the number of sectors in each file.
The number of files matched, number of blocks, number of kb allocated
to those files, and estimated transmission time at the current baudrate
for all files listed are displayed.
Transmission time estimate is based on batch transmission from a
Z89 with 700kb Tandon drives to a Cromenco 4mHz 4fdc
system with Persci 277 drive.
Time includes file i/o but not error correction.

d{mode}@\
Disable mode, where mode is 1 or more of the following.
(Modes affecting file transmission/reception affect term mode; the "s" and
"r" commands always send data transparently.
@Description<
>
@Description<

e@\
Exit from term mode when EOF is encountered on transmitted file.

f@\
Full duplex.

h@\
Half Duplex.

g@\
Resumes (GO) sending file once in term mode, equivalent to XON.

i@\
Image transparent data capture, all 8 bits of all characters received,
including NULLS.
This overrides the t and/or z modes.

l@\
List unit (Printer) on.
Since the printer is separately buffered, it needn't be as fast as the
incoming data as long as the difference doesn't exceed the buffer size.
The rewind command may be used to get extra copies of the received data.

n@\
Send NEWLINE (lf) only when transmitting file (no CR).

p@\
Send CR only at end of line, and then pause until echoes from remote
have stopped.  Useful for sending files to bulletin boards where the remote
needs time to prepare for the next text line.

r@\
Send CR only at the end of each transmitted line.

s@\
Squelch captured data with ^T and unsquelch with ^R.
These characters are not copied to the file.
This mode must be set/reset as desired BEFORE opening the receive file.

t@\
If Waitnum is more than 1, wait for echoes to stop after sending
each Waitnum characters for period Pause.
If Waitnum==1, send at
1/Throttle, measured in loops of the term() function.
The default values of Waitnum and Throttle provide transmission
at about 80 words per minute regardless of baud rate.

w@\
Wait to receive a newline afrer sending a CR at the end of a line.

z@\
Terminate data capture and close file when ^Z is received.
Otherwise ^Z is ignored.
It should be noted that The Source coughs up an occasional ^Z just as UPI
is about to output something interesting.

>

e{mode}@\
Enable 1 or more modes described with the d command.

f[mode] name@\
Open name for sending in term.
The optional mode enables one or modes of the "e" command.

help@\
Displays this file
This command closes any open send file.

initialize@\
Initializes yam to all its default values.
Does not reset the disk system (see "reset").

kill@\
Resets all pointers associated with the capture buffer, thus effectively
killing its contents.

l pattern [...]@\
Display the files specified by the possibly ambiguous pattern(s).
This command closes any open send file.
List stops/resumes printing with ^S.
Typing ^X cancels, and any other character skips to the next file.

mn@\
Change modem data port to (decimal) n.
Example: "m224"

pxm@\
Set Parameter x to value m.

@Description<
>
@Description<

aname@\
Set the alternate root to name.
If the "a" option is selected for the "r" command,
a batch mode file with the same name as a current file will be received
with the file name "nameN".
N starts at 1 each time the "a" parameter is set.
Default name is "TEMP." resulting in "TEMP.1" as the first generated name.

s@\
Set Special to decimal m.
Special is the character which exits from term mode, normally ^E.

wn@\
Set Waitnum to n.
See "w" mode for details.
Default is 1.

tm@\
Set Throttle to m.
The default value corresponds to about 80 words per minute sending speed.

pm@\
Set Pause to m.
When the free characters in the circular buffer reach 400, an XOFF is
sent.
Pause controls the time which must then pass without characters
received before believing
that the other end really has obeyed the XOFF character, as opposed to
the sometimes lengthy Compuserve hitches in the getalong.
If Pause is too short, it is possible that a lurch in output will be
interpreted as acknowledgement of the XOFF, only to have more characters
arrive whilst yam is occupied dumping the buffer
to disk.
When this happens, unfortunate characters are routed to the proverbial
bit bucket, and you can retry the download as the timesharing service
increments the connect charge.
The default value seems suitable for Source over Tymnet and BBS systems.
Pause is also the echo wait period used with the "p" mode.

>
reset [size]@\
Dump the capture buffer (if on), close all files, and
reset the disk system (this allows swapping diskettes).
The optional argument size becomes the size of the circular capture
buffer.

replot [m]@\
Redisplay the last m lines received from the modem.
If m is absent, redisplay the maximum possible.
Output is through CP/M, allowing XOFF and tabbing to work.

rewind@\
Rewind the buffer pointers for the display, printer, and file dump
from term mode.
The effect of this command is the same as if the data had been sent
another time.

r[options] [file ...]@\
Receive with options 1 or more files using the Wayne Christensen protocol.
If no filename is given, batch mode is assumed.
(Note: batch mode is not compatible with MODEM7.)
If more than one filename is given, a single file transfer will be made for
each.
Options are:
@Description<
>
@Description<
a@\
Alternate file name mode.
If an incoming file has the same name as one already on disk,
yam generates an alternate name for the now file.
Implies batch mode.

b@\
Batch mode.
Pathnames are provided by the sender.
Disk names are excluded from the transmitted pathname(s),
and may not be specified for batch mode reception
(use the change directory command).

q@\
Quiet mode inhibits some of the status information.
Quiet mode is not necessary for proprer operation at higher
baudrates.

t@\
Goto term mode after file transfer(s).

v@\
View the data being transmitted.
On receive, only correct data is displayed.
Viewing ascii files
does not interfere with correct transmission at high baud rates,
although throughput will be affected.
For each sector, data is viewed once before sending/after receiving.

y@\
Yes it is OK to clobber a file already on disk.
If absent, the operator is promped for a y or n decision.
>

s@\
Displays status information.

s[options] pattern ...@\
If batch mode is specified with the b option, 0 or more files are sent
according to the ambiguous pathname(s).
If batch mode is not specified, the named unambiguous file(s) are sent
each in single file mode.

t[c][mode] [file]@\
Term mode with optional capture to file.
The c option causes data already in the capture buffer to be written
to file, which is then closed.
For convenience, mode (see "e") may be enabled.
A receive file previously opened by t file will not be closed
by a t command without a file name.
While in term mode, the keyboarded characters are transmitted except for
@Enumerate(
^E
Exits from term mode back to main command level.

^Q
Iff a send file is open and its transmission has been stopped by a
XOFF, transmission is resumed.
Otherwise no special treatment.

^S
Iff a send file is open and it is being transmitted,
transmission is stopped.
Otherwise no special treatment.
)
The following received characters are recognized in term mode, when
they are fetched from the circular buffer for the display.
@Enumerate(
ENQ
Triggers transmission of the ANSWERBACK.

XOFF
Stops file transmission from yam.

XON
Resumes file transmission.

TAB
Tab characters are expanded on the display.
)

wrt@\
Write dumps the circular buffer to the receive file, if open.

;@\
Semicolon delimits commands about the same as CR.
Since commands such as "t" have an indefinite number of operands,
the semicolon must be used to string them together.
Example: "f foo te;f foo.1 t;" sends the two files in succession
without opening a (new) receive file.
>
A sample session might be:

A0>yam b19200 cd b (set 19kb, change to b disk)

dirr yam?.? yamhlp.mss	(list files and calculate xmsn time)

sb yam?.? yamhlp.mss	(send them to a local system)

m224	(switch to modem port)

call hydepark	(Can't remember the phone number!)

b450	(450 baud)

t	(go to term mode, log in, run minicbbs, begin entering a message)

.......

^E

etp f letter t	(enable prompt and throttle modes, open letter and send to bbs)



Notes
@Itemize<
The transmission of pathnames in batch mode differs from that used in
MODEM7.
Yam sends the pathname as a null terminated string in a standard
Wayne Christensen type packet
with sector a number of 0.
Disk specifiers (B:) are not sent.
The sender waits for an initial NAK before sending the pathname.
An explicit NAK is sent by the receiver at intervals
when is ready to receive a pathname.
Upon receiving the pathname, the receiver opens the file and then sends
an initial NAK for the data in the file.
A null pathname terminates batch transmission.


File transmission is compatible with MODEM7 in single file mode.
File transmission may be aborted by sending a sequence of CAN (^X)
of characters.
Each character keyboarded will cause readline() to return a TIMEOUT
error, thus regaining keyboard control relatively easily.

Files may be sent with handshaking
at 19200 baud from a Z89 (2 mHz) to a Cromenco 4mHz
system and 9600 baud the other way.
File reception in term mode works well up to 9600 baud on a Z89 provided
the printer is off.
File reception on a Cromenco with a 300 baud printer works fine at 2400
baud.
Baudrate selection routines are provided for the Cromenco TUART and
Z89 serial board (8250's).

In term mode, use of the circular buffer provides some advantages.
@Enumerate<
Incoming data may come in at a rate higher than the display and/or
printer.
Tab expansion for the display does not compromise this ability.

The user may decide to save a timesharing session on the disk AFTER
it has started (or possibly even finished) as long as the buffer pointers
have not wrapped around.

The same ability also applies to the printer.
The printer need not be as fast as the modem as long as the Tortoise is
allowed to catch up.

Received data may be redisplayed (rep command).
A future version might allow scrolling and/or string searching.
>
At high speeds, the display will fall behind the incoming data,
as storing of raw modem data into the buffer takes precedence over
all else.
As a result,
a defective or incorrectly programmed modem port which sources data
at high speed can lockout the keyboard.
If yam "goes away" when entering term mode, this may be the cause.

If insufficient stack space is provided above the end of the circular
buffer, yam may sulk when attempting to exit from term mode.

The enable t and z modes affecting data capture are executed when the circular
buffer is written to the receive file, not as the characters are first
received from the data port.
>
????????????????????????????????????????????????????????????????



/*
>>:yamsys.h 8-13-81
 *
 * global equates for specific installation and modem ports
 * Other modem specific stuff is in yam5.c
 *
 * Change answerback as you like, but keep the control chars as they
 * are.  Official TWX spec sez 20 chars exactly including controls,
 * but then, why not fudge if Infomaster isn't going to call you?
 */

#define XMODEM TRUE
#define RESTRICTED TRUE
#define USQ TRUE

#define ANSWERBACK "\r\n5036213193 J SHANNON           \r\n\021"
/* files have single letter ext so pip yam?????.? gets all source but no crl */
#define HELPFILE "A:YAMHELP.T"
#define LOGUSER 0
#define LASTCALR "A:LASTCALR"
#define LOGFILE "LOGFILE"
#define LOGRX "A:RXLOG"
#define LOGTX "A:TXLOG"
#define BYEPROG "A:BYE"
#define PHONES "A:YAMPHONE.T"
#define CPM TRUE
#define BDSC TRUE
#define CLKMHZ 4
#define SECPBLK 8
/* ********* following string must be in UPPER case ********* */
#define DISKS "ABCD"	/* legal disks for default selection */
#define MAXUSER 0	/* maximum user number */

/* defines for Heath Z89 aux board port at 0320 */
/* #define STATLINE	 do special status line information */
/* #define Z19			 terminal type */
#define TERMRESET	"\0x80\0x80"
/* #define Z89			 type of modem port */
#define DEFBAUD 300	/* initial baud rate setting */
#define DPORT MDATA
#define SPORT MSTAT


char inp();				/* for fastest 8080 code */
#define MIREADY  (inp(MSTAT) & MIMASK)
/* value != 0 if char available */

/* #define MIERROR (inp(Sport)&0x38)	 != 0 if any error condx */
#define MICHAR (inp(Dport))		/* get char assuming miready */

#define MOREADY  (inp(MSTAT) & MOMASK)
/* modem ready to load next char */

/* It would be nice to have parameterized macros to do the following */
#define MODATA Dport 		/* modem data output port */

char bios();
#define POREADY bios(15,0)

#define CIREADY (inp(CISTAT)&CIMASK)
#define CICHAR (inp(CIDATA))

#define COREADY ((inp(COSTAT)&COMASK)^COMASK)

/* #define CDATA  CODATA  don't define for std bios output */

????????????????????????????????????????????????????????????????

/*
>>:yamz89xm.h 12-16-81
 *
 * global equates for specific installation and modem ports
 * Other modem specific stuff is in yam5.c
 *
 */

#define XMODEM
#define RESTRICTED
#define USQ

#define ANSWERBACK "\215\012C. FORSBERG PTL\215\012\021"
/* files have single letter ext so pip yam?????.? gets all source but no crl */
#define HELPFILE "A:XYAMHELP.T"
#define LOGUSER 0
#define LASTCALR "A:LASTCALR"
#define LOGFILE 
#define LOGRX "A:RXLOG"
#define LOGTX "A:TXLOG"
#define BYEPROG "A:BYE"

#define CPM
#define BDSC
#define FLAVOR "4 mHz Z89 XYAM"
#define CLKMHZ 4	/* Hooray! */
#define SECPBLK 16	/* 2k blocks on CDR DD controller */
/* ********* following string must be in UPPER case ********* */
#define DISKS "ABCDEF"	/* legal disks for default selection */
#define MAXUSER 2	/* maximum user number */

/* defines for Heath Z89 aux board port at 0330 */
#define STATLINE	/* do special status line information */
#define Z19				/* terminal type */
			/* 25th line off, wrap at end of line*/
#define TERMRESET	"\033y1\033x9\033v"
#define TERMINIT	"\033z"
#define TERMREPLOT	"\033y1\033w"	/* mode for replot -no 25th, no wrap */
#define Z89				/* type of modem port */

#define DPORT 0330
#define SPORT 0335

char inp();				/* for fastest 8080 code */
#define CDO ((inp(Dport+6)&0200)==0)	/* RLSD is carrier detect */
#define MIREADY (inp(Sport)&1)	/* value != 0 if char available */
#define MIREADYERROR		/* rx data ready and error bits in smae reg */
#define MIREADYMASK 01		/* rx character available */
#define MIERRORMASK 036		/* rx error condition */
#define MICHAR (inp(Dport))		/* get char assuming miready */

#define MOREADY (inp(Sport)&040)	/* modem ready to load next char */
/* It would be nice to have parameterized macros to do the following */
#define MODATA Dport 		/* modem data output port */

char bios();
#define POREADY bios(15,0)

#define CIREADY (inp(CSTAT)&CIMASK)
#define CICHAR (inp(CDATA))

#define COREADY (inp(CSTAT)&COMASK)

/* STDIO file included here to simplify cross-compiles of cyams */
#include "a:bdscio.h"
????????????????????????????????????????????????????????????????


cc1 b:yam1.c -e 5A00
cc1 b:yam2.c -e 5A00 -o
cc1 b:yam3.c -e 5A00 -o
cc1 b:yam5.c -e 5A00 -o
cc1 b:yam7.c -e 5A00
clink b:yam1 yam2 yam3 yam5 yam7 yam8 -o yam -s
????????????????????????????????????????????????????????????????




	      YAM (Yet Another Modem program) Version 2.23
			 Manual	Revised	9-30-81

 a:		  Change to a: disk (or	b, etc.) 

 a1: Change to a: disk user 1

 bm		  Set baudrate to m.  Example: "b19200"

 bye		  Drop any call	in progress and	prepare	to make/answer
		  another. 

 call name	  Enable Data Terminal	Ready  (DTR), and set baudrate
		  to the value (if present) corresponding to name.  If
		  autodial  is	supported, dial	the telephone number. 
		  If  autodial is not supported, the telephone	number
		  is  displayed.   It is not  necessary	 to  type  the
		  entire  name	as it appears in the  file.   Example:
		  "call	tcbbs" or "call	tc"

 close		  Dump cpature buffer if a recrive file	is open, close
		  files. 

 crck [pattern ...]
		  Perform the "crck" function on the specified files. 
		  The crck alogrithim is stolen	from CRCK.ASM.

 dir  [pattern	...]Display pathnames  matching	 pattern  alphabetized
		  across the page.  The	usual ambiguous	filenames  are
		  allowed  under CP/M provided a  correct  version  of
		  setfcb() is used.  Since dir	or  any	other commands
		  which	accept a  pattern  use the circular buffer for
		  filename  expansion,	be   sure  to  write  out  any
		  captured data	first! 

 Example: "dir"	"dir *.c" "dir yam*.c" "dir *.c	*.h"

 dirr [pattern ...]
		  Displays the directory with the number of sectors in
		  each file.  The  number  of files matched, number of
		  blocks,  number  of kb allocated to those files, and
		  estimated transmission time  at the current baudrate
		  for  all  files  listed are displayed.  Transmission
		  time estimate	is  based on batch transmission	from a
		  Z89 with 700kb Tandon	drives to a Cromenco 4mHz 4fdc
		  system  with Persci 277 drive.  Time	includes  file
		  i/o but not error correction.	

 d{mode}	   Disable  mode(s)  affecting	file  transmission  or
		  reception with the term  function.   (The "s"	and"r"
		  commands always send data transparently.) 

 e{mode}		Disable	      mode(s)	   affecting	  file
		  transmission/reception with the term function.  (The
		  "s"	 and"r"	   commands	always	  send	  data
		  transparently.) 

 f[mode] name	  Send file 'name' in the term function.  The optional
		  mode	enables	 one or	modes.	If squelch is enabled,
		  preface  with	 ^R  and  append  with	^T.  See  also
		  type/list command. 

 help		  Displays a command summary.  This command closes any
		  open send file. 

 initialize	  Initializes yam to all its default values.  Does not
		  reset	the disk system	(see "reset").

 kill		   Kill	 all data in the capture buffer.  Restores the
		  pointers to their initial positions. 

 list pattern [...]
		  Display   the	  files	  specified  by	 the  possibly
		  ambiguous pattern(s).	 This  command closes any open
		  send	file.	List  stops/resumes  printing with ^S.
		  Typing ^C cancels, and any other character  skips to
		  the next file. 

 mn		  Change modem data port  to  (decimal)	 n.   Example:
		  "m224"

 o		  Disable the modem by turning off DTR.

 off		  Disable modem	and return to operating	system.	

 pxm		  Set Parameter	x to value m. 

 reset [size]	  Dump the capture  buffer  (if	 on), close all	files,
		  and  reset  the  disk	system (this  allows  swapping
		  diskettes).  The optional  argument size becomes the
		  size	of  the	circular capture  buffer,  useful  for
		  debugging. 

 replot	[m]	  Redisplay the	last m lines received from the modem. 
		  If  m	 is 0 or absent, redisplay starting  with  the
		  earliest data.  A screenful is displayed at a	time. 
		  The commands accepted	 in  replot  mode  are	listed
		  below. 

 rewind		  Rewind the buffer pointers for the display, printer,
		  and file dump	from the term function.	 The effect of
		  this	command	 is  the  same as if the data had been
		  sent another time. 

 r[options] [file ...]
		  Receive with options 1 or more files using  the Ward
		  Christensen  protocol.   If  no  filename  is	given,
		  batch	mode is	assumed.  (Note:  batch	 mode  is  not
		  compatible with  MODEM7.)  If	more than one filename
		  is  given, a single file transfer will be  made  for
		  each.	

 s		  Displays status information. 

 s[options] pattern ...
		  If batch mode	is specified with the b	option,	 0  or
		  more	files  are  sent according  to	the  ambiguous
		  pathname(s).	 If batch mode is not  specified,  the
		  named	unambiguous file(s) are	 sent  each  in	single
		  file mode. 

 type afn  ...	    Type  files.   XYAM	prefaces each file with	^R and
		  suffixes it with ^T. Direct  console output (bios(4,
		  ...) is used.	

 t[c][mode] [file] The	term  function with optional capture to	file. 
		  The  c  (close)  option  causes  data	in the capture
		  buffer to be written and  closed immeadiately.  0 or
		  more modes may  be  enabled.	 View  mode causes the
		  term	function  to  display  control	characters  by
		  prefixing ^ to the corresponding letter.  A  receive
		  file previously opened  by  't  file'	 will  not  be
		  closed  by  't'.  While  in the term	function,  the
		  keyboarded characters	are transmitted	except for

		    1.	^E Exits from the term	function  back to main
			command	  level.   Rapidly  typing  ^E^E  will
			instead	cause one ^E to	be transmitted.	

		    2.	 ^Q  Iff  a   send   file   is	open  and  its
			transmission  has  been	 stopped  by  a	 XOFF,
			transmission is	resumed.  Otherwise no special
			treatment. 

		    3.	^S Iff	a  send	 file  is open and it is being
			transmitted,	transmission	is   stopped. 
			Otherwise no special treatment.	

		    4.	^V Replots the last 24 lines, then awaits next
			command	in replot.  ^V^V typed	quickly	 sends
			one instead. 

		  The following	received characters are	 recognized in
		  the  term function, when they	are fetched  from  the
		  circular buffer for the display. 

		    1.	XOFF Stops file	transmission from yam. 

		    2.	XON Resumes file transmission. 

		    3.	 TAB   Tab  characters	are  expanded  on  the
			display. 

 wrt		  Write	dumps the circular buffer to the receive file,
		  if open. 

 ;		  Semicolon is an optional command delimiter which may
		  be  used  in	place  or  RETURN in  order  to	 place
		  multiple commands on a line.	Since commands such as
		  "t"  have  an	 indefinite  number  of	operands,  the
		  semicolon must be used to string commands together. 
		  Example: "sb *.c;off"	batch transmits	all *.c	files,
		  then	 disconnects.	 Unfortunately,	  CP/M's   CCP
		  clobbers  ;  and  everyting past it in  the  command
		  line,	so use backslash instead. 

 backslash	  An alternate to ; for	CP/M systems. 

 

		 Modes used with D, E, T or F commands

 a		   A  return  from  the	 keyboard  is sent as  return,
		  linefeed.   If half duplex, both  are	 sent  to  the
		  console. 

 b		  Binary mode of transmission with T function.	 All 8
		  bits are  sent.   Handy for downloading binary files
		  to  adjacent	machines without any  modem  program. 
		  Don't	 confuse  this	with the S function which uses
		  the Christensen protocol. 

 e		   Echo	 characters received from  the	modem  to  the
		  modem.   Use	this  only  for	 keyboard to  keyboard
		  communication,  and  then only at  one  end.	 Reset
		  after	each command.  Does not	imply "Half Duplex".

 f		  Full duplex. 

 g		  Resumes (GO) sending file once in the	term function,
		  equivalent to	XON. Disabling GO causes a file	queued
		  for transmission to wait for an XON character. 

 h		   Half	Duplex.	Displays keyboarded characters as they
		  are sent to the modem. 

 i		  Image	 transparent  data  capture, all 8 bits	of all
		  characters received, including NULLS.	This overrides
		  the t	and/or z modes.	

 l		   List	 unit  (Printer)  on.	Since the  printer  is
		  separately  buffered,	 it  needn't be	as fast	as the
		  incoming  data as long  as  the  difference  doesn't
		  exceed the buffer size.  The	rewind	command	may be
		  used to get extra copies of the received data. 

 n		   Send	 NEWLINE  (lf) only when transmitting file (no
		  CR).

 p		  Send	CR  only  at end of line, and then pause until
		  echoes from remote have stopped.  Useful for sending
		  files	to bulletin boards where the remote needs time
		  to prepare for the next text line. 

 r		  Send CR only at the end of each transmitted line. 

 s		  Squelch captured data	with ^T	and unsquelch with ^R.
		  These	characters are not copied  to  the file.  This
		  mode must be set/reset as desired BEFORE opening the
		  receive file.	

 t		  If Waitnum is	more  than  1, wait for	echoes to stop
		  after	 sending  each	Waitnum	 characters for	period
		  Pause.  If  Waitnum==1, send at 1/Throttle, measured
		  in loops of the term() function.  The	default	values
		  of  Waitnum  and  Throttle provide  transmission  at
		  about	 50 words per minute regardless	of baud	rate. 
		  Many	'BYE'  programs	 cannot	accept input  at  full
		  speed. 

 v		  View control characters as ^C. Useful	in shutting up
		  the  bloody  bell.   View mode is distinct from view
		  option. 

 w		   Wait	to receive a newline afrer sending a CR	at the
		  end of a line. 

 x		  Exit from the	term function when EOF	is encountered
		  on transmitted file. 

 z		   Terminate data capture and close file  when	^Z  is
		  received.  Otherwise ^Z  is  ignored.	  It should be
		  noted	 that  The  Source  coughs up an occasional ^Z
		  just	as the "UPI" program is	just about  to	output
		  something interesting. 

 

		   Options used	with S or R commands

 All options are reset after each command. 

 

 b		  Batch	mode.  Pathnames are provided by  the sender. 
		  Disk	 names	 are  excluded	from  the  transmitted
		  pathname(s), and may not be specified	for batch mode
		  reception (use the change directory command).	

 q		  Quiet	mode inhibits some of the status information. 
		  Quiet	mode is	not necessary for proprer operation at
		  higher baudrates. 

 t		  Execute the term function after file transfer(s). 

 v		   View	the data being transmitted.  Correct  data  is
		  displayed  once.   Viewing   ascii  files  does  not
		  interfere  with correct transmission at extreme baud
		  rates, although throughput  will  be	affected.  For
		  each	  sector,   data   is	viewed	 once	before
		  sending/after	receiving. 

 y		  Yes it is OK to clobber  a file already on disk.  If
		  absent,  the	operator  is  promped  for  a  y or  n
		  decision. 

 

		     Parameters	used with P command

 wn		   Set	Waitnum	 to  n.	  See "w" mode	for  details. 
		  Default is 1.

 tm		  Set Throttle to m.  The default value	corresponds to
		  about	80 words per minute sending speed. 

 m		   Set	Pause  to  m.  When the	free characters	in the
		  circular buffer reach	400, an	XOFF is	 sent.	 Pause
		  controls  the	 time  which  must  then  pass without
		  characters received before believing that  the other
		  end really has obeyed	the XOFF character, as opposed
		  to the sometimes lengthy  Compuserve	hitches	in the
		  getalong.   If  Pause	is too short, it  is  possible
		  that	a  lurch  in  output  will  be	interpreted as
		  acknowledgement  of  the  XOFF,  only	 to have  more
		  characters arrive whilst yam is occupied dumping the
		  buffer  to  disk.   When this	 happens,  unfortunate
		  characters are routed	to the proverbial  bit bucket,
		  and  you can retry the download as  the  timesharing
		  service increments the connect charge.   The default
		  value	 seems suitable	for Source over	Tymnet and BBS
		  systems.   Pause  is	also the echo wait period used
		  with	the  "p"  mode.	  Some bulletin	board programs
		  require a longer pause when accepting	files with the
		  "p" mode. 

 

			    Replot Commands

 Commands  within  replot  consist of a	single character.  Replot maps
 uppercase, lowercase, and control  characters	together  in  decoding
 commands. 

 b		  Beginning of buffer

 v		  backspace
		  Previous page	(some overlap provided)

 space		  Next page

 p		  Backup one line and redisplay

 n		  LF
		  Advance one line

 OTHERWISE	  Return to previous funccion
????????????????????????????????????????????????????????????????


; 9-30-81
xsub
pip b:yamsys.h=b:xyamsys.h
cc1 b:yam1.c -e 6300
cc1 b:yam2.c -e 6300
cc1 b:yam3.c -e 6300
cc1 b:yam5.c -e 6300
cc1 b:yam7.c -e 6300
clink b:yam1 yam2 yam3 yam5 yam7 yam8 -o xyam -s
????????????????????????????????????????????????????????????????



/*
>>:yamsys.h 8-13-81
 *
 * global equates for specific installation and modem ports
 * Other modem specific stuff is in yam5.c
 *
 * Change answerback as you like, but keep the control chars as they
 * are.  Official TWX spec sez 20 chars exactly including controls,
 * but then, why not fudge if Infomaster isn't going to call you?
 */

#define XMODEM TRUE
#define RESTRICTED TRUE
#define USQ TRUE

#define ANSWERBACK "\r\n5036213193 J SHANNON           \r\n\021"
/* files have single letter ext so pip yam?????.? gets all source but no crl */
#define HELPFILE "A:YAMHELP.T"
#define LOGUSER 0
#define LASTCALR "A:LASTCALR"
#define LOGFILE "LOGFILE"
#define LOGRX "A:RXLOG"
#define LOGTX "A:TXLOG"
#define BYEPROG "A:BYE"
#define PHONES "A:YAMPHONE.T"
#define CPM TRUE
#define BDSC TRUE
#define CLKMHZ 4
#define SECPBLK 8
/* ********* following string must be in UPPER case ********* */
#define DISKS "ABCD"	/* legal disks for default selection */
#define MAXUSER 0	/* maximum user number */

/* defines for Heath Z89 aux board port at 0320 */
/* #define STATLINE	 do special status line information */
/* #define Z19			 terminal type */
#define TERMRESET	"\0x80\0x80"
/* #define Z89			 type of modem port */
#define DEFBAUD 300	/* initial baud rate setting */
#define DPORT MDATA
#define SPORT MSTAT


char inp();				/* for fastest 8080 code */
#define MIREADY  (inp(MSTAT) & MIMASK)
/* value != 0 if char available */

/* #define MIERROR (inp(Sport)&0x38)	 != 0 if any error condx */
#define MICHAR (inp(Dport))		/* get char assuming miready */

#define MOREADY  (inp(MSTAT) & MOMASK)
/* modem ready to load next char */

/* It would be nice to have parameterized macros to do the following */
#define MODATA Dport 		/* modem data output port */

char bios();
#define POREADY bios(15,0)

#define CIREADY (inp(CISTAT)&CIMASK)
#define CICHAR (inp(CIDATA))

#define COREADY ((inp(COSTAT)&COMASK)^COMASK)

/* #define CDATA  CODATA  don't define for std bios output */

????????????????????????????????????????????????????????????????


