/*  MAIN.C   File name expandor for C programs     9/80  L.Kenen


    This function will pre-process wild-card filenames given
    on the command line and pass them ONE AT A TIME to the
    function "MAIN2" which should look like the normal 'main'.
    If no parrameters are present on the command line as recieved
    by this file then 'main2' will also be called once with no parameter.
    After expanding wildcards to the real names of the files which
    they match 'main2' will be called once for each of the parameters.
    The value which 'main2' will recieve will always be a 2 indicating
    that only one parameter is avaliable. If the function 'main2' can
    handle more than one parameter (filename) then the function 'XMAIN'
    should be used rather than this one since it expands the filenames
    and passes them all at once to 'main2'.

   In all cases, if an explicit filename is given that name will
   be passed directly to 'main2'. If a wildcard filename is given which
   does not match any entries then 'main2' will be called with the
   exact filename which was typed even though it contained a '*' or
   a '?'. This is done do other strings containing those
   characters may be passed to the program.
   If it is desired for this function to pass no parameters when
   no file matches then the line after "if(explicit..." should
   call 'main2' with a '1' rather than a '2'

   A test directory function is contained in MTEST1.c which
   intended to take only one filename from the console. This
   program is, in effect, being run once for each file that
   matches the specification given on the command line.

*/
#define	SFIRST	17
#define	SNEXT	18
#define	DEBUG	1


main(argc,argv)
int argc; char *argv[];
{
	char *args[2], dircode, *found, drive;
	char line[30], tname[30], newname[30];
	char fcb[40];
	int x;


	args[0] = "BARZOT.COM";
	if(argc <= 1)
	{
		main2(1,args);  /* Pass the prog name
					       as argv[0] always */
		exit();
	}
	for(x=1;x<argc;x++)
	{
		if(explicit(argv[x]))
		{
			
			args[1] = argv[x];
			main2(2,args);
		}
		else
		{
			if(argv[x][1] == ':')
			{
				drive = argv[x][0] - ('A' - 1);
				_mvx(argv[x]); /* Remove drive spec  */
			}
			else drive = 0;
			expand(line,argv[x]); /* Expand wildcard */

			setfcb(fcb,line);
			fcb[0] = drive;
			if((dircode = bdos(SFIRST,fcb)) == 255)
			{
			   args[1] = argv[x];
			   main2(2,args);
			   break;
			}
			do
			{
				found = (dircode * 32) + 0x81;
				newname[0] = '\0';
				compact(tname,found);
				if(drive)
					sprintf(newname,"%c:",drive+('A'-1));
				strcat(newname,tname);
			
				args[1] = newname;
				main2(2,args);
			} while((dircode = bdos(SNEXT,fcb)) != 255);
		}
	}
}

compact(n,o)
char *n, *o;
{
	int x;
	x = 8;
	while(x && (*o != 0x20)){ *n++ = *o++; x--; }
	while(x--) o++; /* Strip spaces */
	*n++ = '.';
	x = 3;
	while(x-- && (*o != 0x20)) *n++ = *o++;
	*n = '\0';
}

expand(n,o)
char *n, *o;
{

	int x;


	x = 8;
	while(*o && x-- && (*o != '.'))
	{
		if(*o == '*'){x++; while(x--) *n++ = '?'; break; }
		else	*n++ = *o++;
	}
	*n++ = '.';
	if(*o == '*') while(*o && (*o != '.'))o++;
	if(*o++ == '.')
	{
		x = 3;
		while(x--)
		{
			if(!*o) break;
			if(*o == '*') *n++ = '?';
			else *n++ = *o++;
		}
	}
	*n = '\0';

}

explicit(s)
char *s;
{
	while(*s) if((*s == '?') || (*s++ == '*')) return 0;
	return 1;
}

_mvx(s)
char *s;
{
	char *p;
	p = s+2;
	while(*s++ = *p++);
}
