;	title	'FLIP - flip originate/answer mode under "bye"'
;	Originally written by Bruce Ratoff.
;
;	updated 6/5/82 to handle faster CPUs by replacing FASTCLK
;		equate with CPUMHZ equate.  Also provided means of
;		flipping back to answer mode with pmmi modem by 
;		specifying 'ANS' as argument on	command line.  No
;		argument defaults to normal flip. (Paul Homchick)
;	updated 6/2/80 to uppercase message and require exactly
;		control-c or return, ignoring all else. (BR)
;	updated 6/6/80 to work with PMMI modem and to re-ask for
;		input if invalid answer. Keith Petersen, W8SDZ.
;	updated 8/8/80 to add conditional assembly for either
;		PMMI or D C Hayes modem cards (BR)
;
FALSE	EQU	0	;BASIC LOGIC DEFINITIONS
TRUE	EQU	NOT FALSE
;
CPUMHZ	EQU	6	;SET TO YOUR CPU CLOCK SPEED IN MHZ
;
PMMI	EQU	TRUE	;SET TRUE IF PMMI MODEM
DCH	EQU	FALSE	;SET TRUE IF D C HAYES MODEM
;
	IF	DCH
MODCTL	EQU	92H	;D C HAYES MODEM CONTROL PORT ADDRESS
	ENDIF
;
	IF	PMMI
MODCTL	EQU	0E0H	;PMMI MODEM CONTROL PORT ADDRESS
	ENDIF
;
BDOS	EQU	5
DBUFF	EQU	80H
;
PMESSG	EQU	9
CHRINP	EQU	1
BUFFER	EQU	80H		;CCP COMAND BUFFER
;
	ORG	100H
;
	IF	PMMI
START:	LDA	BUFFER+1	;CHECK FOR COMMAND ARGUMENT
	ORA	A
	JZ	FLIP		;NO ARGUMENT, NORMAL FLIP
;
;	OTHERWISE, THERE MUST BE SOMETHING.  IS IT 'ANS'?
;
	MVI	C,3		;STRING LENGTH
	LXI	D,BUFFER+2	;POINTER TO CCP CMD LINE BUFFER
	LXI	H,LITSTR	;POINTER TO LITERAL
M1:	DCR	C		;DECR LENGTH COUNT
	JZ	ANSWER		;GO TO ANSWER MODE IF MATCH
	LDAX	D		;GET A BYTE FROM ONE STRING
	SUB	M		;COMPARE WITH OTHER
	JNZ	ERROR		;PRINT INSTRUCTIONS IF NOT 'ANS'
	INX	H
	INX	D		;INCR STRING POINTERS
	JMP	M1		;TRY SOME MORE
;
ERROR:	MVI	C,PMESSG
	LXI	D,ERRMSG
	CALL	BDOS
	JMP	0
	ENDIF
;
FLIP:	MVI	C,PMESSG
	LXI	D,MESSG
	CALL	BDOS
;
FLIP1:	MVI	C,PMESSG
	LXI	D,MESSG2
	CALL	BDOS
	MVI	C,CHRINP
	CALL	BDOS
	CPI	3	;CTL-C?
	JZ	0	;YES, EXIT TO CP/M WARM BOOT
	CPI	13	;CARRIAGE RETURN?
	JNZ	FLIP1	;NO, ASK FOR ANOTHER INPUT
;
;SET MODEM FOR OFF-HOOK ORIGINATE
	IF	PMMI
	MVI	A,1DH
	ENDIF
	IF	DCH
	MVI	A,87H
	ENDIF
	OUT	MODCTL
	IF	PMMI
	JMP	TIMER
;
ANSWER:	MVI	C,PMESSG
	LXI	D,MESSG3
	CALL	BDOS
;
ANSWR1:	MVI	C,PMESSG
	LXI	D,MESSG2
	CALL	BDOS
	MVI	C,CHRINP
	CALL	BDOS
	CPI	3	;CTL-C?
	JZ	0	;YES, EXIT TO CP/M WARM BOOT
	CPI	13	;CARRIAGE RETURN?
	JNZ	ANSWR1	;NO, ASK FOR ANOTHER INPUT
;
;SET MODEM FOR OFF-HOOK ANSWER
	MVI	A,1EH
	OUT	MODCTL
	ENDIF
;
TIMER:	MVI	C,5*CPUMHZ	;10 SECONDS
;
;DELAY LOOP - NUMBER OF SECONDS IN C REGISTER
CTLP:	LXI	H,0	;ONE SECOND DELAY LOOP
	LXI	D,1
;
SLO:	DAD	D	;DONE WITH ONE SECOND LOOP?
	JNC	SLO	;NO, DO ANOTHER LOOP
	DCR	C	;ONE LESS SECOND
	JNZ	CTLP	;NOT DONE WITH COUNT
;
	IF	PMMI
;SET PMMI MODEM CHIP SO IT CAN HANG UP ON LOSS OF CARRIER
	MVI	A,1CH	;SET PMMI MODEM FOR ORIGINATE
	OUT	MODCTL
	ENDIF
	JMP	0	;EXIT TO CP/M WARM BOOT
;
MESSG:
	DB	'IF YOU HIT RETURN, YOU HAVE 15 SECONDS TO SWITCH',13,10
	DB	'TO ANSWER MODE OR YOU WILL LOSE THE CONNECTION.',13,10
	DB	'IF YOUR MODEM INTERRUPTS THE PHONE LINE WHILE',13,10
	DB	'REVERSING, YOU WILL LOSE THE CALL UNLESS YOU',13,10
	DB	'PICK UP THE PHONE FIRST.',13,10,'$'
;
MESSG2:	DB	13,10,'TYPE RETURN TO SWITCH, CONTROL-C TO ABORT: $'
;
	IF	PMMI
MESSG3:
	DB	'IF YOU HIT RETURN, YOU HAVE 15 SECONDS TO SWITCH',13,10
	DB	'TO ORIGINATE MODE OR YOU WILL LOSE THE CONNECTION.',13,10
	DB	'IF YOUR MODEM INTERRUPTS THE PHONE LINE WHILE',13,10
	DB	'REVERSING, YOU WILL LOSE THE CALL UNLESS YOU',13,10
	DB	'PICK UP THE PHONE FIRST.',13,10,'$'
;
LITSTR:	DB	'ANS'		;LITERAL STRING FOR COMMAND COMPARE
;
ERRMSG:	DB	'USAGE: FLIP       WILL GIVE YOU THE OPPORTUNITY TO',13,10
	DB	'                  CHANGE THIS END TO ORIGINATE MODE',13,10
	DB	'       FLIP ANS   WILL GIVE YOU THE OPTION OF CHANGING',13,10
	DB	'                  THIS END TO ANSWER MODE',13,10,13,10,'$'
	ENDIF
	END
