/*********************************************
*    This source code was contributed by:    *
*                                            *
*         Eric Martz                         *
*         Department of Microbiology         *
*         University of Massachusetts        *
*         Amherst, MA 01003                  *
*                                            *
*    Phones:                                 *
*                                            *
*         Day:      413-545-2325             *
*         Evenings: 413-256-0751             *
*                                            *
*********************************************/


/* FILE DIRECTORY AND BACKUP UTILITY FOR CP/M */
/* FOR INSTRUCTIONS, GIVE COMMAND "FI -" TO CP/M */

#include "bdscio.h"
#define NIOBUFS 1
#include "fio.1"

char fcb[33], name[200][13], nobkup[200][13], exname[200][13], buf[BUFSIZ];
int inline, filecnt, excnt, nobk;
char *addr, squeezed[13];
int bdosfunc, areg, line, col, n, collen, charcnt, i;
int a, b, u, w, got_it;
int strcmp();
FILE *fp;

main(argc,argv) 
	int argc;
	char **argv;
	{
#include "fio.2"
	a = b = u = w = FALSE;
	if (argc > 1) {
		for (i=1; i<argc; i++) {
			if (argv[i][0] == '-') {
				switch (argv[i][1]) {
					case 'A':
						a = TRUE;
						break;
					case 'B':
						b = TRUE;
						break;
					case 'U':
						u = TRUE;
						break;
					case 'W':
						w = TRUE;
						break;
					default:
						printf("Use: fi [-a] [-b] [-u] [-w]\n");
						printf("\nWith no arguments, only files on the current disc which\n");
						printf("are absent from the file NOBACKUP will be displayed/written.\n");
						printf("\n\tOPTIONS:\n\n");
						printf("\t\t-a  All files will be displayed/written.\n\n");
						printf("\t\t-b  Backup: write and submit BACKUP.SUB\n\n");
						printf("\t\t-u  Utility filenames included in the file named NOBACKUP\n");
						printf("\t\t    and present on the current disc will be displayed/written.\n\n");
						printf("\t\t-w  Write file BACKUP.SUB to be edited for submit.\n");
						exit(0);
				}
			}
			else {
				/* INSTALL AMBIGUOUS FILENAME */
				/* not implemented (argv[i]) */
			}
		}
	}
	getdir();
	if (a) nobk = 0;
	if (!a) {
		/* GET NOBACKUP FILE INTO MEMORY ARRAY NOBKUP */
		if (!getnobk()) nobk = 0;
		if (nobk == 0) printf("NOBACKUP file nonexistent or empty.\n");
	}
	exwrite();
	showex();
	if (b) execl("submit","backup",0);
}
getdir() {
	/* GET FILENAMES INTO NAME ARRAY */
	strcpy(fcb,"\200???????????\200\200\200\200");
	filecnt = 0;
	bdosfunc = 17;
	while (1) {
		areg = bdos(bdosfunc,fcb);
		bdosfunc = 18;
		if (areg == 255) break;
		filecnt += 1;
		addr = 0x80 + (32*areg);
		fstore(addr);
	}

	/* SORT FILENAMES */
	qsort(&name[1],filecnt,13,&strcmp);

}
exwrite() {
	/* WRITE BACKUP.SUB */
	if (w || b) {
		fp = fopen("backup.sub","w");
		fputs("XSUB\nPIP\n",fp);
	}
	excnt = 0;
	for (line=1; line<=filecnt; line++) {
		charcnt = 0;
		for(i=0; i<=11; i++)
			if(name[line][i] != ' ')
				squeezed[charcnt++] = name[line][i];
		squeezed[charcnt] = NULL;
		if (noback()) {
			if (u) {
				excnt++;
				if (w || b) writeone();
				strcpy(exname[excnt],name[line]);
			}
		}
		else {
			if (!u) {
				excnt++;
				if (w || b) writeone();
				strcpy(exname[excnt],name[line]);
			}
		}
	}
	if (w || b) fclose(fp);
}
writeone() {
	fputs("B:=",fp);
	fputs(squeezed,fp);
	fputs("[V]\n",fp);
}
getnobk() {
	fp = fopen("NOBACKUP","r-");
	if (fp == 0) return(0);
	nobk = 0;
	while (fgets(buf,fp) != 0) {
		nobk++;
		buf[strlen(buf)-1] = NULL; /* STRIP OFF LINE FEED */
		strcpy(nobkup[nobk],buf);
	}				
	fclose(fp);
	return(1);
}
noback() {
	int i;
	if (nobk == 0) return(0);
	for (i=1; i<=nobk; i++)
		if (strcmp(squeezed,nobkup[i]) == 0) return(1);
	return(0);
}
fstore(pfcb)
	char *pfcb;
	{
	int i;
	for (i=0; i<=7; i++) name[filecnt][i] = pfcb[i+1];
	name[filecnt][8] = '.';
	for (i=9; i<=11; i++) name[filecnt][i] = pfcb[i];
	name[filecnt][12] = NULL;
}

showex() {
	/* DISPLAY FILENAMES */
	inline = 0;
	collen = (excnt/5) + 1;
	puts("\n");
	for (line=1; line<=collen; line++) {
		for (col=0; col<=4; col++) {
			n = line + (col * collen);
			puts("  ");
			if (n <= excnt) puts(exname[n]);
			else puts("            ");
			inline += 1;
			if (inline == 5) {
				inline = 0;
				putch('\n');
			}
			else puts("  ");
		}
	}
	printf("\n  %d FILES",excnt);
	if (!a) {
		if (!u) printf(" excluding %d",filecnt-excnt);
		if (u) printf(" present and included");
		printf (" in NOBACKUP\n");
	}
}
#include "fio.3"


/*?????????????????????????????????????????????????????????*/
/*********************************************
*    This source code was contributed by:    *
*                                            *
*         Eric Martz                         *
*         Department of Microbiology         *
*         University of Massachusetts        *
*         Amherst, MA 01003                  *
*                                            *
*    Phones:                                 *
*                                            *
*         Day:      413-545-2325             *
*         Evenings: 413-256-0751             *
*                                            *
*********************************************/


/* This file is part of a set of three inclusions (fio.1, fio.2, fio.3)
designed to permit the writing of source codes as close as possible to K&R C,
where only "fp = fopen(filename,mode)" is needed to allocate an i/o buffer,
etc. By using this plan, a source code can be portable between a minicomputer
Unix-C system and BSDC. To move the code from the latter to the former, one
need only delete the three "includes". Here is an example of the use of these
inclusions in a "word count" program:

	---------------------------------------------------------
	#include "bdscio.h"
	
	#define NIOBUFS 1
	#include "fio.1"
	
	main(argc,argv)
		int argc;
		char **argv;
		{
	#include "fio.2"
		if (argc == 1) {
			printf("Use: wc filename\n");
			exit(0);
		}
		allcnt(argv[1]);
	}
	allcnt(name)
		char *name;
		{
		unsigned linecnt, charcnt, wordcnt, crcnt, longline;
		int white, linelen, longest;
		int c;
		FILE *fp;
		fp = fopen(name,"r");
		/* [OMITTED HERE IS THE BODY OF THE FUNCTION ] */
		/* IF NEEDED, E. G. FOR WRITING A FILE: */
		fclose(fp);
	}
	#include "fio.3"
	---------------------------------------------------------*/

/* Another example of use may be found in the file backup utility fi.c */

/* THIS SEGMENT (fio.1) DECLARES THE I/O BUFFERS NEEDED (_iob), AND A SET OF
FLAGS TO KEEP TRACK OF WHICH ONES ARE IN USE AN ANY GIVEN TIME (bufuse). TAKE
THE EXAMPLE OF A PROGRAM WHICH NEEDS TO HAVE TWO FILES OPEN AT ONCE. MANY MORE
THAN TWO FILES MAY BE OPENED AND CLOSED, BUT WE ARE SUPPOSING THAT NOT MORE
THAN TWO NEED TO BE OPEN SIMULTANEOUSLY. THE "#include fio.1" MUST BE PRECEDED
BY "#define NIOBUFS 2". THIS MEANS _iob[0] THRU _iob[1]. HOWEVER, bufuse[0] IS
USED TO STORE NIOBUFS, THUS THE FIRST BUFFER _iob[0] CORRESPONDS TO THE
BUFFER-USE-FLAG bufuse[1]. */

char _iob[NIOBUFS][BUFSIZ];
int bufuse[NIOBUFS+1];

/* End of fio.1 */


/*?????????????????????????????????????????????????????????*/
/*********************************************
*    This source code was contributed by:    *
*                                            *
*         Eric Martz                         *
*         Department of Microbiology         *
*         University of Massachusetts        *
*         Amherst, MA 01003                  *
*                                            *
*    Phones:                                 *
*                                            *
*         Day:      413-545-2325             *
*         Evenings: 413-256-0751             *
*                                            *
*********************************************/


/* For an example of the use of "fio.2" and an introduction, see "fio.1". */

/* "fio.2" SHOULD BE INCLUDED AS THE FIRST EXECUTABLE CODE IN MAIN;
   IT ZEROS ALL bufuse ELEMENTS, INDICATING THAT NO BUFFERS ARE ASSIGNED
   TO FILES INITIALLY. */

	for(bufuse[0]=1;bufuse[0]<=NIOBUFS;bufuse[bufuse[0]++]=0);

	/* THE NEXT STATEMENT LEAVES bufuse[0] SET AT NIOBUFS FOR
		USE BY FOPEN, FCLOSE */

	bufuse[0] -= 1;

	/* End of fio.2 *


/*?????????????????????????????????????????????????????????*/

/*********************************************
*    This source code was contributed by:    *
*                                            *
*         Eric Martz                         *
*         Department of Microbiology         *
*         University of Massachusetts        *
*         Amherst, MA 01003                  *
*                                            *
*    Phones:                                 *
*                                            *
*         Day:      413-545-2325             *
*         Evenings: 413-256-0751             *
*                                            *
*********************************************/

/* For an example of how to use "fio.3" and an introduction, see "fio.1". */ 

/*****************************************************************************

"fio.3" INCLUDES fopen AND fclose, AND SHOULD BE INCLUDED BY THE LAST LINE
IN THE MAIN SOURCE FILE. INCLUSION OF fio.3 IN MAIN IS NECESSARY TO GIVE THESE
FUNCTIONS ACCESS TO NIOBUFS IN THE EXTERNAL VARIABLE bufuse[0], SINCE PASSING
NIOBUFS AS AN ARGUMENT WOULD MAKE THE FUNCTIONS INCOMPATIBLE WITH STANDARD K&R
C.

"bdscio.h" SHOULD BE MODIFIED TO INCLUDE THIS DEFINITION:

#define FILE struct _buf

There is one non-standard feature in the present fopen: if the function is
called as 'fp = fopen(filename, "r");' and no such file exists, fopen will
print an error message at the console before returning the error value of 0.
If you wish to suppress this error message (e.g. your calling routine will
detect the returned 0 and issue its own message) use a two character string as
the mode, e. g. 'fp = fopen(filename, "r-");'.  The second character, which
can be anything, causes fopen to suppress its internal error message.

It is unfortunate that the BDSC functions supplied with the names "fopen" and
"fclose" are not equivalent to the standard K&R functions. Therefore, in order
to use the standard functions below, the BDSC-supplied functions must be
renamed: fopen becomes r_open (open for read) and fclose becomes bf_close
(close to free buffer). You must do this in your deff.crl using the rename
command of clib. Unfortunately, this means that older programs which use the
non-standard BDSC-supplied functions will have to be modified if they are to
be relinked after these name changes.

If you wish to open for appending, you should use mode "a" in fopen, and
compile and install the following function in your deff.crl:

#include "bdscio.h"

int a_open(filename,iobuf)
struct _buf *iobuf;
char *filename;
{
	if ((iobuf -> _fd = open(filename,2))<0) return ERROR;
	iobuf -> _nleft = 0;
	return iobuf -> _fd;
}

Beware: CP/M does not like names like a_open.c; use aopen.c or a-open.c
for the source file name, and then rename the crl module to a_open using
clib.

*****************************************************************************/

FILE *fopen(filename,mode)
	char *filename;
	char *mode;
	{
	FILE *fp;
	int i, bufat, Stderr;

	/* FIND UNUSED BUFFER */
	for(bufat=1;bufuse[bufat] == 1;bufat++) {
		if (bufat == bufuse[0]) {
			printf("FOPEN ERROR (%s): NO MORE BUFFERS (%d in use)\n",filename,bufuse[0]);
			return(0);
		}
	}
	/* ASSIGN FILE POINTER */
	fp = _iob[bufat-1]; /* FOR EXPLANATION OF -1, SEE FILE FIO.1 */

	Stderr = stderr;
	if (mode[1] > 0) Stderr = 0; /* DUMP ERROR MESSAGE */
	switch (mode[0]) {
		case 'r':
			i = r-open(filename,fp);
			if (i == ERROR) {
				fprintf(Stderr,"FOPEN ERROR: CAN'T R-OPEN \"%s\"\n",filename);
				return(0);
			}
			break;
		case 'w':
			i = fcreat(filename,fp);
			if (i == ERROR) {
				fprintf(Stderr,"FOPEN ERROR: CAN'T FCREAT \"%s\"\n",filename);
				return(0);
			}
			break;
		case 'a':
			i = a_open(filename,fp);
			if (i == ERROR) {
				fprintf(Stderr,"FOPEN ERROR: CAN'T A_OPEN \"%s\"\n",filename);
				return(0);
			}
			break;
		default:
			fprintf(Stderr,"FOPEN ERROR: BAD MODE '%s' FOR '%s'\n",mode,filename);
			return(0);
	}
	bufuse[bufat] = 1; /* SET BUFFER USE FLAG */
	return(fp);
}
fpfree(fp)
	FILE *fp;
	{
	int bufat;
	bf-close(fp);
	for(bufat=1;fp != _iob[bufat-1];bufat++); /* FIND bufuse INDEX */
	bufuse[bufat] = 0; /* SHOW BUFFER NO LONGER IN USE */
}
fclose(fp)
	FILE *fp;
	{
	fprintf(fp,"%c",'\032'); /* CTRL Z */
	fflush(fp);
	fpfree(fp);
}
/* End of fio.3 */
rr = 0; /* DUMP ERROR MESSAGE */
	switch (mode[0]) {
