;
; START 05-09-82
; DATE  05-17-82	*LAST MAJOR CHANGE
; NOW	05-17-82	corrected last cold boot no active message
;
DATE	EQU	0517H	;SET UP DATE
YEAR	EQU	82H	;SET UP YEAR
;EX.COM IS AN ENHANCEMENT OF EXEC.COM
; OPTIONS
;EX <SUBFILE> <PARAMETERS> CR
;EX CR
; ^<?> WILL GIVE CONTROL CHARACTER <?>
; | WILL BE CR
; $<0-9> WILL WILL ADD PARAMTER FROM COMAND LINE INTO TEXT
; $$ WILL GIVE $
; $^ WILL GIVE ^
; $| WILL GIVE |
; |,cr,lf,1ah will eat last from | to end of buffer
; ^C WILL ABORT EX
;
DAY0	SET	(DATE AND 0FH)+'0'
DAY1	SET	((LOW DATE) SHR 4)+'0'
MONTH0	SET	((HIGH DATE)AND 0FH)+'0'
MONTH1	SET	(DATE SHR 12)+'0'
;
YEAR0	SET	(YEAR AND 0FH)+'0'
YEAR1	SET	(YEAR SHR 4)+'0'
;
EATIT	EQU	FALSE
;
CR	EQU	0DH
LF	EQU	0AH
WARM	EQU	0
BDISK	EQU	4
BDOS	EQU	5
DFCB	EQU	5CH
DBUFF	EQU	80H
BEGREL	EQU	0480H
	MACLIB	EX
$-PRINT
	IF	BASE
$+PRINT
	ORG	100H
	LXI	B,0	;LENGHT ON PROGRAM
	LXI	SP,BEGREL
	PUSH	B	;SAVE FOR FUTURE USE
	PUSH	B
	LXI	D,SIGNON;TELL THEM WHO WE ARE
	CALL	PRINT
	LHLD	BDOS+1	;GET BASE
	LXI	D,-806H	;GET BEFORE CCP
	DAD	D
	POP	B	;GET LENGHT
	MOV	A,L	;SUBTRACT RELOC LENGHT
	SUB	C
	MOV	E,A
	MOV	A,H
	SBB	B
	MOV	D,A
	PUSH	D	;SAVE NEW TOP/START TO MOVE TO
	LXI	H,BEGREL;START OF MOVE
OMOVE:	MOV	A,B
	ORA	C
	JZ	MOVEND
	DCX	B
	MOV	A,M
	STAX	D
	INX	D
	INX	H
	JMP	OMOVE
;
MOVEND:	POP	D	;GET START OF MOVED PROGRAM
	POP	B	;LENGHT OF MOVE PROGRAM
	PUSH	H	;START OF BIT MAP
	MOV	H,D	;MSB OFFSET
	MOV	L,E	;LSB OFFSET
OFFLUP:	MOV	A,B	;TEST LENGHT
	ORA	C	;IF 0
	JZ	GOTO	;JUMP TO RELOCATED PROGRAM
	DCX	B	;DECRIMENT COUNT
	LDA	COUNT
	INR	A
	STA	COUNT
	ANI	07H
	JNZ	OFFBIT	;NO
	XTHL		;YES, GET BIT MAP
	MOV	A,M	;GET NEXT BYTE
	INX	H	;INCREMENT BIT MAP POINTER
	XTHL		;SAVE FOR LATER
	STA	BITMAP	;KEEP BIT OFFSET
OFFBIT:	LDA	BITMAP
	RAL		;TEST FOR OFFSET
	STA	BITMAP	;SAVE NEW BYTE
	JNC	NOFSET	;NO
	DCX	D	;GET BACK TO LSB
	LDAX	D
	ADD	L
	STAX	D
	INX	D	;MSB
	LDAX	D	;YES
	ADC	H	;ADD IN OFFSET
	STAX	D	;PUT IN MOVED PLACE
NOFSET:	INX	D	;INCREMENT MOVED POINTER
	JMP	OFFLUP	;CONTINUE WITH RELOCATE
;
GOTO:	POP	D	;RESTORE STACK
	DCX	H	;RELOCATE PROGRAM-1
	PUSH	H	;SAVE TO USE IN RELOCATED PROGRAM
	SHLD	OUTBUF
	INX	H	;GET TO BEGGING OF RELOCATED PROGRAM
	PUSH	H
	LXI	H,PRMPNT
	LXI	D,DBUFF+1
	MVI	B,80
EATSPC:	LDAX	D	;EAT LEADING SPACES
	INX	D
	ORA	A
	JZ	ENDLIN
	CPI	' '
	JZ	EATSPC
	DCX	D
	MOV	M,E
	INX	H
	DCR	B
	MOV	M,D
	INX	H
	INX	D
	DCR	B
ENDWRD:	LDAX	D	;GET TO END OF LINE 
	INX	D
	ORA	A
	JZ	ENDLIN
	CPI	' '
	JNZ	ENDWRD
	MVI	A,0
	DCX	D
	STAX	D
	INX	D
	JMP	EATSPC	;EAT SPACES BETWEEN COMMANDS
;
ENDLIN:	MOV	A,B
	CMA
	ADI	81
	CPI	19
	JC	PRMSOK
	LXI	D,TOOARG
	JMP	ERROR
;
PRMSOK:	LDA	DBUFF	;SEE IF .SUB FILE PRESENT
	ORA	A
	JNZ	OPENSB	;OPEN SUB FILE
	MVI	A,7FH	;GET BUFFER LENGHT
	STA	DBUFF-1
	LXI	H,BEGREL;SET UP OUTPUT BUFFER
	SHLD	INBUF
GETLIN:	CALL	CRLF
	MVI	E,':'	;GET PROMT
	CALL	OUTCHR
	LXI	D,DBUFF-1
	MVI	C,10	;READ CONSOLE BUFFER
	CALL	BDOS
	LXI	D,DBUFF
	LDAX	D	;GET LENGHT
	MOV	B,A
	INX	D
	LHLD	INBUF	;GET INPUT POINTER
	ORA	A	;SEE IF END
	JZ	ENDSTR	;THATS ALL FOLKS
	XCHG
	CALL	MOVE	;MOVE TO INPUT BUFFER
	XCHG
	MVI	M,CR
	INX	H
	MVI	M,LF
	INX	H
	SHLD	INBUF
	JMP	GETLIN
;
OPENSB:	LXI	D,DFCB+9
	LXI	H,SUBNAM;MOVE 'SUB' TO DFCB FILE TYPE
	MVI	B,3
	CALL	MOVE
	XRA	A
	STA	DFCB+32
	LXI	D,DFCB
	MVI	C,15	;OPEN FILE
	CALL	BDOS
	INR	A
	JNZ	READTX
	LXI	H,NOSBF
	LXI	D,DFCB+1
	MVI	B,8	;NAME LENGHT
	CALL	MOVEFN	;MOVE FILE NAME
	MVI	B,3	;TYPE LENGHT
	MVI	M,'.'
	INX	H
	LXI	D,DFCB+9;FILE TYPE POINTER
	CALL	MOVEFN	;MOVE FILE TYPE
	MVI	M,'$'	;END TERMINATER
	LXI	D,NOSUB
	CALL	PRINT
	LXI	D,NOTHER
	JMP	ERROR
;
MOVEFN:	LDAX	D
	CPI	' '	;SEE IF SPACE
	RZ
	MOV	M,A
	INX	D	;INCREMENT POINTERS
	INX	H
	DCR	B
	JNZ	MOVEFN
	RET
;
READTX:	LHLD	INBUF
	XCHG
	LXI	H,80H	;GET SECTOR OFFSET
	DAD	D
	SHLD	INBUF
	MVI	C,26	;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,DFCB
	MVI	C,20	;READ SEQUENTIAL
	CALL	BDOS
	ORA	A
	JZ	READTX	;READ COMPLETE .SUB FILE
	LHLD	INBUF	;MAKE SURE BUFFER'S TERMINATED
	LXI	D,-80H	;GET BACK TO END
	DAD	D
ENDSTR:	MVI	M,1AH	;EOF CHARACTER
	MOV	A,L
	SUI	LOW BEGREL+1;SEE IF BUFFER'S EMPTY
	MOV	A,H
	SBI	HIGH BEGREL
	JC	BUFLOW
	LHLD	OUTBUF
	LXI	D,BEGREL
MOVSTR:	LDAX	D
	INX	D
	ANI	7FH	;MAKE SURE NO PARITY
	CPI	LF
	JNZ	MOVST0
	CALL	INCR
	JMP	MOVSTR
MOVST0:	CPI	1AH
	JZ	SETUP
	CPI	'|'	;CARIAGE RETURN
	JNZ	MOVST1	;NOPE
	PUSH	D	;SAVE OLD POINTER
	INX	D
	INX	D
	LDAX	D	;GET PRESENT LOCATION+3
	POP	D	;GET OLD POINTER
	CPI	1AH	;END OF BUFFER
	JZ	SETUP	;THATS ALL SHE WROTE
	MVI	A,CR
	CALL	INCR	;INCREMENT LINES FOR ERRORS
MOVST1:	CPI	'$'
	CZ	GTPARM	;SUBSTITUTE COMAND PARAMTER/$/^
	CPI	'^'
	CZ	GETCMD	;CONVERT CONTROL CHARACTER
	MOV	M,A
	DCX	H
	JMP	MOVSTR
;
INCR:	PUSH	H	;SAVE OUTPUT POINTER
	LHLD	LINES
	INX	H	;INCREMENT LINE COUNTER
	SHLD	LINES
	MOV	L,E	;DE=HL
	MOV	H,D
	SHLD	BEGLIN
	POP	H
	RET
;
;CONTROL CODES 0-1FH OK
GETCMD:	LDAX	D	;GET NEXT CHARACTER
	INX	D	;INCREMENT POINTER
	cpi	'a'-1	;see if lower case
	JC	GETUPR	;NOPE
	sui	'@'	;GET TO UPPER CASE
GETUPR:	SUI	40H	;GET CONTROL CODE
	RNC
	LXI	D,CMDER	;COMAND ERROR MESSAGE
	CALL	PRINT
	CALL	LINE	;PRINT LINE #
	JMP	WARM
;
GTPARM:	LDAX	D
	INX	D
	CPI	'$'
	RZ
	CPI	'^'	;UP ARROW
	RZ
	CPI	'|'	;CARRIAGE RETURN
	RZ
	CPI	'1'
	JC	PRMERR
	CPI	'9'+1
	JNC	PRMERR
	SUI	'0'	;GET ACTUAL #
	ADD	A	;DOUBLE FOR OFFSET
	PUSH	D
	PUSH	H
	LXI	H,PRMPNT
	MOV	E,A
	MVI	D,0
	DAD	D
	MOV	E,M	;GET PARAMETER POINTER
	INX	H
	MOV	D,M
	POP	H
	MOV	A,E
	ORA	D
	JZ	NOPARM	;NO PARAMETER PRESENT
MOVPRM:	LDAX	D	;MOVE PARAMTER TO BUFFER
	INX	D
	ORA	A
	JZ	ENDPRM
	MOV	M,A
	DCX	H
	JMP	MOVPRM
;
ENDPRM:	POP	D
	INX	H
	MOV	A,M
	RET
;
NOPARM:	LXI	D,NOPRM
	JMP	PARMR
;
PRMERR:	LXI	D,PMERR
PARMR:	CALL	PRINT
	CALL	LINE	;PRINT LINE #
	JMP	WARM
;
SETUP:	MVI	M,-1	;SET UP END OF DATA
	DCX	H
	LDA	BDOS+2	;SET UP BDOS JUMP TO PROTECT DATA
	MOV	M,A
	DCX	H
	LDA	BDOS+1
	MOV	M,A
	DCX	H
	MVI	M,JMP
	XTHL		;GET JUMP ADDRESS/SAVE TOP OF MEMMORY
	PCHL		;GOTO IT
;
BUFLOW:	LXI	D,BUFMTY;BUFFER EMTY
ERROR:	CALL	PRINT
	JMP	WARM
;
PRINT:	MVI	C,9	;PRINT STRING
	CALL	BDOS
	RET
;
CRLF:	LXI	D,CRLFS
	CALL	PRINT
	RET
;
;PRINT ERROR LINE # FOLLOWED BY BAD LINE
LINE:	LXI	D,LINEM
	CALL	PRINT
	LHLD	LINES
	CALL	DECOUT	;PRINT LINE #
	CALL	CRLF
	LHLD	BEGLIN
	PUSH	H	;SAVE BEGGING POINTER
FINDCR:	MOV	A,M
	INX	H
	CPI	1AH	;END OF BUFFER
	JZ	FOUND
	CPI	'|'	;PHYSICAL CR
	JZ	FOUND
	CPI	CR
	JNZ	FINDCR
FOUND:	MVI	M,0	;END OF STRING
	POP	H	;START OF STRING
	CALL	PRNTHL	;PRINT BAD LINE
	JMP	WARM	;THATS ALL FOLKS
;
PRNTHL:	MOV	A,M
	INX	H
	ORA	A
	RZ
	MOV	E,A
	PUSH	H	;SAVE POINTER
	CALL	OUTCHR
	POP	H	;GET POINTER BACK
	JMP	PRNTHL
OUTCHR:	MVI	C,2
	JMP	BDOS
;
DECOUT:	PUSH	H	;SAVE REGS
	PUSH	D
	PUSH	B
	LXI	B,-10	;RADIX FOR CONVERSION
	LXI	D,-1	;THIS BECOMES NO DIVIDED BY RADIX
DX:	DAD	B	;SUBTRACT 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B	;ADD RADIX BACK IN ONCE
	XCHG
	MOV	A,H
	ORA	L	;TEST FOR ZERO
	CNZ	DECOUT	;RECURSIVE CALL
	MOV	A,E
	ADI	'0'	;CONVERT FROM BCD TO HEX
	MOV	E,A	;TO E FOR OUTPUT
	MVI	C,2
	CALL	BDOS
	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
MOVE:	MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
SUBNAM:	DB	'SUB'
LINEM:	DB	' error line # $'
BUFMTY	DB	CR,LF,'Text buffer empty$'
NOPRM:	DB	CR,LF,'No Parameter$'
PMERR:	DB	CR,LF,'Parameter$'
NOSUB:	DB	CR,LF,'File '
NOSBF:	DB	'filename.typ$'
NOTHER:	DB	' not there$'
CMDER:	DB	CR,LF,'Control character$'
TOOARG:	DB	CR,LF,'Too many arguments$'
SIGNON:	DB	'EX.COM ',MONTH1,MONTH0,'-',DAY1,DAY0,'-',YEAR1,YEAR0,'$'
CRLFS:	DB	CR,LF,'$'
;
BITMAP:	DB	0	;PRESENT OFFSET BIT'S
COUNT:	DB	0FFH	;PRESENT OFFSET BIT COUNT
BEGLIN:	DW	0	;BEGGING OF OLD LINE POINTER
LINES:	DW	1
INBUF:	DW	BEGREL
OUTBUF:	DW	0
PRMPNT:
	REPT	10
	DW	0
	ENDM
;
$-PRINT
	ENDIF
	IF NOT	BASE
	ORG	REL
$+PRINT
;
EX:	POP	H	;GET TOP OF MEMMORY
	SHLD	MEMTOP
	POP	H	;GET START OF BUFFER
	SHLD	REVBUF
;
	LXI	SP,MEMTOP
	LHLD	BDOS+1	;GET WARM JUMP FOR STANDARD CCP
	MOV	A,H
	SUI	8
	MOV	H,A
	MVI	L,3	;SET UP FOR WARM CCP JUMP
	SHLD	CCPJMP
	LHLD	WARM+1
	SHLD	WARMPT
	LXI	D,BSWARM
	IF	EATIT
	MVI	B,12
	ELSE
	MVI	B,9
	ENDIF
	CALL	MOVE	;MOVE BIOS JUMPS
	LHLD	WARMPT
	XCHG
	LXI	H,LOCJMP
	IF	EATIT
	MVI	B,12
	ELSE
	MVI	B,9
	ENDIF
	CALL	MOVE	;MOVE NEW BIOS JUMPS TO BIOS AREA
NWARM:	LXI	SP,MEMTOP
;
	LHLD	REVBUF	;SEE IF WE'RE AT BUFFERS END
	MOV	A,M
	ORA	A	;TEST IT
	JM	WARMR	;WARM RETURN
;
	LHLD	WARMPT
	SHLD	WARM+1
	LHLD	MEMTOP
	SHLD	BDOS+1
	LXI	D,DBUFF
	MVI	C,26	;SET DMA
	CALL	BDOS
	IF	EATIT
	MVI	A,1
	STA	EATCHR	;TURN OFF ALL CONSOLE INPUT & OUTPUT
	MVI	C,1	;CONSOLE INPUT
	CALL	BDOS
	XRA	A
	STA	EATCHR	;TURN ON ALL CONSOLE INPUT & OUTPUT
	ENDIF
	LXI	D,STARTM;TELL USER WE'RE STILL HERE
	MVI	C,9
	CALL	BDOS
;
	LDA	BDISK
	MOV	C,A
	LHLD	CCPJMP
	PCHL		;GOTO CONSOLE PROCESSOR
;
LOCJMP:	JMP	NWARM	;WARM
	JMP	BCONST	;CONST
	JMP	NCONIN	;CONIN
	IF	EATIT
	JMP	NCONOT	;CONOT
	ENDIF
;
NCONIN:
	IF	EATIT
	LDA	EATCHR
	ORA	A
	RNZ
	ENDIF
	CALL	BCONST	;GET CONSOLE STATUS
	ORA	A
	JZ	GETBUF	;GET CHARACTER FROM BUFFER
	CALL	BCONIN	;GET CHARACTER
	CPI	'C'-40H	;SEE IF TERMINATE CHARACTER
	JZ	EXABRT
	CPI	'S'-40H	;13H
	RNZ
	CALL	BCONIN	;WAIT FOR NEXT CHARACTER
	LHLD	REVBUF
	INX	H
	MOV	M,A
	SHLD	REVBUF
	MVI	A,'S'-40H;13H
	RET
;
GETBUF:	LHLD	REVBUF
	MOV	A,M
	ORA	A	;END OF BUFFER
	JM	EXEND
	DCX	H
	SHLD	REVBUF
	RET
;
	IF	EATIT
NCONOT:	LDA	EATCHR
	ORA	A
	RNZ
	JMP	BCONOT
	ENDIF
EXEND:	LXI	H,0	;GET OLD STACK
	DAD	SP
	LXI	SP,MEMTOP;GET TEMP STACK
	PUSH	H	;SAVE OLD STACK
	CALL	MOVBAK	;MOVE JUMPS BACK
	LHLD	MEMTOP	;SEE IF BDOS+1=MEMTOP
	XCHG
	LHLD	BDOS+1
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	POP	H	;GET OLD STACK
	SPHL
	JNZ	BCONIN	;DON'T REPLACE BDOS JUMP
	INX	D	;GET TO BDOS JUMP
	LDAX	D
	MOV	L,A	;LSB
	INX	D
	LDAX	D
	MOV	H,A
	SHLD	BDOS+1
	JMP	BCONIN	;GET CHARACTER
;
EXABRT:	LXI	SP,MEMTOP
	LXI	D,ABORTD
	MVI	C,9
	CALL	BDOS
WARMR:	CALL	MOVBAK	;MOVE JUMPS BACK
	JMP	WARM
;
MOVBAK:	LHLD	WARMPT	;MOVE OLD JUMP TABLE BACK TO BIOS
	XCHG
	LXI	H,BSWARM
	IF	EATIT
	MVI	B,12
	ELSE
	MVI	B,9
	ENDIF
	CALL	MOVE
	RET
;
MOVE:	MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
ABORTD:	DB	CR,LF,'>>>Aborted<<<',CR,LF,'$'
;
STARTM:	DB	CR,LF,'(Ex active)$'
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
MEMTOP:	DW	0
REVBUF:	DW	0
CCPJMP:	DW	0
WARMPT:	DW	0
BSWARM:	JMP	$
BCONST:	JMP	$
BCONIN:	JMP	$
	IF	EATIT
BCONOT:	JMP	$
EATCHR:	DB	0
	ENDIF
?PLEN	SET	$
	IF (?PLEN MOD 8) GT 0
?PLEN	SET	(?PLEN AND 0FFF8H)+8;GET NEXT BOUNDARY
	ENDIF
DRVERL	EQU	?PLEN
DRVL8	EQU	DRVERL/8
	ORG	DRVERL
	ENDIF
